/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.views.markers.internal.BookmarkMarker;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.MarkerFilter;
import org.eclipse.ui.views.markers.internal.ProblemMarker;
import org.eclipse.ui.views.markers.internal.TaskMarker;

public class MarkerList {
    private int[] markerCounts = null;
    private ConcreteMarker[] markers;
    private Map markerTable;

    public MarkerList() {
        this(new ConcreteMarker[0]);
    }

    public MarkerList(Collection markers) {
        this(markers.toArray(new ConcreteMarker[markers.size()]));
    }

    public MarkerList(ConcreteMarker[] markers) {
        this.markers = markers;
    }

    public void clearCache() {
        int i = 0;
        while (i < this.markers.length) {
            ConcreteMarker marker = this.markers[i];
            marker.clearCache();
            ++i;
        }
        this.markerTable = null;
    }

    private Map getMarkerMap() {
        if (this.markerTable == null) {
            this.markerTable = new HashMap();
            int idx = 0;
            while (idx < this.markers.length) {
                ConcreteMarker marker = this.markers[idx];
                this.markerTable.put(marker.getMarker(), marker);
                ++idx;
            }
        }
        return this.markerTable;
    }

    public ConcreteMarker getMarker(IMarker toFind) {
        return (ConcreteMarker)this.getMarkerMap().get(toFind);
    }

    public IMarker[] getIMarkers() {
        IMarker[] iMarkers = new IMarker[this.markers.length];
        int i = 0;
        while (i < this.markers.length) {
            iMarkers[i] = this.markers[i].getMarker();
            ++i;
        }
        return iMarkers;
    }

    public static ConcreteMarker createMarker(IMarker marker) throws CoreException {
        if (marker.isSubtypeOf("org.eclipse.core.resources.taskmarker")) {
            return new TaskMarker(marker);
        }
        if (marker.isSubtypeOf("org.eclipse.core.resources.bookmark")) {
            return new BookmarkMarker(marker);
        }
        if (marker.isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
            return new ProblemMarker(marker);
        }
        return new ConcreteMarker(marker);
    }

    public void refresh() {
        int markerIdx = 0;
        while (markerIdx < this.markers.length) {
            ConcreteMarker next = this.markers[markerIdx];
            next.refresh();
            ++markerIdx;
        }
    }

    public List asList() {
        return Arrays.asList(this.markers);
    }

    public MarkerList findMarkers(Collection ofIMarker) {
        ArrayList<ConcreteMarker> result = new ArrayList<ConcreteMarker>(ofIMarker.size());
        for (IMarker next : ofIMarker) {
            ConcreteMarker marker = this.getMarker(next);
            if (marker == null) continue;
            result.add(marker);
        }
        return new MarkerList(result);
    }

    public static ConcreteMarker[] createMarkers(IMarker[] source) throws CoreException {
        ConcreteMarker[] result = new ConcreteMarker[source.length];
        int idx = 0;
        while (idx < source.length) {
            result[idx] = MarkerList.createMarker(source[idx]);
            ++idx;
        }
        return result;
    }

    public static MarkerList compute(MarkerFilter[] filters, IProgressMonitor mon, boolean ignoreExceptions) throws CoreException {
        HashSet returnMarkers = new HashSet();
        int i = 0;
        while (i < filters.length) {
            returnMarkers.addAll(filters[i].findMarkers(mon, ignoreExceptions));
            ++i;
        }
        return new MarkerList(returnMarkers);
    }

    public static IMarker[] compute(String[] types) throws CoreException {
        ArrayList<IMarker> result = new ArrayList<IMarker>();
        IWorkspaceRoot input = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < types.length) {
            IMarker[] newMarkers = input.findMarkers(types[i], true, 2);
            result.addAll(Arrays.asList(newMarkers));
            ++i;
        }
        return result.toArray(new IMarker[result.size()]);
    }

    public ConcreteMarker[] toArray() {
        return this.markers;
    }

    public int getItemCount() {
        return this.markers.length;
    }

    public int getErrors() {
        return this.getMarkerCounts()[2];
    }

    public int getInfos() {
        return this.getMarkerCounts()[0];
    }

    public int getWarnings() {
        return this.getMarkerCounts()[1];
    }

    private int[] getMarkerCounts() {
        if (this.markerCounts == null) {
            this.markerCounts = new int[3];
            int idx = 0;
            while (idx < this.markers.length) {
                int severity;
                ConcreteMarker marker = this.markers[idx];
                if (marker instanceof ProblemMarker && (severity = ((ProblemMarker)this.markers[idx]).getSeverity()) >= 0 && severity <= 2) {
                    int n = severity;
                    this.markerCounts[n] = this.markerCounts[n] + 1;
                }
                ++idx;
            }
        }
        return this.markerCounts;
    }

    public Object[] getArray() {
        return this.markers;
    }

    public int getSize() {
        return this.getArray().length;
    }

    public ConcreteMarker getMarker(int index) {
        return this.markers[index];
    }

    public void updateMarkers(Collection addedMarkers, Collection removedMarkers) {
        ArrayList list = new ArrayList(this.asList());
        list.addAll(addedMarkers);
        list.removeAll(removedMarkers);
        this.markers = new ConcreteMarker[list.size()];
        list.toArray(this.markers);
    }

    public void refreshAll() {
        int i = 0;
        while (i < this.markers.length) {
            this.markers[i].refresh();
            ++i;
        }
    }

    public void clearGroups() {
        int i = 0;
        while (i < this.markers.length) {
            this.markers[i].setGroup(null);
            ++i;
        }
    }
}

