/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.impl.dom;

import java.util.ArrayList;
import org.eclipse.e4.ui.css.core.dom.ExtendedCSSRule;
import org.eclipse.e4.ui.css.core.impl.dom.CSSComputedStyleImpl;
import org.eclipse.e4.ui.css.core.impl.dom.StyleWrapper;
import org.eclipse.e4.ui.css.core.impl.sac.ExtendedSelector;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.DocumentCSS;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.stylesheets.StyleSheetList;
import org.w3c.dom.views.DocumentView;

public class ViewCSSImpl
implements ViewCSS {
    protected DocumentCSS documentCSS;

    public ViewCSSImpl(DocumentCSS documentCSS) {
        this.documentCSS = documentCSS;
    }

    @Override
    public DocumentView getDocument() {
        return null;
    }

    @Override
    public CSSStyleDeclaration getComputedStyle(Element elt, String pseudoElt) {
        StyleSheetList styleSheetList = this.documentCSS.getStyleSheets();
        int l = styleSheetList.getLength();
        int i = 0;
        while (i < l) {
            CSSStyleSheet styleSheet = (CSSStyleSheet)styleSheetList.item(i);
            CSSStyleDeclaration styleDeclaration = this.getComputedStyle(styleSheet, elt, pseudoElt);
            if (styleDeclaration != null) {
                return styleDeclaration;
            }
            ++i;
        }
        return null;
    }

    public CSSStyleDeclaration getComputedStyle(CSSStyleSheet styleSheet, Element elt, String pseudoElt) {
        ArrayList<StyleWrapper> styleDeclarations = null;
        StyleWrapper firstStyleDeclaration = null;
        CSSRuleList ruleList = styleSheet.getCssRules();
        int length = ruleList.getLength();
        int position = 0;
        int i = 0;
        while (i < length) {
            CSSRule rule = ruleList.item(i);
            if (rule.getType() == 1) {
                CSSStyleRule styleRule = (CSSStyleRule)rule;
                if (rule instanceof ExtendedCSSRule) {
                    ExtendedCSSRule r = (ExtendedCSSRule)rule;
                    SelectorList selectorList = r.getSelectorList();
                    int l = selectorList.getLength();
                    int j = 0;
                    while (j < l) {
                        ExtendedSelector extendedSelector;
                        Selector selector = selectorList.item(j);
                        if (selector instanceof ExtendedSelector && (extendedSelector = (ExtendedSelector)selector).match(elt, pseudoElt)) {
                            CSSStyleDeclaration style = styleRule.getStyle();
                            int specificity = extendedSelector.getSpecificity();
                            StyleWrapper wrapper = new StyleWrapper(style, specificity, position++);
                            if (firstStyleDeclaration == null) {
                                firstStyleDeclaration = wrapper;
                            } else {
                                if (styleDeclarations == null) {
                                    styleDeclarations = new ArrayList<StyleWrapper>();
                                    styleDeclarations.add(firstStyleDeclaration);
                                }
                                styleDeclarations.add(wrapper);
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        if (styleDeclarations != null) {
            return new CSSComputedStyleImpl(styleDeclarations);
        }
        if (firstStyleDeclaration != null) {
            return firstStyleDeclaration.style;
        }
        return null;
    }
}

