/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.impl.dom.parsers;

import java.io.IOException;
import java.util.Stack;
import org.eclipse.e4.ui.css.core.dom.parsers.CSSParser;
import org.eclipse.e4.ui.css.core.impl.dom.CSSStyleDeclarationImpl;
import org.eclipse.e4.ui.css.core.impl.dom.CSSValueFactory;
import org.eclipse.e4.ui.css.core.sac.DocumentHandlerFactory;
import org.eclipse.e4.ui.css.core.sac.ExtendedDocumentHandler;
import org.eclipse.e4.ui.css.core.sac.ISACParserFactory;
import org.eclipse.e4.ui.css.core.sac.ParserNotFoundException;
import org.eclipse.e4.ui.css.core.sac.SACParserFactory;
import org.w3c.css.sac.ConditionFactory;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SelectorFactory;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.CSSValue;

public class AbstractCSSParser
implements CSSParser {
    private static DocumentHandlerFactory defaultDocumentHandlerFactory = DocumentHandlerFactory.newInstance();
    private static ISACParserFactory defaultParserFactory = SACParserFactory.newInstance();
    private Parser parser = null;
    private DocumentHandlerFactory documentHandlerFactory;
    private ISACParserFactory parserFactory;
    private ConditionFactory conditionFactory = null;
    private SelectorFactory selectorFactory = null;

    @Override
    public CSSStyleSheet parseStyleSheet(InputSource source) throws IOException {
        ExtendedDocumentHandler documentHandler = this.getDocumentHandlerFactory().makeDocumentHandler();
        Parser parser = this.getParser();
        parser.setDocumentHandler((DocumentHandler)documentHandler);
        parser.parseStyleSheet(source);
        return (CSSStyleSheet)documentHandler.getNodeRoot();
    }

    @Override
    public CSSStyleDeclaration parseStyleDeclaration(InputSource source) throws IOException {
        CSSStyleDeclarationImpl styleDeclaration = new CSSStyleDeclarationImpl(null);
        this.parseStyleDeclaration(styleDeclaration, source);
        return styleDeclaration;
    }

    @Override
    public void parseStyleDeclaration(CSSStyleDeclaration styleDeclaration, InputSource source) throws IOException {
        Stack<CSSStyleDeclaration> stack = new Stack<CSSStyleDeclaration>();
        stack.push(styleDeclaration);
        ExtendedDocumentHandler documentHandler = this.getDocumentHandlerFactory().makeDocumentHandler();
        documentHandler.setNodeStack(stack);
        Parser parser = this.getParser();
        parser.setDocumentHandler((DocumentHandler)documentHandler);
        parser.parseStyleDeclaration(source);
    }

    @Override
    public CSSValue parsePropertyValue(InputSource source) throws IOException {
        Parser parser = this.getParser();
        ExtendedDocumentHandler documentHandler = this.getDocumentHandlerFactory().makeDocumentHandler();
        parser.setDocumentHandler((DocumentHandler)documentHandler);
        return CSSValueFactory.newValue(parser.parsePropertyValue(source));
    }

    @Override
    public CSSRule parseRule(InputSource source) throws IOException {
        return null;
    }

    @Override
    public SelectorList parseSelectors(InputSource source) throws IOException {
        ExtendedDocumentHandler documentHandler = this.getDocumentHandlerFactory().makeDocumentHandler();
        Parser parser = this.getParser();
        parser.setDocumentHandler((DocumentHandler)documentHandler);
        return parser.parseSelectors(source);
    }

    @Override
    public void setParentStyleSheet(CSSStyleSheet parentStyleSheet) {
    }

    public DocumentHandlerFactory getDocumentHandlerFactory() {
        if (this.documentHandlerFactory == null) {
            return defaultDocumentHandlerFactory;
        }
        return this.documentHandlerFactory;
    }

    @Override
    public void setDocumentHandlerFactory(DocumentHandlerFactory documentHandlerFactory) {
        this.documentHandlerFactory = documentHandlerFactory;
    }

    public Parser getParser() {
        if (this.parser == null) {
            try {
                this.parser = this.getSACParserFactory().makeParser();
                if (this.conditionFactory != null) {
                    this.parser.setConditionFactory(this.conditionFactory);
                }
                if (this.selectorFactory != null) {
                    this.parser.setSelectorFactory(this.selectorFactory);
                }
            }
            catch (Exception e) {
                throw new ParserNotFoundException(e);
            }
        }
        return this.parser;
    }

    public void setParser(Parser parser) {
        this.parser = parser;
    }

    public ISACParserFactory getSACParserFactory() {
        if (this.parserFactory == null) {
            return defaultParserFactory;
        }
        return this.parserFactory;
    }

    public void setSACParserFactory(ISACParserFactory parserFactory) {
        this.parserFactory = parserFactory;
    }

    @Override
    public ConditionFactory getConditionFactory() {
        return this.conditionFactory;
    }

    @Override
    public void setConditionFactory(ConditionFactory conditionFactory) {
        this.conditionFactory = conditionFactory;
    }

    @Override
    public SelectorFactory getSelectorFactory() {
        return this.selectorFactory;
    }

    @Override
    public void setSelectorFactory(SelectorFactory selectorFactory) {
        this.selectorFactory = selectorFactory;
    }
}

