/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolverService;
import org.sat4j.specs.IVec;
import org.sat4j.specs.RandomAccessModel;
import org.sat4j.tools.IVisualizationTool;
import org.sat4j.tools.SearchListenerAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LearnedTracing
extends SearchListenerAdapter<ISolverService> {
    private static final long serialVersionUID = 1L;
    private ISolverService solverService;
    private final IVisualizationTool visuTool;

    public LearnedTracing(IVisualizationTool visuTool) {
        this.visuTool = visuTool;
    }

    @Override
    public void solutionFound(int[] model, RandomAccessModel lazyModel) {
        this.trace();
    }

    @Override
    public void restarting() {
        this.trace();
    }

    private void trace() {
        this.visuTool.init();
        IVec<? extends IConstr> constrs = this.solverService.getLearnedConstraints();
        int n = constrs.size();
        int i = 0;
        while (i < n) {
            this.visuTool.addPoint(i, constrs.get(i).getActivity());
            ++i;
        }
        this.visuTool.end();
    }

    @Override
    public void init(ISolverService solverService) {
        this.solverService = solverService;
    }

    @Override
    public void cleaning() {
        this.trace();
    }
}

