/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tools;

import java.util.Calendar;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.releng.tools.RepositoryProviderCopyrightAdapter;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;

public class CVSCopyrightAdapter
extends RepositoryProviderCopyrightAdapter {
    private static String filterString = "copyright";

    public CVSCopyrightAdapter(IResource[] resources) {
        super(resources);
    }

    public int getLastModifiedYear(IFile file, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("Fetching logs from CVS", 100);
            ICVSRemoteResource cvsFile = CVSWorkspaceRoot.getRemoteResourceFor((IResource)file);
            if (cvsFile != null && cvsFile.isManaged()) {
                ILogEntry entry = ((ICVSRemoteFile)cvsFile).getLogEntry((IProgressMonitor)new SubProgressMonitor(monitor, 100));
                String logComment = entry.getComment();
                if (filterString != null && logComment.toLowerCase().indexOf(filterString) != -1) {
                    return 0;
                }
                boolean isSWT = file.getProject().getName().startsWith("org.eclipse.swt");
                if (isSWT && logComment.indexOf("restore HEAD after accidental deletion") != -1) {
                    return 0;
                }
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(entry.getDate());
                int n = calendar.get(1);
                return n;
            }
        }
        finally {
            monitor.done();
        }
        return -1;
    }

    public void initialize(IProgressMonitor monitor) throws CoreException {
    }
}

