/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tools.git;

import java.io.IOException;
import java.util.Calendar;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.releng.tools.RepositoryProviderCopyrightAdapter;

public class GitCopyrightAdapter
extends RepositoryProviderCopyrightAdapter {
    private static String filterString = "copyright";

    public GitCopyrightAdapter(IResource[] resources) {
        super(resources);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getLastModifiedYear(IFile file, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("Fetching logs from Git", 100);
            RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)file);
            if (mapping == null) return -1;
            Repository repo = mapping.getRepository();
            if (repo == null) return -1;
            RevWalk walk = null;
            try {
                ObjectId start = repo.resolve("HEAD");
                walk = new RevWalk(repo);
                walk.setTreeFilter(AndTreeFilter.create((TreeFilter)PathFilter.create((String)mapping.getRepoRelativePath((IResource)file)), (TreeFilter)TreeFilter.ANY_DIFF));
                walk.markStart(walk.lookupCommit((AnyObjectId)start));
                RevCommit commit = walk.next();
                if (commit != null) {
                    boolean isPlatform;
                    if (filterString != null && commit.getFullMessage().toLowerCase().indexOf(filterString) != -1) {
                        return 0;
                    }
                    boolean isSWT = file.getProject().getName().startsWith("org.eclipse.swt");
                    String logComment = commit.getFullMessage();
                    if (isSWT) {
                        if (logComment.indexOf("restore HEAD after accidental deletion") != -1) return 0;
                        if (logComment.indexOf("fix permission of files") != -1) {
                            return 0;
                        }
                    }
                    if (isPlatform = file.getProject().getName().equals("eclipse.platform")) {
                        if (logComment.indexOf("Merge in ant and update from origin/master") != -1) return 0;
                        if (logComment.indexOf("Fixed bug 381684: Remove update from repository and map files") != -1) return 0;
                        if (logComment.indexOf("Restored 'org.eclipse.update.core'") != -1) {
                            return 0;
                        }
                    }
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTimeInMillis(0L);
                    calendar.add(13, commit.getCommitTime());
                    int n = calendar.get(1);
                    return n;
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.releng.tools", 0, NLS.bind((String)"An error occured when processing {0}", (Object)file.getName()), (Throwable)e));
            }
            finally {
                if (walk != null) {
                    walk.release();
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    public void initialize(IProgressMonitor monitor) throws CoreException {
    }
}

