/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.accessibility;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleActionAdapter;
import org.eclipse.swt.accessibility.AccessibleActionEvent;
import org.eclipse.swt.accessibility.AccessibleActionListener;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class AccessibleActionExample {
    static int MARGIN = 20;
    static ResourceBundle resourceBundle = ResourceBundle.getBundle("examples_accessibility");
    static final String buttonText = "Action Button";

    static String getResourceString(String key) {
        try {
            return resourceBundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + key + "!";
        }
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        shell.setText("Accessible Action Example");
        Button button = new Button((Composite)shell, 8);
        button.setText("Button");
        final Canvas customButton = new Canvas((Composite)shell, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                GC gc = new GC((Drawable)this);
                Point point = gc.stringExtent(AccessibleActionExample.buttonText);
                gc.dispose();
                point.x += MARGIN;
                point.y += MARGIN;
                return point;
            }
        };
        customButton.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Rectangle clientArea = customButton.getClientArea();
                Point stringExtent = e.gc.stringExtent(AccessibleActionExample.buttonText);
                int x = clientArea.x + (clientArea.width - stringExtent.x) / 2;
                int y = clientArea.y + (clientArea.height - stringExtent.y) / 2;
                e.gc.drawString(AccessibleActionExample.buttonText, x, y);
            }
        });
        customButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                int actionIndex = e.button == 1 ? 0 : 1;
                AccessibleActionExample.customButtonAction(actionIndex);
            }
        });
        customButton.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                int modifierKeys = e.stateMask & SWT.MODIFIER_MASK;
                if (modifierKeys == 262144 || modifierKeys == 0) {
                    if (e.character == '1') {
                        AccessibleActionExample.customButtonAction(0);
                    } else if (e.character == '2') {
                        AccessibleActionExample.customButtonAction(1);
                    }
                }
            }
        });
        Accessible accessible = customButton.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = AccessibleActionExample.buttonText;
            }

            public void getKeyboardShortcut(AccessibleEvent e) {
                e.result = "CTRL+1";
            }
        });
        accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getRole(AccessibleControlEvent e) {
                e.detail = 43;
            }
        });
        accessible.addAccessibleActionListener((AccessibleActionListener)new AccessibleActionAdapter(){

            public void getActionCount(AccessibleActionEvent e) {
                e.count = 2;
            }

            public void getName(AccessibleActionEvent e) {
                if (e.index >= 0 && e.index <= 1) {
                    e.result = e.localized ? AccessibleActionExample.getResourceString("action" + e.index) : "Action" + e.index;
                }
            }

            public void getDescription(AccessibleActionEvent e) {
                if (e.index >= 0 && e.index <= 1) {
                    e.result = AccessibleActionExample.getResourceString("action" + e.index + "description");
                }
            }

            public void doAction(AccessibleActionEvent e) {
                if (e.index >= 0 && e.index <= 1) {
                    AccessibleActionExample.customButtonAction(e.index);
                    e.result = "OK";
                }
            }

            public void getKeyBinding(AccessibleActionEvent e) {
                switch (e.index) {
                    case 0: {
                        e.result = "1;CTRL+1";
                        break;
                    }
                    case 1: {
                        e.result = "2;CTRL+2";
                        break;
                    }
                    default: {
                        e.result = null;
                    }
                }
            }
        });
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    static void customButtonAction(int action) {
        System.out.println("action " + action + " occurred");
    }
}

