/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.accessibility;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class ControlsWithAccessibleNamesExample {
    static Display display;
    static Shell shell;
    static Button button;
    static Button overrideButton;
    static Button imageButton;
    static Button overrideImageButton;
    static Label label;
    static Label overrideLabel;
    static Label imageLabel;
    static Label overrideImageLabel;
    static Combo combo;
    static Combo overrideCombo;
    static Spinner spinner;
    static Spinner overrideSpinner;
    static Text text;
    static Text overrideText;
    static Text multiLineText;
    static Text overrideMultiLineText;
    static List list;
    static List overrideList;
    static Table table;
    static Table overrideTable;
    static Tree tree;
    static Tree overrideTree;
    static Tree treeTable;
    static Tree overrideTreeTable;
    static ToolBar toolBar;
    static ToolBar overrideToolBar;
    static ToolBar imageToolBar;
    static ToolBar overrideImageToolBar;
    static CoolBar coolBar;
    static CoolBar overrideCoolBar;
    static Canvas canvas;
    static Canvas overrideCanvas;
    static Composite composite;
    static Composite overrideComposite;
    static Group group;
    static Group overrideGroup;
    static TabFolder tabFolder;
    static TabFolder overrideTabFolder;
    static CLabel cLabel;
    static CLabel overrideCLabel;
    static CCombo cCombo;
    static CCombo overrideCCombo;
    static CTabFolder cTabFolder;
    static CTabFolder overrideCTabFolder;
    static StyledText styledText;
    static StyledText overrideStyledText;
    static StyledText multiLineStyledText;
    static StyledText overrideMultiLineStyledText;
    static ProgressBar progressBar;
    static ProgressBar overrideProgressBar;
    static Sash sash;
    static Sash overrideSash;
    static Scale scale;
    static Scale overrideScale;
    static Slider slider;
    static Slider overrideSlider;
    static Link link;
    static Link overrideLink;
    static Image smallImage;
    static Image largeImage;
    static Image transparentImage;

    public static void main(String[] args) {
        Point coolSize;
        Point size;
        ToolItem item;
        int toolItemWidth;
        CoolItem coolItem;
        int j;
        TableItem item2;
        TableColumn column;
        display = new Display();
        shell = new Shell(display);
        shell.setLayout((Layout)new GridLayout(4, true));
        shell.setText("Override Accessibility Test");
        largeImage = new Image((Device)display, ControlsWithAccessibleNamesExample.class.getResourceAsStream("run_wiz.gif"));
        smallImage = new Image((Device)display, ControlsWithAccessibleNamesExample.class.getResourceAsStream("run.gif"));
        ImageData source = smallImage.getImageData();
        ImageData mask = source.getTransparencyMask();
        transparentImage = new Image((Device)display, source, mask);
        new Label((Composite)shell, 0).setText("Use Platform Name");
        new Label((Composite)shell, 0).setText("Override Platform Name");
        new Label((Composite)shell, 0).setText("Use Platform Name");
        new Label((Composite)shell, 0).setText("Override Platform Name");
        AccessibleAdapter overrideAccessibleAdapter = new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                Control control = ((Accessible)e.getSource()).getControl();
                e.result = e.childID == -1 ? "Overriding Platform Name For " + control.getData("name") + " (was " + e.result + ")" : "Overriding Platform Name For " + control.getData("child") + ": " + e.childID + " (was " + e.result + ")";
            }

            public void getHelp(AccessibleEvent e) {
                Control control = ((Accessible)e.getSource()).getControl();
                e.result = e.childID == -1 ? "Overriding Platform Help For " + control.getData("name") + " (was " + e.result + ")" : "Overriding Platform Help For " + control.getData("child") + ": " + e.childID + " (was " + e.result + ")";
            }
        };
        shell.setData("name", (Object)"Shell");
        shell.getAccessible().addAccessibleListener((AccessibleListener)overrideAccessibleAdapter);
        label = new Label((Composite)shell, 2048);
        label.setText("Label");
        label.setToolTipText("Label ToolTip");
        overrideLabel = new Label((Composite)shell, 2048);
        overrideLabel.setText("Label");
        overrideLabel.setToolTipText("Label ToolTip");
        overrideLabel.setData("name", (Object)"Label");
        overrideLabel.getAccessible().addAccessibleListener((AccessibleListener)overrideAccessibleAdapter);
        imageLabel = new Label((Composite)shell, 2048);
        imageLabel.setImage(largeImage);
        imageLabel.setToolTipText("Image Label ToolTip");
        overrideImageLabel = new Label((Composite)shell, 2048);
        overrideImageLabel.setImage(largeImage);
        overrideImageLabel.setToolTipText("Image Label ToolTip");
        overrideImageLabel.setData("name", (Object)"Image Label");
        overrideImageLabel.getAccessible().addAccessibleListener((AccessibleListener)overrideAccessibleAdapter);
        button = new Button((Composite)shell, 8);
        button.setText("Button");
        button.setToolTipText("Button ToolTip");
        overrideButton = new Button((Composite)shell, 8);
        overrideButton.setText("Button");
        overrideButton.setToolTipText("Button ToolTip");
        overrideButton.setData("name", (Object)"Button");
        overrideButton.getAccessible().addAccessibleListener((AccessibleListener)overrideAccessibleAdapter);
        imageButton = new Button((Composite)shell, 8);
        imageButton.setImage(smallImage);
        imageButton.setToolTipText("Image Button ToolTip");
        overrideImageButton = new Button((Composite)shell, 8);
        overrideImageButton.setImage(smallImage);
        overrideImageButton.setToolTipText("Image Button ToolTip");
        overrideImageButton.setData("name", (Object)"Image Button");
        overrideImageButton.getAccessible().addAccessibleListener((AccessibleListener)overrideAccessibleAdapter);
        combo = new Combo((Composite)shell, 2048);
        int i = 0;
        while (i < 5) {
            combo.add("item" + i);
            ++i;
        }
        combo.setText("Combo");
        combo.setToolTipText("Combo ToolTip");
        overrideCombo = new Combo((Composite)shell, 2048);
        i = 0;
        while (i < 5) {
            overrideCombo.add("item" + i);
            ++i;
        }
        overrideCombo.setText("Combo");
        overrideCombo.setToolTipText("Combo ToolTip");
        overrideCombo.setData("name", (Object)"Combo");
        overrideCombo.getAccessible().addAccessibleListener((AccessibleListener)overrideAccessibleAdapter);
        spinner = new Spinner((Composite)shell, 2048);
        spinner.setSelection(5);
        spinner.setToolTipText("Spinner ToolTip");
        overrideSpinner = new Spinner((Composite)shell, 2048);
        overrideSpinner.setSelection(5);
        overrideSpinner.setToolTipText("Spinner ToolTip");
        overrideSpinner.setData("name", (Object)"Spinner");
        overrideSpinner.getAccessible().addAccessibleListener((AccessibleListener)overrideAccessibleAdapter);
        text = new Text((Composite)shell, 2052);
        text.setText("Contents of single-line Text");
        overrideText = new Text((Composite)shell, 2052);
        overrideText.setText("Contents of single-line Text");
        overrideText.setData("name", (Object)"Text");
        overrideText.getAccessible().addAccessibleListener((AccessibleListener)overrideAccessibleAdapter);
        multiLineText = new Text((Composite)shell, 2050);
        multiLineText.setText("Contents of multi-line Text\nLine 2\nLine 3\nLine 4");
        overrideMultiLineText = new Text((Composite)shell, 2050);
        overrideMultiLineText.setText("Contents of multi-line Text\nLine 2\nLine 3\nLine 4");
        overrideMultiLineText.setData("name", (Object)"MultiLineText");
        overrideMultiLineText.getAccessible().addAccessibleListener((AccessibleListener)overrideAccessibleAdapter);
        list = new List((Composite)shell, 2052);
        list.setItems(new String[]{"Item0", "Item1", "Item2"});
        overrideList = new List((Composite)shell, 2052);
        overrideList.setItems(new String[]{"Item0", "Item1", "Item2"});
        overrideList.setData("name", (Object)"List");
        overrideList.setData("child", (Object)"List Item");
        overrideList.getAccessible().addAccessibleListener((AccessibleListener)overrideAccessibleAdapter);
        table = new Table((Composite)shell, 67586);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        int col = 0;
        while (col < 3) {
            column = new TableColumn(table, 0);
            column.setText("Col " + col);
            column.pack();
            ++col;
        }
        int row = 0;
        while (row < 3) {
            item2 = new TableItem(table, 0);
            item2.setText(new String[]{"C0R" + row, "C1R" + row, "C2R" + row});
            ++row;
        }
        overrideTable = new Table((Composite)shell, 67586);
        overrideTable.setHeaderVisible(true);
        overrideTable.setLinesVisible(true);
        col = 0;
        while (col < 3) {
            column = new TableColumn(overrideTable, 0);
            column.setText("Col " + col);
            column.pack();
            ++col;
        }
        row = 0;
        while (row < 3) {
            item2 = new TableItem(overrideTable, 0);
            item2.setText(new String[]{"C0R" + row, "C1R" + row, "C2R" + row});
            ++row;
        }
        overrideTable.setData("name", (Object)"Table");
        overrideTable.setData("child", (Object)"Table Item");
        overrideTable.getAccessible().addAccessibleListener((AccessibleListener)overrideAccessibleAdapter);
        tree = new Tree((Composite)shell, 2050);
        i = 0;
        while (i < 3) {
            item2 = new TreeItem(tree, 0);
            item2.setText("Item" + i);
            j = 0;
            while (j < 4) {
                new TreeItem((TreeItem)item2, 0).setText("Item" + i + j);
                ++j;
            }
            ++i;
        }
        overrideTree = new Tree((Composite)shell, 2050);
        i = 0;
        while (i < 3) {
            item2 = new TreeItem(overrideTree, 0);
            item2.setText("Item" + i);
            j = 0;
            while (j < 4) {
                new TreeItem((TreeItem)item2, 0).setText("Item" + i + j);
                ++j;
            }
            ++i;
        }
        overrideTree.setData("name", (Object)"Tree");
        overrideTree.setData("child", (Object)"Tree Item");
        overrideTree.getAccessible().addAccessibleListener((AccessibleListener)overrideAccessibleAdapter);
        treeTable = new Tree((Composite)shell, 2050);
        treeTable.setHeaderVisible(true);
        treeTable.setLinesVisible(true);
        col = 0;
        while (col < 3) {
            column = new TreeColumn(treeTable, 0);
            column.setText("Col " + col);
            column.pack();
            ++col;
        }
        i = 0;
        while (i < 3) {
            item2 = new TreeItem(treeTable, 0);
            item2.setText(new String[]{"I" + i + "C0", "I" + i + "C1", "I" + i + "C2"});
            j = 0;
            while (j < 4) {
                new TreeItem((TreeItem)item2, 0).setText(new String[]{"I" + i + j + "C0", "I" + i + j + "C1", "I" + i + j + "C2"});
                ++j;
            }
            ++i;
        }
        overrideTreeTable = new Tree((Composite)shell, 2050);
        overrideTreeTable.setHeaderVisible(true);
        overrideTreeTable.setLinesVisible(true);
        col = 0;
        while (col < 3) {
            column = new TreeColumn(overrideTreeTable, 0);
            column.setText("Col " + col);
            column.pack();
            ++col;
        }
        i = 0;
        while (i < 3) {
            item2 = new TreeItem(overrideTreeTable, 0);
            item2.setText(new String[]{"I" + i + "C0", "I" + i + "C1", "I" + i + "C2"});
            j = 0;
            while (j < 4) {
                new TreeItem((TreeItem)item2, 0).setText(new String[]{"I" + i + j + "C0", "I" + i + j + "C1", "I" + i + j + "C2"});
                ++j;
            }
            ++i;
        }
        overrideTreeTable.setData("name", (Object)"Tree Table");
        overrideTreeTable.setData("child", (Object)"Tree Table Item");
        overrideTreeTable.getAccessible().addAccessibleListener((AccessibleListener)overrideAccessibleAdapter);
        toolBar = new ToolBar((Composite)shell, 0x800000);
        i = 0;
        while (i < 3) {
            item2 = new ToolItem(toolBar, 8);
            item2.setText("Item" + i);
            item2.setToolTipText("ToolItem ToolTip" + i);
            ++i;
        }
        overrideToolBar = new ToolBar((Composite)shell, 0x800000);
        i = 0;
        while (i < 3) {
            item2 = new ToolItem(overrideToolBar, 8);
            item2.setText("Item" + i);
            item2.setToolTipText("ToolItem ToolTip" + i);
            ++i;
        }
        overrideToolBar.setData("name", (Object)"ToolBar");
        overrideToolBar.setData("child", (Object)"ToolBar Item");
        overrideToolBar.getAccessible().addAccessibleListener((AccessibleListener)overrideAccessibleAdapter);
        imageToolBar = new ToolBar((Composite)shell, 0x800000);
        i = 0;
        while (i < 3) {
            item2 = new ToolItem(imageToolBar, 8);
            item2.setImage(transparentImage);
            item2.setToolTipText("Image ToolItem ToolTip" + i);
            ++i;
        }
        overrideImageToolBar = new ToolBar((Composite)shell, 0x800000);
        i = 0;
        while (i < 3) {
            item2 = new ToolItem(overrideImageToolBar, 8);
            item2.setImage(transparentImage);
            item2.setToolTipText("Image ToolItem ToolTip" + i);
            ++i;
        }
        overrideImageToolBar.setData("name", (Object)"Image ToolBar");
        overrideImageToolBar.setData("child", (Object)"Image ToolBar Item");
        overrideImageToolBar.getAccessible().addAccessibleListener((AccessibleListener)overrideAccessibleAdapter);
        coolBar = new CoolBar((Composite)shell, 0x800000);
        i = 0;
        while (i < 2) {
            coolItem = new CoolItem(coolBar, 8);
            ToolBar coolItemToolBar = new ToolBar((Composite)coolBar, 0x800000);
            toolItemWidth = 0;
            int j2 = 0;
            while (j2 < 2) {
                item = new ToolItem(coolItemToolBar, 8);
                item.setText("I" + i + j2);
                item.setToolTipText("ToolItem ToolTip" + i + j2);
                if (item.getWidth() > toolItemWidth) {
                    toolItemWidth = item.getWidth();
                }
                ++j2;
            }
            coolItem.setControl((Control)coolItemToolBar);
            size = coolItemToolBar.computeSize(-1, -1);
            coolSize = coolItem.computeSize(size.x, size.y);
            coolItem.setMinimumSize(toolItemWidth, coolSize.y);
            coolItem.setPreferredSize(coolSize);
            coolItem.setSize(coolSize);
            ++i;
        }
        overrideCoolBar = new CoolBar((Composite)shell, 0x800000);
        i = 0;
        while (i < 2) {
            coolItem = new CoolItem(overrideCoolBar, 8);
            ToolBar coolItemToolBar = new ToolBar((Composite)overrideCoolBar, 0x800000);
            toolItemWidth = 0;
            int j3 = 0;
            while (j3 < 2) {
                item = new ToolItem(coolItemToolBar, 8);
                item.setText("I" + i + j3);
                item.setToolTipText("ToolItem ToolTip" + i + j3);
                if (item.getWidth() > toolItemWidth) {
                    toolItemWidth = item.getWidth();
                }
                ++j3;
            }
            coolItem.setControl((Control)coolItemToolBar);
            size = coolItemToolBar.computeSize(-1, -1);
            coolSize = coolItem.computeSize(size.x, size.y);
            coolItem.setMinimumSize(toolItemWidth, coolSize.y);
            coolItem.setPreferredSize(coolSize);
            coolItem.setSize(coolSize);
            ++i;
        }
        overrideCoolBar.setData("name", (Object)"CoolBar");
        overrideCoolBar.setData("child", (Object)"CoolBar Item");
        overrideCoolBar.getAccessible().addAccessibleListener((AccessibleListener)overrideAccessibleAdapter);
        canvas = new Canvas((Composite)shell, 2048);
        canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.drawString("Canvas", 15, 25);
            }
        });
        Caret caret = new Caret(canvas, 0);
        caret.setBounds(15, 25, 2, 20);
        canvas.setCaret(caret);
        canvas.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                e.doit = true;
            }

            public void keyReleased(KeyEvent e) {
                e.doit = true;
            }
        });
        canvas.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                e.doit = true;
            }
        });
        overrideCanvas = new Canvas((Composite)shell, 2048);
        overrideCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.drawString("Canvas", 15, 25);
            }
        });
        caret = new Caret(overrideCanvas, 0);
        caret.setBounds(15, 25, 2, 20);
        overrideCanvas.setCaret(caret);
        overrideCanvas.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                e.doit = true;
            }

            public void keyReleased(KeyEvent e) {
                e.doit = true;
            }
        });
        overrideCanvas.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                e.doit = true;
            }
        });
        overrideCanvas.setData("name", (Object)"Canvas");
        overrideCanvas.getAccessible().addAccessibleListener((AccessibleListener)overrideAccessibleAdapter);
        composite = new Composite((Composite)shell, 2048);
        composite.setLayout((Layout)new GridLayout());
        new Button(composite, 16).setText("Child 1");
        new Button(composite, 16).setText("Child 2");
        overrideComposite = new Composite((Composite)shell, 2048);
        overrideComposite.setLayout((Layout)new GridLayout());
        new Button(overrideComposite, 16).setText("Child 1");
        new Button(overrideComposite, 16).setText("Child 2");
        overrideComposite.setData("name", (Object)"Composite");
        overrideComposite.getAccessible().addAccessibleListener((AccessibleListener)overrideAccessibleAdapter);
        group = new Group((Composite)shell, 0);
        group.setText("Group");
        group.setLayout((Layout)new FillLayout());
        new Text((Composite)group, 4).setText("Text in Group");
        overrideGroup = new Group((Composite)shell, 0);
        overrideGroup.setText("Group");
        overrideGroup.setLayout((Layout)new FillLayout());
        new Text((Composite)overrideGroup, 4).setText("Text in Group");
        overrideGroup.setData("name", (Object)"Group");
        overrideGroup.getAccessible().addAccessibleListener((AccessibleListener)overrideAccessibleAdapter);
        tabFolder = new TabFolder((Composite)shell, 0);
        int i2 = 0;
        while (i2 < 3) {
            TabItem item3 = new TabItem(tabFolder, 0);
            item3.setText("TabItem &" + i2);
            item3.setToolTipText("TabItem ToolTip" + i2);
            Text itemText = new Text((Composite)tabFolder, 2050);
            itemText.setText("\nText for TabItem " + i2 + "\n\n");
            item3.setControl((Control)itemText);
            ++i2;
        }
        overrideTabFolder = new TabFolder((Composite)shell, 0);
        i2 = 0;
        while (i2 < 3) {
            TabItem item4 = new TabItem(overrideTabFolder, 0);
            item4.setText("TabItem &" + i2);
            item4.setToolTipText("TabItem ToolTip" + i2);
            Text itemText = new Text((Composite)overrideTabFolder, 2050);
            itemText.setText("\nText for TabItem " + i2 + "\n\n");
            item4.setControl((Control)itemText);
            ++i2;
        }
        overrideTabFolder.setData("name", (Object)"TabFolder");
        overrideTabFolder.setData("child", (Object)"TabItem");
        overrideTabFolder.getAccessible().addAccessibleListener((AccessibleListener)overrideAccessibleAdapter);
        cLabel = new CLabel((Composite)shell, 2048);
        cLabel.setText("CLabel");
        cLabel.setToolTipText("CLabel ToolTip");
        cLabel.setLayoutData((Object)new GridData(100, -1));
        overrideCLabel = new CLabel((Composite)shell, 2048);
        overrideCLabel.setText("CLabel");
        overrideCLabel.setToolTipText("CLabel ToolTip");
        overrideCLabel.setLayoutData((Object)new GridData(100, -1));
        overrideCLabel.setData("name", (Object)"CLabel");
        overrideCLabel.getAccessible().addAccessibleListener((AccessibleListener)overrideAccessibleAdapter);
        cCombo = new CCombo((Composite)shell, 2048);
        i2 = 0;
        while (i2 < 5) {
            cCombo.add("item" + i2);
            ++i2;
        }
        cCombo.setText("CCombo");
        cCombo.setToolTipText("CCombo ToolTip");
        overrideCCombo = new CCombo((Composite)shell, 2048);
        i2 = 0;
        while (i2 < 5) {
            overrideCCombo.add("item" + i2);
            ++i2;
        }
        overrideCCombo.setText("CCombo");
        overrideCCombo.setToolTipText("CCombo ToolTip");
        overrideCCombo.setData("name", (Object)"CCombo");
        overrideCCombo.getAccessible().addAccessibleListener((AccessibleListener)overrideAccessibleAdapter);
        cTabFolder = new CTabFolder((Composite)shell, 0);
        i2 = 0;
        while (i2 < 3) {
            CTabItem item5 = new CTabItem(cTabFolder, 0);
            item5.setText("CTabItem &" + i2);
            item5.setToolTipText("TabItem ToolTip" + i2);
            Text itemText = new Text((Composite)cTabFolder, 2050);
            itemText.setText("\nText for CTabItem " + i2 + "\n\n");
            item5.setControl((Control)itemText);
            ++i2;
        }
        cTabFolder.setSelection(cTabFolder.getItem(0));
        overrideCTabFolder = new CTabFolder((Composite)shell, 0);
        i2 = 0;
        while (i2 < 3) {
            CTabItem item6 = new CTabItem(overrideCTabFolder, 0);
            item6.setText("CTabItem &" + i2);
            item6.setToolTipText("TabItem ToolTip" + i2);
            Text itemText = new Text((Composite)overrideCTabFolder, 2050);
            itemText.setText("\nText for CTabItem " + i2 + "\n\n");
            item6.setControl((Control)itemText);
            ++i2;
        }
        overrideCTabFolder.setSelection(overrideCTabFolder.getItem(0));
        overrideCTabFolder.setData("name", (Object)"CTabFolder");
        overrideCTabFolder.setData("child", (Object)"CTabItem");
        overrideCTabFolder.getAccessible().addAccessibleListener((AccessibleListener)overrideAccessibleAdapter);
        styledText = new StyledText((Composite)shell, 2052);
        styledText.setText("Contents of single-line StyledText");
        overrideStyledText = new StyledText((Composite)shell, 2052);
        overrideStyledText.setText("Contents of single-line StyledText");
        overrideStyledText.setData("name", (Object)"StyledText");
        overrideStyledText.getAccessible().addAccessibleListener((AccessibleListener)overrideAccessibleAdapter);
        multiLineStyledText = new StyledText((Composite)shell, 2050);
        multiLineStyledText.setText("Contents of multi-line StyledText\nLine 2\nLine 3\nLine 4");
        overrideMultiLineStyledText = new StyledText((Composite)shell, 2050);
        overrideMultiLineStyledText.setText("Contents of multi-line StyledText\nLine 2\nLine 3\nLine 4");
        overrideMultiLineStyledText.setData("name", (Object)"MultiLineStyledText");
        overrideMultiLineStyledText.getAccessible().addAccessibleListener((AccessibleListener)overrideAccessibleAdapter);
        scale = new Scale((Composite)shell, 0);
        scale.setToolTipText("Scale ToolTip");
        overrideScale = new Scale((Composite)shell, 0);
        overrideScale.setToolTipText("Scale ToolTip");
        overrideScale.setData("name", (Object)"Scale");
        overrideScale.getAccessible().addAccessibleListener((AccessibleListener)overrideAccessibleAdapter);
        slider = new Slider((Composite)shell, 0);
        slider.setToolTipText("Slider ToolTip");
        overrideSlider = new Slider((Composite)shell, 0);
        overrideSlider.setToolTipText("Slider ToolTip");
        overrideSlider.setData("name", (Object)"Slider");
        overrideSlider.getAccessible().addAccessibleListener((AccessibleListener)overrideAccessibleAdapter);
        if (!SWT.getPlatform().equals("cocoa")) {
            progressBar = new ProgressBar((Composite)shell, 0);
            progressBar.setSelection(50);
            progressBar.setToolTipText("ProgressBar ToolTip");
            overrideProgressBar = new ProgressBar((Composite)shell, 0);
            overrideProgressBar.setSelection(50);
            overrideProgressBar.setToolTipText("ProgressBar ToolTip");
            overrideProgressBar.setData("name", (Object)"ProgressBar");
            overrideProgressBar.getAccessible().addAccessibleListener((AccessibleListener)overrideAccessibleAdapter);
        }
        sash = new Sash((Composite)shell, 2048);
        sash.setToolTipText("Sash ToolTip");
        overrideSash = new Sash((Composite)shell, 2048);
        overrideSash.setToolTipText("Sash ToolTip");
        overrideSash.setData("name", (Object)"Sash");
        overrideSash.getAccessible().addAccessibleListener((AccessibleListener)overrideAccessibleAdapter);
        link = new Link((Composite)shell, 0);
        link.setText("<a>This is a link</a>");
        link.setToolTipText("Link ToolTip");
        overrideLink = new Link((Composite)shell, 0);
        overrideLink.setText("<a>This is a link</a>");
        overrideLink.setToolTipText("Link ToolTip");
        overrideLink.setData("name", (Object)"Link");
        overrideLink.getAccessible().addAccessibleListener((AccessibleListener)overrideAccessibleAdapter);
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        largeImage.dispose();
        smallImage.dispose();
        transparentImage.dispose();
        display.dispose();
    }
}

