/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.accessibility;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class Shape
extends Canvas {
    static final int SQUARE = 0;
    static final int CIRCLE = 1;
    static final int TRIANGLE = 2;
    static ResourceBundle bundle = ResourceBundle.getBundle("examples_accessibility");
    int color = 9;
    int shape = 0;

    public Shape(Composite parent, int style) {
        super(parent, style);
        this.addListeners();
    }

    void addListeners() {
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                Display display = Shape.this.getDisplay();
                Color c = display.getSystemColor(Shape.this.color);
                gc.setBackground(c);
                Rectangle rect = Shape.this.getClientArea();
                int length = Math.min(rect.width, rect.height);
                if (Shape.this.shape == 1) {
                    gc.fillOval(0, 0, length, length);
                } else {
                    gc.fillRectangle(0, 0, length, length);
                }
                if (Shape.this.isFocusControl()) {
                    gc.drawFocus(rect.x, rect.y, rect.width, rect.height);
                }
            }
        });
        this.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                Shape.this.redraw();
            }

            public void focusLost(FocusEvent e) {
                Shape.this.redraw();
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (Shape.this.getClientArea().contains(e.x, e.y)) {
                    Shape.this.setFocus();
                }
            }
        });
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
            }
        });
        this.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                switch (e.detail) {
                    case 8: 
                    case 16: {
                        e.doit = true;
                    }
                }
            }
        });
        this.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                MessageFormat formatter = new MessageFormat("");
                formatter.applyPattern(bundle.getString("name"));
                String colorName = bundle.getString("color" + Shape.this.color);
                String shapeName = bundle.getString("shape" + Shape.this.shape);
                e.result = formatter.format(new String[]{colorName, shapeName});
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getRole(AccessibleControlEvent e) {
                e.detail = 40;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0x100000;
                if (Shape.this.isFocusControl()) {
                    e.detail |= 4;
                }
            }
        });
    }

    public int getColor() {
        return this.color;
    }

    public int getShape() {
        return this.shape;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setShape(int shape) {
        this.shape = shape;
    }
}

