/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.browserexample;

import java.io.IOException;
import java.io.InputStream;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class BrowserExample {
    static ResourceBundle resourceBundle = ResourceBundle.getBundle("examples_browser");
    int index;
    boolean busy;
    Image[] images;
    Image icon = null;
    boolean title = false;
    Composite parent;
    Text locationBar;
    Browser browser;
    ToolBar toolbar;
    Canvas canvas;
    ToolItem itemBack;
    ToolItem itemForward;
    Label status;
    ProgressBar progressBar;
    SWTError error = null;
    static final String[] imageLocations = new String[]{"eclipse01.bmp", "eclipse02.bmp", "eclipse03.bmp", "eclipse04.bmp", "eclipse05.bmp", "eclipse06.bmp", "eclipse07.bmp", "eclipse08.bmp", "eclipse09.bmp", "eclipse10.bmp", "eclipse11.bmp", "eclipse12.bmp"};
    static final String iconLocation = "document.gif";

    public BrowserExample(Composite parent, boolean top) {
        this.parent = parent;
        try {
            this.browser = new Browser(parent, 2048);
        }
        catch (SWTError e) {
            this.error = e;
            parent.setLayout((Layout)new FillLayout());
            Label label = new Label(parent, 0x1000040);
            label.setText(BrowserExample.getResourceString("BrowserNotCreated"));
            parent.layout(true);
            return;
        }
        this.initResources();
        final Display display = parent.getDisplay();
        this.browser.setData("org.eclipse.swt.examples.browserexample.BrowserApplication", (Object)this);
        this.browser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent event) {
                Shell shell = new Shell(display);
                if (BrowserExample.this.icon != null) {
                    shell.setImage(BrowserExample.this.icon);
                }
                shell.setLayout((Layout)new FillLayout());
                BrowserExample app = new BrowserExample((Composite)shell, false);
                app.setShellDecoration(BrowserExample.this.icon, true);
                event.browser = app.getBrowser();
            }
        });
        if (top) {
            this.browser.setUrl(BrowserExample.getResourceString("Startup"));
            this.show(false, null, null, true, true, true, true);
        } else {
            this.browser.addVisibilityWindowListener(new VisibilityWindowListener(){

                public void hide(WindowEvent e) {
                }

                public void show(WindowEvent e) {
                    Browser browser = (Browser)e.widget;
                    BrowserExample app = (BrowserExample)browser.getData("org.eclipse.swt.examples.browserexample.BrowserApplication");
                    app.show(true, e.location, e.size, e.addressBar, e.menuBar, e.statusBar, e.toolBar);
                }
            });
            this.browser.addCloseWindowListener(new CloseWindowListener(){

                public void close(WindowEvent event) {
                    Browser browser = (Browser)event.widget;
                    Shell shell = browser.getShell();
                    shell.close();
                }
            });
        }
    }

    public void dispose() {
        this.freeResources();
    }

    static String getResourceString(String key) {
        try {
            return resourceBundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + key + "!";
        }
    }

    public SWTError getError() {
        return this.error;
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public void setShellDecoration(Image icon, boolean title) {
        this.icon = icon;
        this.title = title;
    }

    void show(boolean owned, Point location, Point size, boolean addressBar, boolean menuBar, boolean statusBar, boolean toolBar) {
        final Shell shell = this.browser.getShell();
        if (owned) {
            if (location != null) {
                shell.setLocation(location);
            }
            if (size != null) {
                shell.setSize(shell.computeSize(size.x, size.y));
            }
        }
        FormData data = null;
        if (toolBar) {
            this.toolbar = new ToolBar(this.parent, 0);
            data = new FormData();
            data.top = new FormAttachment(0, 5);
            this.toolbar.setLayoutData((Object)data);
            this.itemBack = new ToolItem(this.toolbar, 8);
            this.itemBack.setText(BrowserExample.getResourceString("Back"));
            this.itemForward = new ToolItem(this.toolbar, 8);
            this.itemForward.setText(BrowserExample.getResourceString("Forward"));
            final ToolItem itemStop = new ToolItem(this.toolbar, 8);
            itemStop.setText(BrowserExample.getResourceString("Stop"));
            final ToolItem itemRefresh = new ToolItem(this.toolbar, 8);
            itemRefresh.setText(BrowserExample.getResourceString("Refresh"));
            final ToolItem itemGo = new ToolItem(this.toolbar, 8);
            itemGo.setText(BrowserExample.getResourceString("Go"));
            this.itemBack.setEnabled(this.browser.isBackEnabled());
            this.itemForward.setEnabled(this.browser.isForwardEnabled());
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    ToolItem item = (ToolItem)event.widget;
                    if (item == BrowserExample.this.itemBack) {
                        BrowserExample.this.browser.back();
                    } else if (item == BrowserExample.this.itemForward) {
                        BrowserExample.this.browser.forward();
                    } else if (item == itemStop) {
                        BrowserExample.this.browser.stop();
                    } else if (item == itemRefresh) {
                        BrowserExample.this.browser.refresh();
                    } else if (item == itemGo) {
                        BrowserExample.this.browser.setUrl(BrowserExample.this.locationBar.getText());
                    }
                }
            };
            this.itemBack.addListener(13, listener);
            this.itemForward.addListener(13, listener);
            itemStop.addListener(13, listener);
            itemRefresh.addListener(13, listener);
            itemGo.addListener(13, listener);
            this.canvas = new Canvas(this.parent, 262144);
            data = new FormData();
            data.width = 24;
            data.height = 24;
            data.top = new FormAttachment(0, 5);
            data.right = new FormAttachment(100, -5);
            this.canvas.setLayoutData((Object)data);
            final Rectangle rect = this.images[0].getBounds();
            this.canvas.addListener(9, new Listener(){

                public void handleEvent(Event e) {
                    Point pt = ((Canvas)e.widget).getSize();
                    e.gc.drawImage(BrowserExample.this.images[BrowserExample.this.index], 0, 0, rect.width, rect.height, 0, 0, pt.x, pt.y);
                }
            });
            this.canvas.addListener(3, new Listener(){

                public void handleEvent(Event e) {
                    BrowserExample.this.browser.setUrl(BrowserExample.getResourceString("Startup"));
                }
            });
            final Display display = this.parent.getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    if (BrowserExample.this.canvas.isDisposed()) {
                        return;
                    }
                    if (BrowserExample.this.busy) {
                        ++BrowserExample.this.index;
                        if (BrowserExample.this.index == BrowserExample.this.images.length) {
                            BrowserExample.this.index = 0;
                        }
                        BrowserExample.this.canvas.redraw();
                    }
                    display.timerExec(150, (Runnable)this);
                }
            });
        }
        if (addressBar) {
            this.locationBar = new Text(this.parent, 2048);
            data = new FormData();
            if (this.toolbar != null) {
                data.top = new FormAttachment((Control)this.toolbar, 0, 128);
                data.left = new FormAttachment((Control)this.toolbar, 5, 131072);
                data.right = new FormAttachment((Control)this.canvas, -5, -1);
            } else {
                data.top = new FormAttachment(0, 0);
                data.left = new FormAttachment(0, 0);
                data.right = new FormAttachment(100, 0);
            }
            this.locationBar.setLayoutData((Object)data);
            this.locationBar.addListener(14, new Listener(){

                public void handleEvent(Event e) {
                    BrowserExample.this.browser.setUrl(BrowserExample.this.locationBar.getText());
                }
            });
        }
        if (statusBar) {
            this.status = new Label(this.parent, 0);
            this.progressBar = new ProgressBar(this.parent, 0);
            data = new FormData();
            data.left = new FormAttachment(0, 5);
            data.right = new FormAttachment((Control)this.progressBar, 0, -1);
            data.bottom = new FormAttachment(100, -5);
            this.status.setLayoutData((Object)data);
            data = new FormData();
            data.right = new FormAttachment(100, -5);
            data.bottom = new FormAttachment(100, -5);
            this.progressBar.setLayoutData((Object)data);
            this.browser.addStatusTextListener(new StatusTextListener(){

                public void changed(StatusTextEvent event) {
                    BrowserExample.this.status.setText(event.text);
                }
            });
        }
        this.parent.setLayout((Layout)new FormLayout());
        Canvas aboveBrowser = toolBar ? this.canvas : (addressBar ? this.locationBar : null);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = aboveBrowser != null ? new FormAttachment((Control)aboveBrowser, 5, -1) : new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = this.status != null ? new FormAttachment((Control)this.status, -5, -1) : new FormAttachment(100, 0);
        this.browser.setLayoutData((Object)data);
        if (statusBar || toolBar) {
            this.browser.addProgressListener(new ProgressListener(){

                public void changed(ProgressEvent event) {
                    if (event.total == 0) {
                        return;
                    }
                    int ratio = event.current * 100 / event.total;
                    if (BrowserExample.this.progressBar != null) {
                        BrowserExample.this.progressBar.setSelection(ratio);
                    }
                    boolean bl = BrowserExample.this.busy = event.current != event.total;
                    if (!BrowserExample.this.busy) {
                        BrowserExample.this.index = 0;
                        if (BrowserExample.this.canvas != null) {
                            BrowserExample.this.canvas.redraw();
                        }
                    }
                }

                public void completed(ProgressEvent event) {
                    if (BrowserExample.this.progressBar != null) {
                        BrowserExample.this.progressBar.setSelection(0);
                    }
                    BrowserExample.this.busy = false;
                    BrowserExample.this.index = 0;
                    if (BrowserExample.this.canvas != null) {
                        BrowserExample.this.itemBack.setEnabled(BrowserExample.this.browser.isBackEnabled());
                        BrowserExample.this.itemForward.setEnabled(BrowserExample.this.browser.isForwardEnabled());
                        BrowserExample.this.canvas.redraw();
                    }
                }
            });
        }
        if (addressBar || statusBar || toolBar) {
            this.browser.addLocationListener(new LocationListener(){

                public void changed(LocationEvent event) {
                    BrowserExample.this.busy = true;
                    if (event.top && BrowserExample.this.locationBar != null) {
                        BrowserExample.this.locationBar.setText(event.location);
                    }
                }

                public void changing(LocationEvent event) {
                }
            });
        }
        if (this.title) {
            this.browser.addTitleListener(new TitleListener(){

                public void changed(TitleEvent event) {
                    shell.setText(String.valueOf(event.title) + " - " + BrowserExample.getResourceString("window.title"));
                }
            });
        }
        this.parent.layout(true);
        if (owned) {
            shell.open();
        }
    }

    public void focus() {
        if (this.locationBar != null) {
            this.locationBar.setFocus();
        } else if (this.browser != null) {
            this.browser.setFocus();
        } else {
            this.parent.setFocus();
        }
    }

    void freeResources() {
        if (this.images != null) {
            int i = 0;
            while (i < this.images.length) {
                Image image = this.images[i];
                if (image != null) {
                    image.dispose();
                }
                ++i;
            }
            this.images = null;
        }
    }

    void initResources() {
        Class<?> clazz = this.getClass();
        if (resourceBundle != null) {
            try {
                if (this.images == null) {
                    this.images = new Image[imageLocations.length];
                    int i = 0;
                    while (i < imageLocations.length) {
                        InputStream sourceStream = clazz.getResourceAsStream(imageLocations[i]);
                        ImageData source = new ImageData(sourceStream);
                        ImageData mask = source.getTransparencyMask();
                        this.images[i] = new Image(null, source, mask);
                        try {
                            sourceStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        ++i;
                    }
                }
                return;
            }
            catch (Throwable throwable) {}
        }
        String error = resourceBundle != null ? BrowserExample.getResourceString("error.CouldNotLoadResources") : "Unable to load resources";
        this.freeResources();
        throw new RuntimeException(error);
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        shell.setText(BrowserExample.getResourceString("window.title"));
        InputStream stream = BrowserExample.class.getResourceAsStream(iconLocation);
        Image icon = new Image((Device)display, stream);
        shell.setImage(icon);
        try {
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        BrowserExample app = new BrowserExample((Composite)shell, true);
        app.setShellDecoration(icon, true);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        icon.dispose();
        app.dispose();
        display.dispose();
    }
}

