/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.clipboard;

import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ClipboardExample {
    Clipboard clipboard;
    Shell shell;
    Text text;
    Combo combo;
    StyledText styledText;
    Label status;
    static final int HSIZE = 100;
    static final int VSIZE = 60;

    public static void main(String[] args) {
        Display display = new Display();
        new ClipboardExample().open(display);
        display.dispose();
    }

    public void open(Display display) {
        this.clipboard = new Clipboard(display);
        this.shell = new Shell(display);
        this.shell.setText("SWT Clipboard");
        this.shell.setLayout((Layout)new FillLayout());
        ScrolledComposite sc = new ScrolledComposite((Composite)this.shell, 768);
        Composite parent = new Composite((Composite)sc, 0);
        sc.setContent((Control)parent);
        parent.setLayout((Layout)new GridLayout(2, true));
        Group copyGroup = new Group(parent, 0);
        copyGroup.setText("Copy From:");
        GridData data = new GridData(1808);
        copyGroup.setLayoutData((Object)data);
        copyGroup.setLayout((Layout)new GridLayout(3, false));
        Group pasteGroup = new Group(parent, 0);
        pasteGroup.setText("Paste To:");
        data = new GridData(1808);
        pasteGroup.setLayoutData((Object)data);
        pasteGroup.setLayout((Layout)new GridLayout(3, false));
        Group controlGroup = new Group(parent, 0);
        controlGroup.setText("Control API:");
        data = new GridData(768);
        data.horizontalSpan = 2;
        controlGroup.setLayoutData((Object)data);
        controlGroup.setLayout((Layout)new GridLayout(5, false));
        Group typesGroup = new Group(parent, 0);
        typesGroup.setText("Available Types");
        data = new GridData(768);
        data.horizontalSpan = 2;
        typesGroup.setLayoutData((Object)data);
        typesGroup.setLayout((Layout)new GridLayout(2, false));
        this.status = new Label(parent, 0);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.status.setLayoutData((Object)data);
        this.createTextTransfer((Composite)copyGroup, (Composite)pasteGroup);
        this.createRTFTransfer((Composite)copyGroup, (Composite)pasteGroup);
        this.createHTMLTransfer((Composite)copyGroup, (Composite)pasteGroup);
        this.createFileTransfer((Composite)copyGroup, (Composite)pasteGroup);
        this.createImageTransfer((Composite)copyGroup, (Composite)pasteGroup);
        this.createMyTransfer((Composite)copyGroup, (Composite)pasteGroup);
        this.createControlTransfer((Composite)controlGroup);
        this.createAvailableTypes((Composite)typesGroup);
        sc.setMinSize(parent.computeSize(-1, -1));
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        Point size = this.shell.computeSize(-1, -1);
        Rectangle monitorArea = this.shell.getMonitor().getClientArea();
        this.shell.setSize(Math.min(size.x, monitorArea.width - 20), Math.min(size.y, monitorArea.height - 20));
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        this.clipboard.dispose();
    }

    void createTextTransfer(Composite copyParent, Composite pasteParent) {
        Label l = new Label(copyParent, 0);
        l.setText("TextTransfer:");
        final Text copyText = new Text(copyParent, 2818);
        copyText.setText("some\nplain\ntext");
        GridData data = new GridData(1808);
        data.widthHint = 100;
        data.heightHint = 60;
        copyText.setLayoutData((Object)data);
        Button b = new Button(copyParent, 8);
        b.setText("Copy");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String data = copyText.getText();
                if (data.length() > 0) {
                    ClipboardExample.this.status.setText("");
                    ClipboardExample.this.clipboard.setContents(new Object[]{data}, new Transfer[]{TextTransfer.getInstance()});
                } else {
                    ClipboardExample.this.status.setText("No text to copy");
                }
            }
        });
        l = new Label(pasteParent, 0);
        l.setText("TextTransfer:");
        final Text pasteText = new Text(pasteParent, 2826);
        data = new GridData(1808);
        data.widthHint = 100;
        data.heightHint = 60;
        pasteText.setLayoutData((Object)data);
        b = new Button(pasteParent, 8);
        b.setText("Paste");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String data = (String)ClipboardExample.this.clipboard.getContents((Transfer)TextTransfer.getInstance());
                if (data != null && data.length() > 0) {
                    ClipboardExample.this.status.setText("");
                    pasteText.setText("begin paste>" + data + "<end paste");
                } else {
                    ClipboardExample.this.status.setText("No text to paste");
                }
            }
        });
    }

    void createRTFTransfer(Composite copyParent, Composite pasteParent) {
        Label l = new Label(copyParent, 0);
        l.setText("RTFTransfer:");
        final Text copyRtfText = new Text(copyParent, 2818);
        copyRtfText.setText("some\nrtf\ntext");
        GridData data = new GridData(1808);
        data.widthHint = 100;
        data.heightHint = 60;
        copyRtfText.setLayoutData((Object)data);
        Button b = new Button(copyParent, 8);
        b.setText("Copy");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String data = copyRtfText.getText();
                if (data.length() > 0) {
                    ClipboardExample.this.status.setText("");
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("{\\rtf1\\ansi\\uc1{\\colortbl;\\red255\\green0\\blue0;}\\uc1\\b\\i ");
                    int i = 0;
                    while (i < data.length()) {
                        char ch = data.charAt(i);
                        if (ch > '\u00ff') {
                            buffer.append("\\u");
                            buffer.append(Integer.toString((short)ch));
                            buffer.append('?');
                        } else {
                            if (ch == '}' || ch == '{' || ch == '\\') {
                                buffer.append('\\');
                            }
                            buffer.append(ch);
                            if (ch == '\n') {
                                buffer.append("\\par ");
                            }
                            if (ch == '\r' && (i - 1 == data.length() || data.charAt(i + 1) != '\n')) {
                                buffer.append("\\par ");
                            }
                        }
                        ++i;
                    }
                    buffer.append("}");
                    ClipboardExample.this.clipboard.setContents(new Object[]{buffer.toString()}, new Transfer[]{RTFTransfer.getInstance()});
                } else {
                    ClipboardExample.this.status.setText("No RTF to copy");
                }
            }
        });
        l = new Label(pasteParent, 0);
        l.setText("RTFTransfer:");
        final Text pasteRtfText = new Text(pasteParent, 2826);
        data = new GridData(1808);
        data.widthHint = 100;
        data.heightHint = 60;
        pasteRtfText.setLayoutData((Object)data);
        b = new Button(pasteParent, 8);
        b.setText("Paste");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String data = (String)ClipboardExample.this.clipboard.getContents((Transfer)RTFTransfer.getInstance());
                if (data != null && data.length() > 0) {
                    ClipboardExample.this.status.setText("");
                    pasteRtfText.setText("start paste>" + data + "<end paste");
                } else {
                    ClipboardExample.this.status.setText("No RTF to paste");
                }
            }
        });
    }

    void createHTMLTransfer(Composite copyParent, Composite pasteParent) {
        Label l = new Label(copyParent, 0);
        l.setText("HTMLTransfer:");
        final Text copyHtmlText = new Text(copyParent, 2818);
        copyHtmlText.setText("<b>Hello World</b>");
        GridData data = new GridData(1808);
        data.widthHint = 100;
        data.heightHint = 60;
        copyHtmlText.setLayoutData((Object)data);
        Button b = new Button(copyParent, 8);
        b.setText("Copy");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String data = copyHtmlText.getText();
                if (data.length() > 0) {
                    ClipboardExample.this.status.setText("");
                    ClipboardExample.this.clipboard.setContents(new Object[]{data}, new Transfer[]{HTMLTransfer.getInstance()});
                } else {
                    ClipboardExample.this.status.setText("No HTML to copy");
                }
            }
        });
        l = new Label(pasteParent, 0);
        l.setText("HTMLTransfer:");
        final Text pasteHtmlText = new Text(pasteParent, 2826);
        data = new GridData(1808);
        data.widthHint = 100;
        data.heightHint = 60;
        pasteHtmlText.setLayoutData((Object)data);
        b = new Button(pasteParent, 8);
        b.setText("Paste");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String data = (String)ClipboardExample.this.clipboard.getContents((Transfer)HTMLTransfer.getInstance());
                if (data != null && data.length() > 0) {
                    ClipboardExample.this.status.setText("");
                    pasteHtmlText.setText("start paste>" + data + "<end paste");
                } else {
                    ClipboardExample.this.status.setText("No HTML to paste");
                }
            }
        });
    }

    void createFileTransfer(Composite copyParent, Composite pasteParent) {
        Label l = new Label(copyParent, 0);
        l.setText("FileTransfer:");
        GridData data = new GridData();
        data.verticalSpan = 3;
        l.setLayoutData((Object)data);
        final Table copyFileTable = new Table(copyParent, 2818);
        data = new GridData(1808);
        data.widthHint = 100;
        data.heightHint = 60;
        data.verticalSpan = 3;
        copyFileTable.setLayoutData((Object)data);
        Button b = new Button(copyParent, 8);
        b.setText("Select file(s)");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(ClipboardExample.this.shell, 4098);
                String result = dialog.open();
                if (result != null && result.length() > 0) {
                    String separator = System.getProperty("file.separator");
                    String path = dialog.getFilterPath();
                    String[] names = dialog.getFileNames();
                    int i = 0;
                    while (i < names.length) {
                        TableItem item = new TableItem(copyFileTable, 0);
                        item.setText(String.valueOf(path) + separator + names[i]);
                        ++i;
                    }
                }
            }
        });
        b = new Button(copyParent, 8);
        b.setText("Select directory");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(ClipboardExample.this.shell, 4096);
                String result = dialog.open();
                if (result != null && result.length() > 0) {
                    TableItem item = new TableItem(copyFileTable, 0);
                    item.setText(result);
                }
            }
        });
        b = new Button(copyParent, 8);
        b.setText("Copy");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = copyFileTable.getItems();
                if (items.length > 0) {
                    ClipboardExample.this.status.setText("");
                    String[] data = new String[items.length];
                    int i = 0;
                    while (i < data.length) {
                        data[i] = items[i].getText();
                        ++i;
                    }
                    ClipboardExample.this.clipboard.setContents(new Object[]{data}, new Transfer[]{FileTransfer.getInstance()});
                } else {
                    ClipboardExample.this.status.setText("No file to copy");
                }
            }
        });
        l = new Label(pasteParent, 0);
        l.setText("FileTransfer:");
        final Table pasteFileTable = new Table(pasteParent, 2818);
        data = new GridData(1808);
        data.widthHint = 100;
        data.heightHint = 60;
        pasteFileTable.setLayoutData((Object)data);
        b = new Button(pasteParent, 8);
        b.setText("Paste");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] data = (String[])ClipboardExample.this.clipboard.getContents((Transfer)FileTransfer.getInstance());
                if (data != null && data.length > 0) {
                    ClipboardExample.this.status.setText("");
                    pasteFileTable.removeAll();
                    int i = 0;
                    while (i < data.length) {
                        TableItem item = new TableItem(pasteFileTable, 0);
                        item.setText(data[i]);
                        ++i;
                    }
                } else {
                    ClipboardExample.this.status.setText("No file to paste");
                }
            }
        });
    }

    void createImageTransfer(Composite copyParent, Composite pasteParent) {
        final Image[] copyImage = new Image[1];
        Label l = new Label(copyParent, 0);
        l.setText("ImageTransfer:");
        GridData data = new GridData();
        data.verticalSpan = 2;
        l.setLayoutData((Object)data);
        final Canvas copyImageCanvas = new Canvas(copyParent, 2816);
        data = new GridData(1808);
        data.verticalSpan = 2;
        data.widthHint = 100;
        data.heightHint = 60;
        copyImageCanvas.setLayoutData((Object)data);
        final Point copyOrigin = new Point(0, 0);
        final ScrollBar copyHBar = copyImageCanvas.getHorizontalBar();
        copyHBar.setEnabled(false);
        copyHBar.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (copyImage[0] != null) {
                    int hSelection = copyHBar.getSelection();
                    int destX = -hSelection - copyOrigin.x;
                    Rectangle rect = copyImage[0].getBounds();
                    copyImageCanvas.scroll(destX, 0, 0, 0, rect.width, rect.height, false);
                    copyOrigin.x = -hSelection;
                }
            }
        });
        final ScrollBar copyVBar = copyImageCanvas.getVerticalBar();
        copyVBar.setEnabled(false);
        copyVBar.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (copyImage[0] != null) {
                    int vSelection = copyVBar.getSelection();
                    int destY = -vSelection - copyOrigin.y;
                    Rectangle rect = copyImage[0].getBounds();
                    copyImageCanvas.scroll(0, destY, 0, 0, rect.width, rect.height, false);
                    copyOrigin.y = -vSelection;
                }
            }
        });
        copyImageCanvas.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                if (copyImage[0] != null) {
                    int marginHeight;
                    GC gc = e.gc;
                    gc.drawImage(copyImage[0], copyOrigin.x, copyOrigin.y);
                    Rectangle rect = copyImage[0].getBounds();
                    Rectangle client = copyImageCanvas.getClientArea();
                    int marginWidth = client.width - rect.width;
                    if (marginWidth > 0) {
                        gc.fillRectangle(rect.width, 0, marginWidth, client.height);
                    }
                    if ((marginHeight = client.height - rect.height) > 0) {
                        gc.fillRectangle(0, rect.height, client.width, marginHeight);
                    }
                    gc.dispose();
                }
            }
        });
        Button openButton = new Button(copyParent, 8);
        openButton.setText("Open Image");
        openButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(ClipboardExample.this.shell, 4096);
                dialog.setText("Open an image file or cancel");
                String string = dialog.open();
                if (string != null) {
                    if (copyImage[0] != null) {
                        System.out.println("CopyImage");
                        copyImage[0].dispose();
                    }
                    copyImage[0] = new Image((Device)e.display, string);
                    copyVBar.setEnabled(true);
                    copyHBar.setEnabled(true);
                    copyOrigin.x = 0;
                    copyOrigin.y = 0;
                    Rectangle rect = copyImage[0].getBounds();
                    Rectangle client = copyImageCanvas.getClientArea();
                    copyHBar.setMaximum(rect.width);
                    copyVBar.setMaximum(rect.height);
                    copyHBar.setThumb(Math.min(rect.width, client.width));
                    copyVBar.setThumb(Math.min(rect.height, client.height));
                    copyImageCanvas.scroll(0, 0, 0, 0, rect.width, rect.height, true);
                    copyVBar.setSelection(0);
                    copyHBar.setSelection(0);
                    copyImageCanvas.redraw();
                }
            }
        });
        Button b = new Button(copyParent, 8);
        b.setText("Copy");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (copyImage[0] != null) {
                    ClipboardExample.this.status.setText("");
                    ClipboardExample.this.clipboard.setContents(new Object[]{copyImage[0].getImageData()}, new Transfer[]{ImageTransfer.getInstance()});
                } else {
                    ClipboardExample.this.status.setText("No image to copy");
                }
            }
        });
        final Image[] pasteImage = new Image[1];
        l = new Label(pasteParent, 0);
        l.setText("ImageTransfer:");
        final Canvas pasteImageCanvas = new Canvas(pasteParent, 2816);
        data = new GridData(1808);
        data.widthHint = 100;
        data.heightHint = 60;
        pasteImageCanvas.setLayoutData((Object)data);
        final Point pasteOrigin = new Point(0, 0);
        final ScrollBar pasteHBar = pasteImageCanvas.getHorizontalBar();
        pasteHBar.setEnabled(false);
        pasteHBar.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (pasteImage[0] != null) {
                    int hSelection = pasteHBar.getSelection();
                    int destX = -hSelection - pasteOrigin.x;
                    Rectangle rect = pasteImage[0].getBounds();
                    pasteImageCanvas.scroll(destX, 0, 0, 0, rect.width, rect.height, false);
                    pasteOrigin.x = -hSelection;
                }
            }
        });
        final ScrollBar pasteVBar = pasteImageCanvas.getVerticalBar();
        pasteVBar.setEnabled(false);
        pasteVBar.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (pasteImage[0] != null) {
                    int vSelection = pasteVBar.getSelection();
                    int destY = -vSelection - pasteOrigin.y;
                    Rectangle rect = pasteImage[0].getBounds();
                    pasteImageCanvas.scroll(0, destY, 0, 0, rect.width, rect.height, false);
                    pasteOrigin.y = -vSelection;
                }
            }
        });
        pasteImageCanvas.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                if (pasteImage[0] != null) {
                    int marginHeight;
                    GC gc = e.gc;
                    gc.drawImage(pasteImage[0], pasteOrigin.x, pasteOrigin.y);
                    Rectangle rect = pasteImage[0].getBounds();
                    Rectangle client = pasteImageCanvas.getClientArea();
                    int marginWidth = client.width - rect.width;
                    if (marginWidth > 0) {
                        gc.fillRectangle(rect.width, 0, marginWidth, client.height);
                    }
                    if ((marginHeight = client.height - rect.height) > 0) {
                        gc.fillRectangle(0, rect.height, client.width, marginHeight);
                    }
                }
            }
        });
        b = new Button(pasteParent, 8);
        b.setText("Paste");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageData data = (ImageData)ClipboardExample.this.clipboard.getContents((Transfer)ImageTransfer.getInstance());
                if (data != null) {
                    if (pasteImage[0] != null) {
                        System.out.println("PasteImage");
                        pasteImage[0].dispose();
                    }
                    ClipboardExample.this.status.setText("");
                    pasteImage[0] = new Image((Device)e.display, data);
                    pasteVBar.setEnabled(true);
                    pasteHBar.setEnabled(true);
                    pasteOrigin.x = 0;
                    pasteOrigin.y = 0;
                    Rectangle rect = pasteImage[0].getBounds();
                    Rectangle client = pasteImageCanvas.getClientArea();
                    pasteHBar.setMaximum(rect.width);
                    pasteVBar.setMaximum(rect.height);
                    pasteHBar.setThumb(Math.min(rect.width, client.width));
                    pasteVBar.setThumb(Math.min(rect.height, client.height));
                    pasteImageCanvas.scroll(0, 0, 0, 0, rect.width, rect.height, true);
                    pasteVBar.setSelection(0);
                    pasteHBar.setSelection(0);
                    pasteImageCanvas.redraw();
                } else {
                    ClipboardExample.this.status.setText("No image to paste");
                }
            }
        });
    }

    void createMyTransfer(Composite copyParent, Composite pasteParent) {
    }

    void createControlTransfer(Composite parent) {
        Label l = new Label(parent, 0);
        l.setText("Text:");
        Button b = new Button(parent, 8);
        b.setText("Cut");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClipboardExample.this.text.cut();
            }
        });
        b = new Button(parent, 8);
        b.setText("Copy");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClipboardExample.this.text.copy();
            }
        });
        b = new Button(parent, 8);
        b.setText("Paste");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClipboardExample.this.text.paste();
            }
        });
        this.text = new Text(parent, 2818);
        GridData data = new GridData(768);
        data.widthHint = 100;
        data.heightHint = 60;
        this.text.setLayoutData((Object)data);
        l = new Label(parent, 0);
        l.setText("Combo:");
        b = new Button(parent, 8);
        b.setText("Cut");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClipboardExample.this.combo.cut();
            }
        });
        b = new Button(parent, 8);
        b.setText("Copy");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClipboardExample.this.combo.copy();
            }
        });
        b = new Button(parent, 8);
        b.setText("Paste");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClipboardExample.this.combo.paste();
            }
        });
        this.combo = new Combo(parent, 0);
        this.combo.setItems(new String[]{"Item 1", "Item 2", "Item 3", "A longer Item"});
        this.combo.setLayoutData((Object)new GridData(768));
        l = new Label(parent, 0);
        l.setText("StyledText:");
        b = new Button(parent, 8);
        b.setText("Cut");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClipboardExample.this.styledText.cut();
            }
        });
        b = new Button(parent, 8);
        b.setText("Copy");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClipboardExample.this.styledText.copy();
            }
        });
        b = new Button(parent, 8);
        b.setText("Paste");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClipboardExample.this.styledText.paste();
            }
        });
        this.styledText = new StyledText(parent, 2818);
        data = new GridData(768);
        data.widthHint = 100;
        data.heightHint = 60;
        this.styledText.setLayoutData((Object)data);
    }

    void createAvailableTypes(Composite parent) {
        final List list = new List(parent, 2816);
        GridData data = new GridData(1808);
        data.heightHint = 60;
        list.setLayoutData((Object)data);
        Button b = new Button(parent, 8);
        b.setText("Get Available Types");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                list.removeAll();
                String[] names = ClipboardExample.this.clipboard.getAvailableTypeNames();
                int i = 0;
                while (i < names.length) {
                    list.add(names[i]);
                    ++i;
                }
            }
        });
    }
}

