/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.clipboard;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.examples.clipboard.MyType;

public class MyTypeTransfer
extends ByteArrayTransfer {
    private static final String MYTYPENAME = "name_list";
    private static final int MYTYPEID = MyTypeTransfer.registerType((String)"name_list");
    private static MyTypeTransfer _instance = new MyTypeTransfer();

    public static MyTypeTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkMyType(object) || !this.isSupportedType(transferData)) {
            DND.error((int)2003);
        }
        MyType[] myTypes = (MyType[])object;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream writeOut = new DataOutputStream(out);
            int i = 0;
            int length = myTypes.length;
            while (i < length) {
                byte[] buffer = myTypes[i].firstName.getBytes();
                writeOut.writeInt(buffer.length);
                writeOut.write(buffer);
                buffer = myTypes[i].firstName.getBytes();
                writeOut.writeInt(buffer.length);
                writeOut.write(buffer);
                ++i;
            }
            byte[] buffer = out.toByteArray();
            writeOut.close();
            super.javaToNative((Object)buffer, transferData);
        }
        catch (IOException iOException) {}
    }

    public Object nativeToJava(TransferData transferData) {
        if (this.isSupportedType(transferData)) {
            byte[] buffer = (byte[])super.nativeToJava(transferData);
            if (buffer == null) {
                return null;
            }
            MyType[] myData = new MyType[]{};
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(buffer);
                DataInputStream readIn = new DataInputStream(in);
                while (readIn.available() > 20) {
                    MyType datum = new MyType();
                    int size = readIn.readInt();
                    byte[] name = new byte[size];
                    readIn.read(name);
                    datum.firstName = new String(name);
                    size = readIn.readInt();
                    name = new byte[size];
                    readIn.read(name);
                    datum.lastName = new String(name);
                    MyType[] newMyData = new MyType[myData.length + 1];
                    System.arraycopy(myData, 0, newMyData, 0, myData.length);
                    newMyData[myData.length] = datum;
                    myData = newMyData;
                }
                readIn.close();
            }
            catch (IOException iOException) {
                return null;
            }
            return myData;
        }
        return null;
    }

    protected String[] getTypeNames() {
        return new String[]{MYTYPENAME};
    }

    protected int[] getTypeIds() {
        return new int[]{MYTYPEID};
    }

    boolean checkMyType(Object object) {
        if (object == null || !(object instanceof MyType[]) || ((MyType[])object).length == 0) {
            return false;
        }
        MyType[] myTypes = (MyType[])object;
        int i = 0;
        while (i < myTypes.length) {
            if (myTypes[i] == null || myTypes[i].firstName == null || myTypes[i].firstName.length() == 0 || myTypes[i].lastName == null || myTypes[i].lastName.length() == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean validate(Object object) {
        return this.checkMyType(object);
    }
}

