/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.AlignableTab;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

class ButtonTab
extends AlignableTab {
    Button button1;
    Button button2;
    Button button3;
    Button button4;
    Button button5;
    Button button6;
    Button button7;
    Button button8;
    Button button9;
    Group textButtonGroup;
    Group imageButtonGroup;
    Group imagetextButtonGroup;
    Button upButton;
    Button downButton;
    Button pushButton;
    Button checkButton;
    Button radioButton;
    Button toggleButton;
    Button arrowButton;
    Button flatButton;
    Button wrapButton;

    ButtonTab(ControlExample instance) {
        super(instance);
    }

    void createControlGroup() {
        super.createControlGroup();
        this.upButton = new Button((Composite)this.alignmentGroup, 16);
        this.upButton.setText(ControlExample.getResourceString("Up"));
        this.downButton = new Button((Composite)this.alignmentGroup, 16);
        this.downButton.setText(ControlExample.getResourceString("Down"));
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!((Button)event.widget).getSelection()) {
                    return;
                }
                ButtonTab.this.setExampleWidgetAlignment();
            }
        };
        this.upButton.addSelectionListener((SelectionListener)selectionListener);
        this.downButton.addSelectionListener((SelectionListener)selectionListener);
    }

    void createExampleGroup() {
        super.createExampleGroup();
        this.textButtonGroup = new Group((Composite)this.exampleGroup, 0);
        GridLayout gridLayout = new GridLayout();
        this.textButtonGroup.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 3;
        this.textButtonGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.textButtonGroup.setText(ControlExample.getResourceString("Text_Buttons"));
        this.imageButtonGroup = new Group((Composite)this.exampleGroup, 0);
        gridLayout = new GridLayout();
        this.imageButtonGroup.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 3;
        this.imageButtonGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.imageButtonGroup.setText(ControlExample.getResourceString("Image_Buttons"));
        this.imagetextButtonGroup = new Group((Composite)this.exampleGroup, 0);
        gridLayout = new GridLayout();
        this.imagetextButtonGroup.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 3;
        this.imagetextButtonGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.imagetextButtonGroup.setText(ControlExample.getResourceString("Image_Text_Buttons"));
    }

    void createExampleWidgets() {
        int style = this.getDefaultStyle();
        if (this.pushButton.getSelection()) {
            style |= 8;
        }
        if (this.checkButton.getSelection()) {
            style |= 0x20;
        }
        if (this.radioButton.getSelection()) {
            style |= 0x10;
        }
        if (this.toggleButton.getSelection()) {
            style |= 2;
        }
        if (this.flatButton.getSelection()) {
            style |= 0x800000;
        }
        if (this.wrapButton.getSelection()) {
            style |= 0x40;
        }
        if (this.borderButton.getSelection()) {
            style |= 0x800;
        }
        if (this.leftButton.getSelection()) {
            style |= 0x4000;
        }
        if (this.rightButton.getSelection()) {
            style |= 0x20000;
        }
        if (this.arrowButton.getSelection()) {
            style |= 4;
            if (this.upButton.getSelection()) {
                style |= 0x80;
            }
            if (this.downButton.getSelection()) {
                style |= 0x400;
            }
        } else if (this.centerButton.getSelection()) {
            style |= 0x1000000;
        }
        this.button1 = new Button((Composite)this.textButtonGroup, style);
        this.button1.setText(ControlExample.getResourceString("One"));
        this.button2 = new Button((Composite)this.textButtonGroup, style);
        this.button2.setText(ControlExample.getResourceString("Two"));
        this.button3 = new Button((Composite)this.textButtonGroup, style);
        if (this.wrapButton.getSelection()) {
            this.button3.setText(ControlExample.getResourceString("Wrap_Text"));
        } else {
            this.button3.setText(ControlExample.getResourceString("Three"));
        }
        this.button4 = new Button((Composite)this.imageButtonGroup, style);
        this.button4.setImage(this.instance.images[0]);
        this.button5 = new Button((Composite)this.imageButtonGroup, style);
        this.button5.setImage(this.instance.images[1]);
        this.button6 = new Button((Composite)this.imageButtonGroup, style);
        this.button6.setImage(this.instance.images[2]);
        this.button7 = new Button((Composite)this.imagetextButtonGroup, style);
        this.button7.setText(ControlExample.getResourceString("One"));
        this.button7.setImage(this.instance.images[0]);
        this.button8 = new Button((Composite)this.imagetextButtonGroup, style);
        this.button8.setText(ControlExample.getResourceString("Two"));
        this.button8.setImage(this.instance.images[1]);
        this.button9 = new Button((Composite)this.imagetextButtonGroup, style);
        if (this.wrapButton.getSelection()) {
            this.button9.setText(ControlExample.getResourceString("Wrap_Text"));
        } else {
            this.button9.setText(ControlExample.getResourceString("Three"));
        }
        this.button9.setImage(this.instance.images[2]);
    }

    void createStyleGroup() {
        super.createStyleGroup();
        this.pushButton = new Button((Composite)this.styleGroup, 16);
        this.pushButton.setText("SWT.PUSH");
        this.checkButton = new Button((Composite)this.styleGroup, 16);
        this.checkButton.setText("SWT.CHECK");
        this.radioButton = new Button((Composite)this.styleGroup, 16);
        this.radioButton.setText("SWT.RADIO");
        this.toggleButton = new Button((Composite)this.styleGroup, 16);
        this.toggleButton.setText("SWT.TOGGLE");
        this.arrowButton = new Button((Composite)this.styleGroup, 16);
        this.arrowButton.setText("SWT.ARROW");
        this.flatButton = new Button((Composite)this.styleGroup, 32);
        this.flatButton.setText("SWT.FLAT");
        this.wrapButton = new Button((Composite)this.styleGroup, 32);
        this.wrapButton.setText("SWT.WRAP");
        this.borderButton = new Button((Composite)this.styleGroup, 32);
        this.borderButton.setText("SWT.BORDER");
    }

    Widget[] getExampleWidgets() {
        return new Widget[]{this.button1, this.button2, this.button3, this.button4, this.button5, this.button6, this.button7, this.button8, this.button9};
    }

    String[] getMethodNames() {
        return new String[]{"Grayed", "Selection", "Text", "ToolTipText"};
    }

    String getTabText() {
        return "Button";
    }

    void setExampleWidgetAlignment() {
        int alignment = 0;
        if (this.leftButton.getSelection()) {
            alignment = 16384;
        }
        if (this.centerButton.getSelection()) {
            alignment = 0x1000000;
        }
        if (this.rightButton.getSelection()) {
            alignment = 131072;
        }
        if (this.upButton.getSelection()) {
            alignment = 128;
        }
        if (this.downButton.getSelection()) {
            alignment = 1024;
        }
        this.button1.setAlignment(alignment);
        this.button2.setAlignment(alignment);
        this.button3.setAlignment(alignment);
        this.button4.setAlignment(alignment);
        this.button5.setAlignment(alignment);
        this.button6.setAlignment(alignment);
        this.button7.setAlignment(alignment);
        this.button8.setAlignment(alignment);
        this.button9.setAlignment(alignment);
    }

    void setExampleWidgetState() {
        super.setExampleWidgetState();
        if (this.arrowButton.getSelection()) {
            this.upButton.setEnabled(true);
            this.centerButton.setEnabled(false);
            this.downButton.setEnabled(true);
        } else {
            this.upButton.setEnabled(false);
            this.centerButton.setEnabled(true);
            this.downButton.setEnabled(false);
        }
        this.upButton.setSelection((this.button1.getStyle() & 0x80) != 0);
        this.downButton.setSelection((this.button1.getStyle() & 0x400) != 0);
        this.pushButton.setSelection((this.button1.getStyle() & 8) != 0);
        this.checkButton.setSelection((this.button1.getStyle() & 0x20) != 0);
        this.radioButton.setSelection((this.button1.getStyle() & 0x10) != 0);
        this.toggleButton.setSelection((this.button1.getStyle() & 2) != 0);
        this.arrowButton.setSelection((this.button1.getStyle() & 4) != 0);
        this.flatButton.setSelection((this.button1.getStyle() & 0x800000) != 0);
        this.wrapButton.setSelection((this.button1.getStyle() & 0x40) != 0);
        this.borderButton.setSelection((this.button1.getStyle() & 0x800) != 0);
    }
}

