/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.Tab;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

class DialogTab
extends Tab {
    Group dialogStyleGroup;
    Group resultGroup;
    Text textWidget;
    Combo dialogCombo;
    Button createButton;
    Button okButton;
    Button cancelButton;
    Button yesButton;
    Button noButton;
    Button retryButton;
    Button abortButton;
    Button ignoreButton;
    Button iconErrorButton;
    Button iconInformationButton;
    Button iconQuestionButton;
    Button iconWarningButton;
    Button iconWorkingButton;
    Button noIconButton;
    Button primaryModalButton;
    Button applicationModalButton;
    Button systemModalButton;
    Button sheetButton;
    Button effectsVisibleButton;
    Button usePreviousResultButton;
    Button saveButton;
    Button openButton;
    Button multiButton;
    RGB colorDialogResult;
    RGB fontDialogColorResult;
    RGB[] colorDialogCustomColors;
    String directoryDialogResult;
    String fileDialogResult;
    int fileDialogIndexResult;
    FontData[] fontDialogFontListResult;
    PrinterData printDialogResult;
    static String[] FilterExtensions = new String[]{"*.txt", "*.bat", "*.doc;*.rtf", "*"};
    static String[] FilterNames = new String[]{ControlExample.getResourceString("FilterName_0"), ControlExample.getResourceString("FilterName_1"), ControlExample.getResourceString("FilterName_2"), ControlExample.getResourceString("FilterName_3")};

    DialogTab(ControlExample instance) {
        super(instance);
    }

    void buttonStyleSelected(SelectionEvent event) {
        boolean ok = this.okButton.getSelection();
        boolean cancel = this.cancelButton.getSelection();
        boolean yes = this.yesButton.getSelection();
        boolean no = this.noButton.getSelection();
        boolean abort = this.abortButton.getSelection();
        boolean retry = this.retryButton.getSelection();
        boolean ignore = this.ignoreButton.getSelection();
        this.okButton.setEnabled(!yes && !no && !retry && !abort && !ignore);
        this.cancelButton.setEnabled(!abort && !ignore && yes == no);
        this.yesButton.setEnabled(!ok && !retry && !abort && !ignore && (!cancel || yes || no));
        this.noButton.setEnabled(!ok && !retry && !abort && !ignore && (!cancel || yes || no));
        this.retryButton.setEnabled(!ok && !yes && !no);
        this.abortButton.setEnabled(!ok && !cancel && !yes && !no);
        this.ignoreButton.setEnabled(!ok && !cancel && !yes && !no);
        this.createButton.setEnabled(!ok && !cancel && !yes && !no && !retry && !abort && !ignore || ok || ok && cancel || yes && no || yes && no && cancel || retry && cancel || abort && retry && ignore);
    }

    void createButtonSelected(SelectionEvent event) {
        String name;
        int style = this.getDefaultStyle();
        if (this.okButton.getEnabled() && this.okButton.getSelection()) {
            style |= 0x20;
        }
        if (this.cancelButton.getEnabled() && this.cancelButton.getSelection()) {
            style |= 0x100;
        }
        if (this.yesButton.getEnabled() && this.yesButton.getSelection()) {
            style |= 0x40;
        }
        if (this.noButton.getEnabled() && this.noButton.getSelection()) {
            style |= 0x80;
        }
        if (this.retryButton.getEnabled() && this.retryButton.getSelection()) {
            style |= 0x400;
        }
        if (this.abortButton.getEnabled() && this.abortButton.getSelection()) {
            style |= 0x200;
        }
        if (this.ignoreButton.getEnabled() && this.ignoreButton.getSelection()) {
            style |= 0x800;
        }
        if (this.iconErrorButton.getEnabled() && this.iconErrorButton.getSelection()) {
            style |= 1;
        }
        if (this.iconInformationButton.getEnabled() && this.iconInformationButton.getSelection()) {
            style |= 2;
        }
        if (this.iconQuestionButton.getEnabled() && this.iconQuestionButton.getSelection()) {
            style |= 4;
        }
        if (this.iconWarningButton.getEnabled() && this.iconWarningButton.getSelection()) {
            style |= 8;
        }
        if (this.iconWorkingButton.getEnabled() && this.iconWorkingButton.getSelection()) {
            style |= 0x10;
        }
        if (this.primaryModalButton.getEnabled() && this.primaryModalButton.getSelection()) {
            style |= 0x8000;
        }
        if (this.applicationModalButton.getEnabled() && this.applicationModalButton.getSelection()) {
            style |= 0x10000;
        }
        if (this.systemModalButton.getEnabled() && this.systemModalButton.getSelection()) {
            style |= 0x20000;
        }
        if (this.sheetButton.getSelection()) {
            style |= 0x10000000;
        }
        if (this.saveButton.getEnabled() && this.saveButton.getSelection()) {
            style |= 0x2000;
        }
        if (this.openButton.getEnabled() && this.openButton.getSelection()) {
            style |= 0x1000;
        }
        if (this.multiButton.getEnabled() && this.multiButton.getSelection()) {
            style |= 2;
        }
        if ((name = this.dialogCombo.getText()).equals(ControlExample.getResourceString("ColorDialog"))) {
            ColorDialog dialog = new ColorDialog(this.shell, style);
            if (this.usePreviousResultButton.getSelection()) {
                dialog.setRGB(this.colorDialogResult);
                dialog.setRGBs(this.colorDialogCustomColors);
            }
            dialog.setText(ControlExample.getResourceString("Title"));
            RGB result = dialog.open();
            this.textWidget.append(String.valueOf(ControlExample.getResourceString("ColorDialog")) + Text.DELIMITER);
            this.textWidget.append(String.valueOf(ControlExample.getResourceString("Result", new String[]{"" + result})) + Text.DELIMITER);
            this.textWidget.append("getRGB() = " + dialog.getRGB() + Text.DELIMITER);
            this.textWidget.append("getRGBs() =" + Text.DELIMITER);
            RGB[] rgbs = dialog.getRGBs();
            if (rgbs != null) {
                int i = 0;
                while (i < rgbs.length) {
                    this.textWidget.append("\t" + rgbs[i] + Text.DELIMITER);
                    ++i;
                }
            }
            this.textWidget.append(Text.DELIMITER);
            this.colorDialogResult = result;
            this.colorDialogCustomColors = rgbs;
            return;
        }
        if (name.equals(ControlExample.getResourceString("DirectoryDialog"))) {
            DirectoryDialog dialog = new DirectoryDialog(this.shell, style);
            if (this.usePreviousResultButton.getSelection()) {
                dialog.setFilterPath(this.directoryDialogResult);
            }
            dialog.setMessage(ControlExample.getResourceString("Example_string"));
            dialog.setText(ControlExample.getResourceString("Title"));
            String result = dialog.open();
            this.textWidget.append(String.valueOf(ControlExample.getResourceString("DirectoryDialog")) + Text.DELIMITER);
            this.textWidget.append(String.valueOf(ControlExample.getResourceString("Result", new String[]{result})) + Text.DELIMITER + Text.DELIMITER);
            this.directoryDialogResult = result;
            return;
        }
        if (name.equals(ControlExample.getResourceString("FileDialog"))) {
            FileDialog dialog = new FileDialog(this.shell, style);
            if (this.usePreviousResultButton.getSelection()) {
                dialog.setFileName(this.fileDialogResult);
                dialog.setFilterIndex(this.fileDialogIndexResult);
            }
            dialog.setFilterNames(FilterNames);
            dialog.setFilterExtensions(FilterExtensions);
            dialog.setText(ControlExample.getResourceString("Title"));
            String result = dialog.open();
            this.textWidget.append(String.valueOf(ControlExample.getResourceString("FileDialog")) + Text.DELIMITER);
            this.textWidget.append(String.valueOf(ControlExample.getResourceString("Result", new String[]{result})) + Text.DELIMITER);
            this.textWidget.append("getFilterIndex() =" + dialog.getFilterIndex() + Text.DELIMITER);
            this.textWidget.append("getFilterPath() =" + dialog.getFilterPath() + Text.DELIMITER);
            this.textWidget.append("getFileName() =" + dialog.getFileName() + Text.DELIMITER);
            this.textWidget.append("getFileNames() =" + Text.DELIMITER);
            String[] files = dialog.getFileNames();
            int i = 0;
            while (i < files.length) {
                this.textWidget.append("\t" + files[i] + Text.DELIMITER);
                ++i;
            }
            this.textWidget.append(Text.DELIMITER);
            this.fileDialogResult = result;
            this.fileDialogIndexResult = dialog.getFilterIndex();
            return;
        }
        if (name.equals(ControlExample.getResourceString("FontDialog"))) {
            FontDialog dialog = new FontDialog(this.shell, style);
            if (this.usePreviousResultButton.getSelection()) {
                dialog.setFontList(this.fontDialogFontListResult);
                dialog.setRGB(this.fontDialogColorResult);
            }
            dialog.setEffectsVisible(this.effectsVisibleButton.getSelection());
            dialog.setText(ControlExample.getResourceString("Title"));
            FontData result = dialog.open();
            this.textWidget.append(String.valueOf(ControlExample.getResourceString("FontDialog")) + Text.DELIMITER);
            this.textWidget.append(String.valueOf(ControlExample.getResourceString("Result", new String[]{"" + result})) + Text.DELIMITER);
            this.textWidget.append("getFontList() =" + Text.DELIMITER);
            FontData[] fonts = dialog.getFontList();
            if (fonts != null) {
                int i = 0;
                while (i < fonts.length) {
                    this.textWidget.append("\t" + fonts[i] + Text.DELIMITER);
                    ++i;
                }
            }
            this.textWidget.append("getEffectsVisible() = " + dialog.getEffectsVisible() + Text.DELIMITER);
            this.textWidget.append("getRGB() = " + dialog.getRGB() + Text.DELIMITER + Text.DELIMITER);
            this.fontDialogFontListResult = dialog.getFontList();
            this.fontDialogColorResult = dialog.getRGB();
            return;
        }
        if (name.equals(ControlExample.getResourceString("PrintDialog"))) {
            PrintDialog dialog = new PrintDialog(this.shell, style);
            if (this.usePreviousResultButton.getSelection()) {
                dialog.setPrinterData(this.printDialogResult);
            }
            dialog.setText(ControlExample.getResourceString("Title"));
            PrinterData result = dialog.open();
            this.textWidget.append(String.valueOf(ControlExample.getResourceString("PrintDialog")) + Text.DELIMITER);
            this.textWidget.append(String.valueOf(ControlExample.getResourceString("Result", new String[]{"" + result})) + Text.DELIMITER);
            if (result != null) {
                this.textWidget.append("printerData.scope = " + (result.scope == 1 ? "PAGE_RANGE" : (result.scope == 2 ? "SELECTION" : "ALL_PAGES")) + Text.DELIMITER);
                this.textWidget.append("printerData.startPage = " + result.startPage + Text.DELIMITER);
                this.textWidget.append("printerData.endPage = " + result.endPage + Text.DELIMITER);
                this.textWidget.append("printerData.printToFile = " + result.printToFile + Text.DELIMITER);
                this.textWidget.append("printerData.fileName = " + result.fileName + Text.DELIMITER);
                this.textWidget.append("printerData.orientation = " + (result.orientation == 2 ? "LANDSCAPE" : "PORTRAIT") + Text.DELIMITER);
                this.textWidget.append("printerData.copyCount = " + result.copyCount + Text.DELIMITER);
                this.textWidget.append("printerData.collate = " + result.collate + Text.DELIMITER);
                this.textWidget.append("printerData.duplex = " + (result.duplex == 1 ? "DUPLEX_LONG_EDGE" : (result.duplex == 2 ? "DUPLEX_SHORT_EDGE" : "NONE")) + Text.DELIMITER);
            }
            this.textWidget.append(Text.DELIMITER);
            this.printDialogResult = result;
            return;
        }
        if (name.equals(ControlExample.getResourceString("MessageBox"))) {
            MessageBox dialog = new MessageBox(this.shell, style);
            dialog.setMessage(ControlExample.getResourceString("Example_string"));
            dialog.setText(ControlExample.getResourceString("Title"));
            int result = dialog.open();
            this.textWidget.append(String.valueOf(ControlExample.getResourceString("MessageBox")) + Text.DELIMITER);
            switch (result) {
                case 32: {
                    this.textWidget.append(ControlExample.getResourceString("Result", new String[]{"SWT.OK"}));
                    break;
                }
                case 64: {
                    this.textWidget.append(ControlExample.getResourceString("Result", new String[]{"SWT.YES"}));
                    break;
                }
                case 128: {
                    this.textWidget.append(ControlExample.getResourceString("Result", new String[]{"SWT.NO"}));
                    break;
                }
                case 256: {
                    this.textWidget.append(ControlExample.getResourceString("Result", new String[]{"SWT.CANCEL"}));
                    break;
                }
                case 512: {
                    this.textWidget.append(ControlExample.getResourceString("Result", new String[]{"SWT.ABORT"}));
                    break;
                }
                case 1024: {
                    this.textWidget.append(ControlExample.getResourceString("Result", new String[]{"SWT.RETRY"}));
                    break;
                }
                case 2048: {
                    this.textWidget.append(ControlExample.getResourceString("Result", new String[]{"SWT.IGNORE"}));
                    break;
                }
                default: {
                    this.textWidget.append(ControlExample.getResourceString("Result", new String[]{"" + result}));
                }
            }
            this.textWidget.append(String.valueOf(Text.DELIMITER) + Text.DELIMITER);
        }
    }

    void createControlGroup() {
        this.controlGroup = new Group(this.tabFolderPage, 0);
        GridLayout gridLayout = new GridLayout();
        this.controlGroup.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        this.controlGroup.setLayoutData((Object)new GridData(272));
        this.controlGroup.setText(ControlExample.getResourceString("Parameters"));
        this.dialogStyleGroup = new Group((Composite)this.controlGroup, 0);
        this.dialogStyleGroup.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(64);
        gridData.horizontalSpan = 2;
        this.dialogStyleGroup.setLayoutData((Object)gridData);
        this.dialogStyleGroup.setText(ControlExample.getResourceString("Dialog_Type"));
    }

    void createControlWidgets() {
        String[] strings = new String[]{ControlExample.getResourceString("ColorDialog"), ControlExample.getResourceString("DirectoryDialog"), ControlExample.getResourceString("FileDialog"), ControlExample.getResourceString("FontDialog"), ControlExample.getResourceString("PrintDialog"), ControlExample.getResourceString("MessageBox")};
        this.dialogCombo = new Combo((Composite)this.dialogStyleGroup, 8);
        this.dialogCombo.setItems(strings);
        this.dialogCombo.setText(strings[0]);
        this.dialogCombo.setVisibleItemCount(strings.length);
        this.createButton = new Button((Composite)this.dialogStyleGroup, 0);
        this.createButton.setText(ControlExample.getResourceString("Create_Dialog"));
        this.createButton.setLayoutData((Object)new GridData(64));
        Group buttonStyleGroup = new Group((Composite)this.controlGroup, 0);
        buttonStyleGroup.setLayout((Layout)new GridLayout());
        buttonStyleGroup.setLayoutData((Object)new GridData(272));
        buttonStyleGroup.setText(ControlExample.getResourceString("Button_Styles"));
        this.okButton = new Button((Composite)buttonStyleGroup, 32);
        this.okButton.setText("SWT.OK");
        this.cancelButton = new Button((Composite)buttonStyleGroup, 32);
        this.cancelButton.setText("SWT.CANCEL");
        this.yesButton = new Button((Composite)buttonStyleGroup, 32);
        this.yesButton.setText("SWT.YES");
        this.noButton = new Button((Composite)buttonStyleGroup, 32);
        this.noButton.setText("SWT.NO");
        this.retryButton = new Button((Composite)buttonStyleGroup, 32);
        this.retryButton.setText("SWT.RETRY");
        this.abortButton = new Button((Composite)buttonStyleGroup, 32);
        this.abortButton.setText("SWT.ABORT");
        this.ignoreButton = new Button((Composite)buttonStyleGroup, 32);
        this.ignoreButton.setText("SWT.IGNORE");
        Group iconStyleGroup = new Group((Composite)this.controlGroup, 0);
        iconStyleGroup.setLayout((Layout)new GridLayout());
        iconStyleGroup.setLayoutData((Object)new GridData(272));
        iconStyleGroup.setText(ControlExample.getResourceString("Icon_Styles"));
        this.iconErrorButton = new Button((Composite)iconStyleGroup, 16);
        this.iconErrorButton.setText("SWT.ICON_ERROR");
        this.iconInformationButton = new Button((Composite)iconStyleGroup, 16);
        this.iconInformationButton.setText("SWT.ICON_INFORMATION");
        this.iconQuestionButton = new Button((Composite)iconStyleGroup, 16);
        this.iconQuestionButton.setText("SWT.ICON_QUESTION");
        this.iconWarningButton = new Button((Composite)iconStyleGroup, 16);
        this.iconWarningButton.setText("SWT.ICON_WARNING");
        this.iconWorkingButton = new Button((Composite)iconStyleGroup, 16);
        this.iconWorkingButton.setText("SWT.ICON_WORKING");
        this.noIconButton = new Button((Composite)iconStyleGroup, 16);
        this.noIconButton.setText(ControlExample.getResourceString("No_Icon"));
        Group modalStyleGroup = new Group((Composite)this.controlGroup, 0);
        modalStyleGroup.setLayout((Layout)new GridLayout());
        modalStyleGroup.setLayoutData((Object)new GridData(272));
        modalStyleGroup.setText(ControlExample.getResourceString("Modal_Styles"));
        this.primaryModalButton = new Button((Composite)modalStyleGroup, 16);
        this.primaryModalButton.setText("SWT.PRIMARY_MODAL");
        this.applicationModalButton = new Button((Composite)modalStyleGroup, 16);
        this.applicationModalButton.setText("SWT.APPLICATION_MODAL");
        this.systemModalButton = new Button((Composite)modalStyleGroup, 16);
        this.systemModalButton.setText("SWT.SYSTEM_MODAL");
        Group fileDialogStyleGroup = new Group((Composite)this.controlGroup, 0);
        fileDialogStyleGroup.setLayout((Layout)new GridLayout());
        fileDialogStyleGroup.setLayoutData((Object)new GridData(272));
        fileDialogStyleGroup.setText(ControlExample.getResourceString("File_Dialog_Styles"));
        this.openButton = new Button((Composite)fileDialogStyleGroup, 16);
        this.openButton.setText("SWT.OPEN");
        this.saveButton = new Button((Composite)fileDialogStyleGroup, 16);
        this.saveButton.setText("SWT.SAVE");
        this.multiButton = new Button((Composite)fileDialogStyleGroup, 32);
        this.multiButton.setText("SWT.MULTI");
        if (RTL_SUPPORT_ENABLE) {
            this.createOrientationGroup();
        }
        Group otherGroup = new Group((Composite)this.controlGroup, 0);
        otherGroup.setLayout((Layout)new GridLayout());
        otherGroup.setLayoutData((Object)new GridData(272));
        otherGroup.setText(ControlExample.getResourceString("Other"));
        this.sheetButton = new Button((Composite)otherGroup, 32);
        this.sheetButton.setText("SWT.SHEET");
        this.usePreviousResultButton = new Button((Composite)otherGroup, 32);
        this.usePreviousResultButton.setText(ControlExample.getResourceString("Use_Previous_Result"));
        this.effectsVisibleButton = new Button((Composite)otherGroup, 32);
        this.effectsVisibleButton.setText("FontDialog.setEffectsVisible");
        this.dialogCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DialogTab.this.dialogSelected(event);
            }
        });
        this.createButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DialogTab.this.createButtonSelected(event);
            }
        });
        SelectionAdapter buttonStyleListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DialogTab.this.buttonStyleSelected(event);
            }
        };
        this.okButton.addSelectionListener((SelectionListener)buttonStyleListener);
        this.cancelButton.addSelectionListener((SelectionListener)buttonStyleListener);
        this.yesButton.addSelectionListener((SelectionListener)buttonStyleListener);
        this.noButton.addSelectionListener((SelectionListener)buttonStyleListener);
        this.retryButton.addSelectionListener((SelectionListener)buttonStyleListener);
        this.abortButton.addSelectionListener((SelectionListener)buttonStyleListener);
        this.ignoreButton.addSelectionListener((SelectionListener)buttonStyleListener);
        this.okButton.setEnabled(false);
        this.cancelButton.setEnabled(false);
        this.yesButton.setEnabled(false);
        this.noButton.setEnabled(false);
        this.retryButton.setEnabled(false);
        this.abortButton.setEnabled(false);
        this.ignoreButton.setEnabled(false);
        this.iconErrorButton.setEnabled(false);
        this.iconInformationButton.setEnabled(false);
        this.iconQuestionButton.setEnabled(false);
        this.iconWarningButton.setEnabled(false);
        this.iconWorkingButton.setEnabled(false);
        this.noIconButton.setEnabled(false);
        this.saveButton.setEnabled(false);
        this.openButton.setEnabled(false);
        this.openButton.setSelection(true);
        this.multiButton.setEnabled(false);
        this.noIconButton.setSelection(true);
        this.effectsVisibleButton.setEnabled(false);
        this.effectsVisibleButton.setSelection(true);
    }

    void createExampleGroup() {
        super.createExampleGroup();
        this.exampleGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.resultGroup = new Group((Composite)this.exampleGroup, 0);
        this.resultGroup.setLayout((Layout)new GridLayout());
        this.resultGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.resultGroup.setText(ControlExample.getResourceString("Dialog_Result"));
    }

    void createExampleWidgets() {
        this.textWidget = new Text((Composite)this.resultGroup, 2816);
        GridData gridData = new GridData(1808);
        this.textWidget.setLayoutData((Object)gridData);
    }

    void createListenersGroup() {
    }

    void dialogSelected(SelectionEvent event) {
        String name = this.dialogCombo.getText();
        boolean isMessageBox = name.equals(ControlExample.getResourceString("MessageBox"));
        boolean isFileDialog = name.equals(ControlExample.getResourceString("FileDialog"));
        boolean isFontDialog = name.equals(ControlExample.getResourceString("FontDialog"));
        this.okButton.setEnabled(isMessageBox);
        this.cancelButton.setEnabled(isMessageBox);
        this.yesButton.setEnabled(isMessageBox);
        this.noButton.setEnabled(isMessageBox);
        this.retryButton.setEnabled(isMessageBox);
        this.abortButton.setEnabled(isMessageBox);
        this.ignoreButton.setEnabled(isMessageBox);
        this.iconErrorButton.setEnabled(isMessageBox);
        this.iconInformationButton.setEnabled(isMessageBox);
        this.iconQuestionButton.setEnabled(isMessageBox);
        this.iconWarningButton.setEnabled(isMessageBox);
        this.iconWorkingButton.setEnabled(isMessageBox);
        this.noIconButton.setEnabled(isMessageBox);
        this.saveButton.setEnabled(isFileDialog);
        this.openButton.setEnabled(isFileDialog);
        this.multiButton.setEnabled(isFileDialog);
        this.effectsVisibleButton.setEnabled(isFontDialog);
        this.usePreviousResultButton.setEnabled(!isMessageBox);
        if (!isMessageBox) {
            this.okButton.setSelection(false);
            this.cancelButton.setSelection(false);
            this.yesButton.setSelection(false);
            this.noButton.setSelection(false);
            this.retryButton.setSelection(false);
            this.abortButton.setSelection(false);
            this.ignoreButton.setSelection(false);
        }
    }

    Widget[] getExampleWidgets() {
        return new Widget[0];
    }

    String getTabText() {
        return "Dialog";
    }

    void recreateExampleWidgets() {
        if (this.textWidget == null) {
            super.recreateExampleWidgets();
        }
    }
}

