/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.examples.controlexample.AlignableTab;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

class LabelTab
extends AlignableTab {
    Label label1;
    Label label2;
    Label label3;
    Label label4;
    Label label5;
    Label label6;
    Group textLabelGroup;
    Group imageLabelGroup;
    Button wrapButton;
    Button separatorButton;
    Button horizontalButton;
    Button verticalButton;
    Button shadowInButton;
    Button shadowOutButton;
    Button shadowNoneButton;

    LabelTab(ControlExample instance) {
        super(instance);
    }

    void createExampleGroup() {
        super.createExampleGroup();
        this.textLabelGroup = new Group((Composite)this.exampleGroup, 0);
        GridLayout gridLayout = new GridLayout();
        this.textLabelGroup.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 3;
        this.textLabelGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.textLabelGroup.setText(ControlExample.getResourceString("Text_Labels"));
        this.imageLabelGroup = new Group((Composite)this.exampleGroup, 32);
        gridLayout = new GridLayout();
        this.imageLabelGroup.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 3;
        this.imageLabelGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.imageLabelGroup.setText(ControlExample.getResourceString("Image_Labels"));
    }

    void createExampleWidgets() {
        int style = this.getDefaultStyle();
        if (this.wrapButton.getSelection()) {
            style |= 0x40;
        }
        if (this.separatorButton.getSelection()) {
            style |= 2;
        }
        if (this.horizontalButton.getSelection()) {
            style |= 0x100;
        }
        if (this.verticalButton.getSelection()) {
            style |= 0x200;
        }
        if (this.shadowInButton.getSelection()) {
            style |= 4;
        }
        if (this.shadowOutButton.getSelection()) {
            style |= 8;
        }
        if (this.shadowNoneButton.getSelection()) {
            style |= 0x20;
        }
        if (this.borderButton.getSelection()) {
            style |= 0x800;
        }
        if (this.leftButton.getSelection()) {
            style |= 0x4000;
        }
        if (this.centerButton.getSelection()) {
            style |= 0x1000000;
        }
        if (this.rightButton.getSelection()) {
            style |= 0x20000;
        }
        this.label1 = new Label((Composite)this.textLabelGroup, style);
        this.label1.setText(ControlExample.getResourceString("One"));
        this.label2 = new Label((Composite)this.textLabelGroup, style);
        this.label2.setText(ControlExample.getResourceString("Two"));
        this.label3 = new Label((Composite)this.textLabelGroup, style);
        if (this.wrapButton.getSelection()) {
            this.label3.setText(ControlExample.getResourceString("Wrap_Text"));
        } else {
            this.label3.setText(ControlExample.getResourceString("Three"));
        }
        this.label4 = new Label((Composite)this.imageLabelGroup, style);
        this.label4.setImage(this.instance.images[0]);
        this.label5 = new Label((Composite)this.imageLabelGroup, style);
        this.label5.setImage(this.instance.images[1]);
        this.label6 = new Label((Composite)this.imageLabelGroup, style);
        this.label6.setImage(this.instance.images[2]);
    }

    void createStyleGroup() {
        super.createStyleGroup();
        this.wrapButton = new Button((Composite)this.styleGroup, 32);
        this.wrapButton.setText("SWT.WRAP");
        this.separatorButton = new Button((Composite)this.styleGroup, 32);
        this.separatorButton.setText("SWT.SEPARATOR");
        this.horizontalButton = new Button((Composite)this.styleGroup, 16);
        this.horizontalButton.setText("SWT.HORIZONTAL");
        this.verticalButton = new Button((Composite)this.styleGroup, 16);
        this.verticalButton.setText("SWT.VERTICAL");
        Group styleSubGroup = new Group((Composite)this.styleGroup, 0);
        styleSubGroup.setLayout((Layout)new GridLayout());
        this.shadowInButton = new Button((Composite)styleSubGroup, 16);
        this.shadowInButton.setText("SWT.SHADOW_IN");
        this.shadowOutButton = new Button((Composite)styleSubGroup, 16);
        this.shadowOutButton.setText("SWT.SHADOW_OUT");
        this.shadowNoneButton = new Button((Composite)styleSubGroup, 16);
        this.shadowNoneButton.setText("SWT.SHADOW_NONE");
        this.borderButton = new Button((Composite)this.styleGroup, 32);
        this.borderButton.setText("SWT.BORDER");
    }

    Widget[] getExampleWidgets() {
        return new Widget[]{this.label1, this.label2, this.label3, this.label4, this.label5, this.label6};
    }

    String[] getMethodNames() {
        return new String[]{"Text", "ToolTipText"};
    }

    String getTabText() {
        return "Label";
    }

    void setExampleWidgetAlignment() {
        int alignment = 0;
        if (this.leftButton.getSelection()) {
            alignment = 16384;
        }
        if (this.centerButton.getSelection()) {
            alignment = 0x1000000;
        }
        if (this.rightButton.getSelection()) {
            alignment = 131072;
        }
        this.label1.setAlignment(alignment);
        this.label2.setAlignment(alignment);
        this.label3.setAlignment(alignment);
        this.label4.setAlignment(alignment);
        this.label5.setAlignment(alignment);
        this.label6.setAlignment(alignment);
    }

    void setExampleWidgetState() {
        super.setExampleWidgetState();
        boolean isSeparator = (this.label1.getStyle() & 2) != 0;
        this.wrapButton.setSelection(!isSeparator && (this.label1.getStyle() & 0x40) != 0);
        this.leftButton.setSelection(!isSeparator && (this.label1.getStyle() & 0x4000) != 0);
        this.centerButton.setSelection(!isSeparator && (this.label1.getStyle() & 0x1000000) != 0);
        this.rightButton.setSelection(!isSeparator && (this.label1.getStyle() & 0x20000) != 0);
        this.shadowInButton.setSelection(isSeparator && (this.label1.getStyle() & 4) != 0);
        this.shadowOutButton.setSelection(isSeparator && (this.label1.getStyle() & 8) != 0);
        this.shadowNoneButton.setSelection(isSeparator && (this.label1.getStyle() & 0x20) != 0);
        this.horizontalButton.setSelection(isSeparator && (this.label1.getStyle() & 0x100) != 0);
        this.verticalButton.setSelection(isSeparator && (this.label1.getStyle() & 0x200) != 0);
        this.wrapButton.setEnabled(!isSeparator);
        this.leftButton.setEnabled(!isSeparator);
        this.centerButton.setEnabled(!isSeparator);
        this.rightButton.setEnabled(!isSeparator);
        this.shadowInButton.setEnabled(isSeparator);
        this.shadowOutButton.setEnabled(isSeparator);
        this.shadowNoneButton.setEnabled(isSeparator);
        this.horizontalButton.setEnabled(isSeparator);
        this.verticalButton.setEnabled(isSeparator);
    }
}

