/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.Tab;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;

abstract class RangeTab
extends Tab {
    Button horizontalButton;
    Button verticalButton;
    boolean orientationButtons = true;
    Spinner minimumSpinner;
    Spinner selectionSpinner;
    Spinner maximumSpinner;

    RangeTab(ControlExample instance) {
        super(instance);
    }

    void createControlWidgets() {
        this.createMinimumGroup();
        this.createMaximumGroup();
        this.createSelectionGroup();
    }

    void createMaximumGroup() {
        Group maximumGroup = new Group((Composite)this.controlGroup, 0);
        maximumGroup.setLayout((Layout)new GridLayout());
        maximumGroup.setText(ControlExample.getResourceString("Maximum"));
        maximumGroup.setLayoutData((Object)new GridData(768));
        this.maximumSpinner = new Spinner((Composite)maximumGroup, 2048);
        this.maximumSpinner.setMaximum(100000);
        this.maximumSpinner.setSelection(this.getDefaultMaximum());
        this.maximumSpinner.setPageIncrement(100);
        this.maximumSpinner.setIncrement(1);
        this.maximumSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.maximumSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RangeTab.this.setWidgetMaximum();
            }
        });
    }

    void createMinimumGroup() {
        Group minimumGroup = new Group((Composite)this.controlGroup, 0);
        minimumGroup.setLayout((Layout)new GridLayout());
        minimumGroup.setText(ControlExample.getResourceString("Minimum"));
        minimumGroup.setLayoutData((Object)new GridData(768));
        this.minimumSpinner = new Spinner((Composite)minimumGroup, 2048);
        this.minimumSpinner.setMaximum(100000);
        this.minimumSpinner.setSelection(this.getDefaultMinimum());
        this.minimumSpinner.setPageIncrement(100);
        this.minimumSpinner.setIncrement(1);
        this.minimumSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.minimumSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RangeTab.this.setWidgetMinimum();
            }
        });
    }

    void createSelectionGroup() {
        Group selectionGroup = new Group((Composite)this.controlGroup, 0);
        selectionGroup.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(4, 1, false, false);
        selectionGroup.setLayoutData((Object)gridData);
        selectionGroup.setText(ControlExample.getResourceString("Selection"));
        this.selectionSpinner = new Spinner((Composite)selectionGroup, 2048);
        this.selectionSpinner.setMaximum(100000);
        this.selectionSpinner.setSelection(this.getDefaultSelection());
        this.selectionSpinner.setPageIncrement(100);
        this.selectionSpinner.setIncrement(1);
        this.selectionSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.selectionSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RangeTab.this.setWidgetSelection();
            }
        });
    }

    void createStyleGroup() {
        super.createStyleGroup();
        if (this.orientationButtons) {
            this.horizontalButton = new Button((Composite)this.styleGroup, 16);
            this.horizontalButton.setText("SWT.HORIZONTAL");
            this.verticalButton = new Button((Composite)this.styleGroup, 16);
            this.verticalButton.setText("SWT.VERTICAL");
        }
        this.borderButton = new Button((Composite)this.styleGroup, 32);
        this.borderButton.setText("SWT.BORDER");
    }

    void setExampleWidgetState() {
        Widget[] widgets;
        super.setExampleWidgetState();
        if (!this.instance.startup) {
            this.setWidgetMinimum();
            this.setWidgetMaximum();
            this.setWidgetSelection();
        }
        if ((widgets = this.getExampleWidgets()).length != 0) {
            if (this.orientationButtons) {
                this.horizontalButton.setSelection((widgets[0].getStyle() & 0x100) != 0);
                this.verticalButton.setSelection((widgets[0].getStyle() & 0x200) != 0);
            }
            this.borderButton.setSelection((widgets[0].getStyle() & 0x800) != 0);
        }
    }

    abstract int getDefaultMaximum();

    abstract int getDefaultMinimum();

    abstract int getDefaultSelection();

    abstract void setWidgetMaximum();

    abstract void setWidgetMinimum();

    abstract void setWidgetSelection();
}

