/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.RangeTab;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;

class SliderTab
extends RangeTab {
    Slider slider1;
    Group sliderGroup;
    Spinner incrementSpinner;
    Spinner pageIncrementSpinner;
    Spinner thumbSpinner;

    SliderTab(ControlExample instance) {
        super(instance);
    }

    void createControlWidgets() {
        super.createControlWidgets();
        this.createThumbGroup();
        this.createIncrementGroup();
        this.createPageIncrementGroup();
    }

    void createExampleGroup() {
        super.createExampleGroup();
        this.sliderGroup = new Group((Composite)this.exampleGroup, 0);
        this.sliderGroup.setLayout((Layout)new GridLayout());
        this.sliderGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.sliderGroup.setText("Slider");
    }

    void createExampleWidgets() {
        int style = this.getDefaultStyle();
        if (this.horizontalButton.getSelection()) {
            style |= 0x100;
        }
        if (this.verticalButton.getSelection()) {
            style |= 0x200;
        }
        if (this.borderButton.getSelection()) {
            style |= 0x800;
        }
        this.slider1 = new Slider((Composite)this.sliderGroup, style);
    }

    void createIncrementGroup() {
        Group incrementGroup = new Group((Composite)this.controlGroup, 0);
        incrementGroup.setLayout((Layout)new GridLayout());
        incrementGroup.setText(ControlExample.getResourceString("Increment"));
        incrementGroup.setLayoutData((Object)new GridData(768));
        this.incrementSpinner = new Spinner((Composite)incrementGroup, 2048);
        this.incrementSpinner.setMaximum(100000);
        this.incrementSpinner.setSelection(this.getDefaultIncrement());
        this.incrementSpinner.setPageIncrement(100);
        this.incrementSpinner.setIncrement(1);
        this.incrementSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.incrementSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SliderTab.this.setWidgetIncrement();
            }
        });
    }

    void createPageIncrementGroup() {
        Group pageIncrementGroup = new Group((Composite)this.controlGroup, 0);
        pageIncrementGroup.setLayout((Layout)new GridLayout());
        pageIncrementGroup.setText(ControlExample.getResourceString("Page_Increment"));
        pageIncrementGroup.setLayoutData((Object)new GridData(768));
        this.pageIncrementSpinner = new Spinner((Composite)pageIncrementGroup, 2048);
        this.pageIncrementSpinner.setMaximum(100000);
        this.pageIncrementSpinner.setSelection(this.getDefaultPageIncrement());
        this.pageIncrementSpinner.setPageIncrement(100);
        this.pageIncrementSpinner.setIncrement(1);
        this.pageIncrementSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.pageIncrementSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SliderTab.this.setWidgetPageIncrement();
            }
        });
    }

    void createThumbGroup() {
        Group thumbGroup = new Group((Composite)this.controlGroup, 0);
        thumbGroup.setLayout((Layout)new GridLayout());
        thumbGroup.setText(ControlExample.getResourceString("Thumb"));
        thumbGroup.setLayoutData((Object)new GridData(768));
        this.thumbSpinner = new Spinner((Composite)thumbGroup, 2048);
        this.thumbSpinner.setMaximum(100000);
        this.thumbSpinner.setSelection(this.getDefaultThumb());
        this.thumbSpinner.setPageIncrement(100);
        this.thumbSpinner.setIncrement(1);
        this.thumbSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.thumbSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SliderTab.this.setWidgetThumb();
            }
        });
    }

    Widget[] getExampleWidgets() {
        return new Widget[]{this.slider1};
    }

    String[] getMethodNames() {
        return new String[]{"Selection", "ToolTipText"};
    }

    String getTabText() {
        return "Slider";
    }

    void setExampleWidgetState() {
        super.setExampleWidgetState();
        if (!this.instance.startup) {
            this.setWidgetIncrement();
            this.setWidgetPageIncrement();
            this.setWidgetThumb();
        }
    }

    int getDefaultMaximum() {
        return this.slider1.getMaximum();
    }

    int getDefaultMinimum() {
        return this.slider1.getMinimum();
    }

    int getDefaultSelection() {
        return this.slider1.getSelection();
    }

    int getDefaultIncrement() {
        return this.slider1.getIncrement();
    }

    int getDefaultPageIncrement() {
        return this.slider1.getPageIncrement();
    }

    int getDefaultThumb() {
        return this.slider1.getThumb();
    }

    void setWidgetIncrement() {
        this.slider1.setIncrement(this.incrementSpinner.getSelection());
    }

    void setWidgetMaximum() {
        this.slider1.setMaximum(this.maximumSpinner.getSelection());
    }

    void setWidgetMinimum() {
        this.slider1.setMinimum(this.minimumSpinner.getSelection());
    }

    void setWidgetPageIncrement() {
        this.slider1.setPageIncrement(this.pageIncrementSpinner.getSelection());
    }

    void setWidgetSelection() {
        this.slider1.setSelection(this.selectionSpinner.getSelection());
    }

    void setWidgetThumb() {
        this.slider1.setThumb(this.thumbSpinner.getSelection());
    }
}

