/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.swt.custom.BidiSegmentEvent;
import org.eclipse.swt.custom.BidiSegmentListener;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.MovementEvent;
import org.eclipse.swt.custom.MovementListener;
import org.eclipse.swt.custom.PaintObjectEvent;
import org.eclipse.swt.custom.PaintObjectListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.TextChangedEvent;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.ScrollableTab;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Widget;

class StyledTextTab
extends ScrollableTab {
    StyledText styledText;
    Group styledTextGroup;
    Group styledTextStyleGroup;
    Button wrapButton;
    Button readOnlyButton;
    Button fullSelectionButton;
    Button boldButton;
    Button italicButton;
    Button redButton;
    Button yellowButton;
    Button underlineButton;
    Button strikeoutButton;
    Image boldImage;
    Image italicImage;
    Image redImage;
    Image yellowImage;
    Image underlineImage;
    Image strikeoutImage;
    String text;
    StyleRange[] styleRanges;

    StyledTextTab(ControlExample instance) {
        super(instance);
    }

    Image createBitmapImage(Display display, String name) {
        InputStream sourceStream = ControlExample.class.getResourceAsStream(String.valueOf(name) + ".bmp");
        InputStream maskStream = ControlExample.class.getResourceAsStream(String.valueOf(name) + "_mask.bmp");
        ImageData source = new ImageData(sourceStream);
        ImageData mask = new ImageData(maskStream);
        Image result = new Image((Device)display, source, mask);
        try {
            sourceStream.close();
            maskStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    void createControlWidgets() {
        super.createControlWidgets();
        this.createStyledTextStyleGroup();
    }

    void createExampleGroup() {
        super.createExampleGroup();
        this.styledTextGroup = new Group((Composite)this.exampleGroup, 0);
        this.styledTextGroup.setLayout((Layout)new GridLayout());
        this.styledTextGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.styledTextGroup.setText("StyledText");
    }

    void createExampleWidgets() {
        int style = this.getDefaultStyle();
        if (this.singleButton.getSelection()) {
            style |= 4;
        }
        if (this.multiButton.getSelection()) {
            style |= 2;
        }
        if (this.horizontalButton.getSelection()) {
            style |= 0x100;
        }
        if (this.verticalButton.getSelection()) {
            style |= 0x200;
        }
        if (this.wrapButton.getSelection()) {
            style |= 0x40;
        }
        if (this.readOnlyButton.getSelection()) {
            style |= 8;
        }
        if (this.borderButton.getSelection()) {
            style |= 0x800;
        }
        if (this.fullSelectionButton.getSelection()) {
            style |= 0x10000;
        }
        this.styledText = new StyledText((Composite)this.styledTextGroup, style);
        this.styledText.setText(ControlExample.getResourceString("Example_string"));
        this.styledText.append("\n");
        this.styledText.append(ControlExample.getResourceString("One_Two_Three"));
        if (this.text != null) {
            this.styledText.setText(this.text);
            this.text = null;
        }
        if (this.styleRanges != null) {
            this.styledText.setStyleRanges(this.styleRanges);
            this.styleRanges = null;
        }
    }

    void createStyleGroup() {
        super.createStyleGroup();
        this.wrapButton = new Button((Composite)this.styleGroup, 32);
        this.wrapButton.setText("SWT.WRAP");
        this.readOnlyButton = new Button((Composite)this.styleGroup, 32);
        this.readOnlyButton.setText("SWT.READ_ONLY");
        this.fullSelectionButton = new Button((Composite)this.styleGroup, 32);
        this.fullSelectionButton.setText("SWT.FULL_SELECTION");
    }

    void createStyledTextStyleGroup() {
        this.styledTextStyleGroup = new Group((Composite)this.controlGroup, 0);
        this.styledTextStyleGroup.setText(ControlExample.getResourceString("StyledText_Styles"));
        this.styledTextStyleGroup.setLayout((Layout)new GridLayout(6, false));
        GridData data = new GridData(256);
        data.horizontalSpan = 2;
        this.styledTextStyleGroup.setLayoutData((Object)data);
        this.boldImage = this.createBitmapImage(this.display, "bold");
        this.italicImage = this.createBitmapImage(this.display, "italic");
        this.redImage = this.createBitmapImage(this.display, "red");
        this.yellowImage = this.createBitmapImage(this.display, "yellow");
        this.underlineImage = this.createBitmapImage(this.display, "underline");
        this.strikeoutImage = this.createBitmapImage(this.display, "strikeout");
        Label label = new Label((Composite)this.styledTextStyleGroup, 0);
        label.setText(ControlExample.getResourceString("StyledText_Style_Instructions"));
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 6, 1));
        label = new Label((Composite)this.styledTextStyleGroup, 0);
        label.setText(ControlExample.getResourceString("Bold"));
        label.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        this.boldButton = new Button((Composite)this.styledTextStyleGroup, 8);
        this.boldButton.setImage(this.boldImage);
        label = new Label((Composite)this.styledTextStyleGroup, 0);
        label.setText(ControlExample.getResourceString("Underline"));
        label.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        this.underlineButton = new Button((Composite)this.styledTextStyleGroup, 8);
        this.underlineButton.setImage(this.underlineImage);
        label = new Label((Composite)this.styledTextStyleGroup, 0);
        label.setText(ControlExample.getResourceString("Foreground_Style"));
        label.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        this.redButton = new Button((Composite)this.styledTextStyleGroup, 8);
        this.redButton.setImage(this.redImage);
        label = new Label((Composite)this.styledTextStyleGroup, 0);
        label.setText(ControlExample.getResourceString("Italic"));
        label.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        this.italicButton = new Button((Composite)this.styledTextStyleGroup, 8);
        this.italicButton.setImage(this.italicImage);
        label = new Label((Composite)this.styledTextStyleGroup, 0);
        label.setText(ControlExample.getResourceString("Strikeout"));
        label.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        this.strikeoutButton = new Button((Composite)this.styledTextStyleGroup, 8);
        this.strikeoutButton.setImage(this.strikeoutImage);
        label = new Label((Composite)this.styledTextStyleGroup, 0);
        label.setText(ControlExample.getResourceString("Background_Style"));
        label.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        this.yellowButton = new Button((Composite)this.styledTextStyleGroup, 8);
        this.yellowButton.setImage(this.yellowImage);
        SelectionAdapter styleListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Point sel = StyledTextTab.this.styledText.getSelectionRange();
                if (sel == null || sel.y == 0) {
                    return;
                }
                int i = sel.x;
                while (i < sel.x + sel.y) {
                    StyleRange style;
                    StyleRange range = StyledTextTab.this.styledText.getStyleRangeAtOffset(i);
                    if (range != null) {
                        style = (StyleRange)range.clone();
                        style.start = i;
                        style.length = 1;
                    } else {
                        style = new StyleRange(i, 1, null, null, 0);
                    }
                    if (e.widget == StyledTextTab.this.boldButton) {
                        style.fontStyle ^= 1;
                    } else if (e.widget == StyledTextTab.this.italicButton) {
                        style.fontStyle ^= 2;
                    } else if (e.widget == StyledTextTab.this.underlineButton) {
                        style.underline = !style.underline;
                    } else if (e.widget == StyledTextTab.this.strikeoutButton) {
                        style.strikeout = !style.strikeout;
                    }
                    StyledTextTab.this.styledText.setStyleRange(style);
                    ++i;
                }
                StyledTextTab.this.styledText.setSelectionRange(sel.x + sel.y, 0);
            }
        };
        SelectionAdapter colorListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Point sel = StyledTextTab.this.styledText.getSelectionRange();
                if (sel == null || sel.y == 0) {
                    return;
                }
                Color fg = null;
                Color bg = null;
                if (e.widget == StyledTextTab.this.redButton) {
                    fg = StyledTextTab.this.display.getSystemColor(3);
                } else if (e.widget == StyledTextTab.this.yellowButton) {
                    bg = StyledTextTab.this.display.getSystemColor(7);
                }
                int i = sel.x;
                while (i < sel.x + sel.y) {
                    StyleRange style;
                    StyleRange range = StyledTextTab.this.styledText.getStyleRangeAtOffset(i);
                    if (range != null) {
                        style = (StyleRange)range.clone();
                        style.start = i;
                        style.length = 1;
                        style.foreground = style.foreground != null ? null : fg;
                        style.background = style.background != null ? null : bg;
                    } else {
                        style = new StyleRange(i, 1, fg, bg, 0);
                    }
                    StyledTextTab.this.styledText.setStyleRange(style);
                    ++i;
                }
                StyledTextTab.this.styledText.setSelectionRange(sel.x + sel.y, 0);
            }
        };
        this.boldButton.addSelectionListener((SelectionListener)styleListener);
        this.italicButton.addSelectionListener((SelectionListener)styleListener);
        this.underlineButton.addSelectionListener((SelectionListener)styleListener);
        this.strikeoutButton.addSelectionListener((SelectionListener)styleListener);
        this.redButton.addSelectionListener((SelectionListener)colorListener);
        this.yellowButton.addSelectionListener((SelectionListener)colorListener);
        this.yellowButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                StyledTextTab.this.boldImage.dispose();
                StyledTextTab.this.italicImage.dispose();
                StyledTextTab.this.redImage.dispose();
                StyledTextTab.this.yellowImage.dispose();
                StyledTextTab.this.underlineImage.dispose();
                StyledTextTab.this.strikeoutImage.dispose();
            }
        });
    }

    Composite createTabFolderPage(TabFolder tabFolder) {
        super.createTabFolderPage(tabFolder);
        this.tabFolderPage.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                StyledTextTab.this.setExampleWidgetSize();
            }
        });
        return this.tabFolderPage;
    }

    void disposeExampleWidgets() {
        if (this.styledText != null) {
            this.styleRanges = this.styledText.getStyleRanges();
            this.text = this.styledText.getText();
        }
        super.disposeExampleWidgets();
    }

    String[] getCustomEventNames() {
        return new String[]{"ExtendedModifyListener", "BidiSegmentListener", "LineBackgroundListener", "LineStyleListener", "PaintObjectListener", "TextChangeListener", "VerifyKeyListener", "WordMovementListener"};
    }

    Widget[] getExampleWidgets() {
        return new Widget[]{this.styledText};
    }

    String[] getMethodNames() {
        return new String[]{"Alignment", "AlwaysShowScrollBars", "BlockSelection", "BottomMargin", "CaretOffset", "DoubleClickEnabled", "Editable", "HorizontalIndex", "HorizontalPixel", "Indent", "Justify", "LeftMargin", "LineSpacing", "Orientation", "RightMargin", "Selection", "Tabs", "TabStops", "Text", "TextLimit", "ToolTipText", "TopIndex", "TopMargin", "TopPixel", "WrapIndent", "WordWrap"};
    }

    String getTabText() {
        return "StyledText";
    }

    void hookCustomListener(final String eventName) {
        if (eventName == "ExtendedModifyListener") {
            this.styledText.addExtendedModifyListener(new ExtendedModifyListener(){

                public void modifyText(ExtendedModifyEvent event) {
                    StyledTextTab.this.log(eventName, (TypedEvent)event);
                }
            });
        }
        if (eventName == "BidiSegmentListener") {
            this.styledText.addBidiSegmentListener(new BidiSegmentListener(){

                public void lineGetSegments(BidiSegmentEvent event) {
                    StyledTextTab.this.log(eventName, (TypedEvent)event);
                }
            });
        }
        if (eventName == "LineBackgroundListener") {
            this.styledText.addLineBackgroundListener(new LineBackgroundListener(){

                public void lineGetBackground(LineBackgroundEvent event) {
                    StyledTextTab.this.log(eventName, (TypedEvent)event);
                }
            });
        }
        if (eventName == "LineStyleListener") {
            this.styledText.addLineStyleListener(new LineStyleListener(){

                public void lineGetStyle(LineStyleEvent event) {
                    StyledTextTab.this.log(eventName, (TypedEvent)event);
                }
            });
        }
        if (eventName == "PaintObjectListener") {
            this.styledText.addPaintObjectListener(new PaintObjectListener(){

                public void paintObject(PaintObjectEvent event) {
                    StyledTextTab.this.log(eventName, (TypedEvent)event);
                }
            });
        }
        if (eventName == "TextChangeListener") {
            this.styledText.getContent().addTextChangeListener(new TextChangeListener(){

                public void textChanged(TextChangedEvent event) {
                    StyledTextTab.this.log(String.valueOf(eventName) + ".textChanged", (TypedEvent)event);
                }

                public void textChanging(TextChangingEvent event) {
                    StyledTextTab.this.log(String.valueOf(eventName) + ".textChanging", (TypedEvent)event);
                }

                public void textSet(TextChangedEvent event) {
                    StyledTextTab.this.log(String.valueOf(eventName) + ".textSet", (TypedEvent)event);
                }
            });
        }
        if (eventName == "VerifyKeyListener") {
            this.styledText.addVerifyKeyListener(new VerifyKeyListener(){

                public void verifyKey(VerifyEvent event) {
                    StyledTextTab.this.log(eventName, (TypedEvent)event);
                }
            });
        }
        if (eventName == "WordMovementListener") {
            this.styledText.addWordMovementListener(new MovementListener(){

                public void getNextOffset(MovementEvent event) {
                    StyledTextTab.this.log(String.valueOf(eventName) + ".getNextOffset", (TypedEvent)event);
                }

                public void getPreviousOffset(MovementEvent event) {
                    StyledTextTab.this.log(String.valueOf(eventName) + ".getPreviousOffset", (TypedEvent)event);
                }
            });
        }
    }

    void setExampleWidgetState() {
        super.setExampleWidgetState();
        this.wrapButton.setSelection((this.styledText.getStyle() & 0x40) != 0);
        this.readOnlyButton.setSelection((this.styledText.getStyle() & 8) != 0);
        this.fullSelectionButton.setSelection((this.styledText.getStyle() & 0x10000) != 0);
        this.horizontalButton.setEnabled((this.styledText.getStyle() & 2) != 0);
        this.verticalButton.setEnabled((this.styledText.getStyle() & 2) != 0);
        this.wrapButton.setEnabled((this.styledText.getStyle() & 2) != 0);
    }
}

