/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.ScrollableTab;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

class TableTab
extends ScrollableTab {
    Table table1;
    Group tableGroup;
    Button packColumnsButton;
    Button noScrollButton;
    Button checkButton;
    Button fullSelectionButton;
    Button hideSelectionButton;
    Button multipleColumns;
    Button moveableColumns;
    Button resizableColumns;
    Button headerVisibleButton;
    Button sortIndicatorButton;
    Button headerImagesButton;
    Button linesVisibleButton;
    Button subImagesButton;
    static final int ITEM_FOREGROUND_COLOR = 3;
    static final int ITEM_BACKGROUND_COLOR = 4;
    static final int ITEM_FONT = 5;
    static final int CELL_FOREGROUND_COLOR = 6;
    static final int CELL_BACKGROUND_COLOR = 7;
    static final int CELL_FONT = 8;
    Color itemForegroundColor;
    Color itemBackgroundColor;
    Color cellForegroundColor;
    Color cellBackgroundColor;
    Font itemFont;
    Font cellFont;
    static String[] columnTitles = new String[]{ControlExample.getResourceString("TableTitle_0"), ControlExample.getResourceString("TableTitle_1"), ControlExample.getResourceString("TableTitle_2"), ControlExample.getResourceString("TableTitle_3")};
    static String[][] tableData = new String[][]{{ControlExample.getResourceString("TableLine0_0"), ControlExample.getResourceString("TableLine0_1"), ControlExample.getResourceString("TableLine0_2"), ControlExample.getResourceString("TableLine0_3")}, {ControlExample.getResourceString("TableLine1_0"), ControlExample.getResourceString("TableLine1_1"), ControlExample.getResourceString("TableLine1_2"), ControlExample.getResourceString("TableLine1_3")}, {ControlExample.getResourceString("TableLine2_0"), ControlExample.getResourceString("TableLine2_1"), ControlExample.getResourceString("TableLine2_2"), ControlExample.getResourceString("TableLine2_3")}};
    Point menuMouseCoords;

    TableTab(ControlExample instance) {
        super(instance);
    }

    void createColorAndFontGroup() {
        super.createColorAndFontGroup();
        TableItem item = new TableItem(this.colorAndFontTable, 0);
        item.setText(ControlExample.getResourceString("Item_Foreground_Color"));
        item = new TableItem(this.colorAndFontTable, 0);
        item.setText(ControlExample.getResourceString("Item_Background_Color"));
        item = new TableItem(this.colorAndFontTable, 0);
        item.setText(ControlExample.getResourceString("Item_Font"));
        item = new TableItem(this.colorAndFontTable, 0);
        item.setText(ControlExample.getResourceString("Cell_Foreground_Color"));
        item = new TableItem(this.colorAndFontTable, 0);
        item.setText(ControlExample.getResourceString("Cell_Background_Color"));
        item = new TableItem(this.colorAndFontTable, 0);
        item.setText(ControlExample.getResourceString("Cell_Font"));
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                if (TableTab.this.itemBackgroundColor != null) {
                    TableTab.this.itemBackgroundColor.dispose();
                }
                if (TableTab.this.itemForegroundColor != null) {
                    TableTab.this.itemForegroundColor.dispose();
                }
                if (TableTab.this.itemFont != null) {
                    TableTab.this.itemFont.dispose();
                }
                if (TableTab.this.cellBackgroundColor != null) {
                    TableTab.this.cellBackgroundColor.dispose();
                }
                if (TableTab.this.cellForegroundColor != null) {
                    TableTab.this.cellForegroundColor.dispose();
                }
                if (TableTab.this.cellFont != null) {
                    TableTab.this.cellFont.dispose();
                }
                TableTab.this.itemBackgroundColor = null;
                TableTab.this.itemForegroundColor = null;
                TableTab.this.itemFont = null;
                TableTab.this.cellBackgroundColor = null;
                TableTab.this.cellForegroundColor = null;
                TableTab.this.cellFont = null;
            }
        });
    }

    void changeFontOrColor(int index) {
        switch (index) {
            case 3: {
                Color oldColor = this.itemForegroundColor;
                if (oldColor == null) {
                    oldColor = this.table1.getItem(0).getForeground();
                }
                this.colorDialog.setRGB(oldColor.getRGB());
                RGB rgb = this.colorDialog.open();
                if (rgb == null) {
                    return;
                }
                oldColor = this.itemForegroundColor;
                this.itemForegroundColor = new Color((Device)this.display, rgb);
                this.setItemForeground();
                if (oldColor == null) break;
                oldColor.dispose();
                break;
            }
            case 4: {
                Color oldColor = this.itemBackgroundColor;
                if (oldColor == null) {
                    oldColor = this.table1.getItem(0).getBackground();
                }
                this.colorDialog.setRGB(oldColor.getRGB());
                RGB rgb = this.colorDialog.open();
                if (rgb == null) {
                    return;
                }
                oldColor = this.itemBackgroundColor;
                this.itemBackgroundColor = new Color((Device)this.display, rgb);
                this.setItemBackground();
                if (oldColor == null) break;
                oldColor.dispose();
                break;
            }
            case 5: {
                Font oldFont = this.itemFont;
                if (oldFont == null) {
                    oldFont = this.table1.getItem(0).getFont();
                }
                this.fontDialog.setFontList(oldFont.getFontData());
                FontData fontData = this.fontDialog.open();
                if (fontData == null) {
                    return;
                }
                oldFont = this.itemFont;
                this.itemFont = new Font((Device)this.display, fontData);
                this.setItemFont();
                this.setExampleWidgetSize();
                if (oldFont == null) break;
                oldFont.dispose();
                break;
            }
            case 6: {
                Color oldColor = this.cellForegroundColor;
                if (oldColor == null) {
                    oldColor = this.table1.getItem(0).getForeground(1);
                }
                this.colorDialog.setRGB(oldColor.getRGB());
                RGB rgb = this.colorDialog.open();
                if (rgb == null) {
                    return;
                }
                oldColor = this.cellForegroundColor;
                this.cellForegroundColor = new Color((Device)this.display, rgb);
                this.setCellForeground();
                if (oldColor == null) break;
                oldColor.dispose();
                break;
            }
            case 7: {
                Color oldColor = this.cellBackgroundColor;
                if (oldColor == null) {
                    oldColor = this.table1.getItem(0).getBackground(1);
                }
                this.colorDialog.setRGB(oldColor.getRGB());
                RGB rgb = this.colorDialog.open();
                if (rgb == null) {
                    return;
                }
                oldColor = this.cellBackgroundColor;
                this.cellBackgroundColor = new Color((Device)this.display, rgb);
                this.setCellBackground();
                if (oldColor == null) break;
                oldColor.dispose();
                break;
            }
            case 8: {
                Font oldFont = this.cellFont;
                if (oldFont == null) {
                    oldFont = this.table1.getItem(0).getFont(1);
                }
                this.fontDialog.setFontList(oldFont.getFontData());
                FontData fontData = this.fontDialog.open();
                if (fontData == null) {
                    return;
                }
                oldFont = this.cellFont;
                this.cellFont = new Font((Device)this.display, fontData);
                this.setCellFont();
                this.setExampleWidgetSize();
                if (oldFont == null) break;
                oldFont.dispose();
                break;
            }
            default: {
                super.changeFontOrColor(index);
            }
        }
    }

    void createOtherGroup() {
        super.createOtherGroup();
        this.linesVisibleButton = new Button((Composite)this.otherGroup, 32);
        this.linesVisibleButton.setText(ControlExample.getResourceString("Lines_Visible"));
        this.multipleColumns = new Button((Composite)this.otherGroup, 32);
        this.multipleColumns.setText(ControlExample.getResourceString("Multiple_Columns"));
        this.multipleColumns.setSelection(true);
        this.headerVisibleButton = new Button((Composite)this.otherGroup, 32);
        this.headerVisibleButton.setText(ControlExample.getResourceString("Header_Visible"));
        this.sortIndicatorButton = new Button((Composite)this.otherGroup, 32);
        this.sortIndicatorButton.setText(ControlExample.getResourceString("Sort_Indicator"));
        this.moveableColumns = new Button((Composite)this.otherGroup, 32);
        this.moveableColumns.setText(ControlExample.getResourceString("Moveable_Columns"));
        this.resizableColumns = new Button((Composite)this.otherGroup, 32);
        this.resizableColumns.setText(ControlExample.getResourceString("Resizable_Columns"));
        this.headerImagesButton = new Button((Composite)this.otherGroup, 32);
        this.headerImagesButton.setText(ControlExample.getResourceString("Header_Images"));
        this.subImagesButton = new Button((Composite)this.otherGroup, 32);
        this.subImagesButton.setText(ControlExample.getResourceString("Sub_Images"));
        this.linesVisibleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableTab.this.setWidgetLinesVisible();
            }
        });
        this.multipleColumns.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableTab.this.recreateExampleWidgets();
            }
        });
        this.headerVisibleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableTab.this.setWidgetHeaderVisible();
            }
        });
        this.sortIndicatorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableTab.this.setWidgetSortIndicator();
            }
        });
        this.moveableColumns.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableTab.this.setColumnsMoveable();
            }
        });
        this.resizableColumns.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableTab.this.setColumnsResizable();
            }
        });
        this.headerImagesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableTab.this.recreateExampleWidgets();
            }
        });
        this.subImagesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableTab.this.recreateExampleWidgets();
            }
        });
    }

    void createExampleGroup() {
        super.createExampleGroup();
        this.tableGroup = new Group((Composite)this.exampleGroup, 0);
        this.tableGroup.setLayout((Layout)new GridLayout());
        this.tableGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableGroup.setText("Table");
    }

    void createExampleWidgets() {
        int i;
        int style = this.getDefaultStyle();
        if (this.singleButton.getSelection()) {
            style |= 4;
        }
        if (this.multiButton.getSelection()) {
            style |= 2;
        }
        if (this.verticalButton.getSelection()) {
            style |= 0x200;
        }
        if (this.horizontalButton.getSelection()) {
            style |= 0x100;
        }
        if (this.noScrollButton.getSelection()) {
            style |= 0x10;
        }
        if (this.checkButton.getSelection()) {
            style |= 0x20;
        }
        if (this.fullSelectionButton.getSelection()) {
            style |= 0x10000;
        }
        if (this.hideSelectionButton.getSelection()) {
            style |= 0x8000;
        }
        if (this.borderButton.getSelection()) {
            style |= 0x800;
        }
        this.table1 = new Table((Composite)this.tableGroup, style);
        boolean multiColumn = this.multipleColumns.getSelection();
        if (multiColumn) {
            i = 0;
            while (i < columnTitles.length) {
                TableColumn tableColumn = new TableColumn(this.table1, 0);
                tableColumn.setText(columnTitles[i]);
                tableColumn.setToolTipText(ControlExample.getResourceString("Tooltip", new String[]{columnTitles[i]}));
                if (this.headerImagesButton.getSelection()) {
                    tableColumn.setImage(this.instance.images[i % 3]);
                }
                ++i;
            }
            this.table1.setSortColumn(this.table1.getColumn(0));
        }
        i = 0;
        while (i < 16) {
            TableItem item = new TableItem(this.table1, 0);
            if (multiColumn && this.subImagesButton.getSelection()) {
                int j = 0;
                while (j < columnTitles.length) {
                    item.setImage(j, this.instance.images[i % 3]);
                    ++j;
                }
            } else {
                item.setImage(this.instance.images[i % 3]);
            }
            this.setItemText(item, i, String.valueOf(ControlExample.getResourceString("Index")) + i);
            ++i;
        }
        this.packColumns();
    }

    void setItemText(TableItem item, int i, String node) {
        int index = i % 3;
        if (this.multipleColumns.getSelection()) {
            TableTab.tableData[index][0] = node;
            item.setText(tableData[index]);
        } else {
            item.setText(node);
        }
    }

    void createSizeGroup() {
        super.createSizeGroup();
        this.packColumnsButton = new Button((Composite)this.sizeGroup, 8);
        this.packColumnsButton.setText(ControlExample.getResourceString("Pack_Columns"));
        this.packColumnsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableTab.this.packColumns();
                TableTab.this.setExampleWidgetSize();
            }
        });
    }

    void createStyleGroup() {
        super.createStyleGroup();
        this.noScrollButton = new Button((Composite)this.styleGroup, 32);
        this.noScrollButton.setText("SWT.NO_SCROLL");
        this.noScrollButton.moveAbove((Control)this.borderButton);
        this.checkButton = new Button((Composite)this.styleGroup, 32);
        this.checkButton.setText("SWT.CHECK");
        this.fullSelectionButton = new Button((Composite)this.styleGroup, 32);
        this.fullSelectionButton.setText("SWT.FULL_SELECTION");
        this.hideSelectionButton = new Button((Composite)this.styleGroup, 32);
        this.hideSelectionButton.setText("SWT.HIDE_SELECTION");
    }

    Item[] getExampleWidgetItems() {
        TableColumn[] columns = this.table1.getColumns();
        TableItem[] items = this.table1.getItems();
        Item[] allItems = new Item[columns.length + items.length];
        System.arraycopy(columns, 0, allItems, 0, columns.length);
        System.arraycopy(items, 0, allItems, columns.length, items.length);
        return allItems;
    }

    Widget[] getExampleWidgets() {
        return new Widget[]{this.table1};
    }

    String[] getMethodNames() {
        return new String[]{"ColumnOrder", "ItemCount", "Selection", "SelectionIndex", "ToolTipText", "TopIndex"};
    }

    String setMethodName(String methodRoot) {
        return methodRoot.equals("SelectionIndex") ? "setSelection" : "set" + methodRoot;
    }

    void packColumns() {
        int columnCount = this.table1.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            TableColumn tableColumn = this.table1.getColumn(i);
            tableColumn.pack();
            ++i;
        }
    }

    Object[] parameterForType(String typeName, String value, Widget widget) {
        TableItem item;
        if (value.equals("")) {
            return new Object[]{new TableItem[0]};
        }
        if (typeName.equals("org.eclipse.swt.widgets.TableItem") && (item = this.findItem(value, ((Table)widget).getItems())) != null) {
            return new Object[]{item};
        }
        if (typeName.equals("[Lorg.eclipse.swt.widgets.TableItem;")) {
            String[] values = this.split(value, ',');
            TableItem[] items = new TableItem[values.length];
            int i = 0;
            while (i < values.length) {
                items[i] = this.findItem(values[i], ((Table)widget).getItems());
                ++i;
            }
            return new Object[]{items};
        }
        return super.parameterForType(typeName, value, widget);
    }

    TableItem findItem(String value, TableItem[] items) {
        TableItem[] tableItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getText().equals(value)) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    String getTabText() {
        return "Table";
    }

    void resetColorsAndFonts() {
        super.resetColorsAndFonts();
        Color oldColor = this.itemForegroundColor;
        this.itemForegroundColor = null;
        this.setItemForeground();
        if (oldColor != null) {
            oldColor.dispose();
        }
        oldColor = this.itemBackgroundColor;
        this.itemBackgroundColor = null;
        this.setItemBackground();
        if (oldColor != null) {
            oldColor.dispose();
        }
        Font oldFont = this.font;
        this.itemFont = null;
        this.setItemFont();
        if (oldFont != null) {
            oldFont.dispose();
        }
        oldColor = this.cellForegroundColor;
        this.cellForegroundColor = null;
        this.setCellForeground();
        if (oldColor != null) {
            oldColor.dispose();
        }
        oldColor = this.cellBackgroundColor;
        this.cellBackgroundColor = null;
        this.setCellBackground();
        if (oldColor != null) {
            oldColor.dispose();
        }
        oldFont = this.font;
        this.cellFont = null;
        this.setCellFont();
        if (oldFont != null) {
            oldFont.dispose();
        }
    }

    void setCellBackground() {
        TableItem item;
        Image oldImage;
        Color color;
        if (!this.instance.startup) {
            this.table1.getItem(0).setBackground(1, this.cellBackgroundColor);
        }
        if ((color = this.cellBackgroundColor) == null) {
            color = this.table1.getItem(0).getBackground(1);
        }
        if ((oldImage = (item = this.colorAndFontTable.getItem(7)).getImage()) != null) {
            oldImage.dispose();
        }
        item.setImage(this.colorImage(color));
    }

    void setCellForeground() {
        TableItem item;
        Image oldImage;
        Color color;
        if (!this.instance.startup) {
            this.table1.getItem(0).setForeground(1, this.cellForegroundColor);
        }
        if ((color = this.cellForegroundColor) == null) {
            color = this.table1.getItem(0).getForeground(1);
        }
        if ((oldImage = (item = this.colorAndFontTable.getItem(6)).getImage()) != null) {
            oldImage.dispose();
        }
        item.setImage(this.colorImage(color));
    }

    void setCellFont() {
        TableItem item;
        Image oldImage;
        Font ft;
        if (!this.instance.startup) {
            this.table1.getItem(0).setFont(1, this.cellFont);
        }
        if ((ft = this.cellFont) == null) {
            ft = this.table1.getItem(0).getFont(1);
        }
        if ((oldImage = (item = this.colorAndFontTable.getItem(8)).getImage()) != null) {
            oldImage.dispose();
        }
        item.setImage(this.fontImage(ft));
        item.setFont(ft);
        this.colorAndFontTable.layout();
    }

    void setItemBackground() {
        TableItem item;
        Image oldImage;
        Color color;
        if (!this.instance.startup) {
            this.table1.getItem(0).setBackground(this.itemBackgroundColor);
        }
        if ((color = this.itemBackgroundColor) == null) {
            color = this.table1.getItem(0).getBackground();
        }
        if ((oldImage = (item = this.colorAndFontTable.getItem(4)).getImage()) != null) {
            oldImage.dispose();
        }
        item.setImage(this.colorImage(color));
    }

    void setItemForeground() {
        TableItem item;
        Image oldImage;
        Color color;
        if (!this.instance.startup) {
            this.table1.getItem(0).setForeground(this.itemForegroundColor);
        }
        if ((color = this.itemForegroundColor) == null) {
            color = this.table1.getItem(0).getForeground();
        }
        if ((oldImage = (item = this.colorAndFontTable.getItem(3)).getImage()) != null) {
            oldImage.dispose();
        }
        item.setImage(this.colorImage(color));
    }

    void setItemFont() {
        TableItem item;
        Image oldImage;
        Font ft;
        if (!this.instance.startup) {
            this.table1.getItem(0).setFont(this.itemFont);
        }
        if ((ft = this.itemFont) == null) {
            ft = this.table1.getItem(0).getFont();
        }
        if ((oldImage = (item = this.colorAndFontTable.getItem(5)).getImage()) != null) {
            oldImage.dispose();
        }
        item.setImage(this.fontImage(ft));
        item.setFont(ft);
        this.colorAndFontTable.layout();
    }

    void setColumnsMoveable() {
        TableColumn[] columns;
        boolean selection = this.moveableColumns.getSelection();
        TableColumn[] tableColumnArray = columns = this.table1.getColumns();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.setMoveable(selection);
            ++n2;
        }
    }

    void setColumnsResizable() {
        TableColumn[] columns;
        boolean selection = this.resizableColumns.getSelection();
        TableColumn[] tableColumnArray = columns = this.table1.getColumns();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.setResizable(selection);
            ++n2;
        }
    }

    void setExampleWidgetState() {
        this.setItemBackground();
        this.setItemForeground();
        this.setItemFont();
        this.setCellBackground();
        this.setCellForeground();
        this.setCellFont();
        if (!this.instance.startup) {
            this.setColumnsMoveable();
            this.setColumnsResizable();
            this.setWidgetHeaderVisible();
            this.setWidgetSortIndicator();
            this.setWidgetLinesVisible();
        }
        super.setExampleWidgetState();
        this.noScrollButton.setSelection((this.table1.getStyle() & 0x10) != 0);
        this.checkButton.setSelection((this.table1.getStyle() & 0x20) != 0);
        this.fullSelectionButton.setSelection((this.table1.getStyle() & 0x10000) != 0);
        this.hideSelectionButton.setSelection((this.table1.getStyle() & 0x8000) != 0);
        try {
            TableColumn column = this.table1.getColumn(0);
            this.moveableColumns.setSelection(column.getMoveable());
            this.resizableColumns.setSelection(column.getResizable());
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.headerVisibleButton.setSelection(this.table1.getHeaderVisible());
        this.linesVisibleButton.setSelection(this.table1.getLinesVisible());
    }

    void setWidgetHeaderVisible() {
        this.table1.setHeaderVisible(this.headerVisibleButton.getSelection());
    }

    void setWidgetSortIndicator() {
        TableColumn[] columns = this.table1.getColumns();
        if (this.sortIndicatorButton.getSelection()) {
            this.table1.setSortDirection(1024);
            int i = 0;
            while (i < columns.length) {
                TableColumn column = columns[i];
                if (i == 0) {
                    this.table1.setSortColumn(column);
                }
                SelectionAdapter listener = new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        int sortDirection = 1024;
                        if (e.widget == TableTab.this.table1.getSortColumn()) {
                            switch (TableTab.this.table1.getSortDirection()) {
                                case 1024: {
                                    sortDirection = 128;
                                    break;
                                }
                                case 128: {
                                    sortDirection = 0;
                                }
                            }
                        } else {
                            TableTab.this.table1.setSortColumn((TableColumn)e.widget);
                        }
                        TableTab.this.table1.setSortDirection(sortDirection);
                    }
                };
                column.addSelectionListener((SelectionListener)listener);
                column.setData("SortListener", (Object)listener);
                ++i;
            }
        } else {
            this.table1.setSortDirection(0);
            TableColumn[] tableColumnArray = columns;
            int n = columns.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn column = tableColumnArray[n2];
                SelectionListener listener = (SelectionListener)column.getData("SortListener");
                if (listener != null) {
                    column.removeSelectionListener(listener);
                }
                ++n2;
            }
        }
    }

    void setWidgetLinesVisible() {
        this.table1.setLinesVisible(this.linesVisibleButton.getSelection());
    }

    protected void specialPopupMenuItems(Menu menu, Event event) {
        MenuItem item = new MenuItem(menu, 8);
        item.setText("getItem(Point) on mouse coordinates");
        this.menuMouseCoords = this.table1.toControl(new Point(event.x, event.y));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableTab.this.eventConsole.append("getItem(Point(" + TableTab.this.menuMouseCoords + ")) returned: " + TableTab.this.table1.getItem(TableTab.this.menuMouseCoords));
                TableTab.this.eventConsole.append("\n");
            }
        });
    }
}

