/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.Tab;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.Widget;

class ToolTipTab
extends Tab {
    ToolTip toolTip1;
    Group toolTipGroup;
    Button balloonButton;
    Button iconErrorButton;
    Button iconInformationButton;
    Button iconWarningButton;
    Button noIconButton;
    Button autoHideButton;
    Button showInTrayButton;
    Tray tray;
    TrayItem trayItem;

    ToolTipTab(ControlExample instance) {
        super(instance);
    }

    void createExampleGroup() {
        super.createExampleGroup();
        this.toolTipGroup = new Group((Composite)this.exampleGroup, 0);
        this.toolTipGroup.setLayout((Layout)new GridLayout());
        this.toolTipGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.toolTipGroup.setText("ToolTip");
        this.visibleButton = new Button((Composite)this.toolTipGroup, 32);
        this.visibleButton.setText(ControlExample.getResourceString("Visible"));
        this.visibleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ToolTipTab.this.setExampleWidgetVisibility();
            }
        });
    }

    void createExampleWidgets() {
        int style = this.getDefaultStyle();
        if (this.balloonButton.getSelection()) {
            style |= 0x1000;
        }
        if (this.iconErrorButton.getSelection()) {
            style |= 1;
        }
        if (this.iconInformationButton.getSelection()) {
            style |= 2;
        }
        if (this.iconWarningButton.getSelection()) {
            style |= 8;
        }
        this.toolTip1 = new ToolTip(this.shell, style);
        this.toolTip1.setText(ControlExample.getResourceString("ToolTip_Title"));
        this.toolTip1.setMessage(ControlExample.getResourceString("Example_string"));
    }

    Composite createTabFolderPage(TabFolder tabFolder) {
        super.createTabFolderPage(tabFolder);
        this.tabFolderPage.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ToolTipTab.this.setExampleWidgetSize();
            }
        });
        return this.tabFolderPage;
    }

    void createStyleGroup() {
        super.createStyleGroup();
        this.balloonButton = new Button((Composite)this.styleGroup, 32);
        this.balloonButton.setText("SWT.BALLOON");
        this.iconErrorButton = new Button((Composite)this.styleGroup, 16);
        this.iconErrorButton.setText("SWT.ICON_ERROR");
        this.iconInformationButton = new Button((Composite)this.styleGroup, 16);
        this.iconInformationButton.setText("SWT.ICON_INFORMATION");
        this.iconWarningButton = new Button((Composite)this.styleGroup, 16);
        this.iconWarningButton.setText("SWT.ICON_WARNING");
        this.noIconButton = new Button((Composite)this.styleGroup, 16);
        this.noIconButton.setText(ControlExample.getResourceString("No_Icon"));
    }

    void createColorAndFontGroup() {
    }

    void createOtherGroup() {
        this.otherGroup = new Group((Composite)this.controlGroup, 0);
        this.otherGroup.setLayout((Layout)new GridLayout());
        this.otherGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        this.otherGroup.setText(ControlExample.getResourceString("Other"));
        this.autoHideButton = new Button((Composite)this.otherGroup, 32);
        this.autoHideButton.setText(ControlExample.getResourceString("AutoHide"));
        this.showInTrayButton = new Button((Composite)this.otherGroup, 32);
        this.showInTrayButton.setText(ControlExample.getResourceString("Show_In_Tray"));
        this.tray = this.display.getSystemTray();
        this.showInTrayButton.setEnabled(this.tray != null);
        this.autoHideButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ToolTipTab.this.setExampleWidgetAutoHide();
            }
        });
        this.showInTrayButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ToolTipTab.this.showExampleWidgetInTray();
            }
        });
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ToolTipTab.this.disposeTrayItem();
            }
        });
        this.autoHideButton.setSelection(true);
    }

    void createSizeGroup() {
    }

    void createBackgroundModeGroup() {
    }

    void disposeExampleWidgets() {
        this.disposeTrayItem();
        super.disposeExampleWidgets();
    }

    Widget[] getExampleWidgets() {
        return new Widget[]{this.toolTip1};
    }

    String[] getMethodNames() {
        return new String[]{"Message", "Text"};
    }

    String getShortTabText() {
        return "TT";
    }

    String getTabText() {
        return "ToolTip";
    }

    void setExampleWidgetState() {
        this.showExampleWidgetInTray();
        this.setExampleWidgetAutoHide();
        super.setExampleWidgetState();
        this.balloonButton.setSelection((this.toolTip1.getStyle() & 0x1000) != 0);
        this.iconErrorButton.setSelection((this.toolTip1.getStyle() & 1) != 0);
        this.iconInformationButton.setSelection((this.toolTip1.getStyle() & 2) != 0);
        this.iconWarningButton.setSelection((this.toolTip1.getStyle() & 8) != 0);
        this.noIconButton.setSelection((this.toolTip1.getStyle() & 0xB) == 0);
        this.autoHideButton.setSelection(this.toolTip1.getAutoHide());
    }

    void setExampleWidgetVisibility() {
        this.toolTip1.setVisible(this.visibleButton.getSelection());
    }

    void setExampleWidgetAutoHide() {
        this.toolTip1.setAutoHide(this.autoHideButton.getSelection());
    }

    void showExampleWidgetInTray() {
        if (this.showInTrayButton.getSelection()) {
            this.createTrayItem();
            this.trayItem.setToolTip(this.toolTip1);
        } else {
            this.disposeTrayItem();
        }
    }

    void createTrayItem() {
        if (this.trayItem == null) {
            this.trayItem = new TrayItem(this.tray, 0);
            this.trayItem.setImage(this.instance.images[2]);
        }
    }

    void disposeTrayItem() {
        if (this.trayItem != null) {
            this.trayItem.setToolTip(null);
            this.trayItem.dispose();
            this.trayItem = null;
        }
    }
}

