/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.dnd;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class DNDExample {
    private int dragOperation = 0;
    private Transfer[] dragTypes = new Transfer[0];
    private Control dragControl;
    private int dragControlType = 0;
    private DragSource dragSource;
    private String dragDataText;
    private String dragDataRTF;
    private String dragDataHTML;
    private String dragDataURL;
    private String[] dragDataFiles;
    private List fileList;
    private boolean dragEnabled = false;
    private int dropOperation = 0;
    private int dropFeedback = 0;
    private int dropDefaultOperation = 0;
    private Transfer[] dropTypes = new Transfer[0];
    private DropTarget dropTarget;
    private Control dropControl;
    private int dropControlType = 0;
    private Composite defaultParent;
    private boolean dropEnabled = false;
    private Text dragConsole;
    private boolean dragEventDetail = false;
    private Text dropConsole;
    private boolean dropEventDetail = false;
    private Image itemImage;
    private static final int BUTTON_TOGGLE = 0;
    private static final int BUTTON_RADIO = 1;
    private static final int BUTTON_CHECK = 2;
    private static final int CANVAS = 3;
    private static final int LABEL = 4;
    private static final int LIST = 5;
    private static final int TABLE = 6;
    private static final int TREE = 7;
    private static final int TEXT = 8;
    private static final int STYLED_TEXT = 9;
    private static final int COMBO = 10;

    public static void main(String[] args) {
        Display display = new Display();
        DNDExample example = new DNDExample();
        example.open(display);
        display.dispose();
    }

    private void addDragTransfer(Transfer transfer) {
        Transfer[] newTypes = new Transfer[this.dragTypes.length + 1];
        System.arraycopy(this.dragTypes, 0, newTypes, 0, this.dragTypes.length);
        newTypes[this.dragTypes.length] = transfer;
        this.dragTypes = newTypes;
        if (this.dragSource != null) {
            this.dragSource.setTransfer(this.dragTypes);
        }
    }

    private void addDropTransfer(Transfer transfer) {
        Transfer[] newTypes = new Transfer[this.dropTypes.length + 1];
        System.arraycopy(this.dropTypes, 0, newTypes, 0, this.dropTypes.length);
        newTypes[this.dropTypes.length] = transfer;
        this.dropTypes = newTypes;
        if (this.dropTarget != null) {
            this.dropTarget.setTransfer(this.dropTypes);
        }
    }

    private void createDragOperations(Composite parent) {
        parent.setLayout((Layout)new RowLayout(512));
        final Button moveButton = new Button(parent, 32);
        moveButton.setText("DND.DROP_MOVE");
        moveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    DNDExample dNDExample = DNDExample.this;
                    dNDExample.dragOperation = dNDExample.dragOperation | 2;
                } else {
                    DNDExample dNDExample = DNDExample.this;
                    dNDExample.dragOperation = dNDExample.dragOperation & 0xFFFFFFFD;
                    if (DNDExample.this.dragOperation == 0) {
                        DNDExample.this.dragOperation = 2;
                        moveButton.setSelection(true);
                    }
                }
                if (DNDExample.this.dragEnabled) {
                    DNDExample.this.createDragSource();
                }
            }
        });
        Button copyButton = new Button(parent, 32);
        copyButton.setText("DND.DROP_COPY");
        copyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    DNDExample dNDExample = DNDExample.this;
                    dNDExample.dragOperation = dNDExample.dragOperation | 1;
                } else {
                    DNDExample dNDExample = DNDExample.this;
                    dNDExample.dragOperation = dNDExample.dragOperation & 0xFFFFFFFE;
                    if (DNDExample.this.dragOperation == 0) {
                        DNDExample.this.dragOperation = 2;
                        moveButton.setSelection(true);
                    }
                }
                if (DNDExample.this.dragEnabled) {
                    DNDExample.this.createDragSource();
                }
            }
        });
        Button linkButton = new Button(parent, 32);
        linkButton.setText("DND.DROP_LINK");
        linkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    DNDExample dNDExample = DNDExample.this;
                    dNDExample.dragOperation = dNDExample.dragOperation | 4;
                } else {
                    DNDExample dNDExample = DNDExample.this;
                    dNDExample.dragOperation = dNDExample.dragOperation & 0xFFFFFFFB;
                    if (DNDExample.this.dragOperation == 0) {
                        DNDExample.this.dragOperation = 2;
                        moveButton.setSelection(true);
                    }
                }
                if (DNDExample.this.dragEnabled) {
                    DNDExample.this.createDragSource();
                }
            }
        });
        moveButton.setSelection(true);
        copyButton.setSelection(true);
        linkButton.setSelection(true);
        this.dragOperation |= 7;
    }

    private void createDragSource() {
        if (this.dragSource != null) {
            this.dragSource.dispose();
        }
        this.dragSource = new DragSource(this.dragControl, this.dragOperation);
        this.dragSource.setTransfer(this.dragTypes);
        this.dragSource.addDragListener(new DragSourceListener(){

            public void dragFinished(DragSourceEvent event) {
                DNDExample.this.dragConsole.append(">>dragFinished\n");
                DNDExample.this.printEvent(event);
                DNDExample.this.dragDataURL = null;
                DNDExample.this.dragDataHTML = null;
                DNDExample.this.dragDataRTF = null;
                DNDExample.this.dragDataText = null;
                DNDExample.this.dragDataFiles = null;
                if (event.detail == 2) {
                    switch (DNDExample.this.dragControlType) {
                        case 0: 
                        case 1: 
                        case 2: {
                            Button b = (Button)DNDExample.this.dragControl;
                            b.setText("");
                            break;
                        }
                        case 9: {
                            StyledText text = (StyledText)DNDExample.this.dragControl;
                            text.insert("");
                            break;
                        }
                        case 6: {
                            Table table = (Table)DNDExample.this.dragControl;
                            TableItem[] items = table.getSelection();
                            int i = 0;
                            while (i < items.length) {
                                items[i].dispose();
                                ++i;
                            }
                            break;
                        }
                        case 8: {
                            Text text = (Text)DNDExample.this.dragControl;
                            text.insert("");
                            break;
                        }
                        case 7: {
                            Tree tree = (Tree)DNDExample.this.dragControl;
                            TreeItem[] items = tree.getSelection();
                            int i = 0;
                            while (i < items.length) {
                                items[i].dispose();
                                ++i;
                            }
                            break;
                        }
                        case 3: {
                            DNDExample.this.dragControl.setData("STRINGS", null);
                            DNDExample.this.dragControl.redraw();
                            break;
                        }
                        case 4: {
                            Label label = (Label)DNDExample.this.dragControl;
                            label.setText("");
                            break;
                        }
                        case 5: {
                            List list = (List)DNDExample.this.dragControl;
                            int[] indices = list.getSelectionIndices();
                            list.remove(indices);
                            break;
                        }
                        case 10: {
                            Combo combo = (Combo)DNDExample.this.dragControl;
                            combo.setText("");
                        }
                    }
                }
            }

            public void dragSetData(DragSourceEvent event) {
                DNDExample.this.dragConsole.append(">>dragSetData\n");
                DNDExample.this.printEvent(event);
                if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = DNDExample.this.dragDataText;
                }
                if (RTFTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = DNDExample.this.dragDataRTF;
                }
                if (HTMLTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = DNDExample.this.dragDataHTML;
                }
                if (URLTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = DNDExample.this.dragDataURL;
                }
                if (FileTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = DNDExample.this.dragDataFiles;
                }
            }

            public void dragStart(DragSourceEvent event) {
                DNDExample.this.dragConsole.append(">>dragStart\n");
                DNDExample.this.printEvent(event);
                DNDExample.this.dragDataFiles = DNDExample.this.fileList.getItems();
                switch (DNDExample.this.dragControlType) {
                    case 0: 
                    case 1: 
                    case 2: {
                        Button b = (Button)DNDExample.this.dragControl;
                        DNDExample.this.dragDataText = b.getSelection() ? "true" : "false";
                        break;
                    }
                    case 9: {
                        StyledText text = (StyledText)DNDExample.this.dragControl;
                        String s = text.getSelectionText();
                        if (s.length() == 0) {
                            event.doit = false;
                            break;
                        }
                        DNDExample.this.dragDataText = s;
                        break;
                    }
                    case 6: {
                        Table table = (Table)DNDExample.this.dragControl;
                        TableItem[] items = table.getSelection();
                        if (items.length == 0) {
                            event.doit = false;
                            break;
                        }
                        StringBuffer buffer = new StringBuffer();
                        int i = 0;
                        while (i < items.length) {
                            buffer.append(items[i].getText());
                            if (items.length > 1 && i < items.length - 1) {
                                buffer.append("\n");
                            }
                            ++i;
                        }
                        DNDExample.this.dragDataText = buffer.toString();
                        break;
                    }
                    case 8: {
                        StyledText text = (Text)DNDExample.this.dragControl;
                        String s = text.getSelectionText();
                        if (s.length() == 0) {
                            event.doit = false;
                            break;
                        }
                        DNDExample.this.dragDataText = s;
                        break;
                    }
                    case 7: {
                        Tree tree = (Tree)DNDExample.this.dragControl;
                        TableItem[] items = tree.getSelection();
                        if (items.length == 0) {
                            event.doit = false;
                            break;
                        }
                        StringBuffer buffer = new StringBuffer();
                        int i = 0;
                        while (i < items.length) {
                            buffer.append(items[i].getText());
                            if (items.length > 1 && i < items.length - 1) {
                                buffer.append("\n");
                            }
                            ++i;
                        }
                        DNDExample.this.dragDataText = buffer.toString();
                        break;
                    }
                    case 3: {
                        String[] strings = (String[])DNDExample.this.dragControl.getData("STRINGS");
                        if (strings == null || strings.length == 0) {
                            event.doit = false;
                            break;
                        }
                        StringBuffer buffer = new StringBuffer();
                        int i = 0;
                        while (i < strings.length) {
                            buffer.append(strings[i]);
                            if (strings.length > 1 && i < strings.length - 1) {
                                buffer.append("\n");
                            }
                            ++i;
                        }
                        DNDExample.this.dragDataText = buffer.toString();
                        break;
                    }
                    case 4: {
                        Label label = (Label)DNDExample.this.dragControl;
                        String string = label.getText();
                        if (string.length() == 0) {
                            event.doit = false;
                            break;
                        }
                        DNDExample.this.dragDataText = string;
                        break;
                    }
                    case 5: {
                        List list = (List)DNDExample.this.dragControl;
                        String[] selection = list.getSelection();
                        if (selection.length == 0) {
                            event.doit = false;
                            break;
                        }
                        StringBuffer buffer = new StringBuffer();
                        int i = 0;
                        while (i < selection.length) {
                            buffer.append(selection[i]);
                            if (selection.length > 1 && i < selection.length - 1) {
                                buffer.append("\n");
                            }
                            ++i;
                        }
                        DNDExample.this.dragDataText = buffer.toString();
                        break;
                    }
                    case 10: {
                        Combo combo = (Combo)DNDExample.this.dragControl;
                        String string = combo.getText();
                        Point selection = combo.getSelection();
                        if (selection.x == selection.y) {
                            event.doit = false;
                            break;
                        }
                        DNDExample.this.dragDataText = string.substring(selection.x, selection.y);
                        break;
                    }
                    default: {
                        throw new SWTError(20);
                    }
                }
                if (DNDExample.this.dragDataText != null) {
                    DNDExample.this.dragDataRTF = "{\\rtf1{\\colortbl;\\red255\\green0\\blue0;}\\cf1\\b " + DNDExample.this.dragDataText + "}";
                    DNDExample.this.dragDataHTML = "<b>" + DNDExample.this.dragDataText + "</b>";
                    DNDExample.this.dragDataURL = "http://" + DNDExample.this.dragDataText.replace(' ', '.');
                    try {
                        new URL(DNDExample.this.dragDataURL);
                    }
                    catch (MalformedURLException malformedURLException) {
                        DNDExample.this.dragDataURL = null;
                    }
                }
                int i = 0;
                while (i < DNDExample.this.dragTypes.length) {
                    if (DNDExample.this.dragTypes[i] instanceof TextTransfer && DNDExample.this.dragDataText == null) {
                        event.doit = false;
                    }
                    if (DNDExample.this.dragTypes[i] instanceof RTFTransfer && DNDExample.this.dragDataRTF == null) {
                        event.doit = false;
                    }
                    if (DNDExample.this.dragTypes[i] instanceof HTMLTransfer && DNDExample.this.dragDataHTML == null) {
                        event.doit = false;
                    }
                    if (DNDExample.this.dragTypes[i] instanceof URLTransfer && DNDExample.this.dragDataURL == null) {
                        event.doit = false;
                    }
                    if (DNDExample.this.dragTypes[i] instanceof FileTransfer && (DNDExample.this.dragDataFiles == null || DNDExample.this.dragDataFiles.length == 0)) {
                        event.doit = false;
                    }
                    ++i;
                }
            }
        });
    }

    private void createDragTypes(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        Button textButton = new Button(parent, 32);
        textButton.setText("Text Transfer");
        textButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    DNDExample.this.addDragTransfer((Transfer)TextTransfer.getInstance());
                } else {
                    DNDExample.this.removeDragTransfer((Transfer)TextTransfer.getInstance());
                }
            }
        });
        Button b = new Button(parent, 32);
        b.setText("RTF Transfer");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    DNDExample.this.addDragTransfer((Transfer)RTFTransfer.getInstance());
                } else {
                    DNDExample.this.removeDragTransfer((Transfer)RTFTransfer.getInstance());
                }
            }
        });
        b = new Button(parent, 32);
        b.setText("HTML Transfer");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    DNDExample.this.addDragTransfer((Transfer)HTMLTransfer.getInstance());
                } else {
                    DNDExample.this.removeDragTransfer((Transfer)HTMLTransfer.getInstance());
                }
            }
        });
        b = new Button(parent, 32);
        b.setText("URL Transfer");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    DNDExample.this.addDragTransfer((Transfer)URLTransfer.getInstance());
                } else {
                    DNDExample.this.removeDragTransfer((Transfer)URLTransfer.getInstance());
                }
            }
        });
        b = new Button(parent, 32);
        b.setText("File Transfer");
        b.setLayoutData((Object)new GridData(2));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    DNDExample.this.addDragTransfer((Transfer)FileTransfer.getInstance());
                } else {
                    DNDExample.this.removeDragTransfer((Transfer)FileTransfer.getInstance());
                }
            }
        });
        b = new Button(parent, 8);
        b.setText("Select File(s)");
        b.setLayoutData((Object)new GridData(2));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(DNDExample.this.fileList.getShell(), 4098);
                String result = dialog.open();
                if (result != null && result.length() > 0) {
                    DNDExample.this.fileList.removeAll();
                    String separator = System.getProperty("file.separator");
                    String path = dialog.getFilterPath();
                    String[] names = dialog.getFileNames();
                    int i = 0;
                    while (i < names.length) {
                        DNDExample.this.fileList.add(String.valueOf(path) + separator + names[i]);
                        ++i;
                    }
                }
            }
        });
        this.fileList = new List(parent, 2816);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        this.fileList.setLayoutData((Object)data);
        textButton.setSelection(true);
        this.addDragTransfer((Transfer)TextTransfer.getInstance());
    }

    private void createDragWidget(Composite parent) {
        parent.setLayout((Layout)new FormLayout());
        Combo combo = new Combo(parent, 8);
        combo.setItems(new String[]{"Toggle Button", "Radio Button", "Checkbox", "Canvas", "Label", "List", "Table", "Tree", "Text", "StyledText", "Combo"});
        combo.select(4);
        this.dragControlType = combo.getSelectionIndex();
        this.dragControl = this.createWidget(this.dragControlType, parent, "Drag Source");
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object data = DNDExample.this.dragControl.getLayoutData();
                Composite parent = DNDExample.this.dragControl.getParent();
                DNDExample.this.dragControl.dispose();
                Combo c = (Combo)e.widget;
                DNDExample.this.dragControlType = c.getSelectionIndex();
                DNDExample.this.dragControl = DNDExample.this.createWidget(DNDExample.this.dragControlType, parent, "Drag Source");
                DNDExample.this.dragControl.setLayoutData(data);
                if (DNDExample.this.dragEnabled) {
                    DNDExample.this.createDragSource();
                }
                parent.layout();
            }
        });
        Button b = new Button(parent, 32);
        b.setText("DragSource");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                DNDExample.this.dragEnabled = b.getSelection();
                if (DNDExample.this.dragEnabled) {
                    DNDExample.this.createDragSource();
                } else {
                    if (DNDExample.this.dragSource != null) {
                        DNDExample.this.dragSource.dispose();
                    }
                    DNDExample.this.dragSource = null;
                }
            }
        });
        b.setSelection(true);
        this.dragEnabled = true;
        FormData data = new FormData();
        data.top = new FormAttachment(0, 10);
        data.bottom = new FormAttachment((Control)combo, -10);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(100, -10);
        this.dragControl.setLayoutData((Object)data);
        data = new FormData();
        data.bottom = new FormAttachment(100, -10);
        data.left = new FormAttachment(0, 10);
        combo.setLayoutData((Object)data);
        data = new FormData();
        data.bottom = new FormAttachment(100, -10);
        data.left = new FormAttachment((Control)combo, 10);
        b.setLayoutData((Object)data);
    }

    private void createDropOperations(Composite parent) {
        parent.setLayout((Layout)new RowLayout(512));
        final Button moveButton = new Button(parent, 32);
        moveButton.setText("DND.DROP_MOVE");
        moveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    DNDExample dNDExample = DNDExample.this;
                    dNDExample.dropOperation = dNDExample.dropOperation | 2;
                } else {
                    DNDExample dNDExample = DNDExample.this;
                    dNDExample.dropOperation = dNDExample.dropOperation & 0xFFFFFFFD;
                    if (DNDExample.this.dropOperation == 0 || (DNDExample.this.dropDefaultOperation & 2) != 0) {
                        DNDExample dNDExample2 = DNDExample.this;
                        dNDExample2.dropOperation = dNDExample2.dropOperation | 2;
                        moveButton.setSelection(true);
                    }
                }
                if (DNDExample.this.dropEnabled) {
                    DNDExample.this.createDropTarget();
                }
            }
        });
        final Button copyButton = new Button(parent, 32);
        copyButton.setText("DND.DROP_COPY");
        copyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    DNDExample dNDExample = DNDExample.this;
                    dNDExample.dropOperation = dNDExample.dropOperation | 1;
                } else {
                    DNDExample dNDExample = DNDExample.this;
                    dNDExample.dropOperation = dNDExample.dropOperation & 0xFFFFFFFE;
                    if (DNDExample.this.dropOperation == 0 || (DNDExample.this.dropDefaultOperation & 1) != 0) {
                        DNDExample.this.dropOperation = 1;
                        copyButton.setSelection(true);
                    }
                }
                if (DNDExample.this.dropEnabled) {
                    DNDExample.this.createDropTarget();
                }
            }
        });
        final Button linkButton = new Button(parent, 32);
        linkButton.setText("DND.DROP_LINK");
        linkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    DNDExample dNDExample = DNDExample.this;
                    dNDExample.dropOperation = dNDExample.dropOperation | 4;
                } else {
                    DNDExample dNDExample = DNDExample.this;
                    dNDExample.dropOperation = dNDExample.dropOperation & 0xFFFFFFFB;
                    if (DNDExample.this.dropOperation == 0 || (DNDExample.this.dropDefaultOperation & 4) != 0) {
                        DNDExample.this.dropOperation = 4;
                        linkButton.setSelection(true);
                    }
                }
                if (DNDExample.this.dropEnabled) {
                    DNDExample.this.createDropTarget();
                }
            }
        });
        Button b = new Button(parent, 32);
        b.setText("DND.DROP_DEFAULT");
        this.defaultParent = new Composite(parent, 0);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    DNDExample dNDExample = DNDExample.this;
                    dNDExample.dropOperation = dNDExample.dropOperation | 0x10;
                    DNDExample.this.defaultParent.setVisible(true);
                } else {
                    DNDExample dNDExample = DNDExample.this;
                    dNDExample.dropOperation = dNDExample.dropOperation & 0xFFFFFFEF;
                    DNDExample.this.defaultParent.setVisible(false);
                }
                if (DNDExample.this.dropEnabled) {
                    DNDExample.this.createDropTarget();
                }
            }
        });
        this.defaultParent.setVisible(false);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 20;
        this.defaultParent.setLayout((Layout)layout);
        Label label = new Label(this.defaultParent, 0);
        label.setText("Value for default operation is:");
        b = new Button(this.defaultParent, 16);
        b.setText("DND.DROP_MOVE");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    DNDExample.this.dropDefaultOperation = 2;
                    DNDExample dNDExample = DNDExample.this;
                    dNDExample.dropOperation = dNDExample.dropOperation | 2;
                    moveButton.setSelection(true);
                    if (DNDExample.this.dropEnabled) {
                        DNDExample.this.createDropTarget();
                    }
                }
            }
        });
        b = new Button(this.defaultParent, 16);
        b.setText("DND.DROP_COPY");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    DNDExample.this.dropDefaultOperation = 1;
                    DNDExample dNDExample = DNDExample.this;
                    dNDExample.dropOperation = dNDExample.dropOperation | 1;
                    copyButton.setSelection(true);
                    if (DNDExample.this.dropEnabled) {
                        DNDExample.this.createDropTarget();
                    }
                }
            }
        });
        b = new Button(this.defaultParent, 16);
        b.setText("DND.DROP_LINK");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    DNDExample.this.dropDefaultOperation = 4;
                    DNDExample dNDExample = DNDExample.this;
                    dNDExample.dropOperation = dNDExample.dropOperation | 4;
                    linkButton.setSelection(true);
                    if (DNDExample.this.dropEnabled) {
                        DNDExample.this.createDropTarget();
                    }
                }
            }
        });
        b = new Button(this.defaultParent, 16);
        b.setText("DND.DROP_NONE");
        b.setSelection(true);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    DNDExample.this.dropDefaultOperation = 0;
                    DNDExample dNDExample = DNDExample.this;
                    dNDExample.dropOperation = dNDExample.dropOperation & 0xFFFFFFEF;
                    if (DNDExample.this.dropEnabled) {
                        DNDExample.this.createDropTarget();
                    }
                }
            }
        });
        moveButton.setSelection(true);
        copyButton.setSelection(true);
        linkButton.setSelection(true);
        this.dropOperation = 7;
    }

    private void createDropTarget() {
        if (this.dropTarget != null) {
            this.dropTarget.dispose();
        }
        this.dropTarget = new DropTarget(this.dropControl, this.dropOperation);
        this.dropTarget.setTransfer(this.dropTypes);
        this.dropTarget.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                DNDExample.this.dropConsole.append(">>dragEnter\n");
                DNDExample.this.printEvent(event);
                if (event.detail == 16) {
                    event.detail = DNDExample.this.dropDefaultOperation;
                }
                event.feedback = DNDExample.this.dropFeedback;
            }

            public void dragLeave(DropTargetEvent event) {
                DNDExample.this.dropConsole.append(">>dragLeave\n");
                DNDExample.this.printEvent(event);
            }

            public void dragOperationChanged(DropTargetEvent event) {
                DNDExample.this.dropConsole.append(">>dragOperationChanged\n");
                DNDExample.this.printEvent(event);
                if (event.detail == 16) {
                    event.detail = DNDExample.this.dropDefaultOperation;
                }
                event.feedback = DNDExample.this.dropFeedback;
            }

            public void dragOver(DropTargetEvent event) {
                DNDExample.this.dropConsole.append(">>dragOver\n");
                DNDExample.this.printEvent(event);
                event.feedback = DNDExample.this.dropFeedback;
            }

            public void drop(DropTargetEvent event) {
                DNDExample.this.dropConsole.append(">>drop\n");
                DNDExample.this.printEvent(event);
                String[] strings = null;
                if (TextTransfer.getInstance().isSupportedType(event.currentDataType) || RTFTransfer.getInstance().isSupportedType(event.currentDataType) || HTMLTransfer.getInstance().isSupportedType(event.currentDataType) || URLTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    strings = new String[]{(String)event.data};
                }
                if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    strings = (String[])event.data;
                }
                if (strings == null || strings.length == 0) {
                    DNDExample.this.dropConsole.append("!!Invalid data dropped");
                    return;
                }
                if (strings.length == 1 && (DNDExample.this.dropControlType == 6 || DNDExample.this.dropControlType == 7 || DNDExample.this.dropControlType == 5)) {
                    String string = strings[0];
                    int count = 0;
                    int offset = string.indexOf("\n", 0);
                    while (offset > 0) {
                        ++count;
                        offset = string.indexOf("\n", offset + 1);
                    }
                    if (count > 0) {
                        strings = new String[count + 1];
                        int start = 0;
                        int end = string.indexOf("\n");
                        int index = 0;
                        while (start < end) {
                            strings[index++] = string.substring(start, end);
                            start = end + 1;
                            if ((end = string.indexOf("\n", start)) != -1) continue;
                            end = string.length();
                        }
                    }
                }
                switch (DNDExample.this.dropControlType) {
                    case 0: 
                    case 1: 
                    case 2: {
                        Button b = (Button)DNDExample.this.dropControl;
                        b.setText(strings[0]);
                        break;
                    }
                    case 9: {
                        StyledText text = (StyledText)DNDExample.this.dropControl;
                        int i = 0;
                        while (i < strings.length) {
                            text.insert(strings[i]);
                            ++i;
                        }
                        break;
                    }
                    case 6: {
                        Table table = (Table)DNDExample.this.dropControl;
                        Point p = event.display.map(null, (Control)table, event.x, event.y);
                        TableItem dropItem = table.getItem(p);
                        int index = dropItem == null ? table.getItemCount() : table.indexOf(dropItem);
                        int i = 0;
                        while (i < strings.length) {
                            TableItem item = new TableItem(table, 0, index);
                            item.setText(0, strings[i]);
                            item.setText(1, "dropped item");
                            ++i;
                        }
                        TableColumn[] columns = table.getColumns();
                        int i2 = 0;
                        while (i2 < columns.length) {
                            columns[i2].pack();
                            ++i2;
                        }
                        break;
                    }
                    case 8: {
                        StyledText text = (Text)DNDExample.this.dropControl;
                        int i = 0;
                        while (i < strings.length) {
                            text.append(String.valueOf(strings[i]) + "\n");
                            ++i;
                        }
                        break;
                    }
                    case 7: {
                        Tree tree = (Tree)DNDExample.this.dropControl;
                        Point p = event.display.map(null, (Control)tree, event.x, event.y);
                        TreeItem parentItem = tree.getItem(p);
                        int i = 0;
                        while (i < strings.length) {
                            TreeItem item = parentItem != null ? new TreeItem(parentItem, 0) : new TreeItem(tree, 0);
                            item.setText(strings[i]);
                            ++i;
                        }
                        break;
                    }
                    case 3: {
                        DNDExample.this.dropControl.setData("STRINGS", (Object)strings);
                        DNDExample.this.dropControl.redraw();
                        break;
                    }
                    case 4: {
                        Label label = (Label)DNDExample.this.dropControl;
                        label.setText(strings[0]);
                        break;
                    }
                    case 5: {
                        List list = (List)DNDExample.this.dropControl;
                        int i = 0;
                        while (i < strings.length) {
                            list.add(strings[i]);
                            ++i;
                        }
                        break;
                    }
                    case 10: {
                        Combo combo = (Combo)DNDExample.this.dropControl;
                        combo.setText(strings[0]);
                        break;
                    }
                    default: {
                        throw new SWTError(20);
                    }
                }
            }

            public void dropAccept(DropTargetEvent event) {
                DNDExample.this.dropConsole.append(">>dropAccept\n");
                DNDExample.this.printEvent(event);
            }
        });
    }

    private void createFeedbackTypes(Group parent) {
        parent.setLayout((Layout)new RowLayout(512));
        Button b = new Button((Composite)parent, 32);
        b.setText("FEEDBACK_SELECT");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    DNDExample dNDExample = DNDExample.this;
                    dNDExample.dropFeedback = dNDExample.dropFeedback | 1;
                } else {
                    DNDExample dNDExample = DNDExample.this;
                    dNDExample.dropFeedback = dNDExample.dropFeedback & 0xFFFFFFFE;
                }
            }
        });
        b = new Button((Composite)parent, 32);
        b.setText("FEEDBACK_SCROLL");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    DNDExample dNDExample = DNDExample.this;
                    dNDExample.dropFeedback = dNDExample.dropFeedback | 8;
                } else {
                    DNDExample dNDExample = DNDExample.this;
                    dNDExample.dropFeedback = dNDExample.dropFeedback & 0xFFFFFFF7;
                }
            }
        });
        b = new Button((Composite)parent, 32);
        b.setText("FEEDBACK_INSERT_BEFORE");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    DNDExample dNDExample = DNDExample.this;
                    dNDExample.dropFeedback = dNDExample.dropFeedback | 2;
                } else {
                    DNDExample dNDExample = DNDExample.this;
                    dNDExample.dropFeedback = dNDExample.dropFeedback & 0xFFFFFFFD;
                }
            }
        });
        b = new Button((Composite)parent, 32);
        b.setText("FEEDBACK_INSERT_AFTER");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    DNDExample dNDExample = DNDExample.this;
                    dNDExample.dropFeedback = dNDExample.dropFeedback | 4;
                } else {
                    DNDExample dNDExample = DNDExample.this;
                    dNDExample.dropFeedback = dNDExample.dropFeedback & 0xFFFFFFFB;
                }
            }
        });
        b = new Button((Composite)parent, 32);
        b.setText("FEEDBACK_EXPAND");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    DNDExample dNDExample = DNDExample.this;
                    dNDExample.dropFeedback = dNDExample.dropFeedback | 0x10;
                } else {
                    DNDExample dNDExample = DNDExample.this;
                    dNDExample.dropFeedback = dNDExample.dropFeedback & 0xFFFFFFEF;
                }
            }
        });
    }

    private void createDropTypes(Composite parent) {
        parent.setLayout((Layout)new RowLayout(512));
        Button textButton = new Button(parent, 32);
        textButton.setText("Text Transfer");
        textButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    DNDExample.this.addDropTransfer((Transfer)TextTransfer.getInstance());
                } else {
                    DNDExample.this.removeDropTransfer((Transfer)TextTransfer.getInstance());
                }
            }
        });
        Button b = new Button(parent, 32);
        b.setText("RTF Transfer");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    DNDExample.this.addDropTransfer((Transfer)RTFTransfer.getInstance());
                } else {
                    DNDExample.this.removeDropTransfer((Transfer)RTFTransfer.getInstance());
                }
            }
        });
        b = new Button(parent, 32);
        b.setText("HTML Transfer");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    DNDExample.this.addDropTransfer((Transfer)HTMLTransfer.getInstance());
                } else {
                    DNDExample.this.removeDropTransfer((Transfer)HTMLTransfer.getInstance());
                }
            }
        });
        b = new Button(parent, 32);
        b.setText("URL Transfer");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    DNDExample.this.addDropTransfer((Transfer)URLTransfer.getInstance());
                } else {
                    DNDExample.this.removeDropTransfer((Transfer)URLTransfer.getInstance());
                }
            }
        });
        b = new Button(parent, 32);
        b.setText("File Transfer");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    DNDExample.this.addDropTransfer((Transfer)FileTransfer.getInstance());
                } else {
                    DNDExample.this.removeDropTransfer((Transfer)FileTransfer.getInstance());
                }
            }
        });
        textButton.setSelection(true);
        this.addDropTransfer((Transfer)TextTransfer.getInstance());
    }

    private void createDropWidget(Composite parent) {
        parent.setLayout((Layout)new FormLayout());
        Combo combo = new Combo(parent, 8);
        combo.setItems(new String[]{"Toggle Button", "Radio Button", "Checkbox", "Canvas", "Label", "List", "Table", "Tree", "Text", "StyledText", "Combo"});
        combo.select(4);
        this.dropControlType = combo.getSelectionIndex();
        this.dropControl = this.createWidget(this.dropControlType, parent, "Drop Target");
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object data = DNDExample.this.dropControl.getLayoutData();
                Composite parent = DNDExample.this.dropControl.getParent();
                DNDExample.this.dropControl.dispose();
                Combo c = (Combo)e.widget;
                DNDExample.this.dropControlType = c.getSelectionIndex();
                DNDExample.this.dropControl = DNDExample.this.createWidget(DNDExample.this.dropControlType, parent, "Drop Target");
                DNDExample.this.dropControl.setLayoutData(data);
                if (DNDExample.this.dropEnabled) {
                    DNDExample.this.createDropTarget();
                }
                parent.layout();
            }
        });
        Button b = new Button(parent, 32);
        b.setText("DropTarget");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                DNDExample.this.dropEnabled = b.getSelection();
                if (DNDExample.this.dropEnabled) {
                    DNDExample.this.createDropTarget();
                } else {
                    if (DNDExample.this.dropTarget != null) {
                        DNDExample.this.dropTarget.dispose();
                    }
                    DNDExample.this.dropTarget = null;
                }
            }
        });
        b.setSelection(true);
        this.dropEnabled = true;
        FormData data = new FormData();
        data.top = new FormAttachment(0, 10);
        data.bottom = new FormAttachment((Control)combo, -10);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(100, -10);
        this.dropControl.setLayoutData((Object)data);
        data = new FormData();
        data.bottom = new FormAttachment(100, -10);
        data.left = new FormAttachment(0, 10);
        combo.setLayoutData((Object)data);
        data = new FormData();
        data.bottom = new FormAttachment(100, -10);
        data.left = new FormAttachment((Control)combo, 10);
        b.setLayoutData((Object)data);
    }

    private Control createWidget(int type, Composite parent, String prefix) {
        switch (type) {
            case 2: {
                Button button = new Button(parent, 32);
                button.setText(String.valueOf(prefix) + " Check box");
                return button;
            }
            case 0: {
                Button button = new Button(parent, 2);
                button.setText(String.valueOf(prefix) + " Toggle button");
                return button;
            }
            case 1: {
                Button button = new Button(parent, 16);
                button.setText(String.valueOf(prefix) + " Radio button");
                return button;
            }
            case 9: {
                StyledText text = new StyledText(parent, 2818);
                text.setText(String.valueOf(prefix) + " Styled Text");
                return text;
            }
            case 6: {
                Table table = new Table(parent, 2050);
                table.setHeaderVisible(true);
                TableColumn column0 = new TableColumn(table, 16384);
                column0.setText("Name");
                TableColumn column1 = new TableColumn(table, 131072);
                column1.setText("Value");
                TableColumn column2 = new TableColumn(table, 0x1000000);
                column2.setText("Description");
                int i = 0;
                while (i < 10) {
                    TableItem item = new TableItem(table, 0);
                    item.setText(0, String.valueOf(prefix) + " name " + i);
                    item.setText(1, String.valueOf(prefix) + " value " + i);
                    item.setText(2, String.valueOf(prefix) + " description " + i);
                    item.setImage(this.itemImage);
                    ++i;
                }
                column0.pack();
                column1.pack();
                column2.pack();
                return table;
            }
            case 8: {
                Text text = new Text(parent, 2818);
                text.setText(String.valueOf(prefix) + " Text");
                return text;
            }
            case 7: {
                Tree tree = new Tree(parent, 2050);
                tree.setHeaderVisible(true);
                TreeColumn column0 = new TreeColumn(tree, 16384);
                column0.setText("Name");
                TreeColumn column1 = new TreeColumn(tree, 131072);
                column1.setText("Value");
                TreeColumn column2 = new TreeColumn(tree, 0x1000000);
                column2.setText("Description");
                int i = 0;
                while (i < 3) {
                    TreeItem item = new TreeItem(tree, 0);
                    item.setText(0, String.valueOf(prefix) + " name " + i);
                    item.setText(1, String.valueOf(prefix) + " value " + i);
                    item.setText(2, String.valueOf(prefix) + " description " + i);
                    item.setImage(this.itemImage);
                    int j = 0;
                    while (j < 3) {
                        TreeItem subItem = new TreeItem(item, 0);
                        subItem.setText(0, String.valueOf(prefix) + " name " + i + " " + j);
                        subItem.setText(1, String.valueOf(prefix) + " value " + i + " " + j);
                        subItem.setText(2, String.valueOf(prefix) + " description " + i + " " + j);
                        subItem.setImage(this.itemImage);
                        int k = 0;
                        while (k < 3) {
                            TreeItem subsubItem = new TreeItem(subItem, 0);
                            subsubItem.setText(0, String.valueOf(prefix) + " name " + i + " " + j + " " + k);
                            subsubItem.setText(1, String.valueOf(prefix) + " value " + i + " " + j + " " + k);
                            subsubItem.setText(2, String.valueOf(prefix) + " description " + i + " " + j + " " + k);
                            subsubItem.setImage(this.itemImage);
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
                column0.pack();
                column1.pack();
                column2.pack();
                return tree;
            }
            case 3: {
                Canvas canvas = new Canvas(parent, 2048);
                canvas.setData("STRINGS", (Object)new String[]{String.valueOf(prefix) + " Canvas widget"});
                canvas.addPaintListener(new PaintListener(){

                    public void paintControl(PaintEvent e) {
                        Canvas c = (Canvas)e.widget;
                        Image image = (Image)c.getData("IMAGE");
                        if (image != null) {
                            e.gc.drawImage(image, 5, 5);
                        } else {
                            String[] strings = (String[])c.getData("STRINGS");
                            if (strings != null) {
                                FontMetrics metrics = e.gc.getFontMetrics();
                                int height = metrics.getHeight();
                                int y = 5;
                                int i = 0;
                                while (i < strings.length) {
                                    e.gc.drawString(strings[i], 5, y);
                                    y += height + 5;
                                    ++i;
                                }
                            }
                        }
                    }
                });
                return canvas;
            }
            case 4: {
                Label label = new Label(parent, 2048);
                label.setText(String.valueOf(prefix) + " Label");
                return label;
            }
            case 5: {
                List list = new List(parent, 2048);
                list.setItems(new String[]{String.valueOf(prefix) + " Item a", String.valueOf(prefix) + " Item b", String.valueOf(prefix) + " Item c", String.valueOf(prefix) + " Item d"});
                return list;
            }
            case 10: {
                Combo combo = new Combo(parent, 2048);
                combo.setItems(new String[]{"Item a", "Item b", "Item c", "Item d"});
                return combo;
            }
        }
        throw new SWTError(20);
    }

    public void open(Display display) {
        Shell shell = new Shell(display);
        shell.setText("Drag and Drop Example");
        shell.setLayout((Layout)new FillLayout());
        this.itemImage = new Image((Device)display, DNDExample.class.getResourceAsStream("openFolder.gif"));
        ScrolledComposite sc = new ScrolledComposite((Composite)shell, 768);
        Composite parent = new Composite((Composite)sc, 0);
        sc.setContent((Control)parent);
        parent.setLayout((Layout)new FormLayout());
        Label dragLabel = new Label(parent, 16384);
        dragLabel.setText("Drag Source:");
        Group dragWidgetGroup = new Group(parent, 0);
        dragWidgetGroup.setText("Widget");
        this.createDragWidget((Composite)dragWidgetGroup);
        Composite cLeft = new Composite(parent, 0);
        cLeft.setLayout((Layout)new GridLayout(2, false));
        Group dragOperationsGroup = new Group(cLeft, 0);
        dragOperationsGroup.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        dragOperationsGroup.setText("Allowed Operation(s):");
        this.createDragOperations((Composite)dragOperationsGroup);
        Group dragTypesGroup = new Group(cLeft, 0);
        dragTypesGroup.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        dragTypesGroup.setText("Transfer Type(s):");
        this.createDragTypes((Composite)dragTypesGroup);
        this.dragConsole = new Text(cLeft, 2826);
        this.dragConsole.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Menu menu = new Menu((Decorations)shell, 8);
        MenuItem item = new MenuItem(menu, 8);
        item.setText("Clear");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DNDExample.this.dragConsole.setText("");
            }
        });
        item = new MenuItem(menu, 32);
        item.setText("Show Event detail");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MenuItem item = (MenuItem)e.widget;
                DNDExample.this.dragEventDetail = item.getSelection();
            }
        });
        this.dragConsole.setMenu(menu);
        Label dropLabel = new Label(parent, 16384);
        dropLabel.setText("Drop Target:");
        Group dropWidgetGroup = new Group(parent, 0);
        dropWidgetGroup.setText("Widget");
        this.createDropWidget((Composite)dropWidgetGroup);
        Composite cRight = new Composite(parent, 0);
        cRight.setLayout((Layout)new GridLayout(2, false));
        Group dropOperationsGroup = new Group(cRight, 0);
        dropOperationsGroup.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 2));
        dropOperationsGroup.setText("Allowed Operation(s):");
        this.createDropOperations((Composite)dropOperationsGroup);
        Group dropTypesGroup = new Group(cRight, 0);
        dropTypesGroup.setText("Transfer Type(s):");
        this.createDropTypes((Composite)dropTypesGroup);
        Group feedbackTypesGroup = new Group(cRight, 0);
        feedbackTypesGroup.setText("Feedback Type(s):");
        this.createFeedbackTypes(feedbackTypesGroup);
        this.dropConsole = new Text(cRight, 2826);
        this.dropConsole.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        menu = new Menu((Decorations)shell, 8);
        item = new MenuItem(menu, 8);
        item.setText("Clear");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DNDExample.this.dropConsole.setText("");
            }
        });
        item = new MenuItem(menu, 32);
        item.setText("Show Event detail");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MenuItem item = (MenuItem)e.widget;
                DNDExample.this.dropEventDetail = item.getSelection();
            }
        });
        this.dropConsole.setMenu(menu);
        if (this.dragEnabled) {
            this.createDragSource();
        }
        if (this.dropEnabled) {
            this.createDropTarget();
        }
        int height = 200;
        FormData data = new FormData();
        data.top = new FormAttachment(0, 10);
        data.left = new FormAttachment(0, 10);
        dragLabel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)dragLabel, 10);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(50, -10);
        data.height = height;
        dragWidgetGroup.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)dragWidgetGroup, 10);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(50, -10);
        data.bottom = new FormAttachment(100, -10);
        cLeft.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 10);
        data.left = new FormAttachment((Control)cLeft, 10);
        dropLabel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)dropLabel, 10);
        data.left = new FormAttachment((Control)cLeft, 10);
        data.right = new FormAttachment(100, -10);
        data.height = height;
        dropWidgetGroup.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)dropWidgetGroup, 10);
        data.left = new FormAttachment((Control)cLeft, 10);
        data.right = new FormAttachment(100, -10);
        data.bottom = new FormAttachment(100, -10);
        cRight.setLayoutData((Object)data);
        sc.setMinSize(parent.computeSize(-1, -1));
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        Point size = shell.computeSize(-1, -1);
        Rectangle monitorArea = shell.getMonitor().getClientArea();
        shell.setSize(Math.min(size.x, monitorArea.width - 20), Math.min(size.y, monitorArea.height - 20));
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        this.itemImage.dispose();
    }

    private void printEvent(DragSourceEvent e) {
        if (!this.dragEventDetail) {
            return;
        }
        this.dragConsole.append(String.valueOf(e.toString()) + "\n");
    }

    private void printEvent(DropTargetEvent e) {
        if (!this.dropEventDetail) {
            return;
        }
        this.dropConsole.append(String.valueOf(e.toString()) + "\n");
    }

    private void removeDragTransfer(Transfer transfer) {
        if (this.dragTypes.length == 1) {
            this.dragTypes = new Transfer[0];
        } else {
            int index = -1;
            int i = 0;
            while (i < this.dragTypes.length) {
                if (this.dragTypes[i] == transfer) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index == -1) {
                return;
            }
            Transfer[] newTypes = new Transfer[this.dragTypes.length - 1];
            System.arraycopy(this.dragTypes, 0, newTypes, 0, index);
            System.arraycopy(this.dragTypes, index + 1, newTypes, index, this.dragTypes.length - index - 1);
            this.dragTypes = newTypes;
        }
        if (this.dragSource != null) {
            this.dragSource.setTransfer(this.dragTypes);
        }
    }

    private void removeDropTransfer(Transfer transfer) {
        if (this.dropTypes.length == 1) {
            this.dropTypes = new Transfer[0];
        } else {
            int index = -1;
            int i = 0;
            while (i < this.dropTypes.length) {
                if (this.dropTypes[i] == transfer) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index == -1) {
                return;
            }
            Transfer[] newTypes = new Transfer[this.dropTypes.length - 1];
            System.arraycopy(this.dropTypes, 0, newTypes, 0, index);
            System.arraycopy(this.dropTypes, index + 1, newTypes, index, this.dropTypes.length - index - 1);
            this.dropTypes = newTypes;
        }
        if (this.dropTarget != null) {
            this.dropTarget.setTransfer(this.dropTypes);
        }
    }
}

