/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.examples.graphics.AnimatedGraphicsTab;
import org.eclipse.swt.examples.graphics.GraphicsExample;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;

public class FontBounceTab
extends AnimatedGraphicsTab {
    float x;
    float y;
    float incX = 10.0f;
    float incY = 5.0f;
    int textWidth;
    int textHeight;
    String text = GraphicsExample.getResourceString("SWT");
    int fontSize = 100;
    int fontFace = 0;
    int foreGrdColor;
    int fillColor;
    int fontStyle;

    public FontBounceTab(GraphicsExample example) {
        super(example);
    }

    public String getCategory() {
        return GraphicsExample.getResourceString("Font");
    }

    public String getText() {
        return GraphicsExample.getResourceString("Bounce");
    }

    public String getDescription() {
        return GraphicsExample.getResourceString("FontBounceDescription");
    }

    public void next(int width, int height) {
        this.x += this.incX;
        this.y += this.incY;
        float random = (float)Math.random();
        if (this.x + (float)this.textWidth > (float)width) {
            this.x = width - this.textWidth;
            this.incX = random * (float)(-width) / 16.0f - 1.0f;
            this.fontFace = 0;
            this.fontSize = 125;
            this.fillColor = 10;
            this.foreGrdColor = 7;
            this.fontStyle = 2;
        }
        if (this.x < 0.0f) {
            this.x = 0.0f;
            this.incX = random * (float)width / 16.0f + 1.0f;
            this.fontFace = 1;
            this.fontSize = 80;
            this.fillColor = 12;
            this.foreGrdColor = 13;
            this.fontStyle = 0;
        }
        if (this.y + (float)this.textHeight > (float)height) {
            this.y = height - this.textHeight - 2;
            this.incY = random * (float)(-height) / 16.0f - 1.0f;
            this.fontFace = 2;
            this.fontSize = 100;
            this.fillColor = 7;
            this.foreGrdColor = 2;
            this.fontStyle = 1;
        }
        if (this.y < 0.0f) {
            this.y = 0.0f;
            this.incY = random * (float)height / 16.0f + 1.0f;
            this.fontFace = 3;
            this.fontSize = 120;
            this.fillColor = 5;
            this.foreGrdColor = 15;
            this.fontStyle = 0;
        }
    }

    public void paint(GC gc, int width, int height) {
        if (!this.example.checkAdvancedGraphics()) {
            return;
        }
        Device device = gc.getDevice();
        Font font = new Font(device, FontBounceTab.getPlatformFontFace(this.fontFace), this.fontSize, this.fontStyle);
        gc.setFont(font);
        Point size = gc.stringExtent(this.text);
        this.textWidth = size.x;
        this.textHeight = size.y;
        Path path = new Path(device);
        path.addString(this.text, this.x, this.y, font);
        gc.setForeground(device.getSystemColor(this.foreGrdColor));
        gc.setBackground(device.getSystemColor(this.fillColor));
        gc.fillPath(path);
        gc.drawPath(path);
        font.dispose();
        path.dispose();
    }

    static String getPlatformFontFace(int index) {
        if (SWT.getPlatform() == "win32") {
            return (new String[]{"Arial", "Impact", "Times", "Verdana"})[index];
        }
        if (SWT.getPlatform() == "motif") {
            return (new String[]{"URW Chancery L", "URW Gothic L", "Times", "qub"})[index];
        }
        if (SWT.getPlatform() == "gtk") {
            return (new String[]{"URW Chancery L", "Baekmuk Batang", "Baekmuk Headline", "KacsTitleL"})[index];
        }
        if (SWT.getPlatform() == "carbon") {
            return (new String[]{"Arial", "Impact", "Times", "Verdana"})[index];
        }
        return (new String[]{"Arial", "Impact", "Times", "Verdana"})[index];
    }
}

