/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.graphics;

import java.util.ArrayList;
import org.eclipse.swt.examples.graphics.ColorListener;
import org.eclipse.swt.examples.graphics.ColorMenu;
import org.eclipse.swt.examples.graphics.GraphicsBackground;
import org.eclipse.swt.examples.graphics.GraphicsExample;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;

public class GradientDialog
extends Dialog {
    Canvas canvas;
    Button colorButton1;
    Button colorButton2;
    Button okButton;
    Button cancelButton;
    Menu menu1;
    Menu menu2;
    RGB rgb1 = null;
    RGB rgb2 = null;
    int returnVal = 256;
    ArrayList<Image> resources = new ArrayList();

    public GradientDialog(Shell parent) {
        this(parent, 32768);
    }

    public GradientDialog(Shell parent, int style) {
        super(parent, style);
    }

    public int open() {
        final Shell dialog = new Shell(this.getParent(), 0x870 | this.getStyle());
        dialog.setText(GraphicsExample.getResourceString("Gradient"));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 10;
        gridLayout.marginWidth = 10;
        dialog.setLayout((Layout)gridLayout);
        this.createDialogControls(dialog);
        dialog.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                int i = 0;
                while (i < GradientDialog.this.resources.size()) {
                    Image obj = GradientDialog.this.resources.get(i);
                    if (obj != null && obj instanceof Resource) {
                        ((Resource)obj).dispose();
                    }
                    ++i;
                }
                dialog.dispose();
            }
        });
        dialog.setDefaultButton(this.okButton);
        dialog.pack();
        Rectangle rect = this.getParent().getMonitor().getBounds();
        Rectangle bounds = dialog.getBounds();
        dialog.setLocation(rect.x + (rect.width - bounds.width) / 2, rect.y + (rect.height - bounds.height) / 2);
        dialog.setMinimumSize(bounds.width, bounds.height);
        dialog.open();
        Display display = this.getParent().getDisplay();
        while (!dialog.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (this.menu1 != null) {
            this.menu1.dispose();
            this.menu1 = null;
        }
        if (this.menu2 != null) {
            this.menu2.dispose();
            this.menu2 = null;
        }
        return this.returnVal;
    }

    public void createDialogControls(final Shell parent) {
        final Display display = parent.getDisplay();
        Label message = new Label((Composite)parent, 0);
        message.setText(GraphicsExample.getResourceString("GradientDlgMsg"));
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        message.setLayoutData((Object)gridData);
        if (this.rgb1 == null || this.rgb2 == null) {
            this.rgb1 = display.getSystemColor(1).getRGB();
            this.rgb2 = display.getSystemColor(2).getRGB();
        }
        this.canvas = new Canvas((Composite)parent, 0);
        gridData = new GridData(1808);
        gridData.widthHint = 200;
        gridData.heightHint = 100;
        this.canvas.setLayoutData((Object)gridData);
        this.canvas.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                Image preview = null;
                Point size = GradientDialog.this.canvas.getSize();
                Color color1 = new Color((Device)display, GradientDialog.this.rgb1);
                Color color2 = new Color((Device)display, GradientDialog.this.rgb2);
                preview = GraphicsExample.createImage((Device)display, color1, color2, size.x, size.y);
                if (preview != null) {
                    e.gc.drawImage(preview, 0, 0);
                }
                preview.dispose();
                color1.dispose();
                color2.dispose();
            }
        });
        Composite colorButtonComp = new Composite((Composite)parent, 0);
        RowLayout layout = new RowLayout();
        layout.type = 512;
        layout.pack = false;
        colorButtonComp.setLayout((Layout)layout);
        gridData = new GridData(2);
        colorButtonComp.setLayoutData((Object)gridData);
        ColorMenu colorMenu = new ColorMenu();
        this.colorButton1 = new Button(colorButtonComp, 8);
        this.colorButton1.setText(GraphicsExample.getResourceString("GradientDlgButton1"));
        Color color1 = new Color((Device)display, this.rgb1);
        Image img1 = GraphicsExample.createImage((Device)display, color1);
        color1.dispose();
        this.colorButton1.setImage(img1);
        this.resources.add(img1);
        this.menu1 = colorMenu.createMenu((Control)parent.getParent(), new ColorListener(){

            public void setColor(GraphicsBackground gb) {
                GradientDialog.this.rgb1 = gb.getBgColor1().getRGB();
                GradientDialog.this.colorButton1.setImage(gb.getThumbNail());
                if (GradientDialog.this.canvas != null) {
                    GradientDialog.this.canvas.redraw();
                }
            }
        });
        this.colorButton1.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Button button = (Button)event.widget;
                Composite parent = button.getParent();
                Rectangle bounds = button.getBounds();
                Point point = parent.toDisplay(new Point(bounds.x, bounds.y));
                GradientDialog.this.menu1.setLocation(point.x, point.y + bounds.height);
                GradientDialog.this.menu1.setVisible(true);
            }
        });
        this.colorButton2 = new Button(colorButtonComp, 8);
        this.colorButton2.setText(GraphicsExample.getResourceString("GradientDlgButton2"));
        Color color2 = new Color((Device)display, this.rgb2);
        Image img2 = GraphicsExample.createImage((Device)display, color2);
        color2.dispose();
        this.colorButton2.setImage(img2);
        this.resources.add(img2);
        this.menu2 = colorMenu.createMenu((Control)parent.getParent(), new ColorListener(){

            public void setColor(GraphicsBackground gb) {
                GradientDialog.this.rgb2 = gb.getBgColor1().getRGB();
                GradientDialog.this.colorButton2.setImage(gb.getThumbNail());
                if (GradientDialog.this.canvas != null) {
                    GradientDialog.this.canvas.redraw();
                }
            }
        });
        this.colorButton2.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Button button = (Button)event.widget;
                Composite parent = button.getParent();
                Rectangle bounds = button.getBounds();
                Point point = parent.toDisplay(new Point(bounds.x, bounds.y));
                GradientDialog.this.menu2.setLocation(point.x, point.y + bounds.height);
                GradientDialog.this.menu2.setVisible(true);
            }
        });
        Composite okCancelComp = new Composite((Composite)parent, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.pack = false;
        rowLayout.marginTop = 5;
        okCancelComp.setLayout((Layout)rowLayout);
        gridData = new GridData(128);
        gridData.horizontalSpan = 2;
        okCancelComp.setLayoutData((Object)gridData);
        this.okButton = new Button(okCancelComp, 8);
        this.okButton.setText("&OK");
        this.okButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GradientDialog.this.returnVal = 32;
                parent.close();
            }
        });
        this.cancelButton = new Button(okCancelComp, 8);
        this.cancelButton.setText("&Cancel");
        this.cancelButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                parent.close();
            }
        });
    }

    public RGB getFirstRGB() {
        return this.rgb1;
    }

    public void setFirstRGB(RGB rgb) {
        this.rgb1 = rgb;
    }

    public RGB getSecondRGB() {
        return this.rgb2;
    }

    public void setSecondRGB(RGB rgb) {
        this.rgb2 = rgb;
    }
}

