/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.graphics;

import org.eclipse.swt.examples.graphics.GraphicsExample;
import org.eclipse.swt.examples.graphics.GraphicsTab;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;

public class ImageTransformTab
extends GraphicsTab {
    private Spinner rotateSpinner;
    private Spinner translateSpinnerX;
    private Spinner translateSpinnerY;
    private Spinner scaleSpinnerX;
    private Spinner scaleSpinnerY;
    private Button invertButton;

    public ImageTransformTab(GraphicsExample example) {
        super(example);
    }

    public String getCategory() {
        return GraphicsExample.getResourceString("Transform");
    }

    public String getText() {
        return GraphicsExample.getResourceString("Image");
    }

    public String getDescription() {
        return GraphicsExample.getResourceString("TransformImgDescription");
    }

    public void createControlPanel(Composite parent) {
        GridLayout gridLayout = new GridLayout(2, false);
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)gridLayout);
        new Label(comp, 0x1000000).setText(GraphicsExample.getResourceString("Rotate"));
        this.rotateSpinner = new Spinner(comp, 2112);
        GC gc = new GC((Drawable)this.rotateSpinner);
        int width = gc.getFontMetrics().getAverageCharWidth() * 5;
        gc.dispose();
        this.rotateSpinner.setLayoutData((Object)new GridData(width, -1));
        this.rotateSpinner.setSelection(0);
        this.rotateSpinner.setMinimum(-720);
        this.rotateSpinner.setMaximum(720);
        this.rotateSpinner.setIncrement(30);
        this.rotateSpinner.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ImageTransformTab.this.example.redraw();
            }
        });
        comp = new Composite(parent, 0);
        comp.setLayout((Layout)gridLayout);
        new Label(comp, 0x1000000).setText(GraphicsExample.getResourceString("xtranslate"));
        this.translateSpinnerX = new Spinner(comp, 2112);
        this.translateSpinnerX.setLayoutData((Object)new GridData(width, -1));
        this.translateSpinnerX.setMinimum(-100);
        this.translateSpinnerX.setMaximum(500);
        this.translateSpinnerX.setSelection(0);
        this.translateSpinnerX.setIncrement(10);
        this.translateSpinnerX.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ImageTransformTab.this.example.redraw();
            }
        });
        comp = new Composite(parent, 0);
        comp.setLayout((Layout)gridLayout);
        new Label(comp, 0x1000000).setText(GraphicsExample.getResourceString("ytranslate"));
        this.translateSpinnerY = new Spinner(comp, 2112);
        this.translateSpinnerY.setLayoutData((Object)new GridData(width, -1));
        this.translateSpinnerY.setMinimum(-100);
        this.translateSpinnerY.setMaximum(500);
        this.translateSpinnerY.setSelection(0);
        this.translateSpinnerY.setIncrement(10);
        this.translateSpinnerY.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ImageTransformTab.this.example.redraw();
            }
        });
        comp = new Composite(parent, 0);
        comp.setLayout((Layout)gridLayout);
        new Label(comp, 0x1000000).setText(GraphicsExample.getResourceString("xscale"));
        this.scaleSpinnerX = new Spinner(comp, 2112);
        this.scaleSpinnerX.setLayoutData((Object)new GridData(width, -1));
        this.scaleSpinnerX.setDigits(2);
        this.scaleSpinnerX.setMinimum(1);
        this.scaleSpinnerX.setMaximum(400);
        this.scaleSpinnerX.setSelection(100);
        this.scaleSpinnerX.setIncrement(10);
        this.scaleSpinnerX.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ImageTransformTab.this.example.redraw();
            }
        });
        comp = new Composite(parent, 0);
        comp.setLayout((Layout)gridLayout);
        new Label(comp, 0x1000000).setText(GraphicsExample.getResourceString("yscale"));
        this.scaleSpinnerY = new Spinner(comp, 2112);
        this.scaleSpinnerY.setLayoutData((Object)new GridData(width, -1));
        this.scaleSpinnerY.setDigits(2);
        this.scaleSpinnerY.setMinimum(1);
        this.scaleSpinnerY.setMaximum(400);
        this.scaleSpinnerY.setSelection(100);
        this.scaleSpinnerY.setIncrement(10);
        this.scaleSpinnerY.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ImageTransformTab.this.example.redraw();
            }
        });
        comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        this.invertButton = new Button(comp, 2);
        this.invertButton.setText(GraphicsExample.getResourceString("Invert"));
        this.invertButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ImageTransformTab.this.example.redraw();
            }
        });
    }

    public void paint(GC gc, int width, int height) {
        if (!this.example.checkAdvancedGraphics()) {
            return;
        }
        Device device = gc.getDevice();
        Image image = GraphicsExample.loadImage(device, GraphicsExample.class, "ace_club.jpg");
        Transform transform = new Transform(device);
        transform.scale((float)this.scaleSpinnerX.getSelection() / 100.0f, (float)this.scaleSpinnerY.getSelection() / 100.0f);
        transform.translate((float)this.translateSpinnerX.getSelection(), (float)this.translateSpinnerY.getSelection());
        Rectangle rect = image.getBounds();
        transform.translate((float)(rect.width / 2), (float)(rect.height / 2));
        transform.rotate((float)this.rotateSpinner.getSelection());
        transform.translate((float)(-rect.width / 2), (float)(-rect.height / 2));
        if (this.invertButton.getSelection()) {
            transform.invert();
        }
        gc.setTransform(transform);
        gc.drawImage(image, 0, 0);
        transform.dispose();
        image.dispose();
    }
}

