/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.graphics;

import org.eclipse.swt.examples.graphics.ColorListener;
import org.eclipse.swt.examples.graphics.ColorMenu;
import org.eclipse.swt.examples.graphics.GraphicsBackground;
import org.eclipse.swt.examples.graphics.GraphicsExample;
import org.eclipse.swt.examples.graphics.GraphicsTab;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;

public class LineJoinTab
extends GraphicsTab {
    private Combo joinCb;
    private Button colorButton;
    private GraphicsBackground shapeColor;
    private Menu menu;
    private int[] joinValues = new int[]{3, 1, 2};

    public LineJoinTab(GraphicsExample example) {
        super(example);
    }

    public String getCategory() {
        return GraphicsExample.getResourceString("Lines");
    }

    public String getText() {
        return GraphicsExample.getResourceString("LineJoin");
    }

    public String getDescription() {
        return GraphicsExample.getResourceString("LineJoinDescription");
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
    }

    public void createControlPanel(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        new Label(comp, 0x1000000).setText(GraphicsExample.getResourceString("LineJoin"));
        this.joinCb = new Combo(comp, 4);
        this.joinCb.add(GraphicsExample.getResourceString("bevel"));
        this.joinCb.add(GraphicsExample.getResourceString("miter"));
        this.joinCb.add(GraphicsExample.getResourceString("round"));
        this.joinCb.select(1);
        this.joinCb.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                LineJoinTab.this.example.redraw();
            }
        });
        ColorMenu cm = new ColorMenu();
        cm.setPatternItems(this.example.checkAdvancedGraphics());
        this.menu = cm.createMenu((Control)parent.getParent(), new ColorListener(){

            public void setColor(GraphicsBackground gb) {
                LineJoinTab.this.shapeColor = gb;
                LineJoinTab.this.colorButton.setImage(gb.getThumbNail());
                LineJoinTab.this.example.redraw();
            }
        });
        this.shapeColor = (GraphicsBackground)this.menu.getItem(3).getData();
        comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        this.colorButton = new Button(comp, 8);
        this.colorButton.setText(GraphicsExample.getResourceString("Color"));
        this.colorButton.setImage(this.shapeColor.getThumbNail());
        this.colorButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Button button = (Button)event.widget;
                Composite parent = button.getParent();
                Rectangle bounds = button.getBounds();
                Point point = parent.toDisplay(new Point(bounds.x, bounds.y));
                LineJoinTab.this.menu.setLocation(point.x, point.y + bounds.height);
                LineJoinTab.this.menu.setVisible(true);
            }
        });
    }

    public void paint(GC gc, int width, int height) {
        if (!this.example.checkAdvancedGraphics()) {
            return;
        }
        Device device = gc.getDevice();
        gc.setLineWidth(20);
        gc.setLineJoin(this.joinValues[this.joinCb.getSelectionIndex()]);
        Pattern pattern = null;
        if (this.shapeColor.getBgColor1() != null) {
            gc.setForeground(this.shapeColor.getBgColor1());
        } else if (this.shapeColor.getBgImage() != null) {
            pattern = new Pattern(device, this.shapeColor.getBgImage());
            gc.setForegroundPattern(pattern);
        }
        Path path = new Path(device);
        path.moveTo((float)(width / 2), 25.0f);
        path.lineTo((float)(2 * width / 3), (float)(height / 3));
        path.lineTo((float)(width - 25), (float)(height / 2));
        path.lineTo((float)(2 * width / 3), (float)(2 * height / 3));
        path.lineTo((float)(width / 2), (float)(height - 25));
        path.lineTo((float)(width / 3), (float)(2 * height / 3));
        path.lineTo(25.0f, (float)(height / 2));
        path.lineTo((float)(width / 3), (float)(height / 3));
        path.lineTo((float)(width / 2), 25.0f);
        path.close();
        gc.drawPath(path);
        path.dispose();
        if (pattern != null) {
            pattern.dispose();
        }
    }
}

