/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.examples.graphics.ColorListener;
import org.eclipse.swt.examples.graphics.ColorMenu;
import org.eclipse.swt.examples.graphics.GraphicsBackground;
import org.eclipse.swt.examples.graphics.GraphicsExample;
import org.eclipse.swt.examples.graphics.GraphicsTab;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Spinner;

public class LineStyleTab
extends GraphicsTab {
    Button colorButton;
    GraphicsBackground lineColor;
    Menu menu;
    Spinner lineWidthSpinner;

    public LineStyleTab(GraphicsExample example) {
        super(example);
    }

    public String getCategory() {
        return GraphicsExample.getResourceString("Lines");
    }

    public String getText() {
        return GraphicsExample.getResourceString("LineStyles");
    }

    public String getDescription() {
        return GraphicsExample.getResourceString("LineStylesDescription");
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
    }

    public void createControlPanel(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        new Label(comp, 0x1000000).setText(GraphicsExample.getResourceString("LineWidth"));
        this.lineWidthSpinner = new Spinner(comp, 2112);
        this.lineWidthSpinner.setSelection(10);
        this.lineWidthSpinner.setMinimum(1);
        this.lineWidthSpinner.setMaximum(30);
        this.lineWidthSpinner.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                LineStyleTab.this.example.redraw();
            }
        });
        ColorMenu cm = new ColorMenu();
        cm.setPatternItems(this.example.checkAdvancedGraphics());
        this.menu = cm.createMenu((Control)parent.getParent(), new ColorListener(){

            public void setColor(GraphicsBackground gb) {
                LineStyleTab.this.lineColor = gb;
                LineStyleTab.this.colorButton.setImage(gb.getThumbNail());
                LineStyleTab.this.example.redraw();
            }
        });
        comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        this.lineColor = (GraphicsBackground)this.menu.getItem(4).getData();
        this.colorButton = new Button(comp, 8);
        this.colorButton.setText(GraphicsExample.getResourceString("Color"));
        this.colorButton.setImage(this.lineColor.getThumbNail());
        this.colorButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Button button = (Button)event.widget;
                Composite parent = button.getParent();
                Rectangle bounds = button.getBounds();
                Point point = parent.toDisplay(new Point(bounds.x, bounds.y));
                LineStyleTab.this.menu.setLocation(point.x, point.y + bounds.height);
                LineStyleTab.this.menu.setVisible(true);
            }
        });
    }

    public void paint(GC gc, int width, int height) {
        Device device = gc.getDevice();
        Pattern pattern = null;
        if (this.lineColor.getBgColor1() != null) {
            gc.setForeground(this.lineColor.getBgColor1());
        } else if (this.lineColor.getBgImage() != null) {
            pattern = new Pattern(device, this.lineColor.getBgImage());
            gc.setForegroundPattern(pattern);
        }
        gc.setLineWidth(this.lineWidthSpinner.getSelection());
        gc.drawLine(3 * width / 16, 1 * height / 6, 13 * width / 16, 1 * height / 6);
        gc.setLineStyle(2);
        gc.drawLine(3 * width / 16, 2 * height / 6, 13 * width / 16, 2 * height / 6);
        gc.setLineStyle(3);
        gc.drawLine(3 * width / 16, 3 * height / 6, 13 * width / 16, 3 * height / 6);
        gc.setLineStyle(4);
        gc.drawLine(3 * width / 16, 4 * height / 6, 13 * width / 16, 4 * height / 6);
        gc.setLineStyle(5);
        gc.drawLine(3 * width / 16, 5 * height / 6, 13 * width / 16, 5 * height / 6);
        Font font = new Font(device, LineStyleTab.getPlatformFont(), 20, 0);
        gc.setFont(font);
        gc.setForeground(device.getSystemColor(2));
        String text = GraphicsExample.getResourceString("Solid");
        Point size = gc.stringExtent(text);
        gc.drawString(text, (width - size.x) / 2, 1 * height / 12, true);
        text = GraphicsExample.getResourceString("Dash");
        size = gc.stringExtent(text);
        gc.drawString(text, (width - size.x) / 2, 3 * height / 12, true);
        text = GraphicsExample.getResourceString("Dot");
        size = gc.stringExtent(text);
        gc.drawString(text, (width - size.x) / 2, 5 * height / 12, true);
        text = GraphicsExample.getResourceString("DashDot");
        size = gc.stringExtent(text);
        gc.drawString(text, (width - size.x) / 2, 7 * height / 12, true);
        text = GraphicsExample.getResourceString("DashDotDot");
        size = gc.stringExtent(text);
        gc.drawString(text, (width - size.x) / 2, 9 * height / 12, true);
        font.dispose();
    }

    static String getPlatformFont() {
        if (SWT.getPlatform() == "win32") {
            return "Arial";
        }
        if (SWT.getPlatform() == "motif") {
            return "Helvetica";
        }
        if (SWT.getPlatform() == "gtk") {
            return "Baekmuk Batang";
        }
        if (SWT.getPlatform() == "carbon") {
            return "Arial";
        }
        return "Verdana";
    }
}

