/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.graphics;

import org.eclipse.swt.examples.graphics.ColorListener;
import org.eclipse.swt.examples.graphics.ColorMenu;
import org.eclipse.swt.examples.graphics.GraphicsBackground;
import org.eclipse.swt.examples.graphics.GraphicsExample;
import org.eclipse.swt.examples.graphics.GraphicsTab;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;

public class PathTab
extends GraphicsTab {
    Button colorButton;
    Button fillButton;
    Button drawButton;
    Button closeButton;
    GraphicsBackground fillColor;
    Menu menu;

    public PathTab(GraphicsExample example) {
        super(example);
    }

    public String getCategory() {
        return GraphicsExample.getResourceString("Path");
    }

    public String getText() {
        return GraphicsExample.getResourceString("PathOper");
    }

    public String getDescription() {
        return GraphicsExample.getResourceString("PathOperDescription");
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
    }

    public void createControlPanel(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        this.drawButton = new Button(comp, 2);
        this.drawButton.setText(GraphicsExample.getResourceString("DrawPath"));
        this.drawButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PathTab.this.example.redraw();
            }
        });
        this.drawButton.setSelection(true);
        comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        this.fillButton = new Button(comp, 2);
        this.fillButton.setText(GraphicsExample.getResourceString("FillPath"));
        this.fillButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PathTab.this.example.redraw();
            }
        });
        comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        this.closeButton = new Button(comp, 2);
        this.closeButton.setText(GraphicsExample.getResourceString("ClosePath"));
        this.closeButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PathTab.this.example.redraw();
            }
        });
        comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        ColorMenu cm = new ColorMenu();
        cm.setPatternItems(this.example.checkAdvancedGraphics());
        this.menu = cm.createMenu((Control)parent.getParent(), new ColorListener(){

            public void setColor(GraphicsBackground gb) {
                PathTab.this.fillColor = gb;
                PathTab.this.colorButton.setImage(gb.getThumbNail());
                PathTab.this.example.redraw();
            }
        });
        this.fillColor = (GraphicsBackground)this.menu.getItem(3).getData();
        this.colorButton = new Button(comp, 8);
        this.colorButton.setText(GraphicsExample.getResourceString("FillColor"));
        this.colorButton.setImage(this.fillColor.getThumbNail());
        this.colorButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Button button = (Button)event.widget;
                Composite parent = button.getParent();
                Rectangle bounds = button.getBounds();
                Point point = parent.toDisplay(new Point(bounds.x, bounds.y));
                PathTab.this.menu.setLocation(point.x, point.y + bounds.height);
                PathTab.this.menu.setVisible(true);
            }
        });
    }

    public void paint(GC gc, int width, int height) {
        if (!this.example.checkAdvancedGraphics()) {
            return;
        }
        Device device = gc.getDevice();
        Pattern pattern = null;
        if (this.fillColor.getBgColor1() != null) {
            gc.setBackground(this.fillColor.getBgColor1());
        } else if (this.fillColor.getBgImage() != null) {
            pattern = new Pattern(device, this.fillColor.getBgImage());
            gc.setBackgroundPattern(pattern);
        }
        gc.setLineWidth(5);
        gc.setForeground(device.getSystemColor(2));
        Path path = new Path(device);
        path.addArc((float)((width - 250) / 2), (float)((height - 400) / 2), 500.0f, 400.0f, 90.0f, 180.0f);
        if (this.closeButton.getSelection()) {
            path.close();
        }
        if (this.fillButton.getSelection()) {
            gc.fillPath(path);
        }
        if (this.drawButton.getSelection()) {
            gc.drawPath(path);
        }
        path.dispose();
        Transform transform = new Transform(device);
        transform.translate((float)((width - 250) / 4), (float)(height / 2 - 150));
        gc.setTransform(transform);
        transform.dispose();
        path = new Path(device);
        path.cubicTo(-150.0f, 100.0f, 150.0f, 200.0f, 0.0f, 300.0f);
        if (this.closeButton.getSelection()) {
            path.close();
        }
        if (this.fillButton.getSelection()) {
            gc.fillPath(path);
        }
        if (this.drawButton.getSelection()) {
            gc.drawPath(path);
        }
        path.dispose();
        gc.setTransform(null);
        path = new Path(device);
        path.moveTo((float)(3 * (width - 250) / 4 - 25 + 250), (float)(height / 2));
        path.lineTo((float)(3 * (width - 250) / 4 + 50 + 250), (float)(height / 2 - 200));
        path.lineTo((float)(3 * (width - 250) / 4 + 50 + 250), (float)(height / 2 + 50));
        path.lineTo((float)(3 * (width - 250) / 4 - 25 + 250), (float)(height / 2 + 150));
        path.lineTo((float)(3 * (width - 250) / 4 + 25 + 250), (float)(height / 2 + 50));
        if (this.closeButton.getSelection()) {
            path.close();
        }
        if (this.fillButton.getSelection()) {
            gc.fillPath(path);
        }
        if (this.drawButton.getSelection()) {
            gc.drawPath(path);
        }
        path.dispose();
        if (pattern != null) {
            pattern.dispose();
        }
    }
}

