/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.graphics;

import org.eclipse.swt.examples.graphics.AnimatedGraphicsTab;
import org.eclipse.swt.examples.graphics.GraphicsExample;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;

public class RGBTab
extends AnimatedGraphicsTab {
    int translateX = 0;
    int translateY = 0;
    float diagTranslateX1 = 0.0f;
    float diagTranslateX2 = 0.0f;
    float diagTranslateY1 = 0.0f;
    float diagTranslateY2 = 0.0f;

    public RGBTab(GraphicsExample example) {
        super(example);
    }

    public String getCategory() {
        return GraphicsExample.getResourceString("Misc");
    }

    public String getText() {
        return GraphicsExample.getResourceString("rgb");
    }

    public String getDescription() {
        return GraphicsExample.getResourceString("rgbDescription");
    }

    public void next(int width, int height) {
        float h = height;
        float w = width;
        this.translateX = (this.translateX + 3) % width;
        this.translateY = (this.translateY + 5) % height;
        this.diagTranslateX1 = (this.diagTranslateX1 + 6.0f) % (float)width;
        this.diagTranslateY1 = this.diagTranslateX1 * (h / w);
        this.diagTranslateX2 = (this.diagTranslateX2 + 8.0f) % (float)width;
        this.diagTranslateY2 = -this.diagTranslateX2 * (h / w) + h;
    }

    public void paint(GC gc, int width, int height) {
        if (!this.example.checkAdvancedGraphics()) {
            return;
        }
        Device device = gc.getDevice();
        Transform transform = new Transform(device);
        transform.translate(0.0f, (float)this.translateY);
        gc.setTransform(transform);
        transform.dispose();
        Path path = new Path(device);
        path.addRectangle(0.0f, 0.0f, (float)width, 50.0f);
        Pattern pattern = new Pattern(device, 0.0f, 0.0f, (float)width, 50.0f, device.getSystemColor(9), 127, device.getSystemColor(3), 127);
        gc.setBackgroundPattern(pattern);
        gc.fillPath(path);
        gc.drawPath(path);
        path.dispose();
        transform = new Transform(device);
        transform.translate((float)this.translateX, 0.0f);
        gc.setTransform(transform);
        transform.dispose();
        path = new Path(device);
        path.addRectangle(0.0f, 0.0f, 50.0f, (float)height);
        pattern.dispose();
        pattern = new Pattern(device, 0.0f, 0.0f, 50.0f, (float)height, device.getSystemColor(14), 127, device.getSystemColor(1), 127);
        gc.setBackgroundPattern(pattern);
        gc.fillPath(path);
        gc.drawPath(path);
        path.dispose();
        Rectangle rect = new Rectangle(0, 0, 50, height);
        transform = new Transform(device);
        transform.translate((float)width - this.diagTranslateX1, (float)(height / 2) - this.diagTranslateY1);
        transform.translate((float)(rect.width / 2), (float)(rect.height / 2));
        transform.rotate(45.0f);
        transform.translate((float)(-rect.width / 2), (float)(-rect.height / 2));
        gc.setTransform(transform);
        transform.dispose();
        path = new Path(device);
        path.addRectangle((float)rect.x, (float)rect.y, (float)rect.width, (float)rect.height);
        pattern.dispose();
        pattern = new Pattern(device, (float)rect.x, (float)rect.y, (float)rect.width, (float)rect.height, device.getSystemColor(6), 127, device.getSystemColor(12), 127);
        gc.setBackgroundPattern(pattern);
        gc.fillPath(path);
        gc.drawPath(path);
        path.dispose();
        transform = new Transform(device);
        transform.translate((float)width - this.diagTranslateX2, (float)(height / 2) - this.diagTranslateY2);
        transform.translate((float)(rect.width / 2), (float)(rect.height / 2));
        transform.rotate(-45.0f);
        transform.translate((float)(-rect.width / 2), (float)(-rect.height / 2));
        gc.setTransform(transform);
        transform.dispose();
        path = new Path(device);
        path.addRectangle((float)rect.x, (float)rect.y, (float)rect.width, (float)rect.height);
        pattern.dispose();
        pattern = new Pattern(device, (float)rect.x, (float)rect.y, (float)rect.width, (float)rect.height, device.getSystemColor(4), 127, device.getSystemColor(7), 127);
        gc.setBackgroundPattern(pattern);
        gc.fillPath(path);
        gc.drawPath(path);
        pattern.dispose();
        path.dispose();
    }
}

