/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.graphics;

import org.eclipse.swt.examples.graphics.AnimatedGraphicsTab;
import org.eclipse.swt.examples.graphics.GraphicsExample;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Transform;

public class ShapesTab
extends AnimatedGraphicsTab {
    int upDownValue = 0;
    int inc = 1;

    public ShapesTab(GraphicsExample example) {
        super(example);
    }

    public String getCategory() {
        return GraphicsExample.getResourceString("Lines");
    }

    public String getText() {
        return GraphicsExample.getResourceString("Shapes");
    }

    public String getDescription() {
        return GraphicsExample.getResourceString("ShapesDescription");
    }

    public void next(int width, int height) {
        this.upDownValue += this.inc;
        if (this.upDownValue > 5) {
            this.inc = -1;
        }
        if (this.upDownValue < -5) {
            this.inc = 1;
        }
    }

    public void paint(GC gc, int width, int height) {
        if (!this.example.checkAdvancedGraphics()) {
            return;
        }
        Device device = gc.getDevice();
        int size = 100;
        gc.setLineWidth(2);
        Transform transform = new Transform(device);
        transform.translate((float)(width / 4 - size), (float)(height / 4 + -this.upDownValue));
        gc.setTransform(transform);
        gc.setLineStyle(3);
        gc.setBackground(device.getSystemColor(3));
        int[] nArray = new int[8];
        nArray[2] = size / 3;
        nArray[3] = -size / 2;
        nArray[4] = size / 3;
        nArray[5] = size / 2;
        nArray[7] = size;
        gc.fillPolygon(nArray);
        gc.setLineStyle(1);
        gc.drawRectangle(0, 0, size, size);
        gc.drawLine(0, 0, size / 3, -size / 2);
        gc.drawLine(size, 0, 4 * size / 3, -size / 2);
        gc.drawLine(size, size, 4 * size / 3, size / 2);
        gc.drawLine(size / 3, -size / 2, 4 * size / 3, -size / 2);
        gc.drawLine(4 * size / 3, size / 2, 4 * size / 3, -size / 2);
        gc.setLineStyle(3);
        gc.drawLine(0, size, size / 3, size / 2);
        gc.drawLine(size / 3, -size / 2, size / 3, size / 2);
        gc.drawLine(4 * size / 3, size / 2, size / 3, size / 2);
        gc.setBackground(device.getSystemColor(15));
        int[] nArray2 = new int[8];
        nArray2[0] = size;
        nArray2[2] = 4 * size / 3;
        nArray2[3] = -size / 2;
        nArray2[4] = 4 * size / 3;
        nArray2[5] = size / 2;
        nArray2[6] = size;
        nArray2[7] = size;
        gc.fillPolygon(nArray2);
        transform.dispose();
        transform = new Transform(device);
        transform.translate((float)(width / 2 + size / 2), (float)(height / 4 + size + this.upDownValue));
        gc.setTransform(transform);
        gc.fillPolygon(new int[]{size / 3, -size / 2, 6 * size / 10, -5 * size / 4, 4 * size / 3, -size / 2});
        gc.setBackground(device.getSystemColor(5));
        int[] nArray3 = new int[6];
        nArray3[2] = 6 * size / 10;
        nArray3[3] = -5 * size / 4;
        nArray3[4] = size / 3;
        nArray3[5] = -size / 2;
        gc.fillPolygon(nArray3);
        gc.setLineStyle(1);
        gc.drawLine(0, 0, size, 0);
        gc.drawLine(size, 0, 4 * size / 3, -size / 2);
        gc.drawLine(0, 0, 6 * size / 10, -5 * size / 4);
        gc.drawLine(size, 0, 6 * size / 10, -5 * size / 4);
        gc.drawLine(4 * size / 3, -size / 2, 6 * size / 10, -5 * size / 4);
        gc.setLineStyle(3);
        gc.drawLine(0, 0, size / 3, -size / 2);
        gc.drawLine(size / 3, -size / 2, 6 * size / 10, -5 * size / 4);
        gc.drawLine(4 * size / 3, -size / 2, size / 3, -size / 2);
        transform.dispose();
        transform = new Transform(device);
        transform.translate((float)(width / 2 + this.upDownValue), (float)(height / 2 + size));
        gc.setTransform(transform);
        gc.setBackground(device.getSystemColor(9));
        int[] nArray4 = new int[8];
        nArray4[1] = size;
        nArray4[2] = size / 3;
        nArray4[3] = size / 2;
        nArray4[4] = 7 * size / 3;
        nArray4[5] = size / 2;
        nArray4[6] = 2 * size;
        nArray4[7] = size;
        gc.fillPolygon(nArray4);
        gc.setLineStyle(1);
        gc.drawRectangle(0, 0, 2 * size, size);
        gc.drawLine(0, 0, size / 3, -size / 2);
        gc.drawLine(2 * size, 0, 7 * size / 3, -size / 2);
        gc.drawLine(2 * size, size, 7 * size / 3, size / 2);
        gc.drawLine(size / 3, -size / 2, 7 * size / 3, -size / 2);
        gc.drawLine(7 * size / 3, size / 2, 7 * size / 3, -size / 2);
        gc.setLineStyle(5);
        gc.drawLine(0, size, size / 3, size / 2);
        gc.drawLine(size / 3, -size / 2, size / 3, size / 2);
        gc.drawLine(7 * size / 3, size / 2, size / 3, size / 2);
        gc.setBackground(device.getSystemColor(15));
        int[] nArray5 = new int[8];
        nArray5[2] = size / 3;
        nArray5[3] = -size / 2;
        nArray5[4] = 7 * size / 3;
        nArray5[5] = -size / 2;
        nArray5[6] = 2 * size;
        gc.fillPolygon(nArray5);
        transform.dispose();
        transform = new Transform(device);
        transform.translate((float)(width / 4 - size - this.upDownValue), (float)(height / 2 + size + this.upDownValue));
        gc.setTransform(transform);
        gc.setBackground(device.getSystemColor(7));
        int[] nArray6 = new int[6];
        nArray6[2] = size / 2;
        nArray6[3] = -size;
        nArray6[4] = size / 2;
        nArray6[5] = -size / 3;
        gc.fillPolygon(nArray6);
        int[] nArray7 = new int[6];
        nArray7[0] = size;
        nArray7[2] = size / 2;
        nArray7[3] = size;
        nArray7[4] = size / 2;
        nArray7[5] = -size / 3;
        gc.fillPolygon(nArray7);
        gc.setLineStyle(1);
        gc.drawLine(0, 0, size / 2, size);
        gc.drawLine(size, 0, size / 2, size);
        gc.drawLine(0, 0, size / 2, -size);
        gc.drawLine(size, 0, size / 2, -size);
        gc.drawLine(0, 0, size / 2, -size / 3);
        gc.drawLine(size, 0, size / 2, -size / 3);
        gc.drawLine(size / 2, -size / 3, size / 2, size);
        gc.drawLine(size / 2, -size / 3, size / 2, -size);
        transform.dispose();
    }
}

