/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.graphics;

import org.eclipse.swt.examples.graphics.AnimatedGraphicsTab;
import org.eclipse.swt.examples.graphics.ColorListener;
import org.eclipse.swt.examples.graphics.ColorMenu;
import org.eclipse.swt.examples.graphics.GraphicsBackground;
import org.eclipse.swt.examples.graphics.GraphicsExample;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Spinner;

public class SpiralTab
extends AnimatedGraphicsTab {
    int angle = -90;
    Spinner petalSpinner;
    Button colorButton;
    GraphicsBackground foreground;
    Menu menu;

    public SpiralTab(GraphicsExample example) {
        super(example);
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
    }

    public void createControlPanel(Composite parent) {
        super.createControlPanel(parent);
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        new Label(comp, 0x1000000).setText(GraphicsExample.getResourceString("Petals"));
        this.petalSpinner = new Spinner(comp, 2112);
        this.petalSpinner.setSelection(8);
        this.petalSpinner.setMinimum(3);
        this.petalSpinner.setMaximum(20);
        this.petalSpinner.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SpiralTab.this.example.redraw();
            }
        });
        comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        ColorMenu cm = new ColorMenu();
        cm.setPatternItems(this.example.checkAdvancedGraphics());
        this.menu = cm.createMenu((Control)parent.getParent(), new ColorListener(){

            public void setColor(GraphicsBackground gb) {
                SpiralTab.this.foreground = gb;
                SpiralTab.this.colorButton.setImage(gb.getThumbNail());
                SpiralTab.this.example.redraw();
            }
        });
        this.foreground = (GraphicsBackground)this.menu.getItem(1).getData();
        this.colorButton = new Button(comp, 8);
        this.colorButton.setText(GraphicsExample.getResourceString("Color"));
        this.colorButton.setImage(this.foreground.getThumbNail());
        this.colorButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Button button = (Button)event.widget;
                Composite parent = button.getParent();
                Rectangle bounds = button.getBounds();
                Point point = parent.toDisplay(new Point(bounds.x, bounds.y));
                SpiralTab.this.menu.setLocation(point.x, point.y + bounds.height);
                SpiralTab.this.menu.setVisible(true);
            }
        });
    }

    public String getCategory() {
        return GraphicsExample.getResourceString("Misc");
    }

    public String getText() {
        return GraphicsExample.getResourceString("Spiral");
    }

    public String getDescription() {
        return GraphicsExample.getResourceString("SpiralDescription");
    }

    public int getInitialAnimationTime() {
        return 150;
    }

    public void next(int width, int height) {
        if (this.angle == 270) {
            this.angle = -90;
        }
        this.angle += 10;
    }

    public void paint(GC gc, int width, int height) {
        if (!this.example.checkAdvancedGraphics()) {
            return;
        }
        Device device = gc.getDevice();
        gc.setLineWidth(20);
        gc.setLineCap(2);
        gc.setAntialias(1);
        Pattern pattern = null;
        if (this.foreground.getBgColor1() != null) {
            gc.setForeground(this.foreground.getBgColor1());
        } else if (this.foreground.getBgImage() != null) {
            pattern = new Pattern(device, this.foreground.getBgImage());
            gc.setForegroundPattern(pattern);
        }
        int n = this.petalSpinner.getSelection();
        int i = 0;
        while (i < n) {
            Transform transform = new Transform(device);
            transform.translate((float)(width / 2), (float)(height / 2));
            transform.rotate((float)(-(this.angle + 360 / n * i)));
            gc.setTransform(transform);
            gc.drawArc(0, 0, width / 3, height / 6, 0, 180);
            transform.dispose();
            ++i;
        }
        if (pattern != null) {
            pattern.dispose();
        }
    }
}

