/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.imageanalyzer;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.ImageLoaderEvent;
import org.eclipse.swt.graphics.ImageLoaderListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ImageAnalyzer {
    static ResourceBundle bundle = ResourceBundle.getBundle("examples_images");
    Display display;
    Shell shell;
    Canvas imageCanvas;
    Canvas paletteCanvas;
    Label typeLabel;
    Label sizeLabel;
    Label depthLabel;
    Label transparentPixelLabel;
    Label timeToLoadLabel;
    Label screenSizeLabel;
    Label backgroundPixelLabel;
    Label locationLabel;
    Label disposalMethodLabel;
    Label delayTimeLabel;
    Label repeatCountLabel;
    Label compressionRatioLabel;
    Label paletteLabel;
    Label dataLabel;
    Label statusLabel;
    Combo backgroundCombo;
    Combo imageTypeCombo;
    Combo compressionCombo;
    Combo scaleXCombo;
    Combo scaleYCombo;
    Combo alphaCombo;
    Button incrementalCheck;
    Button transparentCheck;
    Button maskCheck;
    Button backgroundCheck;
    Button previousButton;
    Button nextButton;
    Button animateButton;
    StyledText dataText;
    Sash sash;
    Color whiteColor;
    Color blackColor;
    Color redColor;
    Color greenColor;
    Color blueColor;
    Color canvasBackground;
    Font fixedWidthFont;
    Cursor crossCursor;
    GC imageCanvasGC;
    PrinterData printerData;
    int paletteWidth = 140;
    int ix = 0;
    int iy = 0;
    int py = 0;
    int compression;
    float xscale = 1.0f;
    float yscale = 1.0f;
    int alpha = 255;
    boolean incremental = false;
    boolean transparent = true;
    boolean showMask = false;
    boolean showBackground = false;
    boolean animate = false;
    Thread animateThread;
    Thread incrementalThread;
    String lastPath;
    String currentName;
    String fileName;
    ImageLoader loader;
    ImageData[] imageDataArray;
    int imageDataIndex;
    ImageData imageData;
    Image image;
    Vector<ImageLoaderEvent> incrementalEvents;
    long loadTime = 0L;
    static final int INDEX_DIGITS = 4;
    static final int ALPHA_CHARS = 5;
    static final int ALPHA_CONSTANT = 0;
    static final int ALPHA_X = 1;
    static final int ALPHA_Y = 2;
    static final String[] OPEN_FILTER_EXTENSIONS = new String[]{"*.bmp;*.gif;*.ico;*.jfif;*.jpeg;*.jpg;*.png;*.tif;*.tiff", "*.bmp", "*.gif", "*.ico", "*.jpg;*.jpeg;*.jfif", "*.png", "*.tif;*.tiff"};
    static final String[] OPEN_FILTER_NAMES = new String[]{String.valueOf(bundle.getString("All_images")) + " (bmp, gif, ico, jfif, jpeg, jpg, png, tif, tiff)", "BMP (*.bmp)", "GIF (*.gif)", "ICO (*.ico)", "JPEG (*.jpg, *.jpeg, *.jfif)", "PNG (*.png)", "TIFF (*.tif, *.tiff)"};
    static final String[] SAVE_FILTER_EXTENSIONS = new String[]{"*.bmp", "*.bmp", "*.gif", "*.ico", "*.jpg", "*.png", "*.tif", "*.bmp"};
    static final String[] SAVE_FILTER_NAMES = new String[]{"Uncompressed BMP (*.bmp)", "RLE Compressed BMP (*.bmp)", "GIF (*.gif)", "ICO (*.ico)", "JPEG (*.jpg)", "PNG (*.png)", "TIFF (*.tif)", "OS/2 BMP (*.bmp)"};

    public static void main(String[] args) {
        Display display = new Display();
        ImageAnalyzer imageAnalyzer = new ImageAnalyzer();
        Shell shell = imageAnalyzer.open(display);
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public Shell open(Display dpy) {
        this.display = dpy;
        this.shell = new Shell(this.display);
        this.shell.setText(bundle.getString("Image_analyzer"));
        this.shell.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                ImageAnalyzer.this.resizeShell(event);
            }
        });
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                ImageAnalyzer.this.animate = false;
                if (ImageAnalyzer.this.animateThread != null) {
                    while (ImageAnalyzer.this.animateThread.isAlive()) {
                        if (ImageAnalyzer.this.display.readAndDispatch()) continue;
                        ImageAnalyzer.this.display.sleep();
                    }
                }
                e.doit = true;
            }
        });
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ImageAnalyzer.this.image != null) {
                    ImageAnalyzer.this.image.dispose();
                }
                ImageAnalyzer.this.whiteColor.dispose();
                ImageAnalyzer.this.blackColor.dispose();
                ImageAnalyzer.this.redColor.dispose();
                ImageAnalyzer.this.greenColor.dispose();
                ImageAnalyzer.this.blueColor.dispose();
                ImageAnalyzer.this.fixedWidthFont.dispose();
            }
        });
        this.whiteColor = new Color((Device)this.display, 255, 255, 255);
        this.blackColor = new Color((Device)this.display, 0, 0, 0);
        this.redColor = new Color((Device)this.display, 255, 0, 0);
        this.greenColor = new Color((Device)this.display, 0, 255, 0);
        this.blueColor = new Color((Device)this.display, 0, 0, 255);
        this.fixedWidthFont = new Font((Device)this.display, "courier", 10, 0);
        this.crossCursor = this.display.getSystemCursor(2);
        this.createMenuBar();
        this.createWidgets();
        this.shell.pack();
        this.imageCanvasGC = new GC((Drawable)this.imageCanvas);
        this.imageCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ImageAnalyzer.this.imageCanvasGC.dispose();
            }
        });
        this.shell.open();
        return this.shell;
    }

    void createWidgets() {
        String[] types;
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.numColumns = 2;
        this.shell.setLayout((Layout)layout);
        Composite controls = new Composite((Composite)this.shell, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.marginTop = 5;
        rowLayout.marginBottom = 5;
        rowLayout.spacing = 8;
        controls.setLayout((Layout)rowLayout);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        controls.setLayoutData((Object)gridData);
        Group group = new Group(controls, 0);
        group.setLayout((Layout)new RowLayout());
        group.setText(bundle.getString("Background"));
        this.backgroundCombo = new Combo((Composite)group, 12);
        this.backgroundCombo.setItems(new String[]{bundle.getString("None"), bundle.getString("White"), bundle.getString("Black"), bundle.getString("Red"), bundle.getString("Green"), bundle.getString("Blue")});
        this.backgroundCombo.select(this.backgroundCombo.indexOf(bundle.getString("White")));
        this.backgroundCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.changeBackground();
            }
        });
        group = new Group(controls, 0);
        group.setLayout((Layout)new GridLayout(3, true));
        group.setText(bundle.getString("Save_group"));
        this.imageTypeCombo = new Combo((Composite)group, 12);
        String[] stringArray = types = new String[]{"JPEG", "PNG", "GIF", "ICO", "TIFF", "BMP"};
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            this.imageTypeCombo.add(type);
            ++n2;
        }
        this.imageTypeCombo.select(this.imageTypeCombo.indexOf("JPEG"));
        this.imageTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = ImageAnalyzer.this.imageTypeCombo.getSelectionIndex();
                switch (index) {
                    case 0: {
                        ImageAnalyzer.this.compressionCombo.setEnabled(true);
                        ImageAnalyzer.this.compressionRatioLabel.setEnabled(true);
                        if (ImageAnalyzer.this.compressionCombo.getItemCount() == 100) break;
                        ImageAnalyzer.this.compressionCombo.removeAll();
                        int i = 0;
                        while (i < 100) {
                            ImageAnalyzer.this.compressionCombo.add(String.valueOf(i + 1));
                            ++i;
                        }
                        ImageAnalyzer.this.compressionCombo.select(ImageAnalyzer.this.compressionCombo.indexOf("75"));
                        break;
                    }
                    case 1: {
                        ImageAnalyzer.this.compressionCombo.setEnabled(true);
                        ImageAnalyzer.this.compressionRatioLabel.setEnabled(true);
                        if (ImageAnalyzer.this.compressionCombo.getItemCount() == 10) break;
                        ImageAnalyzer.this.compressionCombo.removeAll();
                        int i = 0;
                        while (i < 4) {
                            ImageAnalyzer.this.compressionCombo.add(String.valueOf(i));
                            ++i;
                        }
                        ImageAnalyzer.this.compressionCombo.select(0);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        ImageAnalyzer.this.compressionCombo.setEnabled(false);
                        ImageAnalyzer.this.compressionRatioLabel.setEnabled(false);
                    }
                }
            }
        });
        this.imageTypeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.compressionRatioLabel = new Label((Composite)group, 0);
        this.compressionRatioLabel.setText(bundle.getString("Compression"));
        this.compressionRatioLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.compressionCombo = new Combo((Composite)group, 12);
        int i = 0;
        while (i < 100) {
            this.compressionCombo.add(String.valueOf(i + 1));
            ++i;
        }
        this.compressionCombo.select(this.compressionCombo.indexOf("75"));
        this.compressionCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        String[] values = new String[]{"0.1", "0.2", "0.3", "0.4", "0.5", "0.6", "0.7", "0.8", "0.9", "1", "1.1", "1.2", "1.3", "1.4", "1.5", "1.6", "1.7", "1.8", "1.9", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
        group = new Group(controls, 0);
        group.setLayout((Layout)new RowLayout());
        group.setText(bundle.getString("X_scale"));
        this.scaleXCombo = new Combo((Composite)group, 4);
        int i2 = 0;
        while (i2 < values.length) {
            this.scaleXCombo.add(values[i2]);
            ++i2;
        }
        this.scaleXCombo.select(this.scaleXCombo.indexOf("1"));
        this.scaleXCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.scaleX();
            }
        });
        group = new Group(controls, 0);
        group.setLayout((Layout)new RowLayout());
        group.setText(bundle.getString("Y_scale"));
        this.scaleYCombo = new Combo((Composite)group, 4);
        i2 = 0;
        while (i2 < values.length) {
            this.scaleYCombo.add(values[i2]);
            ++i2;
        }
        this.scaleYCombo.select(this.scaleYCombo.indexOf("1"));
        this.scaleYCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.scaleY();
            }
        });
        group = new Group(controls, 0);
        group.setLayout((Layout)new RowLayout());
        group.setText(bundle.getString("Alpha_K"));
        this.alphaCombo = new Combo((Composite)group, 12);
        i2 = 0;
        while (i2 <= 255) {
            this.alphaCombo.add(String.valueOf(i2));
            i2 += 5;
        }
        this.alphaCombo.select(this.alphaCombo.indexOf("255"));
        this.alphaCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.alpha();
            }
        });
        group = new Group(controls, 0);
        group.setLayout((Layout)new RowLayout());
        group.setText(bundle.getString("Display"));
        this.incrementalCheck = new Button((Composite)group, 32);
        this.incrementalCheck.setText(bundle.getString("Incremental"));
        this.incrementalCheck.setSelection(this.incremental);
        this.incrementalCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.incremental = ((Button)event.widget).getSelection();
            }
        });
        this.transparentCheck = new Button((Composite)group, 32);
        this.transparentCheck.setText(bundle.getString("Transparent"));
        this.transparentCheck.setSelection(this.transparent);
        this.transparentCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.transparent = ((Button)event.widget).getSelection();
                if (ImageAnalyzer.this.image != null) {
                    ImageAnalyzer.this.imageCanvas.redraw();
                }
            }
        });
        this.maskCheck = new Button((Composite)group, 32);
        this.maskCheck.setText(bundle.getString("Mask"));
        this.maskCheck.setSelection(this.showMask);
        this.maskCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.showMask = ((Button)event.widget).getSelection();
                if (ImageAnalyzer.this.image != null) {
                    ImageAnalyzer.this.imageCanvas.redraw();
                }
            }
        });
        this.backgroundCheck = new Button((Composite)group, 32);
        this.backgroundCheck.setText(bundle.getString("Background"));
        this.backgroundCheck.setSelection(this.showBackground);
        this.backgroundCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.showBackground = ((Button)event.widget).getSelection();
            }
        });
        group = new Group(controls, 0);
        group.setLayout((Layout)new RowLayout());
        group.setText(bundle.getString("Animation"));
        this.previousButton = new Button((Composite)group, 8);
        this.previousButton.setText(bundle.getString("Previous"));
        this.previousButton.setEnabled(false);
        this.previousButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.previous();
            }
        });
        this.nextButton = new Button((Composite)group, 8);
        this.nextButton.setText(bundle.getString("Next"));
        this.nextButton.setEnabled(false);
        this.nextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.next();
            }
        });
        this.animateButton = new Button((Composite)group, 8);
        this.animateButton.setText(bundle.getString("Animate"));
        this.animateButton.setEnabled(false);
        this.animateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.animate();
            }
        });
        this.typeLabel = new Label((Composite)this.shell, 0);
        this.typeLabel.setText(bundle.getString("Type_initial"));
        this.typeLabel.setLayoutData((Object)new GridData(256));
        this.imageCanvas = new Canvas((Composite)this.shell, 1311488);
        this.imageCanvas.setBackground(this.whiteColor);
        this.imageCanvas.setCursor(this.crossCursor);
        gridData = new GridData();
        gridData.verticalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.imageCanvas.setLayoutData((Object)gridData);
        this.imageCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (ImageAnalyzer.this.image == null) {
                    Rectangle bounds = ImageAnalyzer.this.imageCanvas.getBounds();
                    event.gc.fillRectangle(0, 0, bounds.width, bounds.height);
                } else {
                    ImageAnalyzer.this.paintImage(event);
                }
            }
        });
        this.imageCanvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent event) {
                if (ImageAnalyzer.this.image != null) {
                    ImageAnalyzer.this.showColorAt(event.x, event.y);
                }
            }
        });
        ScrollBar horizontal = this.imageCanvas.getHorizontalBar();
        horizontal.setVisible(true);
        horizontal.setMinimum(0);
        horizontal.setEnabled(false);
        horizontal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.scrollHorizontally((ScrollBar)event.widget);
            }
        });
        ScrollBar vertical = this.imageCanvas.getVerticalBar();
        vertical.setVisible(true);
        vertical.setMinimum(0);
        vertical.setEnabled(false);
        vertical.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.scrollVertically((ScrollBar)event.widget);
            }
        });
        this.sizeLabel = new Label((Composite)this.shell, 0);
        this.sizeLabel.setText(bundle.getString("Size_initial"));
        this.sizeLabel.setLayoutData((Object)new GridData(256));
        this.depthLabel = new Label((Composite)this.shell, 0);
        this.depthLabel.setText(bundle.getString("Depth_initial"));
        this.depthLabel.setLayoutData((Object)new GridData(256));
        this.transparentPixelLabel = new Label((Composite)this.shell, 0);
        this.transparentPixelLabel.setText(bundle.getString("Transparent_pixel_initial"));
        this.transparentPixelLabel.setLayoutData((Object)new GridData(256));
        this.timeToLoadLabel = new Label((Composite)this.shell, 0);
        this.timeToLoadLabel.setText(bundle.getString("Time_to_load_initial"));
        this.timeToLoadLabel.setLayoutData((Object)new GridData(256));
        Label separator = new Label((Composite)this.shell, 258);
        separator.setLayoutData((Object)new GridData(256));
        this.screenSizeLabel = new Label((Composite)this.shell, 0);
        this.screenSizeLabel.setText(bundle.getString("Animation_size_initial"));
        this.screenSizeLabel.setLayoutData((Object)new GridData(256));
        this.backgroundPixelLabel = new Label((Composite)this.shell, 0);
        this.backgroundPixelLabel.setText(bundle.getString("Background_pixel_initial"));
        this.backgroundPixelLabel.setLayoutData((Object)new GridData(256));
        this.locationLabel = new Label((Composite)this.shell, 0);
        this.locationLabel.setText(bundle.getString("Image_location_initial"));
        this.locationLabel.setLayoutData((Object)new GridData(256));
        this.disposalMethodLabel = new Label((Composite)this.shell, 0);
        this.disposalMethodLabel.setText(bundle.getString("Disposal_initial"));
        this.disposalMethodLabel.setLayoutData((Object)new GridData(256));
        this.delayTimeLabel = new Label((Composite)this.shell, 0);
        this.delayTimeLabel.setText(bundle.getString("Delay_initial"));
        this.delayTimeLabel.setLayoutData((Object)new GridData(256));
        this.repeatCountLabel = new Label((Composite)this.shell, 0);
        this.repeatCountLabel.setText(bundle.getString("Repeats_initial"));
        this.repeatCountLabel.setLayoutData((Object)new GridData(256));
        separator = new Label((Composite)this.shell, 258);
        separator.setLayoutData((Object)new GridData(256));
        this.paletteLabel = new Label((Composite)this.shell, 0);
        this.paletteLabel.setText(bundle.getString("Palette_initial"));
        this.paletteLabel.setLayoutData((Object)new GridData(256));
        this.paletteCanvas = new Canvas((Composite)this.shell, 0x100A00);
        this.paletteCanvas.setFont(this.fixedWidthFont);
        this.paletteCanvas.getVerticalBar().setVisible(true);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        GC gc = new GC((Drawable)this.paletteLabel);
        this.paletteWidth = gc.stringExtent((String)ImageAnalyzer.bundle.getString((String)"Max_length_string")).x;
        gc.dispose();
        gridData.widthHint = this.paletteWidth;
        gridData.heightHint = 176;
        this.paletteCanvas.setLayoutData((Object)gridData);
        this.paletteCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (ImageAnalyzer.this.image != null) {
                    ImageAnalyzer.this.paintPalette(event);
                }
            }
        });
        vertical = this.paletteCanvas.getVerticalBar();
        vertical.setVisible(true);
        vertical.setMinimum(0);
        vertical.setIncrement(10);
        vertical.setEnabled(false);
        vertical.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.scrollPalette((ScrollBar)event.widget);
            }
        });
        this.sash = new Sash((Composite)this.shell, 256);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        this.sash.setLayoutData((Object)gridData);
        this.sash.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.detail != 1) {
                    ((GridData)ImageAnalyzer.this.paletteCanvas.getLayoutData()).heightHint = -1;
                    Rectangle paletteCanvasBounds = ImageAnalyzer.this.paletteCanvas.getBounds();
                    int minY = paletteCanvasBounds.y + 20;
                    Rectangle dataLabelBounds = ImageAnalyzer.this.dataLabel.getBounds();
                    int maxY = ImageAnalyzer.this.statusLabel.getBounds().y - dataLabelBounds.height - 20;
                    if (event.y > minY && event.y < maxY) {
                        Rectangle oldSash = ImageAnalyzer.this.sash.getBounds();
                        ImageAnalyzer.this.sash.setBounds(event.x, event.y, event.width, event.height);
                        int diff = event.y - oldSash.y;
                        Rectangle bounds = ImageAnalyzer.this.imageCanvas.getBounds();
                        ImageAnalyzer.this.imageCanvas.setBounds(bounds.x, bounds.y, bounds.width, bounds.height + diff);
                        bounds = paletteCanvasBounds;
                        ImageAnalyzer.this.paletteCanvas.setBounds(bounds.x, bounds.y, bounds.width, bounds.height + diff);
                        bounds = dataLabelBounds;
                        ImageAnalyzer.this.dataLabel.setBounds(bounds.x, bounds.y + diff, bounds.width, bounds.height);
                        bounds = ImageAnalyzer.this.dataText.getBounds();
                        ImageAnalyzer.this.dataText.setBounds(bounds.x, bounds.y + diff, bounds.width, bounds.height - diff);
                    }
                }
            }
        });
        this.dataLabel = new Label((Composite)this.shell, 0);
        this.dataLabel.setText(bundle.getString("Pixel_data_initial"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        this.dataLabel.setLayoutData((Object)gridData);
        this.dataText = new StyledText((Composite)this.shell, 2826);
        this.dataText.setBackground(this.display.getSystemColor(22));
        this.dataText.setFont(this.fixedWidthFont);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.heightHint = 128;
        gridData.grabExcessVerticalSpace = true;
        this.dataText.setLayoutData((Object)gridData);
        this.dataText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                if (ImageAnalyzer.this.image != null && event.button == 1) {
                    ImageAnalyzer.this.showColorForData();
                }
            }
        });
        this.dataText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (ImageAnalyzer.this.image != null) {
                    ImageAnalyzer.this.showColorForData();
                }
            }
        });
        this.statusLabel = new Label((Composite)this.shell, 0);
        this.statusLabel.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        this.statusLabel.setLayoutData((Object)gridData);
    }

    Menu createMenuBar() {
        Menu menuBar = new Menu((Decorations)this.shell, 2);
        this.shell.setMenuBar(menuBar);
        this.createFileMenu(menuBar);
        this.createAlphaMenu(menuBar);
        return menuBar;
    }

    void createFileMenu(Menu menuBar) {
        MenuItem item = new MenuItem(menuBar, 64);
        item.setText(bundle.getString("File"));
        Menu fileMenu = new Menu((Decorations)this.shell, 4);
        item.setMenu(fileMenu);
        item = new MenuItem(fileMenu, 8);
        item.setText(bundle.getString("OpenFile"));
        item.setAccelerator(SWT.MOD1 + 79);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.menuOpenFile();
            }
        });
        item = new MenuItem(fileMenu, 8);
        item.setText(bundle.getString("OpenURL"));
        item.setAccelerator(SWT.MOD1 + 85);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.menuOpenURL();
            }
        });
        item = new MenuItem(fileMenu, 8);
        item.setText(bundle.getString("Reopen"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.menuReopen();
            }
        });
        new MenuItem(fileMenu, 2);
        item = new MenuItem(fileMenu, 8);
        item.setText(bundle.getString("LoadFile"));
        item.setAccelerator(SWT.MOD1 + 76);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.menuLoad();
            }
        });
        new MenuItem(fileMenu, 2);
        item = new MenuItem(fileMenu, 8);
        item.setText(bundle.getString("Save"));
        item.setAccelerator(SWT.MOD1 + 83);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.menuSave();
            }
        });
        item = new MenuItem(fileMenu, 8);
        item.setText(bundle.getString("Save_as"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.menuSaveAs();
            }
        });
        item = new MenuItem(fileMenu, 8);
        item.setText(bundle.getString("Save_mask_as"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.menuSaveMaskAs();
            }
        });
        new MenuItem(fileMenu, 2);
        item = new MenuItem(fileMenu, 8);
        item.setText(bundle.getString("Print"));
        item.setAccelerator(SWT.MOD1 + 80);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.menuPrint();
            }
        });
        new MenuItem(fileMenu, 2);
        item = new MenuItem(fileMenu, 8);
        item.setText(bundle.getString("Exit"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.shell.close();
            }
        });
    }

    void createAlphaMenu(Menu menuBar) {
        MenuItem item = new MenuItem(menuBar, 64);
        item.setText(bundle.getString("Alpha"));
        Menu alphaMenu = new Menu((Decorations)this.shell, 4);
        item.setMenu(alphaMenu);
        item = new MenuItem(alphaMenu, 8);
        item.setText("K");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.menuComposeAlpha(0);
            }
        });
        item = new MenuItem(alphaMenu, 8);
        item.setText("(K + x) % 256");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.menuComposeAlpha(1);
            }
        });
        item = new MenuItem(alphaMenu, 8);
        item.setText("(K + y) % 256");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.menuComposeAlpha(2);
            }
        });
    }

    void menuComposeAlpha(int alpha_op) {
        if (this.image == null) {
            return;
        }
        this.animate = false;
        Cursor waitCursor = this.display.getSystemCursor(1);
        this.shell.setCursor(waitCursor);
        this.imageCanvas.setCursor(waitCursor);
        try {
            if (alpha_op == 0) {
                this.imageData.alpha = this.alpha;
            } else {
                this.imageData.alpha = -1;
                switch (alpha_op) {
                    case 1: {
                        int y = 0;
                        while (y < this.imageData.height) {
                            int x = 0;
                            while (x < this.imageData.width) {
                                this.imageData.setAlpha(x, y, (x + this.alpha) % 256);
                                ++x;
                            }
                            ++y;
                        }
                        break;
                    }
                    case 2: {
                        int y = 0;
                        while (y < this.imageData.height) {
                            int x = 0;
                            while (x < this.imageData.width) {
                                this.imageData.setAlpha(x, y, (y + this.alpha) % 256);
                                ++x;
                            }
                            ++y;
                        }
                        break;
                    }
                }
            }
            this.displayImage(this.imageData);
        }
        finally {
            this.shell.setCursor(null);
            this.imageCanvas.setCursor(this.crossCursor);
        }
    }

    /*
     * Loose catch block
     */
    void menuLoad() {
        this.animate = false;
        FileDialog fileChooser = new FileDialog(this.shell, 4096);
        if (this.lastPath != null) {
            fileChooser.setFilterPath(this.lastPath);
        }
        fileChooser.setFilterExtensions(OPEN_FILTER_EXTENSIONS);
        fileChooser.setFilterNames(OPEN_FILTER_NAMES);
        String filename = fileChooser.open();
        this.lastPath = fileChooser.getFilterPath();
        if (filename == null) {
            return;
        }
        Cursor waitCursor = this.display.getSystemCursor(1);
        this.shell.setCursor(waitCursor);
        this.imageCanvas.setCursor(waitCursor);
        try {
            try {
                long startTime = System.currentTimeMillis();
                Image newImage = new Image((Device)this.display, filename);
                this.loadTime = System.currentTimeMillis() - startTime;
                this.imageData = newImage.getImageData();
                this.currentName = filename;
                this.fileName = filename;
                this.loader = new ImageLoader();
                this.imageDataArray = new ImageData[]{this.imageData};
                this.loader.data = this.imageDataArray;
                this.imageDataIndex = 0;
                this.displayImage(this.imageData);
            }
            catch (SWTException e) {
                this.showErrorDialog(bundle.getString("Loading_lc"), filename, e);
                this.shell.setCursor(null);
                this.imageCanvas.setCursor(this.crossCursor);
            }
            catch (SWTError e) {
                this.showErrorDialog(bundle.getString("Loading_lc"), filename, e);
                this.shell.setCursor(null);
                this.imageCanvas.setCursor(this.crossCursor);
            }
            catch (OutOfMemoryError e) {
                this.showErrorDialog(bundle.getString("Loading_lc"), filename, e);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                this.shell.setCursor(null);
                this.imageCanvas.setCursor(this.crossCursor);
            }
        }
        finally {
            this.shell.setCursor(null);
            this.imageCanvas.setCursor(this.crossCursor);
        }
    }

    /*
     * Loose catch block
     */
    void menuOpenFile() {
        this.animate = false;
        FileDialog fileChooser = new FileDialog(this.shell, 4096);
        if (this.lastPath != null) {
            fileChooser.setFilterPath(this.lastPath);
        }
        fileChooser.setFilterExtensions(OPEN_FILTER_EXTENSIONS);
        fileChooser.setFilterNames(OPEN_FILTER_NAMES);
        String filename = fileChooser.open();
        this.lastPath = fileChooser.getFilterPath();
        if (filename == null) {
            return;
        }
        this.showFileType(filename);
        Cursor waitCursor = this.display.getSystemCursor(1);
        this.shell.setCursor(waitCursor);
        this.imageCanvas.setCursor(waitCursor);
        ImageLoader oldLoader = this.loader;
        try {
            try {
                this.loader = new ImageLoader();
                if (this.incremental) {
                    this.loader.addImageLoaderListener(new ImageLoaderListener(){

                        public void imageDataLoaded(ImageLoaderEvent event) {
                            ImageAnalyzer.this.incrementalDataLoaded(event);
                        }
                    });
                    this.incrementalThreadStart();
                }
                long startTime = System.currentTimeMillis();
                this.imageDataArray = this.loader.load(filename);
                this.loadTime = System.currentTimeMillis() - startTime;
                if (this.imageDataArray.length > 0) {
                    this.currentName = filename;
                    this.fileName = filename;
                    this.previousButton.setEnabled(this.imageDataArray.length > 1);
                    this.nextButton.setEnabled(this.imageDataArray.length > 1);
                    this.animateButton.setEnabled(this.imageDataArray.length > 1 && this.loader.logicalScreenWidth > 0 && this.loader.logicalScreenHeight > 0);
                    this.imageDataIndex = 0;
                    this.displayImage(this.imageDataArray[this.imageDataIndex]);
                }
            }
            catch (SWTException e) {
                this.showErrorDialog(bundle.getString("Loading_lc"), filename, e);
                this.loader = oldLoader;
                this.shell.setCursor(null);
                this.imageCanvas.setCursor(this.crossCursor);
            }
            catch (SWTError e) {
                this.showErrorDialog(bundle.getString("Loading_lc"), filename, e);
                this.loader = oldLoader;
                this.shell.setCursor(null);
                this.imageCanvas.setCursor(this.crossCursor);
            }
            catch (OutOfMemoryError e) {
                this.showErrorDialog(bundle.getString("Loading_lc"), filename, e);
                this.loader = oldLoader;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                this.shell.setCursor(null);
                this.imageCanvas.setCursor(this.crossCursor);
            }
        }
        finally {
            this.shell.setCursor(null);
            this.imageCanvas.setCursor(this.crossCursor);
        }
    }

    void menuOpenURL() {
        this.animate = false;
        TextPrompter textPrompter = new TextPrompter(this.shell, 67680);
        textPrompter.setText(bundle.getString("OpenURLDialog"));
        textPrompter.setMessage(bundle.getString("EnterURL"));
        String urlname = textPrompter.open();
        if (urlname == null) {
            return;
        }
        Cursor waitCursor = this.display.getSystemCursor(1);
        this.shell.setCursor(waitCursor);
        this.imageCanvas.setCursor(waitCursor);
        ImageLoader oldLoader = this.loader;
        try {
            try {
                URL url = new URL(urlname);
                InputStream stream = url.openStream();
                this.loader = new ImageLoader();
                if (this.incremental) {
                    this.loader.addImageLoaderListener(new ImageLoaderListener(){

                        public void imageDataLoaded(ImageLoaderEvent event) {
                            ImageAnalyzer.this.incrementalDataLoaded(event);
                        }
                    });
                    this.incrementalThreadStart();
                }
                long startTime = System.currentTimeMillis();
                this.imageDataArray = this.loader.load(stream);
                this.loadTime = System.currentTimeMillis() - startTime;
                stream.close();
                if (this.imageDataArray.length > 0) {
                    this.currentName = urlname;
                    this.fileName = null;
                    this.previousButton.setEnabled(this.imageDataArray.length > 1);
                    this.nextButton.setEnabled(this.imageDataArray.length > 1);
                    this.animateButton.setEnabled(this.imageDataArray.length > 1 && this.loader.logicalScreenWidth > 0 && this.loader.logicalScreenHeight > 0);
                    this.imageDataIndex = 0;
                    this.displayImage(this.imageDataArray[this.imageDataIndex]);
                }
            }
            catch (Exception e) {
                this.showErrorDialog(bundle.getString("Loading_lc"), urlname, e);
                this.loader = oldLoader;
                this.shell.setCursor(null);
                this.imageCanvas.setCursor(this.crossCursor);
            }
            catch (OutOfMemoryError e) {
                this.showErrorDialog(bundle.getString("Loading_lc"), urlname, e);
                this.loader = oldLoader;
                this.shell.setCursor(null);
                this.imageCanvas.setCursor(this.crossCursor);
            }
        }
        finally {
            this.shell.setCursor(null);
            this.imageCanvas.setCursor(this.crossCursor);
        }
    }

    void incrementalThreadStart() {
        this.incrementalEvents = new Vector();
        this.incrementalThread = new Thread("Incremental"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (ImageAnalyzer.this.incrementalEvents != null) {
                    ImageAnalyzer imageAnalyzer = ImageAnalyzer.this;
                    synchronized (imageAnalyzer) {
                        if (ImageAnalyzer.this.incrementalEvents != null) {
                            if (ImageAnalyzer.this.incrementalEvents.size() > 0) {
                                ImageLoaderEvent event = ImageAnalyzer.this.incrementalEvents.remove(0);
                                if (ImageAnalyzer.this.image != null) {
                                    ImageAnalyzer.this.image.dispose();
                                }
                                ImageAnalyzer.this.image = new Image((Device)ImageAnalyzer.this.display, event.imageData);
                                ImageAnalyzer.this.imageData = event.imageData;
                                ImageAnalyzer.this.imageCanvasGC.drawImage(ImageAnalyzer.this.image, 0, 0, ImageAnalyzer.this.imageData.width, ImageAnalyzer.this.imageData.height, ImageAnalyzer.this.imageData.x, ImageAnalyzer.this.imageData.y, ImageAnalyzer.this.imageData.width, ImageAnalyzer.this.imageData.height);
                            } else {
                                40.yield();
                            }
                        }
                    }
                }
                ImageAnalyzer.this.display.wake();
            }
        };
        this.incrementalThread.setDaemon(true);
        this.incrementalThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementalDataLoaded(ImageLoaderEvent event) {
        ImageAnalyzer imageAnalyzer = this;
        synchronized (imageAnalyzer) {
            this.incrementalEvents.addElement(event);
        }
    }

    void menuSave() {
        if (this.image == null) {
            return;
        }
        this.animate = false;
        if (this.imageData.type == -1 || this.fileName == null) {
            this.menuSaveAs();
            return;
        }
        Cursor waitCursor = this.display.getSystemCursor(1);
        this.shell.setCursor(waitCursor);
        this.imageCanvas.setCursor(waitCursor);
        try {
            try {
                this.loader.data = new ImageData[]{this.imageData};
                if (this.imageData.type == 4) {
                    this.loader.compression = this.compressionCombo.indexOf(this.compressionCombo.getText()) + 1;
                }
                if (this.imageData.type == 5) {
                    this.loader.compression = this.compressionCombo.indexOf(this.compressionCombo.getText());
                }
                this.loader.save(this.fileName, this.imageData.type);
            }
            catch (SWTException e) {
                this.showErrorDialog(bundle.getString("Saving_lc"), this.fileName, e);
                this.shell.setCursor(null);
                this.imageCanvas.setCursor(this.crossCursor);
            }
            catch (SWTError e) {
                this.showErrorDialog(bundle.getString("Saving_lc"), this.fileName, e);
                this.shell.setCursor(null);
                this.imageCanvas.setCursor(this.crossCursor);
            }
        }
        finally {
            this.shell.setCursor(null);
            this.imageCanvas.setCursor(this.crossCursor);
        }
    }

    /*
     * Unable to fully structure code
     */
    void menuSaveAs() {
        if (this.image == null) {
            return;
        }
        this.animate = false;
        fileChooser = new FileDialog(this.shell, 8192);
        fileChooser.setFilterPath(this.lastPath);
        if (this.fileName != null) {
            name = this.fileName;
            nameStart = name.lastIndexOf(File.separatorChar);
            if (nameStart > -1) {
                name = name.substring(nameStart + 1);
            }
            fileChooser.setFileName(String.valueOf(name.substring(0, name.indexOf("."))) + "." + this.imageTypeCombo.getText().toLowerCase());
        }
        fileChooser.setFilterExtensions(ImageAnalyzer.SAVE_FILTER_EXTENSIONS);
        fileChooser.setFilterNames(ImageAnalyzer.SAVE_FILTER_NAMES);
        switch (this.imageTypeCombo.getSelectionIndex()) {
            case 0: {
                fileChooser.setFilterIndex(4);
                break;
            }
            case 1: {
                fileChooser.setFilterIndex(5);
                break;
            }
            case 2: {
                fileChooser.setFilterIndex(2);
                break;
            }
            case 3: {
                fileChooser.setFilterIndex(3);
                break;
            }
            case 4: {
                fileChooser.setFilterIndex(6);
                break;
            }
            case 5: {
                fileChooser.setFilterIndex(0);
            }
        }
        filename = fileChooser.open();
        this.lastPath = fileChooser.getFilterPath();
        if (filename == null) {
            return;
        }
        filetype = fileChooser.getFilterIndex();
        if (filetype == -1 && (filetype = this.determineFileType(filename)) == -1) {
            box = new MessageBox(this.shell, 1);
            box.setMessage(ImageAnalyzer.createMsg(ImageAnalyzer.bundle.getString("Unknown_extension"), filename.substring(filename.lastIndexOf(46) + 1)));
            box.open();
            return;
        }
        if (new File(filename).exists()) {
            box = new MessageBox(this.shell, 292);
            box.setMessage(ImageAnalyzer.createMsg(ImageAnalyzer.bundle.getString("Overwrite"), filename));
            if (box.open() == 256) {
                return;
            }
        }
        waitCursor = this.display.getSystemCursor(1);
        this.shell.setCursor(waitCursor);
        this.imageCanvas.setCursor(waitCursor);
        try {
            multi = false;
            if (this.loader.data.length <= 1) ** GOTO lbl62
            box = new MessageBox(this.shell, 452);
            box.setMessage(ImageAnalyzer.createMsg(ImageAnalyzer.bundle.getString("Save_all"), new Integer(this.loader.data.length)));
            result = box.open();
            if (result == 256) {
                return;
            }
            try {
                if (result == 64) {
                    multi = true;
                }
lbl62:
                // 4 sources

                transparentPixel = this.imageData.transparentPixel;
                if (!multi && transparentPixel != -1 && !this.transparent) {
                    this.imageData.transparentPixel = -1;
                }
                if (!multi) {
                    this.loader.data = new ImageData[]{this.imageData};
                }
                this.loader.compression = this.compressionCombo.indexOf(this.compressionCombo.getText());
                this.loader.save(filename, filetype);
                if (!multi && transparentPixel != -1 && !this.transparent) {
                    this.imageData.transparentPixel = transparentPixel;
                }
                this.fileName = filename;
                this.shell.setText(ImageAnalyzer.createMsg(ImageAnalyzer.bundle.getString("Analyzer_on"), filename));
                this.typeLabel.setText(ImageAnalyzer.createMsg(ImageAnalyzer.bundle.getString("Type_string"), this.fileTypeString(filetype)));
            }
            catch (SWTException e) {
                this.showErrorDialog(ImageAnalyzer.bundle.getString("Saving_lc"), filename, e);
            }
            catch (SWTError e) {
                this.showErrorDialog(ImageAnalyzer.bundle.getString("Saving_lc"), filename, e);
            }
        }
        finally {
            this.shell.setCursor(null);
            this.imageCanvas.setCursor(this.crossCursor);
        }
    }

    void menuSaveMaskAs() {
        if (this.image == null || !this.showMask) {
            return;
        }
        if (this.imageData.getTransparencyType() == 0) {
            return;
        }
        this.animate = false;
        FileDialog fileChooser = new FileDialog(this.shell, 8192);
        fileChooser.setFilterPath(this.lastPath);
        if (this.fileName != null) {
            fileChooser.setFileName(this.fileName);
        }
        fileChooser.setFilterExtensions(SAVE_FILTER_EXTENSIONS);
        fileChooser.setFilterNames(SAVE_FILTER_NAMES);
        String filename = fileChooser.open();
        this.lastPath = fileChooser.getFilterPath();
        if (filename == null) {
            return;
        }
        int filetype = fileChooser.getFilterIndex();
        if (filetype == -1 && (filetype = this.determineFileType(filename)) == -1) {
            MessageBox box = new MessageBox(this.shell, 1);
            box.setMessage(ImageAnalyzer.createMsg(bundle.getString("Unknown_extension"), filename.substring(filename.lastIndexOf(46) + 1)));
            box.open();
            return;
        }
        if (new File(filename).exists()) {
            MessageBox box = new MessageBox(this.shell, 292);
            box.setMessage(ImageAnalyzer.createMsg(bundle.getString("Overwrite"), filename));
            if (box.open() == 256) {
                return;
            }
        }
        Cursor waitCursor = this.display.getSystemCursor(1);
        this.shell.setCursor(waitCursor);
        this.imageCanvas.setCursor(waitCursor);
        try {
            try {
                ImageData maskImageData = this.imageData.getTransparencyMask();
                this.loader.data = new ImageData[]{maskImageData};
                this.loader.save(filename, filetype);
            }
            catch (SWTException e) {
                this.showErrorDialog(bundle.getString("Saving_lc"), filename, e);
                this.shell.setCursor(null);
                this.imageCanvas.setCursor(this.crossCursor);
            }
            catch (SWTError e) {
                this.showErrorDialog(bundle.getString("Saving_lc"), filename, e);
                this.shell.setCursor(null);
                this.imageCanvas.setCursor(this.crossCursor);
            }
        }
        finally {
            this.shell.setCursor(null);
            this.imageCanvas.setCursor(this.crossCursor);
        }
    }

    void menuPrint() {
        if (this.image == null) {
            return;
        }
        try {
            PrintDialog dialog = new PrintDialog(this.shell, 0);
            if (this.printerData != null) {
                dialog.setPrinterData(this.printerData);
            }
            this.printerData = dialog.open();
            if (this.printerData == null) {
                return;
            }
            Printer printer = new Printer(this.printerData);
            Point screenDPI = this.display.getDPI();
            Point printerDPI = printer.getDPI();
            int scaleFactor = printerDPI.x / screenDPI.x;
            Rectangle trim = printer.computeTrim(0, 0, 0, 0);
            if (printer.startJob(this.currentName)) {
                if (printer.startPage()) {
                    GC gc = new GC((Drawable)printer);
                    int transparentPixel = this.imageData.transparentPixel;
                    if (transparentPixel != -1 && !this.transparent) {
                        this.imageData.transparentPixel = -1;
                    }
                    Image printerImage = new Image((Device)printer, this.imageData);
                    gc.drawImage(printerImage, 0, 0, this.imageData.width, this.imageData.height, -trim.x, -trim.y, scaleFactor * this.imageData.width, scaleFactor * this.imageData.height);
                    if (transparentPixel != -1 && !this.transparent) {
                        this.imageData.transparentPixel = transparentPixel;
                    }
                    printerImage.dispose();
                    gc.dispose();
                    printer.endPage();
                }
                printer.endJob();
            }
            printer.dispose();
        }
        catch (SWTError e) {
            MessageBox box = new MessageBox(this.shell, 1);
            box.setMessage(String.valueOf(bundle.getString("Printing_error")) + e.getMessage());
            box.open();
        }
    }

    void menuReopen() {
        if (this.currentName == null) {
            return;
        }
        this.animate = false;
        Cursor waitCursor = this.display.getSystemCursor(1);
        this.shell.setCursor(waitCursor);
        this.imageCanvas.setCursor(waitCursor);
        try {
            try {
                ImageData[] newImageData;
                this.loader = new ImageLoader();
                if (this.fileName == null) {
                    URL url = new URL(this.currentName);
                    InputStream stream = url.openStream();
                    long startTime = System.currentTimeMillis();
                    newImageData = this.loader.load(stream);
                    this.loadTime = System.currentTimeMillis() - startTime;
                    stream.close();
                } else {
                    long startTime = System.currentTimeMillis();
                    newImageData = this.loader.load(this.fileName);
                    this.loadTime = System.currentTimeMillis() - startTime;
                }
                this.imageDataIndex = 0;
                this.displayImage(newImageData[this.imageDataIndex]);
            }
            catch (Exception e) {
                this.showErrorDialog(bundle.getString("Reloading_lc"), this.currentName, e);
                this.shell.setCursor(null);
                this.imageCanvas.setCursor(this.crossCursor);
            }
            catch (OutOfMemoryError e) {
                this.showErrorDialog(bundle.getString("Reloading_lc"), this.currentName, e);
                this.shell.setCursor(null);
                this.imageCanvas.setCursor(this.crossCursor);
            }
        }
        finally {
            this.shell.setCursor(null);
            this.imageCanvas.setCursor(this.crossCursor);
        }
    }

    void changeBackground() {
        String background = this.backgroundCombo.getText();
        if (background.equals(bundle.getString("White"))) {
            this.imageCanvas.setBackground(this.whiteColor);
        } else if (background.equals(bundle.getString("Black"))) {
            this.imageCanvas.setBackground(this.blackColor);
        } else if (background.equals(bundle.getString("Red"))) {
            this.imageCanvas.setBackground(this.redColor);
        } else if (background.equals(bundle.getString("Green"))) {
            this.imageCanvas.setBackground(this.greenColor);
        } else if (background.equals(bundle.getString("Blue"))) {
            this.imageCanvas.setBackground(this.blueColor);
        } else {
            this.imageCanvas.setBackground(null);
        }
    }

    void scaleX() {
        try {
            this.xscale = Float.parseFloat(this.scaleXCombo.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.xscale = 1.0f;
            this.scaleXCombo.select(this.scaleXCombo.indexOf("1"));
        }
        if (this.image != null) {
            this.resizeScrollBars();
            this.imageCanvas.redraw();
        }
    }

    void scaleY() {
        try {
            this.yscale = Float.parseFloat(this.scaleYCombo.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.yscale = 1.0f;
            this.scaleYCombo.select(this.scaleYCombo.indexOf("1"));
        }
        if (this.image != null) {
            this.resizeScrollBars();
            this.imageCanvas.redraw();
        }
    }

    void alpha() {
        try {
            this.alpha = Integer.parseInt(this.alphaCombo.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.alphaCombo.select(this.alphaCombo.indexOf("255"));
            this.alpha = 255;
        }
    }

    void showColorAt(int mx, int my) {
        int x = mx - this.imageData.x - this.ix;
        int y = my - this.imageData.y - this.iy;
        this.showColorForPixel(x, y);
    }

    void showColorForData() {
        int y;
        int delimiterLength = this.dataText.getLineDelimiter().length();
        int charactersPerLine = 6 + 3 * this.imageData.bytesPerLine + delimiterLength;
        int position = this.dataText.getCaretOffset();
        if (position - (y = position / charactersPerLine) * charactersPerLine < 6 || (y + 1) * charactersPerLine - position <= delimiterLength) {
            this.statusLabel.setText("");
            return;
        }
        int dataPosition = position - 6 * (y + 1) - delimiterLength * y;
        int byteNumber = dataPosition / 3;
        int where = dataPosition - byteNumber * 3;
        int xByte = byteNumber % this.imageData.bytesPerLine;
        int x = -1;
        int depth = this.imageData.depth;
        if (depth == 1) {
            if (where == 0) {
                x = xByte * 8;
            }
            if (where == 1) {
                x = xByte * 8 + 3;
            }
            if (where == 2) {
                x = xByte * 8 + 7;
            }
        }
        if (depth == 2) {
            if (where == 0) {
                x = xByte * 4;
            }
            if (where == 1) {
                x = xByte * 4 + 1;
            }
            if (where == 2) {
                x = xByte * 4 + 3;
            }
        }
        if (depth == 4) {
            if (where == 0) {
                x = xByte * 2;
            }
            if (where == 1) {
                x = xByte * 2;
            }
            if (where == 2) {
                x = xByte * 2 + 1;
            }
        }
        if (depth == 8) {
            x = xByte;
        }
        if (depth == 16) {
            x = xByte / 2;
        }
        if (depth == 24) {
            x = xByte / 3;
        }
        if (depth == 32) {
            x = xByte / 4;
        }
        if (x != -1) {
            this.showColorForPixel(x, y);
        } else {
            this.statusLabel.setText("");
        }
    }

    void showColorForPixel(int x, int y) {
        if (x >= 0 && x < this.imageData.width && y >= 0 && y < this.imageData.height) {
            int pixel = this.imageData.getPixel(x, y);
            RGB rgb = this.imageData.palette.getRGB(pixel);
            boolean hasAlpha = false;
            int alphaValue = 0;
            if (this.imageData.alphaData != null && this.imageData.alphaData.length > 0) {
                hasAlpha = true;
                alphaValue = this.imageData.getAlpha(x, y);
            }
            String rgbMessageFormat = bundle.getString(hasAlpha ? "RGBA" : "RGB");
            Object[] rgbArgs = new Object[]{Integer.toString(rgb.red), Integer.toString(rgb.green), Integer.toString(rgb.blue), Integer.toString(alphaValue)};
            Object[] rgbHexArgs = new Object[]{Integer.toHexString(rgb.red), Integer.toHexString(rgb.green), Integer.toHexString(rgb.blue), Integer.toHexString(alphaValue)};
            Object[] args = new Object[]{new Integer(x), new Integer(y), new Integer(pixel), Integer.toHexString(pixel), ImageAnalyzer.createMsg(rgbMessageFormat, rgbArgs), ImageAnalyzer.createMsg(rgbMessageFormat, rgbHexArgs), pixel == this.imageData.transparentPixel ? bundle.getString("Color_at_transparent") : ""};
            this.statusLabel.setText(ImageAnalyzer.createMsg(bundle.getString("Color_at"), args));
        } else {
            this.statusLabel.setText("");
        }
    }

    void animate() {
        boolean bl = this.animate = !this.animate;
        if (this.animate && this.image != null && this.imageDataArray.length > 1) {
            this.animateThread = new Thread(bundle.getString("Animation")){

                public void run() {
                    ImageAnalyzer.this.preAnimation();
                    try {
                        ImageAnalyzer.this.animateLoop();
                    }
                    catch (SWTException e) {
                        ImageAnalyzer.this.display.syncExec(new Runnable(){

                            public void run() {
                                ImageAnalyzer.this.showErrorDialog(ImageAnalyzer.createMsg(bundle.getString("Creating_image"), new Integer((this).ImageAnalyzer.this.imageDataIndex + 1)), (this).ImageAnalyzer.this.currentName, (Throwable)e);
                            }
                        });
                    }
                    ImageAnalyzer.this.postAnimation();
                }
            };
            this.animateThread.setDaemon(true);
            this.animateThread.start();
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void animateLoop() {
        Image offScreenImage = new Image((Device)this.display, this.loader.logicalScreenWidth, this.loader.logicalScreenHeight);
        GC offScreenImageGC = new GC((Drawable)offScreenImage);
        try {
            block17: {
                int repeatCount;
                block16: {
                    this.display.syncExec(new Runnable(){

                        public void run() {
                            ImageAnalyzer.this.canvasBackground = ImageAnalyzer.this.imageCanvas.getBackground();
                        }
                    });
                    offScreenImageGC.setBackground(this.canvasBackground);
                    offScreenImageGC.fillRectangle(0, 0, this.loader.logicalScreenWidth, this.loader.logicalScreenHeight);
                    offScreenImageGC.drawImage(this.image, 0, 0, this.imageData.width, this.imageData.height, this.imageData.x, this.imageData.y, this.imageData.width, this.imageData.height);
                    repeatCount = this.loader.repeatCount;
                    if (!true) break block16;
                    if (!this.animate) return;
                    if (this.loader.repeatCount != 0 && repeatCount <= 0) break block17;
                }
                do {
                    if (this.imageData.disposalMethod == 2) {
                        Color bgColor = null;
                        int backgroundPixel = this.loader.backgroundPixel;
                        if (this.showBackground && backgroundPixel != -1) {
                            RGB backgroundRGB = this.imageData.palette.getRGB(backgroundPixel);
                            bgColor = new Color(null, backgroundRGB);
                        }
                        try {
                            offScreenImageGC.setBackground(bgColor != null ? bgColor : this.canvasBackground);
                            offScreenImageGC.fillRectangle(this.imageData.x, this.imageData.y, this.imageData.width, this.imageData.height);
                        }
                        finally {
                            if (bgColor != null) {
                                bgColor.dispose();
                            }
                        }
                    } else if (this.imageData.disposalMethod == 3) {
                        offScreenImageGC.drawImage(this.image, 0, 0, this.imageData.width, this.imageData.height, this.imageData.x, this.imageData.y, this.imageData.width, this.imageData.height);
                    }
                    this.imageDataIndex = (this.imageDataIndex + 1) % this.imageDataArray.length;
                    this.imageData = this.imageDataArray[this.imageDataIndex];
                    this.image.dispose();
                    this.image = new Image((Device)this.display, this.imageData);
                    offScreenImageGC.drawImage(this.image, 0, 0, this.imageData.width, this.imageData.height, this.imageData.x, this.imageData.y, this.imageData.width, this.imageData.height);
                    this.imageCanvasGC.drawImage(offScreenImage, 0, 0);
                    try {
                        Thread.sleep(ImageAnalyzer.visibleDelay(this.imageData.delayTime * 10));
                    }
                    catch (InterruptedException interruptedException) {}
                    if (this.imageDataIndex == this.imageDataArray.length - 1) {
                        --repeatCount;
                    }
                    if (!this.animate) return;
                } while (this.loader.repeatCount == 0 || repeatCount > 0);
            }
            return;
        }
        finally {
            offScreenImage.dispose();
            offScreenImageGC.dispose();
        }
    }

    void preAnimation() {
        this.display.syncExec(new Runnable(){

            public void run() {
                ImageAnalyzer.this.animateButton.setText(bundle.getString("Stop"));
                ImageAnalyzer.this.previousButton.setEnabled(false);
                ImageAnalyzer.this.nextButton.setEnabled(false);
                ImageAnalyzer.this.backgroundCombo.setEnabled(false);
                ImageAnalyzer.this.scaleXCombo.setEnabled(false);
                ImageAnalyzer.this.scaleYCombo.setEnabled(false);
                ImageAnalyzer.this.alphaCombo.setEnabled(false);
                ImageAnalyzer.this.incrementalCheck.setEnabled(false);
                ImageAnalyzer.this.transparentCheck.setEnabled(false);
                ImageAnalyzer.this.maskCheck.setEnabled(false);
                ImageAnalyzer.this.resetScaleCombos();
                ImageAnalyzer.this.resetScrollBars();
            }
        });
    }

    void postAnimation() {
        this.display.syncExec(new Runnable(){

            public void run() {
                ImageAnalyzer.this.previousButton.setEnabled(true);
                ImageAnalyzer.this.nextButton.setEnabled(true);
                ImageAnalyzer.this.backgroundCombo.setEnabled(true);
                ImageAnalyzer.this.scaleXCombo.setEnabled(true);
                ImageAnalyzer.this.scaleYCombo.setEnabled(true);
                ImageAnalyzer.this.alphaCombo.setEnabled(true);
                ImageAnalyzer.this.incrementalCheck.setEnabled(true);
                ImageAnalyzer.this.transparentCheck.setEnabled(true);
                ImageAnalyzer.this.maskCheck.setEnabled(true);
                ImageAnalyzer.this.animateButton.setText(bundle.getString("Animate"));
                if (ImageAnalyzer.this.animate) {
                    ImageAnalyzer.this.animate = false;
                } else {
                    ImageAnalyzer.this.displayImage(ImageAnalyzer.this.imageDataArray[ImageAnalyzer.this.imageDataIndex]);
                }
            }
        });
    }

    void previous() {
        if (this.image != null && this.imageDataArray.length > 1) {
            if (this.imageDataIndex == 0) {
                this.imageDataIndex = this.imageDataArray.length;
            }
            --this.imageDataIndex;
            this.displayImage(this.imageDataArray[this.imageDataIndex]);
        }
    }

    void next() {
        if (this.image != null && this.imageDataArray.length > 1) {
            this.imageDataIndex = (this.imageDataIndex + 1) % this.imageDataArray.length;
            this.displayImage(this.imageDataArray[this.imageDataIndex]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void displayImage(ImageData newImageData) {
        block9: {
            this.resetScaleCombos();
            if (!this.incremental || this.incrementalThread == null) break block9;
            var2_2 = this;
            synchronized (var2_2) {
                this.incrementalEvents = null;
                // MONITOREXIT @DISABLED, blocks:[0, 2] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
                if (true) ** GOTO lbl15
            }
            do {
                if (this.display.readAndDispatch()) continue;
                this.display.sleep();
lbl15:
                // 3 sources

            } while (this.incrementalThread.isAlive());
        }
        if (this.image != null) {
            this.image.dispose();
        }
        try {
            this.image = new Image((Device)this.display, newImageData);
            this.imageData = newImageData;
        }
        catch (SWTException e) {
            this.showErrorDialog(String.valueOf(ImageAnalyzer.bundle.getString("Creating_from")) + " ", this.currentName, e);
            this.image = null;
            return;
        }
        string = ImageAnalyzer.createMsg(ImageAnalyzer.bundle.getString("Analyzer_on"), this.currentName);
        this.shell.setText(string);
        string = this.imageDataArray.length > 1 ? ImageAnalyzer.createMsg(ImageAnalyzer.bundle.getString("Type_index"), new Object[]{this.fileTypeString(this.imageData.type), new Integer(this.imageDataIndex + 1), new Integer(this.imageDataArray.length)}) : ImageAnalyzer.createMsg(ImageAnalyzer.bundle.getString("Type_string"), this.fileTypeString(this.imageData.type));
        this.typeLabel.setText(string);
        string = ImageAnalyzer.createMsg(ImageAnalyzer.bundle.getString("Size_value"), new Object[]{new Integer(this.imageData.width), new Integer(this.imageData.height)});
        this.sizeLabel.setText(string);
        string = ImageAnalyzer.createMsg(ImageAnalyzer.bundle.getString("Depth_value"), new Object[]{new Integer(this.imageData.depth), new Integer(this.display.getDepth())});
        this.depthLabel.setText(string);
        string = ImageAnalyzer.createMsg(ImageAnalyzer.bundle.getString("Transparent_pixel_value"), ImageAnalyzer.pixelInfo(this.imageData.transparentPixel));
        this.transparentPixelLabel.setText(string);
        string = ImageAnalyzer.createMsg(ImageAnalyzer.bundle.getString("Time_to_load_value"), new Long(this.loadTime));
        this.timeToLoadLabel.setText(string);
        string = ImageAnalyzer.createMsg(ImageAnalyzer.bundle.getString("Animation_size_value"), new Object[]{new Integer(this.loader.logicalScreenWidth), new Integer(this.loader.logicalScreenHeight)});
        this.screenSizeLabel.setText(string);
        string = ImageAnalyzer.createMsg(ImageAnalyzer.bundle.getString("Background_pixel_value"), ImageAnalyzer.pixelInfo(this.loader.backgroundPixel));
        this.backgroundPixelLabel.setText(string);
        string = ImageAnalyzer.createMsg(ImageAnalyzer.bundle.getString("Image_location_value"), new Object[]{new Integer(this.imageData.x), new Integer(this.imageData.y)});
        this.locationLabel.setText(string);
        string = ImageAnalyzer.createMsg(ImageAnalyzer.bundle.getString("Disposal_value"), new Object[]{new Integer(this.imageData.disposalMethod), ImageAnalyzer.disposalString(this.imageData.disposalMethod)});
        this.disposalMethodLabel.setText(string);
        delay = this.imageData.delayTime * 10;
        delayUsed = ImageAnalyzer.visibleDelay(delay);
        string = delay != delayUsed ? ImageAnalyzer.createMsg(ImageAnalyzer.bundle.getString("Delay_value"), new Object[]{new Integer(delay), new Integer(delayUsed)}) : ImageAnalyzer.createMsg(ImageAnalyzer.bundle.getString("Delay_used"), new Integer(delay));
        this.delayTimeLabel.setText(string);
        string = this.loader.repeatCount == 0 ? ImageAnalyzer.createMsg(ImageAnalyzer.bundle.getString("Repeats_forever"), new Integer(this.loader.repeatCount)) : ImageAnalyzer.createMsg(ImageAnalyzer.bundle.getString("Repeats_value"), new Integer(this.loader.repeatCount));
        this.repeatCountLabel.setText(string);
        string = this.imageData.palette.isDirect != false ? ImageAnalyzer.bundle.getString("Palette_direct") : ImageAnalyzer.createMsg(ImageAnalyzer.bundle.getString("Palette_value"), new Integer(this.imageData.palette.getRGBs().length));
        this.paletteLabel.setText(string);
        string = ImageAnalyzer.createMsg(ImageAnalyzer.bundle.getString("Pixel_data_value"), new Object[]{new Integer(this.imageData.bytesPerLine), new Integer(this.imageData.scanlinePad), ImageAnalyzer.depthInfo(this.imageData.depth), this.imageData.alphaData != null && this.imageData.alphaData.length > 0 ? ImageAnalyzer.bundle.getString("Scroll_for_alpha") : ""});
        this.dataLabel.setText(string);
        data = this.dataHexDump(this.dataText.getLineDelimiter());
        this.dataText.setText(data);
        index = 0;
        while ((index = data.indexOf(58, index + 1)) != -1) {
            start = index - 4;
            length = 4;
            if (Character.isLetter(data.charAt(index - 1))) {
                start = index - 5;
                length = 5;
            }
            this.dataText.setStyleRange(new StyleRange(start, length, this.dataText.getForeground(), this.dataText.getBackground(), 1));
        }
        this.statusLabel.setText("");
        this.resetScrollBars();
        this.paletteCanvas.redraw();
        this.imageCanvas.redraw();
    }

    void paintImage(PaintEvent event) {
        GC gc = event.gc;
        Image paintImage = this.image;
        int transparentPixel = this.imageData.transparentPixel;
        if (transparentPixel != -1 && !this.transparent) {
            this.imageData.transparentPixel = -1;
            paintImage = new Image((Device)this.display, this.imageData);
        }
        int w = Math.round((float)this.imageData.width * this.xscale);
        int h = Math.round((float)this.imageData.height * this.yscale);
        Rectangle bounds = this.imageCanvas.getBounds();
        if (this.imageData.getTransparencyType() != 0) {
            gc.fillRectangle(0, 0, bounds.width, bounds.height);
        } else {
            if (this.ix + w < bounds.width) {
                gc.fillRectangle(this.ix + w, 0, bounds.width - (this.ix + w), bounds.height);
            }
            if (this.iy + h < bounds.height) {
                gc.fillRectangle(0, this.iy + h, this.ix + w, bounds.height - (this.iy + h));
            }
        }
        gc.drawImage(paintImage, 0, 0, this.imageData.width, this.imageData.height, this.ix + this.imageData.x, this.iy + this.imageData.y, w, h);
        if (this.showMask && this.imageData.getTransparencyType() != 0) {
            ImageData maskImageData = this.imageData.getTransparencyMask();
            Image maskImage = new Image((Device)this.display, maskImageData);
            gc.drawImage(maskImage, 0, 0, this.imageData.width, this.imageData.height, w + 10 + this.ix + this.imageData.x, this.iy + this.imageData.y, w, h);
            maskImage.dispose();
        }
        if (transparentPixel != -1 && !this.transparent) {
            this.imageData.transparentPixel = transparentPixel;
            paintImage.dispose();
        }
    }

    void paintPalette(PaintEvent event) {
        GC gc = event.gc;
        gc.fillRectangle(this.paletteCanvas.getClientArea());
        if (this.imageData.palette.isDirect) {
            int y = this.py + 10;
            int xTab = 50;
            gc.drawString("rMsk", 10, y, true);
            gc.drawString(ImageAnalyzer.toHex4ByteString(this.imageData.palette.redMask), xTab, y, true);
            gc.drawString("gMsk", 10, y += 12, true);
            gc.drawString(ImageAnalyzer.toHex4ByteString(this.imageData.palette.greenMask), xTab, y, true);
            gc.drawString("bMsk", 10, y += 12, true);
            gc.drawString(ImageAnalyzer.toHex4ByteString(this.imageData.palette.blueMask), xTab, y, true);
            gc.drawString("rShf", 10, y += 12, true);
            gc.drawString(Integer.toString(this.imageData.palette.redShift), xTab, y, true);
            gc.drawString("gShf", 10, y += 12, true);
            gc.drawString(Integer.toString(this.imageData.palette.greenShift), xTab, y, true);
            gc.drawString("bShf", 10, y += 12, true);
            gc.drawString(Integer.toString(this.imageData.palette.blueShift), xTab, y, true);
        } else {
            RGB[] rgbs = this.imageData.palette.getRGBs();
            if (rgbs != null) {
                int xTab1 = 40;
                int xTab2 = 100;
                int i = 0;
                while (i < rgbs.length) {
                    int y = (i + 1) * 10 + this.py;
                    gc.drawString(String.valueOf(i), 10, y, true);
                    gc.drawString(String.valueOf(ImageAnalyzer.toHexByteString(rgbs[i].red)) + ImageAnalyzer.toHexByteString(rgbs[i].green) + ImageAnalyzer.toHexByteString(rgbs[i].blue), xTab1, y, true);
                    Color color = new Color((Device)this.display, rgbs[i]);
                    gc.setBackground(color);
                    gc.fillRectangle(xTab2, y + 2, 10, 10);
                    color.dispose();
                    ++i;
                }
            }
        }
    }

    void resizeShell(ControlEvent event) {
        if (this.image == null || this.shell.isDisposed()) {
            return;
        }
        this.resizeScrollBars();
    }

    void resetScaleCombos() {
        this.xscale = 1.0f;
        this.yscale = 1.0f;
        this.scaleXCombo.select(this.scaleXCombo.indexOf("1"));
        this.scaleYCombo.select(this.scaleYCombo.indexOf("1"));
    }

    void resetScrollBars() {
        if (this.image == null) {
            return;
        }
        this.ix = 0;
        this.iy = 0;
        this.py = 0;
        this.resizeScrollBars();
        this.imageCanvas.getHorizontalBar().setSelection(0);
        this.imageCanvas.getVerticalBar().setSelection(0);
        this.paletteCanvas.getVerticalBar().setSelection(0);
    }

    void resizeScrollBars() {
        ScrollBar horizontal = this.imageCanvas.getHorizontalBar();
        ScrollBar vertical = this.imageCanvas.getVerticalBar();
        Rectangle canvasBounds = this.imageCanvas.getClientArea();
        int width = Math.round((float)this.imageData.width * this.xscale);
        if (width > canvasBounds.width) {
            horizontal.setEnabled(true);
            horizontal.setMaximum(width);
            horizontal.setThumb(canvasBounds.width);
            horizontal.setPageIncrement(canvasBounds.width);
        } else {
            horizontal.setEnabled(false);
            if (this.ix != 0) {
                this.ix = 0;
                this.imageCanvas.redraw();
            }
        }
        int height = Math.round((float)this.imageData.height * this.yscale);
        if (height > canvasBounds.height) {
            vertical.setEnabled(true);
            vertical.setMaximum(height);
            vertical.setThumb(canvasBounds.height);
            vertical.setPageIncrement(canvasBounds.height);
        } else {
            vertical.setEnabled(false);
            if (this.iy != 0) {
                this.iy = 0;
                this.imageCanvas.redraw();
            }
        }
        vertical = this.paletteCanvas.getVerticalBar();
        if (this.imageData.palette.isDirect) {
            vertical.setEnabled(false);
        } else {
            canvasBounds = this.paletteCanvas.getClientArea();
            int paletteHeight = this.imageData.palette.getRGBs().length * 10 + 20;
            vertical.setEnabled(true);
            vertical.setMaximum(paletteHeight);
            vertical.setThumb(canvasBounds.height);
            vertical.setPageIncrement(canvasBounds.height);
        }
    }

    void scrollHorizontally(ScrollBar scrollBar) {
        if (this.image == null) {
            return;
        }
        Rectangle canvasBounds = this.imageCanvas.getClientArea();
        int width = Math.round((float)this.imageData.width * this.xscale);
        int height = Math.round((float)this.imageData.height * this.yscale);
        if (width > canvasBounds.width) {
            int x = -scrollBar.getSelection();
            if (x + width < canvasBounds.width) {
                x = canvasBounds.width - width;
            }
            this.imageCanvas.scroll(x, this.iy, this.ix, this.iy, width, height, false);
            this.ix = x;
        }
    }

    void scrollVertically(ScrollBar scrollBar) {
        if (this.image == null) {
            return;
        }
        Rectangle canvasBounds = this.imageCanvas.getClientArea();
        int width = Math.round((float)this.imageData.width * this.xscale);
        int height = Math.round((float)this.imageData.height * this.yscale);
        if (height > canvasBounds.height) {
            int y = -scrollBar.getSelection();
            if (y + height < canvasBounds.height) {
                y = canvasBounds.height - height;
            }
            this.imageCanvas.scroll(this.ix, y, this.ix, this.iy, width, height, false);
            this.iy = y;
        }
    }

    void scrollPalette(ScrollBar scrollBar) {
        if (this.image == null) {
            return;
        }
        Rectangle canvasBounds = this.paletteCanvas.getClientArea();
        int paletteHeight = this.imageData.palette.getRGBs().length * 10 + 20;
        if (paletteHeight > canvasBounds.height) {
            int y = -scrollBar.getSelection();
            if (y + paletteHeight < canvasBounds.height) {
                y = canvasBounds.height - paletteHeight;
            }
            this.paletteCanvas.scroll(0, y, 0, this.py, this.paletteWidth, paletteHeight, false);
            this.py = y;
        }
    }

    String dataHexDump(String lineDelimiter) {
        if (this.image == null) {
            return "";
        }
        boolean truncated = false;
        char[] dump = null;
        byte[] alphas = this.imageData.alphaData;
        try {
            int length = this.imageData.height * (6 + 3 * this.imageData.bytesPerLine + lineDelimiter.length());
            if (alphas != null && alphas.length > 0) {
                length += this.imageData.height * (6 + 3 * this.imageData.width + lineDelimiter.length()) + 6 + lineDelimiter.length();
            }
            dump = new char[length];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            dump = new char[0x100000];
            truncated = true;
        }
        int index = 0;
        try {
            byte b;
            int line;
            int i = 0;
            while (i < this.imageData.data.length) {
                if (i % this.imageData.bytesPerLine == 0) {
                    line = i / this.imageData.bytesPerLine;
                    dump[index++] = Character.forDigit(line / 1000 % 10, 10);
                    dump[index++] = Character.forDigit(line / 100 % 10, 10);
                    dump[index++] = Character.forDigit(line / 10 % 10, 10);
                    dump[index++] = Character.forDigit(line % 10, 10);
                    dump[index++] = 58;
                    dump[index++] = 32;
                }
                b = this.imageData.data[i];
                dump[index++] = Character.forDigit((b & 0xF0) >> 4, 16);
                dump[index++] = Character.forDigit(b & 0xF, 16);
                dump[index++] = 32;
                if ((i + 1) % this.imageData.bytesPerLine == 0) {
                    dump[index++] = lineDelimiter.charAt(0);
                    if (lineDelimiter.length() > 1) {
                        dump[index++] = lineDelimiter.charAt(1);
                    }
                }
                ++i;
            }
            if (alphas != null && alphas.length > 0) {
                dump[index++] = lineDelimiter.charAt(0);
                if (lineDelimiter.length() > 1) {
                    dump[index++] = lineDelimiter.charAt(1);
                }
                System.arraycopy(new char[]{'A', 'l', 'p', 'h', 'a', ':'}, 0, dump, index, 6);
                index += 6;
                dump[index++] = lineDelimiter.charAt(0);
                if (lineDelimiter.length() > 1) {
                    dump[index++] = lineDelimiter.charAt(1);
                }
                i = 0;
                while (i < alphas.length) {
                    if (i % this.imageData.width == 0) {
                        line = i / this.imageData.width;
                        dump[index++] = Character.forDigit(line / 1000 % 10, 10);
                        dump[index++] = Character.forDigit(line / 100 % 10, 10);
                        dump[index++] = Character.forDigit(line / 10 % 10, 10);
                        dump[index++] = Character.forDigit(line % 10, 10);
                        dump[index++] = 58;
                        dump[index++] = 32;
                    }
                    b = alphas[i];
                    dump[index++] = Character.forDigit((b & 0xF0) >> 4, 16);
                    dump[index++] = Character.forDigit(b & 0xF, 16);
                    dump[index++] = 32;
                    if ((i + 1) % this.imageData.width == 0) {
                        dump[index++] = lineDelimiter.charAt(0);
                        if (lineDelimiter.length() > 1) {
                            dump[index++] = lineDelimiter.charAt(1);
                        }
                    }
                    ++i;
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        String result = "";
        try {
            result = new String(dump);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            result = new String(dump, 0, 0x100000);
            truncated = true;
        }
        if (truncated) {
            result = String.valueOf(result) + "\n ...data dump truncated at 1048576bytes...";
        }
        return result;
    }

    void showErrorDialog(String operation, String filename, Throwable e) {
        MessageBox box = new MessageBox(this.shell, 1);
        String message = ImageAnalyzer.createMsg(bundle.getString("Error"), new String[]{operation, filename});
        String errorMessage = "";
        if (e != null) {
            if (e instanceof SWTException) {
                SWTException swte = (SWTException)e;
                errorMessage = swte.getMessage();
                if (swte.throwable != null) {
                    errorMessage = String.valueOf(errorMessage) + ":\n" + swte.throwable.toString();
                }
            } else if (e instanceof SWTError) {
                SWTError swte = (SWTError)e;
                errorMessage = swte.getMessage();
                if (swte.throwable != null) {
                    errorMessage = String.valueOf(errorMessage) + ":\n" + swte.throwable.toString();
                }
            } else {
                errorMessage = e.toString();
            }
        }
        box.setMessage(String.valueOf(message) + errorMessage);
        box.open();
    }

    int showBMPDialog() {
        final int[] bmpType = new int[]{0};
        SelectionAdapter radioSelected = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button radio = (Button)event.widget;
                if (radio.getSelection()) {
                    bmpType[0] = (Integer)radio.getData();
                }
            }
        };
        final Shell dialog = new Shell(this.shell, 2144);
        dialog.setText(bundle.getString("Save_as_type"));
        dialog.setLayout((Layout)new GridLayout());
        Label label = new Label((Composite)dialog, 0);
        label.setText(bundle.getString("Save_as_type_label"));
        Button radio = new Button((Composite)dialog, 16);
        radio.setText(bundle.getString("Save_as_type_no_compress"));
        radio.setSelection(true);
        radio.setData((Object)new Integer(0));
        radio.addSelectionListener((SelectionListener)radioSelected);
        radio = new Button((Composite)dialog, 16);
        radio.setText(bundle.getString("Save_as_type_rle_compress"));
        radio.setData((Object)new Integer(1));
        radio.addSelectionListener((SelectionListener)radioSelected);
        radio = new Button((Composite)dialog, 16);
        radio.setText(bundle.getString("Save_as_type_os2"));
        radio.setData((Object)new Integer(7));
        radio.addSelectionListener((SelectionListener)radioSelected);
        label = new Label((Composite)dialog, 258);
        label.setLayoutData((Object)new GridData(768));
        Button ok = new Button((Composite)dialog, 8);
        ok.setText(bundle.getString("OK"));
        GridData data = new GridData();
        data.horizontalAlignment = 0x1000000;
        data.widthHint = 75;
        ok.setLayoutData((Object)data);
        ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                dialog.close();
            }
        });
        dialog.pack();
        dialog.open();
        while (!dialog.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        return bmpType[0];
    }

    static String depthInfo(int depth) {
        Object[] args = new Object[]{new Integer(depth), ""};
        switch (depth) {
            case 1: {
                args[1] = ImageAnalyzer.createMsg(bundle.getString("Multi_pixels"), new Object[]{new Integer(8), " [01234567]"});
                break;
            }
            case 2: {
                args[1] = ImageAnalyzer.createMsg(bundle.getString("Multi_pixels"), new Object[]{new Integer(4), "[00112233]"});
                break;
            }
            case 4: {
                args[1] = ImageAnalyzer.createMsg(bundle.getString("Multi_pixels"), new Object[]{new Integer(2), "[00001111]"});
                break;
            }
            case 8: {
                args[1] = bundle.getString("One_byte");
                break;
            }
            case 16: {
                args[1] = ImageAnalyzer.createMsg(bundle.getString("Multi_bytes"), new Integer(2));
                break;
            }
            case 24: {
                args[1] = ImageAnalyzer.createMsg(bundle.getString("Multi_bytes"), new Integer(3));
                break;
            }
            case 32: {
                args[1] = ImageAnalyzer.createMsg(bundle.getString("Multi_bytes"), new Integer(4));
                break;
            }
            default: {
                args[1] = bundle.getString("Unsupported_lc");
            }
        }
        return ImageAnalyzer.createMsg(bundle.getString("Depth_info"), args);
    }

    static int visibleDelay(int ms) {
        if (ms < 20) {
            return ms + 30;
        }
        if (ms < 30) {
            return ms + 10;
        }
        return ms;
    }

    static String toHexByteString(int i) {
        if (i <= 15) {
            return "0" + Integer.toHexString(i);
        }
        return Integer.toHexString(i & 0xFF);
    }

    static String toHex4ByteString(int i) {
        String hex = Integer.toHexString(i);
        if (hex.length() == 1) {
            return "0000000" + hex;
        }
        if (hex.length() == 2) {
            return "000000" + hex;
        }
        if (hex.length() == 3) {
            return "00000" + hex;
        }
        if (hex.length() == 4) {
            return "0000" + hex;
        }
        if (hex.length() == 5) {
            return "000" + hex;
        }
        if (hex.length() == 6) {
            return "00" + hex;
        }
        if (hex.length() == 7) {
            return "0" + hex;
        }
        return hex;
    }

    static String pixelInfo(int pixel) {
        if (pixel == -1) {
            return String.valueOf(pixel) + " (" + bundle.getString("None_lc") + ")";
        }
        return String.valueOf(pixel) + " (0x" + Integer.toHexString(pixel) + ")";
    }

    static String disposalString(int disposalMethod) {
        switch (disposalMethod) {
            case 1: {
                return bundle.getString("None_lc");
            }
            case 2: {
                return bundle.getString("Background_lc");
            }
            case 3: {
                return bundle.getString("Previous_lc");
            }
        }
        return bundle.getString("Unspecified_lc");
    }

    String fileTypeString(int filetype) {
        if (filetype == 0) {
            return "BMP";
        }
        if (filetype == 1) {
            return "RLE" + this.imageData.depth + " BMP";
        }
        if (filetype == 7) {
            return "OS/2 BMP";
        }
        if (filetype == 2) {
            return "GIF";
        }
        if (filetype == 3) {
            return "ICO";
        }
        if (filetype == 4) {
            return "JPEG";
        }
        if (filetype == 5) {
            return "PNG";
        }
        if (filetype == 6) {
            return "TIFF";
        }
        return bundle.getString("Unknown_ac");
    }

    int determineFileType(String filename) {
        String ext = filename.substring(filename.lastIndexOf(46) + 1);
        if (ext.equalsIgnoreCase("bmp")) {
            return this.showBMPDialog();
        }
        if (ext.equalsIgnoreCase("gif")) {
            return 2;
        }
        if (ext.equalsIgnoreCase("ico")) {
            return 3;
        }
        if (ext.equalsIgnoreCase("jpg") || ext.equalsIgnoreCase("jpeg") || ext.equalsIgnoreCase("jfif")) {
            return 4;
        }
        if (ext.equalsIgnoreCase("png")) {
            return 5;
        }
        if (ext.equalsIgnoreCase("tif") || ext.equalsIgnoreCase("tiff")) {
            return 6;
        }
        return -1;
    }

    void showFileType(String filename) {
        String ext = filename.substring(filename.lastIndexOf(46) + 1);
        if (ext.equalsIgnoreCase("jpg") || ext.equalsIgnoreCase("jpeg") || ext.equalsIgnoreCase("jfif")) {
            this.imageTypeCombo.select(0);
            this.compressionCombo.setEnabled(true);
            this.compressionRatioLabel.setEnabled(true);
            if (this.compressionCombo.getItemCount() == 100) {
                return;
            }
            this.compressionCombo.removeAll();
            int i = 0;
            while (i < 100) {
                this.compressionCombo.add(String.valueOf(i + 1));
                ++i;
            }
            this.compressionCombo.select(this.compressionCombo.indexOf("75"));
            return;
        }
        if (ext.equalsIgnoreCase("png")) {
            this.imageTypeCombo.select(1);
            this.compressionCombo.setEnabled(true);
            this.compressionRatioLabel.setEnabled(true);
            if (this.compressionCombo.getItemCount() == 10) {
                return;
            }
            this.compressionCombo.removeAll();
            int i = 0;
            while (i < 4) {
                this.compressionCombo.add(String.valueOf(i));
                ++i;
            }
            this.compressionCombo.select(0);
            return;
        }
        if (ext.equalsIgnoreCase("bmp")) {
            this.imageTypeCombo.select(5);
        }
        if (ext.equalsIgnoreCase("gif")) {
            this.imageTypeCombo.select(2);
        }
        if (ext.equalsIgnoreCase("ico")) {
            this.imageTypeCombo.select(3);
        }
        if (ext.equalsIgnoreCase("tif") || ext.equalsIgnoreCase("tiff")) {
            this.imageTypeCombo.select(4);
        }
        this.compressionCombo.setEnabled(false);
        this.compressionRatioLabel.setEnabled(false);
    }

    static String createMsg(String msg, Object[] args) {
        MessageFormat formatter = new MessageFormat(msg);
        return formatter.format(args);
    }

    static String createMsg(String msg, Object arg) {
        MessageFormat formatter = new MessageFormat(msg);
        return formatter.format(new Object[]{arg});
    }

    class TextPrompter
    extends Dialog {
        String message;
        String result;
        Shell dialog;
        Text text;

        public TextPrompter(Shell parent, int style) {
            super(parent, style);
            this.message = "";
            this.result = null;
        }

        public TextPrompter(Shell parent) {
            this(parent, 65536);
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String string) {
            this.message = string;
        }

        public String open() {
            this.dialog = new Shell(this.getParent(), this.getStyle());
            this.dialog.setText(this.getText());
            this.dialog.setLayout((Layout)new GridLayout());
            Label label = new Label((Composite)this.dialog, 0);
            label.setText(this.message);
            label.setLayoutData((Object)new GridData(768));
            this.text = new Text((Composite)this.dialog, 2052);
            GridData data = new GridData(768);
            data.widthHint = 300;
            this.text.setLayoutData((Object)data);
            Composite buttons = new Composite((Composite)this.dialog, 0);
            GridLayout grid = new GridLayout();
            grid.numColumns = 2;
            buttons.setLayout((Layout)grid);
            buttons.setLayoutData((Object)new GridData(128));
            Button ok = new Button(buttons, 8);
            ok.setText(bundle.getString("OK"));
            data = new GridData();
            data.widthHint = 75;
            ok.setLayoutData((Object)data);
            ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TextPrompter.this.result = TextPrompter.this.text.getText();
                    TextPrompter.this.dialog.dispose();
                }
            });
            Button cancel = new Button(buttons, 8);
            cancel.setText(bundle.getString("Cancel"));
            data = new GridData();
            data.widthHint = 75;
            cancel.setLayoutData((Object)data);
            cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TextPrompter.this.dialog.dispose();
                }
            });
            this.dialog.setDefaultButton(ok);
            this.dialog.pack();
            this.dialog.open();
            while (!this.dialog.isDisposed()) {
                if (ImageAnalyzer.this.display.readAndDispatch()) continue;
                ImageAnalyzer.this.display.sleep();
            }
            return this.result;
        }
    }
}

