/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.layoutexample;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.examples.layoutexample.LayoutExample;
import org.eclipse.swt.examples.layoutexample.Tab;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

class FillLayoutTab
extends Tab {
    Button horizontal;
    Button vertical;
    Spinner marginWidth;
    Spinner marginHeight;
    Spinner spacing;
    FillLayout fillLayout;
    TableEditor comboEditor;
    TableEditor nameEditor;
    CCombo combo;
    Text nameText;
    final int NAME_COL = 0;
    final int TOTAL_COLS = 2;

    FillLayoutTab(LayoutExample instance) {
        super(instance);
    }

    void createChildWidgets() {
        super.createChildWidgets();
        this.comboEditor = new TableEditor(this.table);
        this.nameEditor = new TableEditor(this.table);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                FillLayoutTab.this.resetEditors();
                FillLayoutTab.this.index = FillLayoutTab.this.table.getSelectionIndex();
                if (FillLayoutTab.this.index == -1) {
                    return;
                }
                TableItem oldItem = FillLayoutTab.this.comboEditor.getItem();
                FillLayoutTab.this.newItem = FillLayoutTab.this.table.getItem(FillLayoutTab.this.index);
                if (FillLayoutTab.this.newItem == oldItem || FillLayoutTab.this.newItem != FillLayoutTab.this.lastSelected) {
                    FillLayoutTab.this.lastSelected = FillLayoutTab.this.newItem;
                    return;
                }
                FillLayoutTab.this.table.showSelection();
                FillLayoutTab.this.combo = new CCombo((Composite)FillLayoutTab.this.table, 8);
                FillLayoutTab.this.createComboEditor(FillLayoutTab.this.combo, FillLayoutTab.this.comboEditor);
                FillLayoutTab.this.nameText = new Text((Composite)FillLayoutTab.this.table, 4);
                FillLayoutTab.this.nameText.setText(((String[])FillLayoutTab.this.data.elementAt(FillLayoutTab.this.index))[0]);
                FillLayoutTab.this.createTextEditor(FillLayoutTab.this.nameText, FillLayoutTab.this.nameEditor, 0);
            }
        });
    }

    void createControlWidgets() {
        Group typeGroup = new Group((Composite)this.controlGroup, 0);
        typeGroup.setText(LayoutExample.getResourceString("Type"));
        typeGroup.setLayout((Layout)new GridLayout());
        typeGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.horizontal = new Button((Composite)typeGroup, 16);
        this.horizontal.setText("SWT.HORIZONTAL");
        this.horizontal.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.horizontal.setSelection(true);
        this.horizontal.addSelectionListener(this.selectionListener);
        this.vertical = new Button((Composite)typeGroup, 16);
        this.vertical.setText("SWT.VERTICAL");
        this.vertical.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.vertical.addSelectionListener(this.selectionListener);
        Group marginGroup = new Group((Composite)this.controlGroup, 0);
        marginGroup.setText(LayoutExample.getResourceString("Margins_Spacing"));
        marginGroup.setLayout((Layout)new GridLayout(2, false));
        marginGroup.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        new Label((Composite)marginGroup, 0).setText("marginWidth");
        this.marginWidth = new Spinner((Composite)marginGroup, 2048);
        this.marginWidth.setSelection(0);
        this.marginWidth.addSelectionListener(this.selectionListener);
        new Label((Composite)marginGroup, 0).setText("marginHeight");
        this.marginHeight = new Spinner((Composite)marginGroup, 2048);
        this.marginHeight.setSelection(0);
        this.marginHeight.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.marginHeight.addSelectionListener(this.selectionListener);
        new Label((Composite)marginGroup, 0).setText("spacing");
        this.spacing = new Spinner((Composite)marginGroup, 2048);
        this.spacing.setSelection(0);
        this.spacing.addSelectionListener(this.selectionListener);
        super.createControlWidgets();
    }

    void createLayout() {
        this.fillLayout = new FillLayout();
        this.layoutComposite.setLayout((Layout)this.fillLayout);
    }

    void disposeEditors() {
        this.comboEditor.setEditor(null, null, -1);
        this.combo.dispose();
        this.nameText.dispose();
    }

    StringBuffer generateLayoutCode() {
        StringBuffer code = new StringBuffer();
        code.append("\t\tFillLayout fillLayout = new FillLayout ();\n");
        if (this.fillLayout.type == 512) {
            code.append("\t\tfillLayout.type = SWT.VERTICAL;\n");
        }
        if (this.fillLayout.marginWidth != 0) {
            code.append("\t\tfillLayout.marginWidth = " + this.fillLayout.marginWidth + ";\n");
        }
        if (this.fillLayout.marginHeight != 0) {
            code.append("\t\tfillLayout.marginHeight = " + this.fillLayout.marginHeight + ";\n");
        }
        if (this.fillLayout.spacing != 0) {
            code.append("\t\tfillLayout.spacing = " + this.fillLayout.spacing + ";\n");
        }
        code.append("\t\tshell.setLayout (fillLayout);\n");
        int i = 0;
        while (i < this.children.length) {
            Control control = this.children[i];
            code.append(this.getChildCode(control, i));
            ++i;
        }
        return code;
    }

    String[] getInsertString(String name, String controlType) {
        return new String[]{name, controlType};
    }

    String[] getLayoutDataFieldNames() {
        return new String[]{"Control Name", "Control Type"};
    }

    String getTabText() {
        return "FillLayout";
    }

    void resetEditors(boolean tab) {
        TableItem oldItem = this.comboEditor.getItem();
        this.comboEditor.setEditor(null, null, -1);
        if (oldItem != null) {
            int row = this.table.indexOf(oldItem);
            try {
                new String(this.nameText.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.nameText.setText(oldItem.getText(0));
            }
            String[] insert = new String[]{this.nameText.getText(), this.combo.getText()};
            this.data.setElementAt(insert, row);
            int i = 0;
            while (i < 2) {
                oldItem.setText(i, ((String[])this.data.elementAt(row))[i]);
                ++i;
            }
            if (!tab) {
                this.disposeEditors();
            }
        }
        this.setLayoutState();
        this.refreshLayoutComposite();
        this.layoutComposite.layout(true);
        this.layoutGroup.layout(true);
    }

    void setLayoutState() {
        this.fillLayout.type = this.vertical.getSelection() ? 512 : 256;
        this.fillLayout.marginWidth = this.marginWidth.getSelection();
        this.fillLayout.marginHeight = this.marginHeight.getSelection();
        this.fillLayout.spacing = this.spacing.getSelection();
    }
}

