/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.layoutexample;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.examples.layoutexample.LayoutExample;
import org.eclipse.swt.examples.layoutexample.Tab;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

class GridLayoutTab
extends Tab {
    Spinner numColumns;
    Button makeColumnsEqualWidth;
    Spinner marginWidth;
    Spinner marginHeight;
    Spinner marginLeft;
    Spinner marginRight;
    Spinner marginTop;
    Spinner marginBottom;
    Spinner horizontalSpacing;
    Spinner verticalSpacing;
    GridLayout gridLayout;
    TableEditor nameEditor;
    TableEditor comboEditor;
    TableEditor widthEditor;
    TableEditor heightEditor;
    TableEditor vAlignEditor;
    TableEditor hAlignEditor;
    TableEditor hGrabEditor;
    TableEditor vGrabEditor;
    TableEditor hSpanEditor;
    TableEditor vSpanEditor;
    TableEditor hIndentEditor;
    TableEditor vIndentEditor;
    TableEditor minWidthEditor;
    TableEditor minHeightEditor;
    TableEditor excludeEditor;
    CCombo combo;
    CCombo vAlign;
    CCombo hAlign;
    CCombo hGrab;
    CCombo vGrab;
    CCombo exclude;
    Text nameText;
    Text widthText;
    Text heightText;
    Text hSpan;
    Text vSpan;
    Text hIndent;
    Text vIndent;
    Text minWidthText;
    Text minHeightText;
    static final int NAME_COL = 0;
    static final int COMBO_COL = 1;
    static final int WIDTH_COL = 2;
    static final int HEIGHT_COL = 3;
    static final int HALIGN_COL = 4;
    static final int VALIGN_COL = 5;
    static final int HGRAB_COL = 6;
    static final int VGRAB_COL = 7;
    static final int HSPAN_COL = 8;
    static final int VSPAN_COL = 9;
    static final int HINDENT_COL = 10;
    static final int VINDENT_COL = 11;
    static final int MINWIDTH_COL = 12;
    static final int MINHEIGHT_COL = 13;
    static final int EXCLUDE_COL = 14;
    static final int TOTAL_COLS = 15;

    GridLayoutTab(LayoutExample instance) {
        super(instance);
    }

    void createChildWidgets() {
        final TraverseListener traverseListener = new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4 || e.detail == 16) {
                    GridLayoutTab.this.resetEditors();
                }
                if (e.detail == 2) {
                    GridLayoutTab.this.disposeEditors();
                }
            }
        };
        super.createChildWidgets();
        this.table.getColumn(4).setToolTipText("horizontalAlignment");
        this.table.getColumn(5).setToolTipText("verticalAlignment");
        this.table.getColumn(6).setToolTipText("grabExcessHorizontalSpace");
        this.table.getColumn(7).setToolTipText("grabExcessVerticalSpace");
        this.table.getColumn(8).setToolTipText("horizontalSpan");
        this.table.getColumn(9).setToolTipText("verticalSpan");
        this.table.getColumn(10).setToolTipText("horizontalIndent");
        this.table.getColumn(11).setToolTipText("verticalIndent");
        this.table.getColumn(12).setToolTipText("minimumWidth");
        this.table.getColumn(13).setToolTipText("minimumHeight");
        this.nameEditor = new TableEditor(this.table);
        this.comboEditor = new TableEditor(this.table);
        this.widthEditor = new TableEditor(this.table);
        this.heightEditor = new TableEditor(this.table);
        this.vAlignEditor = new TableEditor(this.table);
        this.hAlignEditor = new TableEditor(this.table);
        this.hGrabEditor = new TableEditor(this.table);
        this.vGrabEditor = new TableEditor(this.table);
        this.hSpanEditor = new TableEditor(this.table);
        this.vSpanEditor = new TableEditor(this.table);
        this.hIndentEditor = new TableEditor(this.table);
        this.vIndentEditor = new TableEditor(this.table);
        this.minWidthEditor = new TableEditor(this.table);
        this.minHeightEditor = new TableEditor(this.table);
        this.excludeEditor = new TableEditor(this.table);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                GridLayoutTab.this.resetEditors();
                GridLayoutTab.this.index = GridLayoutTab.this.table.getSelectionIndex();
                Point pt = new Point(e.x, e.y);
                GridLayoutTab.this.newItem = GridLayoutTab.this.table.getItem(pt);
                if (GridLayoutTab.this.newItem == null) {
                    return;
                }
                TableItem oldItem = GridLayoutTab.this.comboEditor.getItem();
                if (GridLayoutTab.this.newItem == oldItem || GridLayoutTab.this.newItem != GridLayoutTab.this.lastSelected) {
                    GridLayoutTab.this.lastSelected = GridLayoutTab.this.newItem;
                    return;
                }
                GridLayoutTab.this.table.showSelection();
                GridLayoutTab.this.nameText = new Text((Composite)GridLayoutTab.this.table, 4);
                GridLayoutTab.this.nameText.setText(((String[])GridLayoutTab.this.data.elementAt(GridLayoutTab.this.index))[0]);
                GridLayoutTab.this.createTextEditor(GridLayoutTab.this.nameText, GridLayoutTab.this.nameEditor, 0);
                GridLayoutTab.this.combo = new CCombo((Composite)GridLayoutTab.this.table, 8);
                GridLayoutTab.this.createComboEditor(GridLayoutTab.this.combo, GridLayoutTab.this.comboEditor);
                GridLayoutTab.this.widthText = new Text((Composite)GridLayoutTab.this.table, 4);
                GridLayoutTab.this.widthText.setText(((String[])GridLayoutTab.this.data.elementAt(GridLayoutTab.this.index))[2]);
                GridLayoutTab.this.createTextEditor(GridLayoutTab.this.widthText, GridLayoutTab.this.widthEditor, 2);
                GridLayoutTab.this.heightText = new Text((Composite)GridLayoutTab.this.table, 4);
                GridLayoutTab.this.heightText.setText(((String[])GridLayoutTab.this.data.elementAt(GridLayoutTab.this.index))[3]);
                GridLayoutTab.this.createTextEditor(GridLayoutTab.this.heightText, GridLayoutTab.this.heightEditor, 3);
                String[] alignValues = new String[]{"BEGINNING", "CENTER", "END", "FILL"};
                GridLayoutTab.this.hAlign = new CCombo((Composite)GridLayoutTab.this.table, 0);
                GridLayoutTab.this.hAlign.setItems(alignValues);
                GridLayoutTab.this.hAlign.setText(GridLayoutTab.this.newItem.getText(4));
                GridLayoutTab.this.hAlignEditor.horizontalAlignment = 16384;
                GridLayoutTab.this.hAlignEditor.grabHorizontal = true;
                GridLayoutTab.this.hAlignEditor.minimumWidth = 50;
                GridLayoutTab.this.hAlignEditor.setEditor((Control)GridLayoutTab.this.hAlign, GridLayoutTab.this.newItem, 4);
                GridLayoutTab.this.hAlign.addTraverseListener(traverseListener);
                GridLayoutTab.this.vAlign = new CCombo((Composite)GridLayoutTab.this.table, 0);
                GridLayoutTab.this.vAlign.setItems(alignValues);
                GridLayoutTab.this.vAlign.setText(GridLayoutTab.this.newItem.getText(5));
                GridLayoutTab.this.vAlignEditor.horizontalAlignment = 16384;
                GridLayoutTab.this.vAlignEditor.grabHorizontal = true;
                GridLayoutTab.this.vAlignEditor.minimumWidth = 50;
                GridLayoutTab.this.vAlignEditor.setEditor((Control)GridLayoutTab.this.vAlign, GridLayoutTab.this.newItem, 5);
                GridLayoutTab.this.vAlign.addTraverseListener(traverseListener);
                String[] boolValues = new String[]{"false", "true"};
                GridLayoutTab.this.hGrab = new CCombo((Composite)GridLayoutTab.this.table, 0);
                GridLayoutTab.this.hGrab.setItems(boolValues);
                GridLayoutTab.this.hGrab.setText(GridLayoutTab.this.newItem.getText(6));
                GridLayoutTab.this.hGrabEditor.horizontalAlignment = 16384;
                GridLayoutTab.this.hGrabEditor.grabHorizontal = true;
                GridLayoutTab.this.hGrabEditor.minimumWidth = 50;
                GridLayoutTab.this.hGrabEditor.setEditor((Control)GridLayoutTab.this.hGrab, GridLayoutTab.this.newItem, 6);
                GridLayoutTab.this.hGrab.addTraverseListener(traverseListener);
                GridLayoutTab.this.vGrab = new CCombo((Composite)GridLayoutTab.this.table, 0);
                GridLayoutTab.this.vGrab.setItems(boolValues);
                GridLayoutTab.this.vGrab.setText(GridLayoutTab.this.newItem.getText(7));
                GridLayoutTab.this.vGrabEditor.horizontalAlignment = 16384;
                GridLayoutTab.this.vGrabEditor.grabHorizontal = true;
                GridLayoutTab.this.vGrabEditor.minimumWidth = 50;
                GridLayoutTab.this.vGrabEditor.setEditor((Control)GridLayoutTab.this.vGrab, GridLayoutTab.this.newItem, 7);
                GridLayoutTab.this.vGrab.addTraverseListener(traverseListener);
                GridLayoutTab.this.hSpan = new Text((Composite)GridLayoutTab.this.table, 4);
                GridLayoutTab.this.hSpan.setText(((String[])GridLayoutTab.this.data.elementAt(GridLayoutTab.this.index))[8]);
                GridLayoutTab.this.createTextEditor(GridLayoutTab.this.hSpan, GridLayoutTab.this.hSpanEditor, 8);
                GridLayoutTab.this.vSpan = new Text((Composite)GridLayoutTab.this.table, 4);
                GridLayoutTab.this.vSpan.setText(((String[])GridLayoutTab.this.data.elementAt(GridLayoutTab.this.index))[9]);
                GridLayoutTab.this.createTextEditor(GridLayoutTab.this.vSpan, GridLayoutTab.this.vSpanEditor, 9);
                GridLayoutTab.this.hIndent = new Text((Composite)GridLayoutTab.this.table, 4);
                GridLayoutTab.this.hIndent.setText(((String[])GridLayoutTab.this.data.elementAt(GridLayoutTab.this.index))[10]);
                GridLayoutTab.this.createTextEditor(GridLayoutTab.this.hIndent, GridLayoutTab.this.hIndentEditor, 10);
                GridLayoutTab.this.vIndent = new Text((Composite)GridLayoutTab.this.table, 4);
                GridLayoutTab.this.vIndent.setText(((String[])GridLayoutTab.this.data.elementAt(GridLayoutTab.this.index))[11]);
                GridLayoutTab.this.createTextEditor(GridLayoutTab.this.vIndent, GridLayoutTab.this.vIndentEditor, 11);
                GridLayoutTab.this.minWidthText = new Text((Composite)GridLayoutTab.this.table, 4);
                GridLayoutTab.this.minWidthText.setText(((String[])GridLayoutTab.this.data.elementAt(GridLayoutTab.this.index))[12]);
                GridLayoutTab.this.createTextEditor(GridLayoutTab.this.minWidthText, GridLayoutTab.this.minWidthEditor, 12);
                GridLayoutTab.this.minHeightText = new Text((Composite)GridLayoutTab.this.table, 4);
                GridLayoutTab.this.minHeightText.setText(((String[])GridLayoutTab.this.data.elementAt(GridLayoutTab.this.index))[13]);
                GridLayoutTab.this.createTextEditor(GridLayoutTab.this.minHeightText, GridLayoutTab.this.minHeightEditor, 13);
                GridLayoutTab.this.exclude = new CCombo((Composite)GridLayoutTab.this.table, 0);
                GridLayoutTab.this.exclude.setItems(boolValues);
                GridLayoutTab.this.exclude.setText(GridLayoutTab.this.newItem.getText(14));
                GridLayoutTab.this.excludeEditor.horizontalAlignment = 16384;
                GridLayoutTab.this.excludeEditor.grabHorizontal = true;
                GridLayoutTab.this.excludeEditor.minimumWidth = 50;
                GridLayoutTab.this.excludeEditor.setEditor((Control)GridLayoutTab.this.exclude, GridLayoutTab.this.newItem, 14);
                GridLayoutTab.this.exclude.addTraverseListener(traverseListener);
                int i = 0;
                while (i < GridLayoutTab.this.table.getColumnCount()) {
                    Rectangle rect = GridLayoutTab.this.newItem.getBounds(i);
                    if (rect.contains(pt)) {
                        switch (i) {
                            case 0: {
                                GridLayoutTab.this.nameText.setFocus();
                                break;
                            }
                            case 1: {
                                GridLayoutTab.this.combo.setFocus();
                                break;
                            }
                            case 2: {
                                GridLayoutTab.this.widthText.setFocus();
                                break;
                            }
                            case 3: {
                                GridLayoutTab.this.heightText.setFocus();
                                break;
                            }
                            case 4: {
                                GridLayoutTab.this.hAlign.setFocus();
                                break;
                            }
                            case 5: {
                                GridLayoutTab.this.vAlign.setFocus();
                                break;
                            }
                            case 6: {
                                GridLayoutTab.this.hGrab.setFocus();
                                break;
                            }
                            case 7: {
                                GridLayoutTab.this.vGrab.setFocus();
                                break;
                            }
                            case 8: {
                                GridLayoutTab.this.hSpan.setFocus();
                                break;
                            }
                            case 9: {
                                GridLayoutTab.this.vSpan.setFocus();
                                break;
                            }
                            case 10: {
                                GridLayoutTab.this.hIndent.setFocus();
                                break;
                            }
                            case 11: {
                                GridLayoutTab.this.vIndent.setFocus();
                                break;
                            }
                            case 12: {
                                GridLayoutTab.this.minWidthText.setFocus();
                                break;
                            }
                            case 13: {
                                GridLayoutTab.this.minHeightText.setFocus();
                                break;
                            }
                            case 14: {
                                GridLayoutTab.this.exclude.setFocus();
                                break;
                            }
                            default: {
                                GridLayoutTab.this.resetEditors();
                            }
                        }
                    }
                    ++i;
                }
            }
        });
    }

    void createControlWidgets() {
        Group columnGroup = new Group((Composite)this.controlGroup, 0);
        columnGroup.setText(LayoutExample.getResourceString("Columns"));
        columnGroup.setLayout((Layout)new GridLayout(2, false));
        columnGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        new Label((Composite)columnGroup, 0).setText("numColumns");
        this.numColumns = new Spinner((Composite)columnGroup, 2048);
        this.numColumns.setMinimum(1);
        this.numColumns.addSelectionListener(this.selectionListener);
        this.makeColumnsEqualWidth = new Button((Composite)columnGroup, 32);
        this.makeColumnsEqualWidth.setText("makeColumnsEqualWidth");
        this.makeColumnsEqualWidth.addSelectionListener(this.selectionListener);
        this.makeColumnsEqualWidth.setEnabled(false);
        this.makeColumnsEqualWidth.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        Group marginGroup = new Group((Composite)this.controlGroup, 0);
        marginGroup.setText(LayoutExample.getResourceString("Margins_Spacing"));
        marginGroup.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        marginGroup.setLayout((Layout)new GridLayout(2, false));
        new Label((Composite)marginGroup, 0).setText("marginWidth");
        this.marginWidth = new Spinner((Composite)marginGroup, 2048);
        this.marginWidth.setSelection(5);
        this.marginWidth.addSelectionListener(this.selectionListener);
        new Label((Composite)marginGroup, 0).setText("marginHeight");
        this.marginHeight = new Spinner((Composite)marginGroup, 2048);
        this.marginHeight.setSelection(5);
        this.marginHeight.addSelectionListener(this.selectionListener);
        new Label((Composite)marginGroup, 0).setText("marginLeft");
        this.marginLeft = new Spinner((Composite)marginGroup, 2048);
        this.marginLeft.setSelection(0);
        this.marginLeft.addSelectionListener(this.selectionListener);
        new Label((Composite)marginGroup, 0).setText("marginRight");
        this.marginRight = new Spinner((Composite)marginGroup, 2048);
        this.marginRight.setSelection(0);
        this.marginRight.addSelectionListener(this.selectionListener);
        new Label((Composite)marginGroup, 0).setText("marginTop");
        this.marginTop = new Spinner((Composite)marginGroup, 2048);
        this.marginTop.setSelection(0);
        this.marginTop.addSelectionListener(this.selectionListener);
        new Label((Composite)marginGroup, 0).setText("marginBottom");
        this.marginBottom = new Spinner((Composite)marginGroup, 2048);
        this.marginBottom.setSelection(0);
        this.marginBottom.addSelectionListener(this.selectionListener);
        new Label((Composite)marginGroup, 0).setText("horizontalSpacing");
        this.horizontalSpacing = new Spinner((Composite)marginGroup, 2048);
        this.horizontalSpacing.setSelection(5);
        this.horizontalSpacing.addSelectionListener(this.selectionListener);
        new Label((Composite)marginGroup, 0).setText("verticalSpacing");
        this.verticalSpacing = new Spinner((Composite)marginGroup, 2048);
        this.verticalSpacing.setSelection(5);
        this.verticalSpacing.addSelectionListener(this.selectionListener);
        super.createControlWidgets();
        this.controlGroup.pack();
    }

    void createLayout() {
        this.gridLayout = new GridLayout();
        this.layoutComposite.setLayout((Layout)this.gridLayout);
    }

    void disposeEditors() {
        this.comboEditor.setEditor(null, null, -1);
        this.combo.dispose();
        this.nameText.dispose();
        this.widthText.dispose();
        this.heightText.dispose();
        this.hAlign.dispose();
        this.vAlign.dispose();
        this.hGrab.dispose();
        this.vGrab.dispose();
        this.hSpan.dispose();
        this.vSpan.dispose();
        this.hIndent.dispose();
        this.vIndent.dispose();
        this.minWidthText.dispose();
        this.minHeightText.dispose();
        this.exclude.dispose();
    }

    StringBuffer generateLayoutCode() {
        StringBuffer code = new StringBuffer();
        code.append("\t\tGridLayout gridLayout = new GridLayout (");
        if (this.gridLayout.numColumns != 1 || this.gridLayout.makeColumnsEqualWidth) {
            code.append(String.valueOf(this.gridLayout.numColumns) + ", " + this.gridLayout.makeColumnsEqualWidth);
        }
        code.append(");\n");
        if (this.gridLayout.marginWidth != 5) {
            code.append("\t\tgridLayout.marginWidth = " + this.gridLayout.marginWidth + ";\n");
        }
        if (this.gridLayout.marginHeight != 5) {
            code.append("\t\tgridLayout.marginHeight = " + this.gridLayout.marginHeight + ";\n");
        }
        if (this.gridLayout.marginLeft != 0) {
            code.append("\t\tgridLayout.marginLeft = " + this.gridLayout.marginLeft + ";\n");
        }
        if (this.gridLayout.marginRight != 0) {
            code.append("\t\tgridLayout.marginRight = " + this.gridLayout.marginRight + ";\n");
        }
        if (this.gridLayout.marginTop != 0) {
            code.append("\t\tgridLayout.marginTop = " + this.gridLayout.marginTop + ";\n");
        }
        if (this.gridLayout.marginBottom != 0) {
            code.append("\t\tgridLayout.marginBottom = " + this.gridLayout.marginBottom + ";\n");
        }
        if (this.gridLayout.horizontalSpacing != 5) {
            code.append("\t\tgridLayout.horizontalSpacing = " + this.gridLayout.horizontalSpacing + ";\n");
        }
        if (this.gridLayout.verticalSpacing != 5) {
            code.append("\t\tgridLayout.verticalSpacing = " + this.gridLayout.verticalSpacing + ";\n");
        }
        code.append("\t\tshell.setLayout (gridLayout);\n");
        boolean first = true;
        int i = 0;
        while (i < this.children.length) {
            Control control = this.children[i];
            code.append(this.getChildCode(control, i));
            GridData data = (GridData)control.getLayoutData();
            if (data != null) {
                boolean bounds = data.widthHint != -1 || data.heightHint != -1;
                boolean align = data.horizontalAlignment != 1 || data.verticalAlignment != 0x1000000;
                boolean grab = data.grabExcessHorizontalSpace || data.grabExcessVerticalSpace;
                boolean span = data.horizontalSpan != 1 || data.verticalSpan != 1;
                code.append("\t\t");
                if (first) {
                    code.append("GridData ");
                    first = false;
                }
                if (align || grab || span) {
                    code.append("data = new GridData (");
                    code.append(String.valueOf(this.alignmentString(data.horizontalAlignment)) + ", ");
                    code.append(String.valueOf(this.alignmentString(data.verticalAlignment)) + ", ");
                    code.append(String.valueOf(data.grabExcessHorizontalSpace) + ", ");
                    code.append(data.grabExcessVerticalSpace);
                    if (span) {
                        code.append(", " + data.horizontalSpan);
                        code.append(", " + data.verticalSpan);
                    }
                    code.append(");\n");
                    if (data.widthHint != -1) {
                        code.append("\t\tdata.widthHint = " + data.widthHint + ";\n");
                    }
                    if (data.heightHint != -1) {
                        code.append("\t\tdata.heightHint = " + data.heightHint + ";\n");
                    }
                } else if (bounds) {
                    code.append("data = new GridData (");
                    code.append(data.widthHint == -1 ? "SWT.DEFAULT" : String.valueOf(String.valueOf(data.widthHint)) + ", ");
                    code.append(data.heightHint == -1 ? "SWT.DEFAULT" : String.valueOf(data.heightHint));
                    code.append(");\n");
                } else {
                    code.append("data = new GridData ();\n");
                }
                if (data.horizontalIndent != 0) {
                    code.append("\t\tdata.horizontalIndent = " + data.horizontalIndent + ";\n");
                }
                if (data.verticalIndent != 0) {
                    code.append("\t\tdata.verticalIndent = " + data.verticalIndent + ";\n");
                }
                if (data.minimumWidth != 0) {
                    code.append("\t\tdata.minimumWidth = " + data.minimumWidth + ";\n");
                }
                if (data.minimumHeight != 0) {
                    code.append("\t\tdata.minimumHeight = " + data.minimumHeight + ";\n");
                }
                if (data.exclude) {
                    code.append("\t\tdata.exclude = true;\n");
                }
                if (code.substring(code.length() - 33).equals("GridData data = new GridData ();\n")) {
                    code.delete(code.length() - 33, code.length());
                    first = true;
                } else if (code.substring(code.length() - 24).equals("data = new GridData ();\n")) {
                    code.delete(code.length() - 24, code.length());
                } else {
                    code.append("\t\t" + this.names[i] + ".setLayoutData (data);\n");
                }
            }
            ++i;
        }
        return code;
    }

    String alignmentString(int alignment) {
        if (alignment == 1) {
            return "SWT.BEGINNING";
        }
        if (alignment == 0x1000000) {
            return "SWT.CENTER";
        }
        if (alignment == 0x1000008) {
            return "SWT.END";
        }
        return "SWT.FILL";
    }

    String[] getInsertString(String name, String controlType) {
        return new String[]{name, controlType, "-1", "-1", "BEGINNING", "CENTER", "false", "false", "1", "1", "0", "0", "0", "0", "false"};
    }

    String[] getLayoutDataFieldNames() {
        return new String[]{"Control Name", "Control Type", "width", "height", "hAlignment", "vAlignment", "grabH", "grabV", "hSpan", "vSpan", "hIndent", "vIndent", "minWidth", "minHeight", "exclude"};
    }

    String getTabText() {
        return "GridLayout";
    }

    void resetEditors(boolean tab) {
        TableItem oldItem = this.comboEditor.getItem();
        if (oldItem != null) {
            int row = this.table.indexOf(oldItem);
            try {
                new String(this.nameText.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.nameText.setText(oldItem.getText(0));
            }
            try {
                new Integer(this.widthText.getText()).intValue();
            }
            catch (NumberFormatException numberFormatException) {
                this.widthText.setText(oldItem.getText(2));
            }
            try {
                new Integer(this.heightText.getText()).intValue();
            }
            catch (NumberFormatException numberFormatException) {
                this.heightText.setText(oldItem.getText(3));
            }
            try {
                new Integer(this.hSpan.getText()).intValue();
            }
            catch (NumberFormatException numberFormatException) {
                this.hSpan.setText(oldItem.getText(8));
            }
            try {
                new Integer(this.vSpan.getText()).intValue();
            }
            catch (NumberFormatException numberFormatException) {
                this.vSpan.setText(oldItem.getText(9));
            }
            try {
                new Integer(this.hIndent.getText()).intValue();
            }
            catch (NumberFormatException numberFormatException) {
                this.hIndent.setText(oldItem.getText(10));
            }
            try {
                new Integer(this.vIndent.getText()).intValue();
            }
            catch (NumberFormatException numberFormatException) {
                this.vIndent.setText(oldItem.getText(11));
            }
            try {
                new Integer(this.minWidthText.getText()).intValue();
            }
            catch (NumberFormatException numberFormatException) {
                this.minWidthText.setText(oldItem.getText(12));
            }
            try {
                new Integer(this.minHeightText.getText()).intValue();
            }
            catch (NumberFormatException numberFormatException) {
                this.minHeightText.setText(oldItem.getText(13));
            }
            String[] insert = new String[]{this.nameText.getText(), this.combo.getText(), this.widthText.getText(), this.heightText.getText(), this.hAlign.getText(), this.vAlign.getText(), this.hGrab.getText(), this.vGrab.getText(), this.hSpan.getText(), this.vSpan.getText(), this.hIndent.getText(), this.vIndent.getText(), this.minWidthText.getText(), this.minHeightText.getText(), this.exclude.getText()};
            this.data.setElementAt(insert, row);
            int i = 0;
            while (i < 15) {
                oldItem.setText(i, ((String[])this.data.elementAt(row))[i]);
                ++i;
            }
            if (!tab) {
                this.disposeEditors();
            }
        }
        this.setLayoutState();
        this.refreshLayoutComposite();
        this.setLayoutData();
        this.layoutComposite.layout(true);
        this.layoutGroup.layout(true);
    }

    int[] sashWeights() {
        return new int[]{35, 65};
    }

    void setLayoutData() {
        Control[] children = this.layoutComposite.getChildren();
        TableItem[] items = this.table.getItems();
        int i = 0;
        while (i < children.length) {
            int vIndent;
            int hIndent;
            int vSpan;
            int hSpan;
            GridData data = new GridData();
            data.widthHint = new Integer(items[i].getText(2));
            data.heightHint = new Integer(items[i].getText(3));
            String hAlign = items[i].getText(4);
            data.horizontalAlignment = hAlign.equals("CENTER") ? 0x1000000 : (hAlign.equals("END") ? 0x1000008 : (hAlign.equals("FILL") ? 4 : 1));
            String vAlign = items[i].getText(5);
            data.verticalAlignment = vAlign.equals("BEGINNING") ? 1 : (vAlign.equals("END") ? 0x1000008 : (vAlign.equals("FILL") ? 4 : 0x1000000));
            data.horizontalSpan = hSpan = new Integer(items[i].getText(8)).intValue();
            data.verticalSpan = vSpan = new Integer(items[i].getText(9)).intValue();
            data.horizontalIndent = hIndent = new Integer(items[i].getText(10)).intValue();
            data.verticalIndent = vIndent = new Integer(items[i].getText(11)).intValue();
            String hGrab = items[i].getText(6);
            data.grabExcessHorizontalSpace = hGrab.equals("true");
            String vGrab = items[i].getText(7);
            data.grabExcessVerticalSpace = vGrab.equals("true");
            data.minimumWidth = new Integer(items[i].getText(12));
            data.minimumHeight = new Integer(items[i].getText(13));
            String exclude = items[i].getText(14);
            data.exclude = exclude.equals("true");
            children[i].setLayoutData((Object)data);
            ++i;
        }
    }

    void setLayoutState() {
        this.gridLayout.numColumns = this.numColumns.getSelection();
        this.gridLayout.makeColumnsEqualWidth = this.makeColumnsEqualWidth.getSelection();
        this.makeColumnsEqualWidth.setEnabled(this.numColumns.getSelection() > 1);
        this.gridLayout.marginWidth = this.marginWidth.getSelection();
        this.gridLayout.marginHeight = this.marginHeight.getSelection();
        this.gridLayout.marginLeft = this.marginLeft.getSelection();
        this.gridLayout.marginRight = this.marginRight.getSelection();
        this.gridLayout.marginTop = this.marginTop.getSelection();
        this.gridLayout.marginBottom = this.marginBottom.getSelection();
        this.gridLayout.horizontalSpacing = this.horizontalSpacing.getSelection();
        this.gridLayout.verticalSpacing = this.verticalSpacing.getSelection();
    }
}

