/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.layoutexample;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.layoutexample.LayoutExample;
import org.eclipse.swt.examples.layoutexample.Tab;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

class StackLayoutTab
extends Tab {
    Button backButton;
    Button advanceButton;
    Label topControl;
    Spinner marginWidth;
    Spinner marginHeight;
    StackLayout stackLayout;
    int currentLayer = -1;
    TableEditor comboEditor;
    TableEditor nameEditor;
    CCombo combo;
    Text nameText;
    final int NAME_COL = 0;
    final int TOTAL_COLS = 2;

    StackLayoutTab(LayoutExample instance) {
        super(instance);
    }

    void createChildWidgets() {
        super.createChildWidgets();
        this.comboEditor = new TableEditor(this.table);
        this.nameEditor = new TableEditor(this.table);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                StackLayoutTab.this.resetEditors();
                StackLayoutTab.this.index = StackLayoutTab.this.table.getSelectionIndex();
                if (StackLayoutTab.this.index == -1) {
                    return;
                }
                StackLayoutTab.this.setTopControl(StackLayoutTab.this.index);
                TableItem oldItem = StackLayoutTab.this.comboEditor.getItem();
                StackLayoutTab.this.newItem = StackLayoutTab.this.table.getItem(StackLayoutTab.this.index);
                if (StackLayoutTab.this.newItem == oldItem || StackLayoutTab.this.newItem != StackLayoutTab.this.lastSelected) {
                    StackLayoutTab.this.lastSelected = StackLayoutTab.this.newItem;
                    return;
                }
                StackLayoutTab.this.table.showSelection();
                StackLayoutTab.this.combo = new CCombo((Composite)StackLayoutTab.this.table, 8);
                StackLayoutTab.this.createComboEditor(StackLayoutTab.this.combo, StackLayoutTab.this.comboEditor);
                StackLayoutTab.this.nameText = new Text((Composite)StackLayoutTab.this.table, 4);
                StackLayoutTab.this.nameText.setText(((String[])StackLayoutTab.this.data.elementAt(StackLayoutTab.this.index))[0]);
                StackLayoutTab.this.createTextEditor(StackLayoutTab.this.nameText, StackLayoutTab.this.nameEditor, 0);
            }
        });
    }

    void createControlWidgets() {
        Group columnGroup = new Group((Composite)this.controlGroup, 0);
        columnGroup.setText("topControl");
        columnGroup.setLayout((Layout)new GridLayout(3, false));
        columnGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        this.backButton = new Button((Composite)columnGroup, 8);
        this.backButton.setText("<<");
        this.backButton.setEnabled(false);
        this.backButton.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.backButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StackLayoutTab.this.setTopControl(StackLayoutTab.this.currentLayer - 1);
            }
        });
        this.topControl = new Label((Composite)columnGroup, 2048);
        this.topControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.advanceButton = new Button((Composite)columnGroup, 8);
        this.advanceButton.setText(">>");
        this.advanceButton.setEnabled(false);
        this.advanceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StackLayoutTab.this.setTopControl(StackLayoutTab.this.currentLayer + 1);
            }
        });
        Group marginGroup = new Group((Composite)this.controlGroup, 0);
        marginGroup.setText(LayoutExample.getResourceString("Margins"));
        marginGroup.setLayout((Layout)new GridLayout(2, false));
        marginGroup.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        new Label((Composite)marginGroup, 0).setText("marginWidth");
        this.marginWidth = new Spinner((Composite)marginGroup, 2048);
        this.marginWidth.setSelection(0);
        this.marginWidth.addSelectionListener(this.selectionListener);
        new Label((Composite)marginGroup, 0).setText("marginHeight");
        this.marginHeight = new Spinner((Composite)marginGroup, 2048);
        this.marginHeight.setSelection(0);
        this.marginHeight.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.marginHeight.addSelectionListener(this.selectionListener);
        super.createControlWidgets();
    }

    void createLayout() {
        this.stackLayout = new StackLayout();
        this.layoutComposite.setLayout((Layout)this.stackLayout);
    }

    void createLayoutComposite() {
        this.layoutComposite = new Composite((Composite)this.layoutGroup, 2048);
        this.layoutComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.createLayout();
    }

    void disposeEditors() {
        this.comboEditor.setEditor(null, null, -1);
        this.combo.dispose();
        this.nameText.dispose();
    }

    StringBuffer generateLayoutCode() {
        StringBuffer code = new StringBuffer();
        code.append("\t\tStackLayout stackLayout = new StackLayout ();\n");
        if (this.stackLayout.marginWidth != 0) {
            code.append("\t\tstackLayout.marginWidth = " + this.stackLayout.marginWidth + ";\n");
        }
        if (this.stackLayout.marginHeight != 0) {
            code.append("\t\tstackLayout.marginHeight = " + this.stackLayout.marginHeight + ";\n");
        }
        code.append("\t\tshell.setLayout (stackLayout);\n");
        int i = 0;
        while (i < this.children.length) {
            Control control = this.children[i];
            code.append(this.getChildCode(control, i));
            ++i;
        }
        if (this.children.length > 0 && this.currentLayer != -1) {
            code.append("\n\t\tstackLayout.topControl = " + this.names[this.currentLayer] + ";\n");
        }
        return code;
    }

    boolean needsCustom() {
        return true;
    }

    String[] getInsertString(String name, String controlType) {
        return new String[]{name, controlType};
    }

    String[] getLayoutDataFieldNames() {
        return new String[]{"Control Name", "Control Type"};
    }

    String getTabText() {
        return "StackLayout";
    }

    void resetEditors(boolean tab) {
        TableItem oldItem = this.comboEditor.getItem();
        this.comboEditor.setEditor(null, null, -1);
        if (oldItem != null) {
            int row = this.table.indexOf(oldItem);
            try {
                new String(this.nameText.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.nameText.setText(oldItem.getText(0));
            }
            String[] insert = new String[]{this.nameText.getText(), this.combo.getText()};
            this.data.setElementAt(insert, row);
            int i = 0;
            while (i < 2) {
                oldItem.setText(i, ((String[])this.data.elementAt(row))[i]);
                ++i;
            }
            if (!tab) {
                this.disposeEditors();
            }
        }
        this.setLayoutState();
        this.refreshLayoutComposite();
        this.setTopControl(this.currentLayer);
        this.layoutGroup.layout(true);
    }

    void setTopControl(int index) {
        if (index == -1 || this.children.length == 0) {
            this.currentLayer = -1;
            this.topControl.setText("");
        } else {
            this.currentLayer = index;
            this.stackLayout.topControl = this.children[this.currentLayer];
            this.layoutComposite.layout();
            TableItem item = this.table.getItem(this.currentLayer);
            this.topControl.setText(item.getText(0));
        }
        this.backButton.setEnabled(this.children.length > 1 && this.currentLayer > 0);
        this.advanceButton.setEnabled(this.children.length > 1 && this.currentLayer < this.children.length - 1);
    }

    void setLayoutState() {
        this.stackLayout.marginWidth = this.marginWidth.getSelection();
        this.stackLayout.marginHeight = this.marginHeight.getSelection();
    }
}

