/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.layoutexample;

import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.examples.layoutexample.LayoutExample;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

abstract class Tab {
    Shell shell;
    Display display;
    Composite tabFolderPage;
    SashForm sash;
    Group layoutGroup;
    Group controlGroup;
    Group childGroup;
    Composite layoutComposite;
    String[] names;
    Control[] children;
    ToolItem add;
    ToolItem delete;
    ToolItem clear;
    ToolItem code;
    int prevSelected = 0;
    Table table;
    int index;
    boolean comboReset = false;
    final String[] OPTIONS = new String[]{"Button", "Canvas", "Combo", "Composite", "CoolBar", "Group", "Label", "Link", "List", "ProgressBar", "Scale", "Slider", "StyledText", "Table", "Text", "ToolBar", "Tree"};
    TableItem newItem;
    TableItem lastSelected;
    Vector<String[]> data = new Vector();
    final LayoutExample instance;
    SelectionListener selectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Tab.this.resetEditors();
        }
    };
    TraverseListener traverseListener = new TraverseListener(){

        public void keyTraversed(TraverseEvent e) {
            if (e.detail == 4) {
                e.doit = false;
                Tab.this.resetEditors();
            }
        }
    };

    Tab(LayoutExample instance) {
        this.instance = instance;
    }

    void createChildGroup() {
        this.childGroup = new Group((Composite)this.controlGroup, 0);
        this.childGroup.setText(LayoutExample.getResourceString("Children"));
        this.childGroup.setLayout((Layout)new GridLayout());
        this.childGroup.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        ToolBar toolBar = new ToolBar((Composite)this.childGroup, 0x800000);
        toolBar.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.add = new ToolItem(toolBar, 4);
        this.add.setText(LayoutExample.getResourceString("Add"));
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.detail == 4) {
                    ToolItem item = (ToolItem)event.widget;
                    ToolBar bar = item.getParent();
                    Menu menu = new Menu((Decorations)Tab.this.shell, 8);
                    int i = 0;
                    while (i < Tab.this.OPTIONS.length) {
                        MenuItem newItem = new MenuItem(menu, 16);
                        newItem.setText(Tab.this.OPTIONS[i]);
                        newItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent event) {
                                MenuItem menuItem = (MenuItem)event.widget;
                                if (menuItem.getSelection()) {
                                    Menu menu = menuItem.getParent();
                                    (this).Tab.this.prevSelected = menu.indexOf(menuItem);
                                    String controlType = menuItem.getText();
                                    String name = String.valueOf(controlType.toLowerCase()) + String.valueOf((this).Tab.this.table.getItemCount());
                                    String[] insert = Tab.this.getInsertString(name, controlType);
                                    if (insert != null) {
                                        TableItem item = new TableItem((this).Tab.this.table, 0);
                                        item.setText(insert);
                                        (this).Tab.this.data.addElement(insert);
                                    }
                                    Tab.this.resetEditors();
                                }
                            }
                        });
                        newItem.setSelection(i == Tab.this.prevSelected);
                        ++i;
                    }
                    Point pt = Tab.this.display.map((Control)bar, null, event.x, event.y);
                    menu.setLocation(pt.x, pt.y);
                    menu.setVisible(true);
                    while (menu != null && !menu.isDisposed() && menu.isVisible()) {
                        if (Tab.this.display.readAndDispatch()) continue;
                        Tab.this.display.sleep();
                    }
                    menu.dispose();
                } else {
                    String controlType = Tab.this.OPTIONS[Tab.this.prevSelected];
                    String name = String.valueOf(controlType.toLowerCase()) + String.valueOf(Tab.this.table.getItemCount());
                    String[] insert = Tab.this.getInsertString(name, controlType);
                    if (insert != null) {
                        TableItem item = new TableItem(Tab.this.table, 0);
                        item.setText(insert);
                        Tab.this.data.addElement(insert);
                    }
                    Tab.this.resetEditors();
                }
            }
        });
        new ToolItem(toolBar, 2);
        this.delete = new ToolItem(toolBar, 8);
        this.delete.setText(LayoutExample.getResourceString("Delete"));
        this.delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Tab.this.resetEditors();
                int[] selected = Tab.this.table.getSelectionIndices();
                Tab.this.table.remove(selected);
                int i = 0;
                while (i < Tab.this.table.getItemCount()) {
                    TableItem item = Tab.this.table.getItem(i);
                    item.setText(0, item.getText(0));
                    ++i;
                }
                Tab.this.refreshLayoutComposite();
                Tab.this.layoutComposite.layout(true);
                Tab.this.layoutGroup.layout(true);
            }
        });
        new ToolItem(toolBar, 2);
        this.clear = new ToolItem(toolBar, 8);
        this.clear.setText(LayoutExample.getResourceString("Clear"));
        this.clear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Tab.this.resetEditors();
                Tab.this.children = Tab.this.layoutComposite.getChildren();
                int i = 0;
                while (i < Tab.this.children.length) {
                    Tab.this.children[i].dispose();
                    ++i;
                }
                Tab.this.table.removeAll();
                Tab.this.data.clear();
                Tab.this.children = new Control[0];
                Tab.this.layoutGroup.layout(true);
            }
        });
        toolBar.pack();
        new ToolItem(toolBar, 2);
        this.code = new ToolItem(toolBar, 8);
        this.code.setText(LayoutExample.getResourceString("Generate_Code"));
        this.code.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final Shell shell = new Shell();
                shell.setText(LayoutExample.getResourceString("Generated_Code"));
                shell.setLayout((Layout)new FillLayout());
                final Text text = new Text((Composite)shell, 2818);
                String layoutCode = Tab.this.generateCode().toString();
                if (layoutCode.length() == 0) {
                    return;
                }
                text.setText(layoutCode);
                Menu bar = new Menu((Decorations)shell, 2);
                shell.setMenuBar(bar);
                MenuItem editItem = new MenuItem(bar, 64);
                editItem.setText(LayoutExample.getResourceString("Edit"));
                Menu menu = new Menu(bar);
                MenuItem select = new MenuItem(menu, 8);
                select.setText(LayoutExample.getResourceString("Select_All"));
                select.setAccelerator(SWT.MOD1 + 65);
                select.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        text.selectAll();
                    }
                });
                MenuItem copy = new MenuItem(menu, 8);
                copy.setText(LayoutExample.getResourceString("Copy"));
                copy.setAccelerator(SWT.MOD1 + 67);
                copy.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        text.copy();
                    }
                });
                MenuItem exit = new MenuItem(menu, 8);
                exit.setText(LayoutExample.getResourceString("Exit"));
                exit.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        shell.close();
                    }
                });
                editItem.setMenu(menu);
                shell.pack();
                shell.setSize(500, 600);
                shell.open();
                while (!shell.isDisposed()) {
                    if (Tab.this.display.readAndDispatch()) continue;
                    Tab.this.display.sleep();
                }
            }
        });
        this.createChildWidgets();
    }

    void createChildWidgets() {
        this.table = new Table((Composite)this.childGroup, 101122);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        FontData[] def = this.display.getSystemFont().getFontData();
        this.table.setFont(new Font((Device)this.display, def[0].getName(), 10, 0));
        GridData gridData = new GridData(4, 4, true, true, 3, 1);
        gridData.heightHint = 150;
        this.table.setLayoutData((Object)gridData);
        this.table.addTraverseListener(this.traverseListener);
        String[] columnHeaders = this.getLayoutDataFieldNames();
        int i = 0;
        while (i < columnHeaders.length) {
            TableColumn column = new TableColumn(this.table, 0);
            column.setText(columnHeaders[i]);
            if (i == 0) {
                column.setWidth(100);
            } else if (i == 1) {
                column.setWidth(90);
            } else {
                column.pack();
            }
            ++i;
        }
    }

    void createComboEditor(CCombo combo, TableEditor comboEditor) {
        combo.setItems(this.OPTIONS);
        combo.setText(this.newItem.getText(1));
        comboEditor.horizontalAlignment = 16384;
        comboEditor.grabHorizontal = true;
        comboEditor.minimumWidth = 50;
        comboEditor.setEditor((Control)combo, this.newItem, 1);
        combo.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16 || e.detail == 4) {
                    Tab.this.comboReset = true;
                    Tab.this.resetEditors();
                }
                if (e.detail == 2) {
                    Tab.this.disposeEditors();
                }
            }
        });
    }

    void createControlGroup() {
        this.controlGroup = new Group((Composite)this.sash, 0);
        this.controlGroup.setText(LayoutExample.getResourceString("Parameters"));
        GridLayout layout = new GridLayout(2, true);
        layout.horizontalSpacing = 10;
        this.controlGroup.setLayout((Layout)layout);
        final Button preferredButton = new Button((Composite)this.controlGroup, 32);
        preferredButton.setText(LayoutExample.getResourceString("Preferred_Size"));
        preferredButton.setSelection(false);
        preferredButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Tab.this.resetEditors();
                GridData data = (GridData)Tab.this.layoutComposite.getLayoutData();
                if (preferredButton.getSelection()) {
                    data.widthHint = -1;
                    data.heightHint = -1;
                    data.horizontalAlignment = 0;
                    data.verticalAlignment = 0;
                    data.grabExcessHorizontalSpace = false;
                    data.grabExcessVerticalSpace = false;
                } else {
                    data.horizontalAlignment = 4;
                    data.verticalAlignment = 4;
                    data.grabExcessHorizontalSpace = true;
                    data.grabExcessVerticalSpace = true;
                }
                Tab.this.layoutComposite.setLayoutData((Object)data);
                Tab.this.layoutGroup.layout(true);
            }
        });
        preferredButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.createControlWidgets();
    }

    void createControlWidgets() {
        this.createChildGroup();
    }

    void createLayout() {
    }

    void createLayoutComposite() {
        this.layoutComposite = new Composite((Composite)this.layoutGroup, 2048);
        this.layoutComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createLayout();
    }

    void createLayoutGroup() {
        this.layoutGroup = new Group((Composite)this.sash, 0);
        this.layoutGroup.setText(LayoutExample.getResourceString("Layout"));
        this.layoutGroup.setLayout((Layout)new GridLayout());
        this.createLayoutComposite();
    }

    Composite createTabFolderPage(TabFolder tabFolder) {
        this.shell = tabFolder.getShell();
        this.display = this.shell.getDisplay();
        this.tabFolderPage = new Composite((Composite)tabFolder, 0);
        this.tabFolderPage.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tabFolderPage.setLayout((Layout)new FillLayout());
        this.sash = new SashForm(this.tabFolderPage, 256);
        this.createLayoutGroup();
        this.createControlGroup();
        this.sash.setWeights(this.sashWeights());
        return this.tabFolderPage;
    }

    int[] sashWeights() {
        return new int[]{50, 50};
    }

    void createTextEditor(Text text, TableEditor textEditor, int column) {
        text.setFont(this.table.getFont());
        text.selectAll();
        textEditor.horizontalAlignment = 16384;
        textEditor.grabHorizontal = true;
        textEditor.setEditor((Control)text, this.newItem, column);
        text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16) {
                    Tab.this.resetEditors(true);
                }
                if (e.detail == 2) {
                    Tab.this.disposeEditors();
                }
            }
        });
    }

    void disposeEditors() {
    }

    StringBuffer generateCode() {
        this.resetEditors();
        this.names = new String[this.children.length];
        int i = 0;
        while (i < this.children.length) {
            TableItem myItem = this.table.getItem(i);
            String name = myItem.getText(0);
            if (name.matches("\\d")) {
                Control control = this.children[i];
                String controlClass = control.getClass().toString();
                String controlType = controlClass.substring(controlClass.lastIndexOf(46) + 1);
                this.names[i] = String.valueOf(controlType.toLowerCase()) + i;
            } else {
                this.names[i] = myItem.getText(0);
            }
            ++i;
        }
        StringBuffer code = new StringBuffer();
        code.append("import org.eclipse.swt.*;\n");
        code.append("import org.eclipse.swt.layout.*;\n");
        code.append("import org.eclipse.swt.widgets.*;\n");
        if (this.needsCustom()) {
            code.append("import org.eclipse.swt.custom.*;\n");
        }
        if (this.needsGraphics()) {
            code.append("import org.eclipse.swt.graphics.*;\n");
        }
        code.append("\n");
        code.append("public class MyLayout {\n");
        code.append("\tpublic static void main (String [] args) {\n");
        code.append("\t\tDisplay display = new Display ();\n");
        code.append("\t\tShell shell = new Shell (display);\n");
        code.append(this.generateLayoutCode());
        code.append("\n\t\tshell.pack ();\n\t\tshell.open ();\n\n");
        code.append("\t\twhile (!shell.isDisposed ()) {\n");
        code.append("\t\t\tif (!display.readAndDispatch ())\n");
        code.append("\t\t\t\tdisplay.sleep ();\n\t\t}\n\t\tdisplay.dispose ();\n\t}\n}");
        return code;
    }

    boolean needsGraphics() {
        return false;
    }

    boolean needsCustom() {
        return false;
    }

    StringBuffer generateLayoutCode() {
        return new StringBuffer();
    }

    StringBuffer getChildCode(Control control, int i) {
        StringBuffer code = new StringBuffer();
        String controlClass = control.getClass().toString();
        String controlType = controlClass.substring(controlClass.lastIndexOf(46) + 1);
        String styleString = controlType.equals("Button") ? "SWT.PUSH" : (controlType.equals("StyledText") ? "SWT.MULTI | SWT.BORDER | SWT.V_SCROLL | SWT.H_SCROLL" : (controlType.equals("Canvas") || controlType.equals("Composite") || controlType.equals("Table") || controlType.equals("StyledText") || controlType.equals("ToolBar") || controlType.equals("Tree") || controlType.equals("List") || controlType.equals("Text") ? "SWT.BORDER" : "SWT.NONE"));
        code.append("\n\t\t" + controlType + " " + this.names[i] + " = new " + controlType + " (shell, " + styleString + ");\n");
        if (controlType.equals("Combo") || controlType.equals("List")) {
            code.append("\t\t" + this.names[i] + ".setItems (new String [] {\"Item 1\", \"Item 2\", \"Item 2\"});\n");
        } else if (controlType.equals("Table")) {
            code.append("\t\t" + this.names[i] + ".setLinesVisible (true);\n");
            code.append("\t\tfor (int i = 0; i < 2; i++) {\n");
            code.append("\t\tTableItem tableItem = new TableItem (" + this.names[i] + ", SWT.NONE);\n");
            code.append("\t\t\ttableItem.setText (\"Item\" + i);\n\t\t}\n");
        } else if (controlType.equals("Tree")) {
            code.append("\t\tfor (int i = 0; i < 2; i++) {\n");
            code.append("\t\tTreeItem treeItem = new TreeItem (" + this.names[i] + ", SWT.NONE);\n");
            code.append("\t\t\ttreeItem.setText (\"Item\" + i);\n\t\t}\n");
        } else if (controlType.equals("ToolBar")) {
            code.append("\t\tfor (int i = 0; i < 2; i++) {\n");
            code.append("\t\tToolItem toolItem = new ToolItem (" + this.names[i] + ", SWT.NONE);\n");
            code.append("\t\t\ttoolItem.setText (\"Item\" + i);\n\t\t}\n");
        } else if (controlType.equals("CoolBar")) {
            code.append("\t\tToolBar coolToolBar = new ToolBar (" + this.names[i] + ", SWT.BORDER);\n");
            code.append("\t\tToolItem coolToolItem = new ToolItem (coolToolBar, SWT.NONE);\n");
            code.append("\t\tcoolToolItem.setText (\"Item 1\");\n");
            code.append("\t\tcoolToolItem = new ToolItem (coolToolBar, SWT.NONE);\n");
            code.append("\t\tcoolToolItem.setText (\"Item 2\");\n");
            code.append("\t\tCoolItem coolItem1 = new CoolItem (" + this.names[i] + ", SWT.NONE);\n");
            code.append("\t\tcoolItem1.setControl (coolToolBar);\n");
            code.append("\t\tPoint size = coolToolBar.computeSize (SWT.DEFAULT, SWT.DEFAULT);\n");
            code.append("\t\tcoolItem1.setSize (coolItem1.computeSize (size.x, size.y));\n");
            code.append("\t\tcoolToolBar = new ToolBar (" + this.names[i] + ", SWT.BORDER);\n");
            code.append("\t\tcoolToolItem = new ToolItem (coolToolBar, SWT.NONE);\n");
            code.append("\t\tcoolToolItem.setText (\"Item 3\");\n");
            code.append("\t\tcoolToolItem = new ToolItem (coolToolBar, SWT.NONE);\n");
            code.append("\t\tcoolToolItem.setText (\"Item 4\");\n");
            code.append("\t\tCoolItem coolItem2 = new CoolItem (" + this.names[i] + ", SWT.NONE);\n");
            code.append("\t\tcoolItem2.setControl (coolToolBar);\n");
            code.append("\t\tsize = coolToolBar.computeSize (SWT.DEFAULT, SWT.DEFAULT);\n");
            code.append("\t\tcoolItem2.setSize (coolItem2.computeSize (size.x, size.y));\n");
            code.append("\t\t" + this.names[i] + ".setSize (" + this.names[i] + ".computeSize (SWT.DEFAULT, SWT.DEFAULT));\n");
        } else if (controlType.equals("ProgressBar")) {
            code.append("\t\t" + this.names[i] + ".setSelection (50);\n");
        }
        if (controlType.equals("Button") || controlType.equals("Combo") || controlType.equals("Group") || controlType.equals("Label") || controlType.equals("Link") || controlType.equals("StyledText") || controlType.equals("Text")) {
            code.append("\t\t" + this.names[i] + ".setText (\"" + this.names[i] + "\");\n");
        }
        return code;
    }

    String[] getInsertString(String name, String controlType) {
        return null;
    }

    String[] getLayoutDataFieldNames() {
        return new String[0];
    }

    String getTabText() {
        return "";
    }

    void refreshLayoutComposite() {
        this.children = this.layoutComposite.getChildren();
        int i = 0;
        while (i < this.children.length) {
            this.children[i].dispose();
            ++i;
        }
        TableItem[] items = this.table.getItems();
        this.children = new Control[items.length];
        String[] itemValues = new String[]{LayoutExample.getResourceString("Item", new String[]{"1"}), LayoutExample.getResourceString("Item", new String[]{"2"}), LayoutExample.getResourceString("Item", new String[]{"3"})};
        int i2 = 0;
        while (i2 < items.length) {
            TableItem item2;
            TableItem item1;
            String control = items[i2].getText(1);
            String controlName = items[i2].getText(0);
            if (control.equals("Button")) {
                Button button = new Button(this.layoutComposite, 8);
                button.setText(controlName);
                this.children[i2] = button;
            } else if (control.equals("Canvas")) {
                Canvas canvas = new Canvas(this.layoutComposite, 2048);
                this.children[i2] = canvas;
            } else if (control.equals("Combo")) {
                Combo combo = new Combo(this.layoutComposite, 0);
                combo.setItems(itemValues);
                combo.setText(controlName);
                this.children[i2] = combo;
            } else if (control.equals("Composite")) {
                Composite composite = new Composite(this.layoutComposite, 2048);
                this.children[i2] = composite;
            } else if (control.equals("CoolBar")) {
                CoolBar coolBar = new CoolBar(this.layoutComposite, 0);
                ToolBar toolBar = new ToolBar((Composite)coolBar, 2048);
                ToolItem item = new ToolItem(toolBar, 0);
                item.setText(LayoutExample.getResourceString("Item", new String[]{"1"}));
                item = new ToolItem(toolBar, 0);
                item.setText(LayoutExample.getResourceString("Item", new String[]{"2"}));
                CoolItem coolItem1 = new CoolItem(coolBar, 0);
                coolItem1.setControl((Control)toolBar);
                toolBar = new ToolBar((Composite)coolBar, 2048);
                item = new ToolItem(toolBar, 0);
                item.setText(LayoutExample.getResourceString("Item", new String[]{"3"}));
                item = new ToolItem(toolBar, 0);
                item.setText(LayoutExample.getResourceString("Item", new String[]{"4"}));
                CoolItem coolItem2 = new CoolItem(coolBar, 0);
                coolItem2.setControl((Control)toolBar);
                Point size = toolBar.computeSize(-1, -1);
                coolItem1.setSize(coolItem1.computeSize(size.x, size.y));
                coolItem2.setSize(coolItem2.computeSize(size.x, size.y));
                coolBar.setSize(coolBar.computeSize(-1, -1));
                this.children[i2] = coolBar;
            } else if (control.equals("Group")) {
                Group group = new Group(this.layoutComposite, 0);
                group.setText(controlName);
                this.children[i2] = group;
            } else if (control.equals("Label")) {
                Label label = new Label(this.layoutComposite, 0);
                label.setText(controlName);
                this.children[i2] = label;
            } else if (control.equals("Link")) {
                Link link = new Link(this.layoutComposite, 0);
                link.setText(controlName);
                this.children[i2] = link;
            } else if (control.equals("List")) {
                List list = new List(this.layoutComposite, 2048);
                list.setItems(itemValues);
                this.children[i2] = list;
            } else if (control.equals("ProgressBar")) {
                ProgressBar progress = new ProgressBar(this.layoutComposite, 0);
                progress.setSelection(50);
                this.children[i2] = progress;
            } else if (control.equals("Scale")) {
                Scale scale = new Scale(this.layoutComposite, 0);
                this.children[i2] = scale;
            } else if (control.equals("Slider")) {
                Slider slider = new Slider(this.layoutComposite, 0);
                this.children[i2] = slider;
            } else if (control.equals("StyledText")) {
                StyledText styledText = new StyledText(this.layoutComposite, 2818);
                styledText.setText(controlName);
                this.children[i2] = styledText;
            } else if (control.equals("Table")) {
                Table table = new Table(this.layoutComposite, 2048);
                table.setLinesVisible(true);
                item1 = new TableItem(table, 0);
                item1.setText(LayoutExample.getResourceString("Item", new String[]{"1"}));
                item2 = new TableItem(table, 0);
                item2.setText(LayoutExample.getResourceString("Item", new String[]{"2"}));
                this.children[i2] = table;
            } else if (control.equals("Text")) {
                Text text = new Text(this.layoutComposite, 2048);
                text.setText(controlName);
                this.children[i2] = text;
            } else if (control.equals("ToolBar")) {
                ToolBar toolBar = new ToolBar(this.layoutComposite, 2048);
                item1 = new ToolItem(toolBar, 0);
                item1.setText(LayoutExample.getResourceString("Item", new String[]{"1"}));
                item2 = new ToolItem(toolBar, 0);
                item2.setText(LayoutExample.getResourceString("Item", new String[]{"2"}));
                this.children[i2] = toolBar;
            } else {
                Tree tree = new Tree(this.layoutComposite, 2048);
                item1 = new TreeItem(tree, 0);
                item1.setText(LayoutExample.getResourceString("Item", new String[]{"1"}));
                item2 = new TreeItem(tree, 0);
                item2.setText(LayoutExample.getResourceString("Item", new String[]{"2"}));
                this.children[i2] = tree;
            }
            ++i2;
        }
    }

    void resetEditors() {
        this.resetEditors(false);
    }

    void resetEditors(boolean tab) {
    }

    void setLayoutData() {
    }

    void setLayoutState() {
    }
}

