/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.paint;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.examples.paint.BasicPaintSession;
import org.eclipse.swt.examples.paint.PaintExample;
import org.eclipse.swt.examples.paint.PaintSurface;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public abstract class ContinuousPaintSession
extends BasicPaintSession {
    private boolean dragInProgress = false;
    private Point[] points = new Point[]{new Point(-1, -1), new Point(-1, -1)};
    private int retriggerInterval = 0;
    protected Runnable retriggerHandler = null;

    protected ContinuousPaintSession(PaintSurface paintSurface) {
        super(paintSurface);
    }

    public void setRetriggerTimer(int interval) {
        this.retriggerInterval = interval;
    }

    public void beginSession() {
        this.getPaintSurface().setStatusMessage(PaintExample.getResourceString("session.ContinuousPaint.message"));
        this.dragInProgress = false;
    }

    public void endSession() {
        this.abortRetrigger();
    }

    public void resetSession() {
        this.abortRetrigger();
    }

    public final void mouseDown(MouseEvent event) {
        if (event.button != 1) {
            return;
        }
        if (this.dragInProgress) {
            return;
        }
        this.dragInProgress = true;
        this.points[0].x = event.x;
        this.points[0].y = event.y;
        this.render(this.points[0]);
        this.prepareRetrigger();
    }

    public final void mouseDoubleClick(MouseEvent event) {
    }

    public final void mouseUp(MouseEvent event) {
        if (event.button != 1) {
            return;
        }
        if (!this.dragInProgress) {
            return;
        }
        this.abortRetrigger();
        this.mouseSegmentFinished(event);
        this.dragInProgress = false;
    }

    public final void mouseMove(MouseEvent event) {
        PaintSurface ps = this.getPaintSurface();
        ps.setStatusCoord(ps.getCurrentPosition());
        if (!this.dragInProgress) {
            return;
        }
        this.mouseSegmentFinished(event);
        this.prepareRetrigger();
    }

    private final void mouseSegmentFinished(MouseEvent event) {
        if (this.points[0].x == -1) {
            return;
        }
        if (this.points[0].x != event.x || this.points[0].y != event.y) {
            this.points[1].x = event.x;
            this.points[1].y = event.y;
            this.renderContinuousSegment();
        }
    }

    protected void renderContinuousSegment() {
        int dX = this.points[1].x - this.points[0].x;
        int dY = this.points[1].y - this.points[0].y;
        int absdX = Math.abs(dX);
        int absdY = Math.abs(dY);
        if (dX == 0 && dY == 0) {
            return;
        }
        if (absdY > absdX) {
            int incfpX = (dX << 16) / absdY;
            int incY = dY > 0 ? 1 : -1;
            int fpX = this.points[0].x << 16;
            while (--absdY >= 0) {
                this.points[0].y += incY;
                this.points[0].x = (fpX += incfpX) >> 16;
                this.render(this.points[0]);
            }
            if (this.points[0].x == this.points[1].x) {
                return;
            }
            this.points[0].x = this.points[1].x;
        } else {
            int incfpY = (dY << 16) / absdX;
            int incX = dX > 0 ? 1 : -1;
            int fpY = this.points[0].y << 16;
            while (--absdX >= 0) {
                this.points[0].x += incX;
                this.points[0].y = (fpY += incfpY) >> 16;
                this.render(this.points[0]);
            }
            if (this.points[0].y == this.points[1].y) {
                return;
            }
            this.points[0].y = this.points[1].y;
        }
        this.render(this.points[0]);
    }

    private final void prepareRetrigger() {
        if (this.retriggerInterval > 0) {
            Display display = this.getPaintSurface().getDisplay();
            this.retriggerHandler = new Runnable(){

                public void run() {
                    if (ContinuousPaintSession.this.retriggerHandler == this) {
                        ContinuousPaintSession.this.render(ContinuousPaintSession.this.points[0]);
                        ContinuousPaintSession.this.prepareRetrigger();
                    }
                }
            };
            display.timerExec(this.retriggerInterval, this.retriggerHandler);
        }
    }

    private final void abortRetrigger() {
        this.retriggerHandler = null;
    }

    protected abstract void render(Point var1);
}

