/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.paint;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.paint.AirbrushTool;
import org.eclipse.swt.examples.paint.EllipseTool;
import org.eclipse.swt.examples.paint.LineTool;
import org.eclipse.swt.examples.paint.PaintSurface;
import org.eclipse.swt.examples.paint.PaintTool;
import org.eclipse.swt.examples.paint.PencilTool;
import org.eclipse.swt.examples.paint.PolyLineTool;
import org.eclipse.swt.examples.paint.RectangleTool;
import org.eclipse.swt.examples.paint.RoundedRectangleTool;
import org.eclipse.swt.examples.paint.TextTool;
import org.eclipse.swt.examples.paint.Tool;
import org.eclipse.swt.examples.paint.ToolSettings;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class PaintExample {
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("examples_paint");
    private Composite mainComposite;
    private Canvas activeForegroundColorCanvas;
    private Canvas activeBackgroundColorCanvas;
    private Color paintColorBlack;
    private Color paintColorWhite;
    private Color[] paintColors;
    private Font paintDefaultFont;
    private static final int numPaletteRows = 3;
    private static final int numPaletteCols = 50;
    private ToolSettings toolSettings;
    private PaintSurface paintSurface;
    static final int Pencil_tool = 0;
    static final int Airbrush_tool = 1;
    static final int Line_tool = 2;
    static final int PolyLine_tool = 3;
    static final int Rectangle_tool = 4;
    static final int RoundedRectangle_tool = 5;
    static final int Ellipse_tool = 6;
    static final int Text_tool = 7;
    static final int None_fill = 8;
    static final int Outline_fill = 9;
    static final int Solid_fill = 10;
    static final int Solid_linestyle = 11;
    static final int Dash_linestyle = 12;
    static final int Dot_linestyle = 13;
    static final int DashDot_linestyle = 14;
    static final int Font_options = 15;
    static final int Default_tool = 0;
    static final int Default_fill = 8;
    static final int Default_linestyle = 11;
    public static final Tool[] tools = new Tool[]{new Tool(0, "Pencil", "tool", 16), new Tool(1, "Airbrush", "tool", 16), new Tool(2, "Line", "tool", 16), new Tool(3, "PolyLine", "tool", 16), new Tool(4, "Rectangle", "tool", 16), new Tool(5, "RoundedRectangle", "tool", 16), new Tool(6, "Ellipse", "tool", 16), new Tool(7, "Text", "tool", 16), new Tool(8, "None", "fill", 16, new Integer(0)), new Tool(9, "Outline", "fill", 16, new Integer(1)), new Tool(10, "Solid", "fill", 16, new Integer(2)), new Tool(11, "Solid", "linestyle", 16, new Integer(1)), new Tool(12, "Dash", "linestyle", 16, new Integer(2)), new Tool(13, "Dot", "linestyle", 16, new Integer(3)), new Tool(14, "DashDot", "linestyle", 16, new Integer(4)), new Tool(15, "Font", "options", 8)};

    public PaintExample(Composite parent) {
        this.mainComposite = parent;
        this.initResources();
        this.initActions();
        this.init();
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setText(PaintExample.getResourceString("window.title"));
        shell.setLayout((Layout)new GridLayout());
        PaintExample instance = new PaintExample((Composite)shell);
        instance.createToolBar((Composite)shell);
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayout((Layout)new FillLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        instance.createGUI(composite);
        instance.setDefaults();
        PaintExample.setShellSize(display, shell);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        instance.dispose();
    }

    private void createToolBar(Composite parent) {
        ToolBar toolbar = new ToolBar(parent, 0);
        String group = null;
        int i = 0;
        while (i < tools.length) {
            Tool tool = tools[i];
            if (group != null && !tool.group.equals(group)) {
                new ToolItem(toolbar, 2);
            }
            group = tool.group;
            ToolItem item = this.addToolItem(toolbar, tool);
            if (i == 0 || i == 8 || i == 11) {
                item.setSelection(true);
            }
            ++i;
        }
    }

    private ToolItem addToolItem(ToolBar toolbar, final Tool tool) {
        final String id = String.valueOf(tool.group) + '.' + tool.name;
        ToolItem item = new ToolItem(toolbar, tool.type);
        item.setText(PaintExample.getResourceString(String.valueOf(id) + ".label"));
        item.setToolTipText(PaintExample.getResourceString(String.valueOf(id) + ".tooltip"));
        item.setImage(tool.image);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                tool.action.run();
            }
        });
        final int childID = toolbar.indexOf(item);
        toolbar.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == childID) {
                    e.result = PaintExample.getResourceString(String.valueOf(id) + ".description");
                }
            }
        });
        return item;
    }

    public void setDefaults() {
        this.setPaintTool(0);
        this.setFillType(8);
        this.setLineStyle(11);
        this.setForegroundColor(this.paintColorBlack);
        this.setBackgroundColor(this.paintColorWhite);
    }

    public void createGUI(Composite parent) {
        Composite displayArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        displayArea.setLayout((Layout)gridLayout);
        Canvas paintCanvas = new Canvas(displayArea, 1313536);
        GridData gridData = new GridData(1808);
        paintCanvas.setLayoutData((Object)gridData);
        paintCanvas.setBackground(this.paintColorWhite);
        Composite colorFrame = new Composite(displayArea, 0);
        gridData = new GridData(784);
        colorFrame.setLayoutData((Object)gridData);
        Composite toolSettingsFrame = new Composite(displayArea, 0);
        gridData = new GridData(784);
        toolSettingsFrame.setLayoutData((Object)gridData);
        Text statusText = new Text(displayArea, 2060);
        gridData = new GridData(784);
        statusText.setLayoutData((Object)gridData);
        this.paintSurface = new PaintSurface(paintCanvas, statusText, this.paintColorWhite);
        PaintExample.tools[0].data = new PencilTool(this.toolSettings, this.paintSurface);
        PaintExample.tools[1].data = new AirbrushTool(this.toolSettings, this.paintSurface);
        PaintExample.tools[2].data = new LineTool(this.toolSettings, this.paintSurface);
        PaintExample.tools[3].data = new PolyLineTool(this.toolSettings, this.paintSurface);
        PaintExample.tools[4].data = new RectangleTool(this.toolSettings, this.paintSurface);
        PaintExample.tools[5].data = new RoundedRectangleTool(this.toolSettings, this.paintSurface);
        PaintExample.tools[6].data = new EllipseTool(this.toolSettings, this.paintSurface);
        PaintExample.tools[7].data = new TextTool(this.toolSettings, this.paintSurface);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        colorFrame.setLayout((Layout)gridLayout);
        this.activeForegroundColorCanvas = new Canvas(colorFrame, 2048);
        gridData = new GridData(256);
        gridData.heightHint = 24;
        gridData.widthHint = 24;
        this.activeForegroundColorCanvas.setLayoutData((Object)gridData);
        this.activeBackgroundColorCanvas = new Canvas(colorFrame, 2048);
        gridData = new GridData(256);
        gridData.heightHint = 24;
        gridData.widthHint = 24;
        this.activeBackgroundColorCanvas.setLayoutData((Object)gridData);
        final Canvas paletteCanvas = new Canvas(colorFrame, 264192);
        gridData = new GridData(768);
        gridData.heightHint = 24;
        paletteCanvas.setLayoutData((Object)gridData);
        paletteCanvas.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                Rectangle bounds = paletteCanvas.getClientArea();
                Color color = this.getColorAt(bounds, e.x, e.y);
                if (e.button == 1) {
                    PaintExample.this.setForegroundColor(color);
                } else {
                    PaintExample.this.setBackgroundColor(color);
                }
            }

            private Color getColorAt(Rectangle bounds, int x, int y) {
                if (bounds.height <= 1 && bounds.width <= 1) {
                    return PaintExample.this.paintColorWhite;
                }
                int row = (y - bounds.y) * 3 / bounds.height;
                int col = (x - bounds.x) * 50 / bounds.width;
                return PaintExample.this.paintColors[Math.min(Math.max(row * 50 + col, 0), PaintExample.this.paintColors.length - 1)];
            }
        });
        Listener refreshListener = new Listener(){

            public void handleEvent(Event e) {
                if (e.gc == null) {
                    return;
                }
                Rectangle bounds = paletteCanvas.getClientArea();
                int row = 0;
                while (row < 3) {
                    int col = 0;
                    while (col < 50) {
                        int x = bounds.width * col / 50;
                        int y = bounds.height * row / 3;
                        int width = Math.max(bounds.width * (col + 1) / 50 - x, 1);
                        int height = Math.max(bounds.height * (row + 1) / 3 - y, 1);
                        e.gc.setBackground(PaintExample.this.paintColors[row * 50 + col]);
                        e.gc.fillRectangle(bounds.x + x, bounds.y + y, width, height);
                        ++col;
                    }
                    ++row;
                }
            }
        };
        paletteCanvas.addListener(11, refreshListener);
        paletteCanvas.addListener(9, refreshListener);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        toolSettingsFrame.setLayout((Layout)gridLayout);
        Label label = new Label(toolSettingsFrame, 0);
        label.setText(PaintExample.getResourceString("settings.AirbrushRadius.text"));
        final Scale airbrushRadiusScale = new Scale(toolSettingsFrame, 256);
        airbrushRadiusScale.setMinimum(5);
        airbrushRadiusScale.setMaximum(50);
        airbrushRadiusScale.setSelection(this.toolSettings.airbrushRadius);
        airbrushRadiusScale.setLayoutData((Object)new GridData(784));
        airbrushRadiusScale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((PaintExample)PaintExample.this).toolSettings.airbrushRadius = airbrushRadiusScale.getSelection();
                PaintExample.this.updateToolSettings();
            }
        });
        label = new Label(toolSettingsFrame, 0);
        label.setText(PaintExample.getResourceString("settings.AirbrushIntensity.text"));
        final Scale airbrushIntensityScale = new Scale(toolSettingsFrame, 256);
        airbrushIntensityScale.setMinimum(1);
        airbrushIntensityScale.setMaximum(100);
        airbrushIntensityScale.setSelection(this.toolSettings.airbrushIntensity);
        airbrushIntensityScale.setLayoutData((Object)new GridData(784));
        airbrushIntensityScale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((PaintExample)PaintExample.this).toolSettings.airbrushIntensity = airbrushIntensityScale.getSelection();
                PaintExample.this.updateToolSettings();
            }
        });
    }

    public void dispose() {
        if (this.paintSurface != null) {
            this.paintSurface.dispose();
        }
        if (this.paintColors != null) {
            int i = 0;
            while (i < this.paintColors.length) {
                Color color = this.paintColors[i];
                if (color != null) {
                    color.dispose();
                }
                ++i;
            }
        }
        this.paintDefaultFont = null;
        this.paintColors = null;
        this.paintSurface = null;
        this.freeResources();
    }

    public void freeResources() {
        int i = 0;
        while (i < tools.length) {
            Tool tool = tools[i];
            Image image = tool.image;
            if (image != null) {
                image.dispose();
            }
            tool.image = null;
            ++i;
        }
    }

    public Display getDisplay() {
        return this.mainComposite.getDisplay();
    }

    public static String getResourceString(String key) {
        try {
            return resourceBundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + key + "!";
        }
    }

    public static String getResourceString(String key, Object[] args) {
        try {
            return MessageFormat.format(PaintExample.getResourceString(key), args);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + key + "!";
        }
    }

    private void init() {
        Display display = this.mainComposite.getDisplay();
        this.paintColorWhite = new Color((Device)display, 255, 255, 255);
        this.paintColorBlack = new Color((Device)display, 0, 0, 0);
        this.paintDefaultFont = display.getSystemFont();
        this.paintColors = new Color[150];
        this.paintColors[0] = this.paintColorBlack;
        this.paintColors[1] = this.paintColorWhite;
        int i = 2;
        while (i < this.paintColors.length) {
            this.paintColors[i] = new Color((Device)display, i * 7 % 255, i * 23 % 255, i * 51 % 255);
            ++i;
        }
        this.toolSettings = new ToolSettings();
        this.toolSettings.commonForegroundColor = this.paintColorBlack;
        this.toolSettings.commonBackgroundColor = this.paintColorWhite;
        this.toolSettings.commonFont = this.paintDefaultFont;
    }

    private void initActions() {
        int i = 0;
        while (i < tools.length) {
            final Tool tool = tools[i];
            String group = tool.group;
            if (group.equals("tool")) {
                tool.action = new Runnable(){

                    public void run() {
                        PaintExample.this.setPaintTool(tool.id);
                    }
                };
            } else if (group.equals("fill")) {
                tool.action = new Runnable(){

                    public void run() {
                        PaintExample.this.setFillType(tool.id);
                    }
                };
            } else if (group.equals("linestyle")) {
                tool.action = new Runnable(){

                    public void run() {
                        PaintExample.this.setLineStyle(tool.id);
                    }
                };
            } else if (group.equals("options")) {
                tool.action = new Runnable(){

                    public void run() {
                        FontDialog fontDialog = new FontDialog(PaintExample.this.paintSurface.getShell(), 32768);
                        FontData[] fontDatum = ((PaintExample)PaintExample.this).toolSettings.commonFont.getFontData();
                        if (fontDatum != null && fontDatum.length > 0) {
                            fontDialog.setFontList(fontDatum);
                        }
                        fontDialog.setText(PaintExample.getResourceString("options.Font.dialog.title"));
                        PaintExample.this.paintSurface.hideRubberband();
                        FontData fontData = fontDialog.open();
                        PaintExample.this.paintSurface.showRubberband();
                        if (fontData != null) {
                            try {
                                Font font;
                                ((PaintExample)PaintExample.this).toolSettings.commonFont = font = new Font((Device)PaintExample.this.mainComposite.getDisplay(), fontData);
                                PaintExample.this.updateToolSettings();
                            }
                            catch (SWTException sWTException) {}
                        }
                    }
                };
            }
            ++i;
        }
    }

    public void initResources() {
        Class<PaintExample> clazz = PaintExample.class;
        if (resourceBundle != null) {
            try {
                int i = 0;
                while (i < tools.length) {
                    Tool tool = tools[i];
                    String id = String.valueOf(tool.group) + '.' + tool.name;
                    InputStream sourceStream = clazz.getResourceAsStream(PaintExample.getResourceString(String.valueOf(id) + ".image"));
                    ImageData source = new ImageData(sourceStream);
                    ImageData mask = source.getTransparencyMask();
                    tool.image = new Image(null, source, mask);
                    try {
                        sourceStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
                return;
            }
            catch (Throwable throwable) {}
        }
        String error = resourceBundle != null ? PaintExample.getResourceString("error.CouldNotLoadResources") : "Unable to load resources";
        this.freeResources();
        throw new RuntimeException(error);
    }

    public void setFocus() {
        this.mainComposite.setFocus();
    }

    public void setForegroundColor(Color color) {
        if (this.activeForegroundColorCanvas != null) {
            this.activeForegroundColorCanvas.setBackground(color);
        }
        this.toolSettings.commonForegroundColor = color;
        this.updateToolSettings();
    }

    public void setBackgroundColor(Color color) {
        if (this.activeBackgroundColorCanvas != null) {
            this.activeBackgroundColorCanvas.setBackground(color);
        }
        this.toolSettings.commonBackgroundColor = color;
        this.updateToolSettings();
    }

    public void setPaintTool(int id) {
        PaintTool paintTool = (PaintTool)PaintExample.tools[id].data;
        this.paintSurface.setPaintSession(paintTool);
        this.updateToolSettings();
    }

    public void setFillType(int id) {
        Integer fillType = (Integer)PaintExample.tools[id].data;
        this.toolSettings.commonFillType = fillType;
        this.updateToolSettings();
    }

    public void setLineStyle(int id) {
        Integer lineType = (Integer)PaintExample.tools[id].data;
        this.toolSettings.commonLineStyle = lineType;
        this.updateToolSettings();
    }

    private static void setShellSize(Display display, Shell shell) {
        Rectangle bounds = display.getBounds();
        Point size = shell.computeSize(-1, -1);
        if (size.x > bounds.width) {
            size.x = bounds.width * 9 / 10;
        }
        if (size.y > bounds.height) {
            size.y = bounds.height * 9 / 10;
        }
        shell.setSize(size);
    }

    private void updateToolSettings() {
        PaintTool activePaintTool = this.paintSurface.getPaintTool();
        if (activePaintTool == null) {
            return;
        }
        activePaintTool.endSession();
        activePaintTool.set(this.toolSettings);
        activePaintTool.beginSession();
    }
}

