/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.paint;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.paint.ContainerFigure;
import org.eclipse.swt.examples.paint.Figure;
import org.eclipse.swt.examples.paint.FigureDrawContext;
import org.eclipse.swt.examples.paint.PaintExample;
import org.eclipse.swt.examples.paint.PaintSession;
import org.eclipse.swt.examples.paint.PaintTool;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PaintSurface {
    private Point currentPosition = new Point(0, 0);
    private Canvas paintCanvas;
    private PaintSession paintSession;
    private Image image;
    private Image paintImage;
    private int imageWidth;
    private int imageHeight;
    private int visibleWidth;
    private int visibleHeight;
    private FigureDrawContext displayFDC = new FigureDrawContext();
    private FigureDrawContext imageFDC = new FigureDrawContext();
    private FigureDrawContext paintFDC = new FigureDrawContext();
    private ContainerFigure rubberband = new ContainerFigure();
    private int rubberbandHiddenNestingCount = 0;
    private Text statusText;
    private String statusActionInfo;
    private String statusMessageInfo;
    private String statusCoordInfo;

    public PaintSurface(Canvas paintCanvas, Text statusText, Color fillColor) {
        this.paintCanvas = paintCanvas;
        this.statusText = statusText;
        this.clearStatus();
        Rectangle displayRect = paintCanvas.getDisplay().getClientArea();
        this.imageWidth = displayRect.width;
        this.imageHeight = displayRect.height;
        this.image = new Image((Device)paintCanvas.getDisplay(), this.imageWidth, this.imageHeight);
        this.imageFDC.gc = new GC((Drawable)this.image);
        this.imageFDC.gc.setBackground(fillColor);
        this.imageFDC.gc.fillRectangle(0, 0, this.imageWidth, this.imageHeight);
        this.displayFDC.gc = new GC((Drawable)paintCanvas);
        this.setPaintSession(null);
        paintCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ((PaintSurface)PaintSurface.this).displayFDC.gc.dispose();
            }
        });
        paintCanvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                PaintSurface.this.processMouseEventCoordinates(event);
                if (PaintSurface.this.paintSession != null) {
                    PaintSurface.this.paintSession.mouseDown(event);
                }
            }

            public void mouseUp(MouseEvent event) {
                PaintSurface.this.processMouseEventCoordinates(event);
                if (PaintSurface.this.paintSession != null) {
                    PaintSurface.this.paintSession.mouseUp(event);
                }
            }

            public void mouseDoubleClick(MouseEvent event) {
                PaintSurface.this.processMouseEventCoordinates(event);
                if (PaintSurface.this.paintSession != null) {
                    PaintSurface.this.paintSession.mouseDoubleClick(event);
                }
            }
        });
        paintCanvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent event) {
                PaintSurface.this.processMouseEventCoordinates(event);
                if (PaintSurface.this.paintSession != null) {
                    PaintSurface.this.paintSession.mouseMove(event);
                }
            }
        });
        paintCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (PaintSurface.this.rubberband.isEmpty()) {
                    event.gc.drawImage(PaintSurface.this.image, ((PaintSurface)PaintSurface.this).displayFDC.xOffset + event.x, ((PaintSurface)PaintSurface.this).displayFDC.yOffset + event.y, event.width, event.height, event.x, event.y, event.width, event.height);
                } else {
                    if (PaintSurface.this.paintImage != null) {
                        Rectangle rect = PaintSurface.this.paintImage.getBounds();
                        if (event.width + event.x > rect.width || event.height + event.y > rect.height) {
                            ((PaintSurface)PaintSurface.this).paintFDC.gc.dispose();
                            PaintSurface.this.paintImage.dispose();
                            PaintSurface.this.paintImage = null;
                        }
                    }
                    if (PaintSurface.this.paintImage == null) {
                        Display display = PaintSurface.this.getDisplay();
                        Rectangle rect = display.getClientArea();
                        PaintSurface.this.paintImage = new Image((Device)display, Math.max(rect.width, event.width + event.x), Math.max(rect.height, event.height + event.y));
                        ((PaintSurface)PaintSurface.this).paintFDC.gc = new GC((Drawable)PaintSurface.this.paintImage);
                    }
                    Region clipRegion = new Region();
                    event.gc.getClipping(clipRegion);
                    ((PaintSurface)PaintSurface.this).paintFDC.gc.setClipping(clipRegion);
                    clipRegion.dispose();
                    ((PaintSurface)PaintSurface.this).paintFDC.xOffset = ((PaintSurface)PaintSurface.this).displayFDC.xOffset;
                    ((PaintSurface)PaintSurface.this).paintFDC.yOffset = ((PaintSurface)PaintSurface.this).displayFDC.yOffset;
                    ((PaintSurface)PaintSurface.this).paintFDC.xScale = ((PaintSurface)PaintSurface.this).displayFDC.xScale;
                    ((PaintSurface)PaintSurface.this).paintFDC.yScale = ((PaintSurface)PaintSurface.this).displayFDC.yScale;
                    ((PaintSurface)PaintSurface.this).paintFDC.gc.drawImage(PaintSurface.this.image, ((PaintSurface)PaintSurface.this).displayFDC.xOffset + event.x, ((PaintSurface)PaintSurface.this).displayFDC.yOffset + event.y, event.width, event.height, event.x, event.y, event.width, event.height);
                    PaintSurface.this.rubberband.draw(PaintSurface.this.paintFDC);
                    event.gc.drawImage(PaintSurface.this.paintImage, event.x, event.y, event.width, event.height, event.x, event.y, event.width, event.height);
                }
            }
        });
        paintCanvas.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                PaintSurface.this.handleResize();
            }
        });
        ScrollBar horizontal = paintCanvas.getHorizontalBar();
        horizontal.setVisible(true);
        horizontal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PaintSurface.this.scrollHorizontally((ScrollBar)event.widget);
            }
        });
        ScrollBar vertical = paintCanvas.getVerticalBar();
        vertical.setVisible(true);
        vertical.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PaintSurface.this.scrollVertically((ScrollBar)event.widget);
            }
        });
        this.handleResize();
    }

    public void dispose() {
        this.imageFDC.gc.dispose();
        this.image.dispose();
        if (this.paintImage != null) {
            this.paintImage.dispose();
            this.paintFDC.gc.dispose();
        }
        this.currentPosition = null;
        this.paintCanvas = null;
        this.paintSession = null;
        this.image = null;
        this.paintImage = null;
        this.displayFDC = null;
        this.imageFDC = null;
        this.paintFDC = null;
        this.rubberband = null;
        this.statusText = null;
        this.statusActionInfo = null;
        this.statusMessageInfo = null;
        this.statusCoordInfo = null;
    }

    public void setFocus() {
        this.paintCanvas.setFocus();
    }

    public Display getDisplay() {
        return this.paintCanvas.getDisplay();
    }

    public Shell getShell() {
        return this.paintCanvas.getShell();
    }

    public void setPaintSession(PaintSession paintSession) {
        if (this.paintSession != null) {
            if (this.paintSession == paintSession) {
                return;
            }
            this.paintSession.endSession();
        }
        this.paintSession = paintSession;
        this.clearStatus();
        if (paintSession != null) {
            this.setStatusAction(paintSession.getDisplayName());
            paintSession.beginSession();
        } else {
            this.setStatusAction(PaintExample.getResourceString("tool.Null.label"));
            this.setStatusMessage(PaintExample.getResourceString("session.Null.message"));
        }
    }

    public PaintSession getPaintSession() {
        return this.paintSession;
    }

    public PaintTool getPaintTool() {
        return this.paintSession != null && this.paintSession instanceof PaintTool ? (PaintTool)this.paintSession : null;
    }

    public Point getCurrentPosition() {
        return this.currentPosition;
    }

    public void drawFigure(Figure object) {
        object.draw(this.imageFDC);
        object.draw(this.displayFDC);
    }

    public void addRubberbandSelection(Figure object) {
        this.rubberband.add(object);
        if (!this.isRubberbandHidden()) {
            object.draw(this.displayFDC);
        }
    }

    public void clearRubberbandSelection() {
        if (!this.isRubberbandHidden()) {
            Region region = new Region();
            this.rubberband.addDamagedRegion(this.displayFDC, region);
            Rectangle r = region.getBounds();
            this.paintCanvas.redraw(r.x, r.y, r.width, r.height, true);
            region.dispose();
        }
        this.rubberband.clear();
    }

    public void commitRubberbandSelection() {
        this.rubberband.draw(this.imageFDC);
        if (this.isRubberbandHidden()) {
            this.rubberband.draw(this.displayFDC);
        }
        this.rubberband.clear();
    }

    public void hideRubberband() {
        if (this.rubberbandHiddenNestingCount++ <= 0) {
            Region region = new Region();
            this.rubberband.addDamagedRegion(this.displayFDC, region);
            Rectangle r = region.getBounds();
            this.paintCanvas.redraw(r.x, r.y, r.width, r.height, true);
            region.dispose();
        }
    }

    public void showRubberband() {
        if (this.rubberbandHiddenNestingCount <= 0) {
            throw new IllegalStateException("rubberbandHiddenNestingCount > 0");
        }
        if (--this.rubberbandHiddenNestingCount == 0) {
            this.rubberband.draw(this.displayFDC);
        }
    }

    public boolean isRubberbandHidden() {
        return this.rubberbandHiddenNestingCount > 0;
    }

    public void scrollHorizontally(ScrollBar scrollBar) {
        int newOffset;
        int oldOffset;
        if (this.image == null) {
            return;
        }
        if (this.imageWidth > this.visibleWidth && (oldOffset = this.displayFDC.xOffset) != (newOffset = Math.min(scrollBar.getSelection(), this.imageWidth - this.visibleWidth))) {
            this.paintCanvas.update();
            this.displayFDC.xOffset = newOffset;
            this.paintCanvas.scroll(Math.max(oldOffset - newOffset, 0), 0, Math.max(newOffset - oldOffset, 0), 0, this.visibleWidth, this.visibleHeight, false);
        }
    }

    public void scrollVertically(ScrollBar scrollBar) {
        int newOffset;
        int oldOffset;
        if (this.image == null) {
            return;
        }
        if (this.imageHeight > this.visibleHeight && (oldOffset = this.displayFDC.yOffset) != (newOffset = Math.min(scrollBar.getSelection(), this.imageHeight - this.visibleHeight))) {
            this.paintCanvas.update();
            this.displayFDC.yOffset = newOffset;
            this.paintCanvas.scroll(0, Math.max(oldOffset - newOffset, 0), 0, Math.max(newOffset - oldOffset, 0), this.visibleWidth, this.visibleHeight, false);
        }
    }

    private void handleResize() {
        ScrollBar vertical;
        this.paintCanvas.update();
        Rectangle visibleRect = this.paintCanvas.getClientArea();
        this.visibleWidth = visibleRect.width;
        this.visibleHeight = visibleRect.height;
        ScrollBar horizontal = this.paintCanvas.getHorizontalBar();
        if (horizontal != null) {
            this.displayFDC.xOffset = Math.min(horizontal.getSelection(), this.imageWidth - this.visibleWidth);
            if (this.imageWidth <= this.visibleWidth) {
                horizontal.setEnabled(false);
                horizontal.setSelection(0);
            } else {
                horizontal.setEnabled(true);
                horizontal.setValues(this.displayFDC.xOffset, 0, this.imageWidth, this.visibleWidth, 8, this.visibleWidth);
            }
        }
        if ((vertical = this.paintCanvas.getVerticalBar()) != null) {
            this.displayFDC.yOffset = Math.min(vertical.getSelection(), this.imageHeight - this.visibleHeight);
            if (this.imageHeight <= this.visibleHeight) {
                vertical.setEnabled(false);
                vertical.setSelection(0);
            } else {
                vertical.setEnabled(true);
                vertical.setValues(this.displayFDC.yOffset, 0, this.imageHeight, this.visibleHeight, 8, this.visibleHeight);
            }
        }
    }

    private void processMouseEventCoordinates(MouseEvent event) {
        this.currentPosition.x = event.x = Math.min(Math.max(event.x, 0), this.visibleWidth - 1) + this.displayFDC.xOffset;
        this.currentPosition.y = event.y = Math.min(Math.max(event.y, 0), this.visibleHeight - 1) + this.displayFDC.yOffset;
    }

    public void clearStatus() {
        this.statusActionInfo = "";
        this.statusMessageInfo = "";
        this.statusCoordInfo = "";
        this.updateStatus();
    }

    public void setStatusAction(String action) {
        this.statusActionInfo = action != null ? action : "";
        this.updateStatus();
    }

    public void setStatusMessage(String message) {
        this.statusMessageInfo = message != null ? message : "";
        this.updateStatus();
    }

    public void setStatusCoord(Point coord) {
        this.statusCoordInfo = coord != null ? PaintExample.getResourceString("status.Coord.format", new Object[]{new Integer(coord.x), new Integer(coord.y)}) : "";
        this.updateStatus();
    }

    public void setStatusCoordRange(Point a, Point b) {
        this.statusCoordInfo = PaintExample.getResourceString("status.CoordRange.format", new Object[]{new Integer(a.x), new Integer(a.y), new Integer(b.x), new Integer(b.y)});
        this.updateStatus();
    }

    private void updateStatus() {
        this.statusText.setText(PaintExample.getResourceString("status.Bar.format", new Object[]{this.statusActionInfo, this.statusMessageInfo, this.statusCoordInfo}));
    }
}

