/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.paint;

import org.eclipse.swt.examples.paint.ContainerFigure;
import org.eclipse.swt.examples.paint.DragPaintSession;
import org.eclipse.swt.examples.paint.Figure;
import org.eclipse.swt.examples.paint.PaintExample;
import org.eclipse.swt.examples.paint.PaintSurface;
import org.eclipse.swt.examples.paint.PaintTool;
import org.eclipse.swt.examples.paint.RectangleFigure;
import org.eclipse.swt.examples.paint.SolidRectangleFigure;
import org.eclipse.swt.examples.paint.ToolSettings;
import org.eclipse.swt.graphics.Point;

public class RectangleTool
extends DragPaintSession
implements PaintTool {
    private ToolSettings settings;

    public RectangleTool(ToolSettings toolSettings, PaintSurface paintSurface) {
        super(paintSurface);
        this.set(toolSettings);
    }

    public void set(ToolSettings toolSettings) {
        this.settings = toolSettings;
    }

    public String getDisplayName() {
        return PaintExample.getResourceString("tool.Rectangle.label");
    }

    protected Figure createFigure(Point a, Point b) {
        switch (this.settings.commonFillType) {
            default: {
                return new RectangleFigure(this.settings.commonForegroundColor, this.settings.commonBackgroundColor, this.settings.commonLineStyle, a.x, a.y, b.x, b.y);
            }
            case 2: {
                return new SolidRectangleFigure(this.settings.commonBackgroundColor, a.x, a.y, b.x, b.y);
            }
            case 1: 
        }
        ContainerFigure container = new ContainerFigure();
        container.add(new SolidRectangleFigure(this.settings.commonBackgroundColor, a.x, a.y, b.x, b.y));
        container.add(new RectangleFigure(this.settings.commonForegroundColor, this.settings.commonBackgroundColor, this.settings.commonLineStyle, a.x, a.y, b.x, b.y));
        return container;
    }
}

