/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.paint;

import org.eclipse.swt.examples.paint.ContainerFigure;
import org.eclipse.swt.examples.paint.DragPaintSession;
import org.eclipse.swt.examples.paint.Figure;
import org.eclipse.swt.examples.paint.PaintExample;
import org.eclipse.swt.examples.paint.PaintSurface;
import org.eclipse.swt.examples.paint.PaintTool;
import org.eclipse.swt.examples.paint.RoundedRectangleFigure;
import org.eclipse.swt.examples.paint.SolidRoundedRectangleFigure;
import org.eclipse.swt.examples.paint.ToolSettings;
import org.eclipse.swt.graphics.Point;

public class RoundedRectangleTool
extends DragPaintSession
implements PaintTool {
    private ToolSettings settings;

    public RoundedRectangleTool(ToolSettings toolSettings, PaintSurface paintSurface) {
        super(paintSurface);
        this.set(toolSettings);
    }

    public void set(ToolSettings toolSettings) {
        this.settings = toolSettings;
    }

    public String getDisplayName() {
        return PaintExample.getResourceString("tool.RoundedRectangle.label");
    }

    protected Figure createFigure(Point a, Point b) {
        ContainerFigure container = new ContainerFigure();
        if (this.settings.commonFillType != 0) {
            container.add(new SolidRoundedRectangleFigure(this.settings.commonBackgroundColor, a.x, a.y, b.x, b.y, this.settings.roundedRectangleCornerDiameter));
        }
        if (this.settings.commonFillType != 2) {
            container.add(new RoundedRectangleFigure(this.settings.commonForegroundColor, this.settings.commonBackgroundColor, this.settings.commonLineStyle, a.x, a.y, b.x, b.y, this.settings.roundedRectangleCornerDiameter));
        }
        return container;
    }
}

