/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.paint;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.paint.BasicPaintSession;
import org.eclipse.swt.examples.paint.PaintExample;
import org.eclipse.swt.examples.paint.PaintSurface;
import org.eclipse.swt.examples.paint.PaintTool;
import org.eclipse.swt.examples.paint.TextFigure;
import org.eclipse.swt.examples.paint.ToolSettings;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TextTool
extends BasicPaintSession
implements PaintTool {
    private ToolSettings settings;
    private String drawText = PaintExample.getResourceString("tool.Text.settings.defaulttext");

    public TextTool(ToolSettings toolSettings, PaintSurface paintSurface) {
        super(paintSurface);
        this.set(toolSettings);
    }

    public void set(ToolSettings toolSettings) {
        this.settings = toolSettings;
    }

    public String getDisplayName() {
        return PaintExample.getResourceString("tool.Text.label");
    }

    public void beginSession() {
        this.getPaintSurface().setStatusMessage(PaintExample.getResourceString("session.Text.message"));
    }

    public void endSession() {
        this.getPaintSurface().clearRubberbandSelection();
    }

    public void resetSession() {
        this.getPaintSurface().clearRubberbandSelection();
    }

    public void mouseDown(MouseEvent event) {
        if (event.button == 1) {
            this.getPaintSurface().commitRubberbandSelection();
        } else {
            this.getPaintSurface().clearRubberbandSelection();
            Shell shell = this.getPaintSurface().getShell();
            final Shell dialog = new Shell(shell, 67680);
            dialog.setText(PaintExample.getResourceString("tool.Text.dialog.title"));
            dialog.setLayout((Layout)new GridLayout());
            Label label = new Label((Composite)dialog, 0);
            label.setText(PaintExample.getResourceString("tool.Text.dialog.message"));
            label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            final Text field = new Text((Composite)dialog, 2052);
            field.setText(this.drawText);
            field.selectAll();
            field.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            Composite buttons = new Composite((Composite)dialog, 0);
            GridLayout layout = new GridLayout(2, true);
            layout.marginWidth = 0;
            buttons.setLayout((Layout)layout);
            buttons.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
            Button ok = new Button(buttons, 8);
            ok.setText(PaintExample.getResourceString("OK"));
            ok.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TextTool.this.drawText = field.getText();
                    dialog.dispose();
                }
            });
            Button cancel = new Button(buttons, 8);
            cancel.setText(PaintExample.getResourceString("Cancel"));
            cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    dialog.dispose();
                }
            });
            dialog.setDefaultButton(ok);
            dialog.pack();
            dialog.open();
            Display display = dialog.getDisplay();
            while (!shell.isDisposed() && !dialog.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
    }

    public void mouseDoubleClick(MouseEvent event) {
    }

    public void mouseUp(MouseEvent event) {
    }

    public void mouseMove(MouseEvent event) {
        PaintSurface ps = this.getPaintSurface();
        ps.setStatusCoord(ps.getCurrentPosition());
        ps.clearRubberbandSelection();
        ps.addRubberbandSelection(new TextFigure(this.settings.commonForegroundColor, this.settings.commonFont, this.drawText, event.x, event.y));
    }
}

