/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.javaeditor;

import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.examples.javaeditor.JavaContentOutlinePage;
import org.eclipse.ui.examples.javaeditor.JavaEditorMessages;
import org.eclipse.ui.examples.javaeditor.JavaSourceViewerConfiguration;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class JavaEditor
extends TextEditor {
    private JavaContentOutlinePage fOutlinePage;
    private ProjectionSupport fProjectionSupport;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected void createActions() {
        super.createActions();
        DefineFoldingRegionAction a = new DefineFoldingRegionAction(JavaEditorMessages.getResourceBundle(), "DefineFoldingRegion.", (ITextEditor)this);
        this.setAction("DefineFoldingRegion", (IAction)a);
    }

    public void dispose() {
        if (this.fOutlinePage != null) {
            this.fOutlinePage.setInput(null);
        }
        super.dispose();
    }

    public void doRevertToSaved() {
        super.doRevertToSaved();
        if (this.fOutlinePage != null) {
            this.fOutlinePage.update();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        if (this.fOutlinePage != null) {
            this.fOutlinePage.update();
        }
    }

    public void doSaveAs() {
        super.doSaveAs();
        if (this.fOutlinePage != null) {
            this.fOutlinePage.update();
        }
    }

    public void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        if (this.fOutlinePage != null) {
            this.fOutlinePage.setInput(input);
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        this.addAction(menu, "ContentAssistProposal");
        this.addAction(menu, "ContentAssistTip");
        this.addAction(menu, "DefineFoldingRegion");
    }

    public Object getAdapter(Class required) {
        Object adapter;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(required)) {
            if (this.fOutlinePage == null) {
                this.fOutlinePage = new JavaContentOutlinePage(this.getDocumentProvider(), (ITextEditor)this);
                if (this.getEditorInput() != null) {
                    this.fOutlinePage.setInput(this.getEditorInput());
                }
            }
            return this.fOutlinePage;
        }
        if (this.fProjectionSupport != null && (adapter = this.fProjectionSupport.getAdapter(this.getSourceViewer(), required)) != null) {
            return adapter;
        }
        return super.getAdapter(required);
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setSourceViewerConfiguration(new JavaSourceViewerConfiguration());
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.fAnnotationAccess = this.createAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        this.fProjectionSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        this.fProjectionSupport.install();
        viewer.doOperation(19);
    }

    protected void adjustHighlightRange(int offset, int length) {
        ISourceViewer viewer = this.getSourceViewer();
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            extension.exposeModelRange((IRegion)new Region(offset, length));
        }
    }

    private class DefineFoldingRegionAction
    extends TextEditorAction {
        public DefineFoldingRegionAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
            super(bundle, prefix, editor);
        }

        private IAnnotationModel getAnnotationModel(ITextEditor editor) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jface.text.source.projection.ProjectionAnnotationModel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IAnnotationModel)editor.getAdapter((Class)clazz);
        }

        public void run() {
            IAnnotationModel model;
            ITextSelection textSelection;
            ITextEditor editor = this.getTextEditor();
            ISelection selection = editor.getSelectionProvider().getSelection();
            if (selection instanceof ITextSelection && !(textSelection = (ITextSelection)selection).isEmpty() && (model = this.getAnnotationModel(editor)) != null) {
                int start = textSelection.getStartLine();
                int end = textSelection.getEndLine();
                try {
                    IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                    int offset = document.getLineOffset(start);
                    int endOffset = document.getLineOffset(end + 1);
                    Position position = new Position(offset, endOffset - offset);
                    model.addAnnotation((Annotation)new ProjectionAnnotation(), position);
                }
                catch (BadLocationException badLocationException) {}
            }
        }
    }
}

