/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.javaeditor;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.examples.javaeditor.JavaEditorMessages;

public class JavaTextHover
implements ITextHover {
    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        if (hoverRegion != null) {
            try {
                if (hoverRegion.getLength() > -1) {
                    return textViewer.getDocument().get(hoverRegion.getOffset(), hoverRegion.getLength());
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return JavaEditorMessages.getString("JavaTextHover.emptySelection");
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        Point selection = textViewer.getSelectedRange();
        if (selection.x <= offset && offset < selection.x + selection.y) {
            return new Region(selection.x, selection.y);
        }
        return new Region(offset, 0);
    }
}

