/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.contributions.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.examples.contributions.ContributionMessages;
import org.eclipse.ui.examples.contributions.model.IPersonService;
import org.eclipse.ui.examples.contributions.model.Person;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;

public class InfoView
extends ViewPart {
    public static final String ID = "org.eclipse.ui.examples.contributions.view";
    private static final String VIEW_COUNT_ID = "org.eclipse.ui.examples.contributions.view.count";
    private static final String VIEW_CONTEXT_ID = "org.eclipse.ui.examples.contributions.view.context";
    private ListViewer viewer;
    private IHandler countHandler;
    private ArrayList viewerInput;
    private IPropertyChangeListener personListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("change".equals(event.getProperty())) {
                InfoView.this.refresh();
            } else if ("add".equals(event.getProperty())) {
                InfoView.this.viewerInput.add(event.getNewValue());
                InfoView.this.viewer.add(event.getNewValue());
            }
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public void createPartControl(Composite parent) {
        this.viewer = new ListViewer(parent);
        this.viewer.setContentProvider((IContentProvider)new ContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                InfoView.this.editSelection();
            }
        });
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.examples.contributions.model.IPersonService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IPersonService service = (IPersonService)iWorkbenchPartSite.getService((Class)clazz);
        this.viewerInput = new ArrayList(service.getPeople());
        service.addPersonChangeListener(this.personListener);
        this.viewer.setInput((Object)this.viewerInput);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        MenuManager contextMenu = new MenuManager();
        contextMenu.setRemoveAllWhenShown(true);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)this.viewer);
        Control control = this.viewer.getControl();
        Menu menu = contextMenu.createContextMenu(control);
        control.setMenu(menu);
        this.activateContext();
        this.createHandlers();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void activateContext() {
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.contexts.IContextService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IContextService contextService = (IContextService)iWorkbenchPartSite.getService((Class)clazz);
        contextService.activateContext(VIEW_CONTEXT_ID);
    }

    private void createHandlers() {
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IHandlerService handlerService = (IHandlerService)iWorkbenchPartSite.getService((Class)clazz);
        this.countHandler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) {
                List elements = (List)InfoView.this.viewer.getInput();
                MessageDialog.openInformation((Shell)InfoView.this.getSite().getShell(), (String)ContributionMessages.SampleHandler_plugin_name, (String)NLS.bind((String)ContributionMessages.InfoView_countElements, (Object)new Integer(elements.size())));
                return null;
            }
        };
        handlerService.activateHandler(VIEW_COUNT_ID, this.countHandler);
    }

    public void dispose() {
        if (this.countHandler != null) {
            this.countHandler.dispose();
            this.countHandler = null;
        }
        super.dispose();
    }

    public void swap(Person p1, Person p2) {
        ArrayList elements = this.viewerInput;
        int i1 = elements.indexOf(p1);
        int i2 = elements.indexOf(p2);
        Collections.swap(elements, i1, i2);
        this.viewer.refresh();
    }

    public void refresh() {
        this.viewer.refresh();
    }

    private void editSelection() {
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IHandlerService handlerService = (IHandlerService)iWorkbenchPartSite.getService((Class)clazz);
        try {
            handlerService.executeCommand("org.eclipse.ui.examples.contributions.view.edit", null);
        }
        catch (ExecutionException executionException) {
        }
        catch (NotDefinedException notDefinedException) {
        }
        catch (NotEnabledException notEnabledException) {
        }
        catch (NotHandledException notHandledException) {}
    }

    private static class ContentProvider
    implements IStructuredContentProvider {
        private ContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return null;
        }
    }
}

