/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.examples.ui.midi.adapters;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.examples.core.midi.launcher.ClockControl;
import org.eclipse.debug.examples.core.midi.launcher.MidiLaunch;
import org.eclipse.debug.examples.ui.midi.adapters.SequencerControlsModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.provisional.AbstractModelProxy;
import org.eclipse.debug.internal.ui.viewers.update.DebugEventHandler;

public class ControlEventHandler
extends DebugEventHandler {
    private MidiLaunch fLaunch;
    private Timer fTimer;

    public ControlEventHandler(SequencerControlsModelProxy proxy) {
        super((AbstractModelProxy)proxy);
        this.fLaunch = proxy.getMidiLaunch();
    }

    protected void init() {
        if (!(this.fLaunch.isSuspended() || this.fLaunch.isTerminated() || this.fLaunch.isDisconnected())) {
            this.startTimer();
        }
    }

    protected boolean handlesEvent(DebugEvent event) {
        return true;
    }

    public synchronized void dispose() {
        super.dispose();
        if (this.fTimer != null) {
            this.fTimer.cancel();
        }
    }

    protected void refreshRoot(DebugEvent event) {
        ModelDelta delta = new ModelDelta((Object)this.fLaunch, 1024);
        this.fireDelta((IModelDelta)delta);
    }

    protected void handleResume(DebugEvent event) {
        super.handleResume(event);
        this.startTimer();
    }

    private void startTimer() {
        this.fTimer = new Timer(true);
        this.fTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                ModelDelta delta = new ModelDelta((Object)ControlEventHandler.this.fLaunch, 0);
                delta = delta.addNode((Object)new ClockControl(ControlEventHandler.this.fLaunch), 3072);
                ControlEventHandler.this.fireDelta((IModelDelta)delta);
            }
        }, 0L, 100L);
    }

    protected void handleSuspend(DebugEvent event) {
        super.handleSuspend(event);
        if (this.fTimer != null) {
            this.fTimer.cancel();
            this.fTimer = null;
        }
    }
}

