/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.examples.ui.midi.adapters;

import javax.sound.midi.Sequencer;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.examples.core.midi.launcher.MidiLaunch;
import org.eclipse.debug.examples.core.midi.launcher.SequencerControl;
import org.eclipse.debug.examples.ui.midi.adapters.ControlEventHandler;
import org.eclipse.debug.internal.ui.viewers.update.DebugEventHandler;
import org.eclipse.debug.internal.ui.viewers.update.EventHandlerModelProxy;
import org.eclipse.jface.viewers.Viewer;

public class SequencerControlsModelProxy
extends EventHandlerModelProxy {
    private MidiLaunch fLaunch;
    private ControlEventHandler fHandler;

    public SequencerControlsModelProxy(MidiLaunch launch) {
        this.fLaunch = launch;
    }

    public void installed(Viewer viewer) {
        super.installed(viewer);
        this.fHandler.init();
    }

    protected MidiLaunch getMidiLaunch() {
        return this.fLaunch;
    }

    protected DebugEventHandler[] createEventHandlers() {
        this.fHandler = new ControlEventHandler(this);
        return new DebugEventHandler[]{this.fHandler};
    }

    protected boolean containsEvent(DebugEvent event) {
        if (event.getSource() instanceof SequencerControl) {
            return ((SequencerControl)event.getSource()).getLaunch().equals(this.fLaunch);
        }
        if (event.getSource() instanceof Sequencer) {
            return this.fLaunch.getSequencer().equals(event.getSource());
        }
        return event.getSource().equals(this.fLaunch);
    }
}

