/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.examples.ui.pda.adapters;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.examples.core.pda.model.PDAThread;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.provisional.AbstractModelProxy;
import org.eclipse.debug.internal.ui.viewers.update.DebugEventHandler;

public class PDAThreadEventHandler
extends DebugEventHandler {
    private IStackFrame fPrev = null;

    public PDAThreadEventHandler(AbstractModelProxy proxy) {
        super(proxy);
    }

    protected void handleSuspend(DebugEvent event) {
        IThread thread = (IThread)event.getSource();
        int extras = 2048;
        if (event.getDetail() == 16 | event.getDetail() == 32) {
            extras = 0x100000;
        }
        this.fireDeltaUpdatingTopFrame(thread, extras);
    }

    private boolean isEqual(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    protected void handleResume(DebugEvent event) {
        IThread thread = (IThread)event.getSource();
        this.fireDeltaAndClearTopFrame(thread, 3072);
    }

    protected void handleCreate(DebugEvent event) {
        this.fireDeltaAndClearTopFrame((IThread)event.getSource(), 1);
    }

    protected void handleTerminate(DebugEvent event) {
        this.fireDeltaAndClearTopFrame((IThread)event.getSource(), 2);
    }

    protected void handleChange(DebugEvent event) {
        this.fireDeltaUpdatingTopFrame((IThread)event.getSource(), 2048);
    }

    protected void handleLateSuspend(DebugEvent suspend, DebugEvent resume) {
        IThread thread = (IThread)suspend.getSource();
        this.fireDeltaUpdatingTopFrame(thread, 0x100400);
    }

    protected void handleSuspendTimeout(DebugEvent event) {
        IThread thread = (IThread)event.getSource();
        this.fireDeltaAndClearTopFrame(thread, 1024);
    }

    private ModelDelta buildRootDelta() {
        return new ModelDelta((Object)this.getLaunchManager(), 0);
    }

    private ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected ModelDelta addTarget(ModelDelta delta, IThread thread) {
        ILaunch launch = thread.getLaunch();
        Object[] children = launch.getChildren();
        ModelDelta newdelta = delta.addNode((Object)launch, this.indexOf(this.getLaunchManager().getLaunches(), launch), 0, children.length);
        IDebugTarget debugTarget = thread.getDebugTarget();
        int numFrames = -1;
        try {
            numFrames = thread.getStackFrames().length;
        }
        catch (DebugException debugException) {}
        return newdelta.addNode((Object)debugTarget, this.indexOf(children, debugTarget), 0, numFrames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDeltaAndClearTopFrame(IThread thread, int flags) {
        ModelDelta delta = this.buildRootDelta();
        this.addTarget(delta, thread);
        PDAThreadEventHandler pDAThreadEventHandler = this;
        synchronized (pDAThreadEventHandler) {
            this.fPrev = null;
        }
        this.fireDelta((IModelDelta)delta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDeltaUpdatingTopFrame(IThread thread, int flags) {
        ModelDelta delta = this.buildRootDelta();
        ModelDelta node = this.addTarget(delta, thread);
        PDAThreadEventHandler pDAThreadEventHandler = this;
        synchronized (pDAThreadEventHandler) {
            IStackFrame prev = this.fPrev;
            IStackFrame frame = null;
            try {
                frame = thread.getTopStackFrame();
            }
            catch (DebugException debugException) {}
            if (this.isEqual(frame, prev)) {
                node.setFlags(flags);
            } else {
                node.setFlags(flags | 0x400);
            }
            if (frame != null) {
                node.addNode((Object)frame, 0, 0x200800, 0);
            }
            this.fPrev = frame;
        }
        this.fireDelta((IModelDelta)delta);
    }

    protected boolean handlesEvent(DebugEvent event) {
        return event.getSource() instanceof PDAThread;
    }
}

