/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.contentprovider.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.set.ObservableSet;
import org.eclipse.swt.widgets.Display;

public class AsynchronousTestSet
extends ObservableSet {
    private static Random randomNumberGenerator = new Random();
    private Display display = Display.getCurrent();
    private boolean stale = false;
    private static final int AVERAGE_DELTA = 4;
    private static final int AVERAGE_BUSY_TIME = 1000;
    private static List allSets = new ArrayList();

    public AsynchronousTestSet() {
        super(new HashSet(), Object.class);
        if (this.display == null) {
            throw new IllegalStateException("This object can only be created in the UI thread");
        }
        this.recompute();
    }

    protected void firstListenerAdded() {
        super.firstListenerAdded();
        allSets.add(this);
    }

    protected void lastListenerRemoved() {
        allSets.remove((Object)this);
        super.lastListenerRemoved();
    }

    public static void recomputeAll() {
        for (AsynchronousTestSet next : allSets) {
            next.recompute();
        }
    }

    public void remove(Collection toRemove) {
        HashSet removed = new HashSet();
        removed.addAll(toRemove);
        removed.retainAll(this.wrappedSet);
        this.wrappedSet.removeAll(removed);
        this.fireSetChange(Diffs.createSetDiff((Set)Collections.EMPTY_SET, removed));
    }

    public boolean isStale() {
        return this.stale;
    }

    public void recompute() {
        if (!this.isStale()) {
            this.setStale(true);
            final int sleepTime = (int)(randomNumberGenerator.nextDouble() * 2000.0);
            Thread newThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException interruptedException) {}
                    AsynchronousTestSet.this.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            HashSet<Integer> toAdd = new HashSet<Integer>();
                            HashSet toRemove = new HashSet();
                            int delta = randomNumberGenerator.nextInt(16) - 8;
                            int extraAdds = randomNumberGenerator.nextInt(4);
                            int addCount = delta + extraAdds;
                            int removeCount = -delta + extraAdds;
                            if (addCount > 0) {
                                int i = 0;
                                while (i < addCount) {
                                    toAdd.add(new Integer(randomNumberGenerator.nextInt(20)));
                                    ++i;
                                }
                            }
                            if (removeCount > 0) {
                                Iterator oldElements = AsynchronousTestSet.this.wrappedSet.iterator();
                                int i = 0;
                                while (i < removeCount && oldElements.hasNext()) {
                                    toRemove.add(oldElements.next());
                                    ++i;
                                }
                            }
                            toAdd.removeAll(AsynchronousTestSet.this.wrappedSet);
                            AsynchronousTestSet.this.wrappedSet.addAll(toAdd);
                            AsynchronousTestSet.this.wrappedSet.removeAll(toRemove);
                            AsynchronousTestSet.this.setStale(false);
                            AsynchronousTestSet.this.fireSetChange(Diffs.createSetDiff(toAdd, toRemove));
                        }
                    });
                }
            });
            newThread.start();
        }
    }
}

