/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.masterdetail.MasterDetailObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class Snippet002UpdateComboRetainSelection {
    public static void main(String[] args) {
        final Display display = new Display();
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)display), (Runnable)new Runnable(){

            @Override
            public void run() {
                ViewModel viewModel = new ViewModel();
                Shell shell = new View(viewModel).createShell();
                while (!shell.isDisposed()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
                System.out.println(viewModel.getText());
            }
        });
        display.dispose();
    }

    private static IObservableFactory getListDetailFactory() {
        return new IObservableFactory(){

            public IObservable createObservable(Object target) {
                WritableList list = WritableList.withElementType(String.class);
                list.addAll((Collection)target);
                return list;
            }
        };
    }

    public static abstract class AbstractModelObject {
        private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    static class View {
        private ViewModel viewModel;
        static int count;

        public View(ViewModel viewModel) {
            this.viewModel = viewModel;
        }

        public Shell createShell() {
            Shell shell = new Shell(Display.getCurrent());
            shell.setLayout((Layout)new RowLayout(512));
            Combo combo = new Combo((Composite)shell, 2056);
            Button reset = new Button((Composite)shell, 0);
            reset.setText("reset collection");
            reset.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ArrayList<String> newList = new ArrayList<String>();
                    newList.add("Chocolate");
                    newList.add("Vanilla");
                    newList.add("Mango Parfait");
                    newList.add("beef");
                    newList.add("Cheesecake");
                    newList.add(Integer.toString(++count));
                    View.this.viewModel.setChoices(newList);
                }
            });
            System.out.println(this.viewModel.getText());
            DataBindingContext dbc = new DataBindingContext();
            IObservableList list = MasterDetailObservables.detailList((IObservableValue)BeansObservables.observeValue((Object)this.viewModel, (String)"choices"), (IObservableFactory)Snippet002UpdateComboRetainSelection.getListDetailFactory(), String.class);
            dbc.bindList(SWTObservables.observeItems((Control)combo), list);
            dbc.bindValue((IObservableValue)SWTObservables.observeText((Control)combo), BeansObservables.observeValue((Object)this.viewModel, (String)"text"));
            shell.pack();
            shell.open();
            return shell;
        }
    }

    public static class ViewModel
    extends AbstractModelObject {
        private String text = "beef";
        private List choices = new ArrayList();

        public ViewModel() {
            this.choices.add("pork");
            this.choices.add("beef");
            this.choices.add("poultry");
            this.choices.add("vegatables");
        }

        public List getChoices() {
            return this.choices;
        }

        public void setChoices(List choices) {
            List old = this.choices;
            this.choices = choices;
            this.firePropertyChange("choices", old, choices);
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            String oldValue = this.text;
            this.text = text;
            this.firePropertyChange("text", oldValue, text);
        }
    }
}

