/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.NativePropertyListener;
import org.eclipse.core.databinding.property.set.DelegatingSetProperty;
import org.eclipse.core.databinding.property.set.ISetProperty;
import org.eclipse.core.databinding.property.set.SimpleSetProperty;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;

public class Snippet026AnonymousBeanProperties {
    private ComboViewer statusViewer;
    private Combo combo;
    private Text nameText;
    private TreeViewer contactViewer;
    private ApplicationModel model;
    private Shell shell;
    private Tree tree;
    private static final String[] statuses = new String[]{"Online", "Idle", "Busy", "Offline"};

    public static void main(String[] args) {
        Display display = new Display();
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)display), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    Snippet026AnonymousBeanProperties window = new Snippet026AnonymousBeanProperties();
                    window.open();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void open() {
        this.model = this.createDefaultModel();
        Display display = Display.getDefault();
        this.createContents();
        this.bindUI();
        this.shell.open();
        this.shell.layout();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private ApplicationModel createDefaultModel() {
        ContactGroup swtGroup = new ContactGroup("SWT");
        swtGroup.addContact(new Contact("Steve Northover", "Busy"));
        swtGroup.addContact(new Contact("Grant Gayed", "Online"));
        swtGroup.addContact(new Contact("Veronika Irvine", "Offline"));
        swtGroup.addContact(new Contact("Mike Wilson", "Online"));
        swtGroup.addContact(new Contact("Christophe Cornu", "Idle"));
        swtGroup.addContact(new Contact("Lynne Kues", "Online"));
        swtGroup.addContact(new Contact("Silenio Quarti", "Idle"));
        ContactGroup jdbGroup = new ContactGroup("JFace Data Binding");
        jdbGroup.addContact(new Contact("Boris Bokowski", "Online"));
        jdbGroup.addContact(new Contact("Matthew Hall", "Idle"));
        TreeSet<ContactGroup> groups = new TreeSet<ContactGroup>();
        groups.add(swtGroup);
        groups.add(jdbGroup);
        ApplicationModel model = new ApplicationModel();
        model.setGroups(groups);
        return model;
    }

    protected void createContents() {
        this.shell = new Shell();
        this.shell.setSize(379, 393);
        this.shell.setText("Snippet026AnonymousBeanProperties");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        this.shell.setLayout((Layout)gridLayout);
        this.contactViewer = new TreeViewer((Composite)this.shell, 2048);
        this.tree = this.contactViewer.getTree();
        this.tree.setHeaderVisible(true);
        this.tree.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        TreeColumn nameColumn = new TreeColumn(this.tree, 0);
        nameColumn.setWidth(163);
        nameColumn.setText("Name");
        TreeColumn newColumnTreeColumn = new TreeColumn(this.tree, 0);
        newColumnTreeColumn.setWidth(100);
        newColumnTreeColumn.setText("Status");
        Label nameLabel = new Label((Composite)this.shell, 0);
        nameLabel.setText("Name");
        this.nameText = new Text((Composite)this.shell, 2048);
        GridData gd_nameText = new GridData(4, 0x1000000, true, false);
        this.nameText.setLayoutData((Object)gd_nameText);
        Label statusLabel = new Label((Composite)this.shell, 0);
        statusLabel.setLayoutData((Object)new GridData());
        statusLabel.setText("Status");
        this.statusViewer = new ComboViewer((Composite)this.shell, 8);
        this.combo = this.statusViewer.getCombo();
        this.combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    private void bindUI() {
        DelegatingSetProperty treeChildrenProperty = new DelegatingSetProperty(){
            ISetProperty modelGroups = BeanProperties.set(ApplicationModel.class, (String)"groups");
            ISetProperty groupContacts = BeanProperties.set(ContactGroup.class, (String)"contacts");

            protected ISetProperty doGetDelegate(Object source) {
                if (source instanceof ApplicationModel) {
                    return this.modelGroups;
                }
                if (source instanceof ContactGroup) {
                    return this.groupContacts;
                }
                return null;
            }
        };
        ViewerSupport.bind((AbstractTreeViewer)this.contactViewer, (Object)this.model, (ISetProperty)treeChildrenProperty, (IValueProperty[])BeanProperties.values((String[])new String[]{"name", "status"}));
        this.contactViewer.expandAll();
        IViewerObservableValue selection = ViewerProperties.singleSelection().observe((Viewer)this.contactViewer);
        DataBindingContext dbc = new DataBindingContext();
        dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.nameText), BeanProperties.value((String)"name").observeDetail((IObservableValue)selection));
        this.statusViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.statusViewer.setInput((Object)statuses);
        dbc.bindValue((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)this.statusViewer), BeanProperties.value((String)"status").observeDetail((IObservableValue)selection));
        dbc.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)this.statusViewer.getControl()), (IObservableValue)new ComputedValue((IObservableValue)selection){
            private final /* synthetic */ IObservableValue val$selection;
            {
                this.val$selection = iObservableValue;
            }

            protected Object calculate() {
                return this.val$selection.getValue() instanceof Contact;
            }
        });
    }

    public static abstract class AbstractModelObject {
        private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public static class ApplicationModel
    extends AbstractModelObject {
        private Set groups = new TreeSet();

        public Set getGroups() {
            return new TreeSet(this.groups);
        }

        public void setGroups(Set groups) {
            Set oldValue = this.getGroups();
            this.groups = new TreeSet(groups);
            Set newValue = this.getGroups();
            this.firePropertyChange("groups", oldValue, newValue);
        }
    }

    public static class Contact
    extends AbstractModelObject
    implements Comparable {
        private String name;
        private String status;

        private String checkNull(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            return string;
        }

        public Contact(String name, String status) {
            this.name = this.checkNull(name);
            this.status = this.checkNull(status);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = this.checkNull(name);
            this.firePropertyChange("name", this.name, this.name);
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = this.checkNull(status);
            this.firePropertyChange("status", this.status, this.status);
        }

        public int compareTo(Object o) {
            Contact that = (Contact)o;
            int result = this.name.compareTo(that.name);
            if (result == 0) {
                result = this.status.compareTo(that.status);
            }
            return result;
        }
    }

    public static class ContactGroup
    extends AbstractModelObject
    implements Comparable {
        private String name;
        private Set contacts = new TreeSet();

        ContactGroup(String name) {
            this.name = this.checkNull(name);
        }

        private String checkNull(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            return string;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = this.checkNull(name);
            this.firePropertyChange("name", this.name, this.name);
        }

        public Set getContacts() {
            return new TreeSet(this.contacts);
        }

        public void addContact(Contact contact) {
            Set oldValue = this.getContacts();
            this.contacts.add(contact);
            Set newValue = this.getContacts();
            this.firePropertyChange("contacts", oldValue, newValue);
        }

        public void removeContact(Contact contact) {
            Set oldValue = this.getContacts();
            this.contacts.remove(contact);
            Set newValue = this.getContacts();
            this.firePropertyChange("contacts", oldValue, newValue);
        }

        public int compareTo(Object o) {
            ContactGroup that = (ContactGroup)o;
            return this.name.compareTo(that.name);
        }
    }

    public static class ContactGroupContactsProperty
    extends SimpleSetProperty {
        public Object getElementType() {
            return Contact.class;
        }

        protected Set doGetSet(Object source) {
            if (source == null) {
                return Collections.EMPTY_SET;
            }
            return ((ContactGroup)source).getContacts();
        }

        protected void doSetSet(Object source, Set set, SetDiff diff) {
            this.doUpdateSet(source, diff);
        }

        protected void doUpdateSet(Object source, SetDiff diff) {
            ContactGroup group = (ContactGroup)source;
            for (Contact contact : diff.getRemovals()) {
                group.removeContact(contact);
            }
            for (Contact contact : diff.getAdditions()) {
                group.addContact(contact);
            }
        }

        public INativePropertyListener adaptListener(ISimplePropertyListener listener) {
            return new Listener((IProperty)this, listener);
        }

        private class Listener
        extends NativePropertyListener
        implements PropertyChangeListener {
            Listener(IProperty property, ISimplePropertyListener listener) {
                super(property, listener);
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                this.fireChange(evt.getSource(), null);
            }

            protected void doAddTo(Object source) {
                ((ContactGroup)source).addPropertyChangeListener("contacts", this);
            }

            protected void doRemoveFrom(Object source) {
                ((ContactGroup)source).removePropertyChangeListener("contacts", this);
            }
        }
    }
}

